/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.control;

import com.ibm.pdp.widgets.ui.control.PDPNumber;
import java.util.regex.Pattern;
import org.eclipse.swt.widgets.Composite;

public class PDPDouble
extends PDPNumber {
    private String inputDecimalSeparator = ".";
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPDouble(Composite parent, int style) {
        super(parent, style);
        this.computePattern();
    }

    public double getDoubleValue() {
        return new Double(this.getValue().toString());
    }

    public void setDoubleValue(double value) {
        super.setValue(new Double(value).toString());
    }

    public String getInputDecimalSeparator() {
        return this.inputDecimalSeparator;
    }

    public void setInputDecimalSeparator(String inputDecimalSeparator) {
        this.inputDecimalSeparator = inputDecimalSeparator;
        this.computePattern();
    }

    protected void computePattern() {
        this.defaultErrorMessage = " is not a valid double value";
        this.setPattern(Pattern.compile("[\\+\\-]?[0-9]+|[\\+\\-]?[0-9]+\\" + this.inputDecimalSeparator + "[0-9]+"));
    }

    public void setValue(Object newValue) {
        if (newValue instanceof String) {
            super.setValue(newValue);
        } else if (newValue instanceof Double) {
            this.setDoubleValue((Double)newValue);
        }
    }
}

