/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.control;

import com.ibm.pdp.widgets.ui.control.PDPDatePickerDialog;
import java.util.GregorianCalendar;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;

public class PDPDatePickerModel {
    public static final String copyright = "IBM Confidential\r\nOCO Source Materials\r\n5724-T07\r\n(C) Copyright IBM Corp. 2011\r\nThe source code for this program is not published or \r\notherwise divested of its trade secrets, irrespective of \r\nwhat has been deposited with the U.S. Copyright Office.";
    private GregorianCalendar now = null;
    private boolean weekStartsMonday;
    private boolean showToday = false;
    private int start;
    private int daysInMonth;
    private int today;
    private int month;
    private int year;
    private int where;
    private final int[][] daysPerMonth = new int[][]{{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, {31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}};
    private int[][] monthArray;
    private ListenerList listeners = new ListenerList();

    public PDPDatePickerModel(boolean b) {
        this.weekStartsMonday = b;
        this.showToday = true;
        this.buildMonthArray();
    }

    public PDPDatePickerModel(GregorianCalendar date, boolean b) {
        this.weekStartsMonday = b;
        this.now = date;
        this.showToday = false;
        this.buildMonthArray();
    }

    private void buildMonthArray() {
        this.monthArray = new int[6][7];
        if (this.now == null) {
            this.now = new GregorianCalendar();
        }
        GregorianCalendar firstOfMonth = new GregorianCalendar(this.now.get(1), this.now.get(2), 1);
        this.start = this.weekStartsMonday ? (firstOfMonth.get(7) == 1 ? 6 : firstOfMonth.get(7) - 2) : firstOfMonth.get(7) - 1;
        this.daysInMonth = this.daysPerMonth[this.now.isLeapYear(this.now.get(1)) ? 1 : 0][this.now.get(2)];
        GregorianCalendar previousMonth = this.now.get(2) == 0 ? new GregorianCalendar(this.now.get(0), 12, 1) : new GregorianCalendar(this.now.get(1), this.now.get(2) - 1, 1);
        int daysInPreviousMonth = this.daysPerMonth[previousMonth.isLeapYear(previousMonth.get(1)) ? 1 : 0][previousMonth.get(2)];
        this.today = this.showToday ? this.start + this.now.get(5) - 1 : -1;
        this.where = this.start + this.now.get(5) - 1;
        int pre = daysInPreviousMonth - this.start + 1;
        int count = 1;
        int post = 1;
        int i = 0;
        while (i < 6) {
            int k = 0;
            while (k < 7) {
                this.monthArray[i][k] = i == 0 & k < this.start ? pre++ : (count < this.daysInMonth + 1 ? count++ : post++);
                ++k;
            }
            ++i;
        }
        this.month = this.now.get(2);
        this.year = this.now.get(1);
        this.now = null;
        firstOfMonth = null;
        previousMonth = null;
    }

    public int[][] getMonthArray() {
        return this.monthArray;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.start + this.daysInMonth;
    }

    public int getToday() {
        return this.showToday ? this.today : -1;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public int getWhere() {
        return this.where;
    }

    public void fireEvent(PDPDatePickerModel m, String t) {
        PropertyChangeEvent e = new PropertyChangeEvent((Object)this, t, (Object)this, (Object)m);
        Object[] listenerMembers = this.listeners.getListeners();
        int i = 0;
        while (i < listenerMembers.length) {
            ((PDPDatePickerDialog.ViewContentProvider)listenerMembers[i]).propertyChange(e);
            ++i;
        }
    }

    public void addPropertyChangeListener(Object listener) {
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(Object listener) {
        this.listeners.remove(listener);
    }
}

