/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.control;

import com.ibm.pdp.widgets.ui.control.PDPDatePickerModel;
import com.ibm.pdp.widgets.ui.formatter.PDPDateFormatter;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class PDPDatePickerDialog
extends Dialog {
    public static final String copyright = "IBM Confidential\r\nOCO Source Materials\r\n5724-T07\r\n(C) Copyright IBM Corp. 2011\r\nThe source code for this program is not published or \r\notherwise divested of its trade secrets, irrespective of \r\nwhat has been deposited with the U.S. Copyright Office.";
    private Date input;
    private Shell p;
    private Shell shell;
    private TableViewer viewer;
    private PDPDatePickerModel model;
    private TableColumn[] cols;
    private Table table;
    private static Table header;
    private Color grey;
    private Color red;
    private Color yellow;
    private Color black;
    private Color white;
    private Color bluegrey;
    private static final String[] months;
    private CCombo monthField;
    private Text yearField;
    private VerifyListener vy;
    private ModifyListener vm;
    private TableCursor cursor;
    private static Control cell;
    private boolean noTrim = false;
    private static Point todayPoint;
    private GregorianCalendar someDate = null;

    static {
        months = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    }

    public Shell getShell() {
        return this.shell;
    }

    public PDPDatePickerDialog(Control c) {
        super(c.getShell());
        this.p = c.getShell();
        cell = c;
        this.shell = new Shell(cell.getShell(), 65600);
        this.shell.setLayout((Layout)new FillLayout(512));
        this.shell.setText("Calendar");
        todayPoint = new Point(0, 0);
    }

    public PDPDatePickerDialog(Control c, Date date, int format) {
        super(c.getShell());
        this.p = c.getShell();
        cell = c;
        this.shell = new Shell(cell.getShell(), 65600);
        this.shell.setLayout((Layout)new FillLayout(512));
        this.shell.setText("Calendar");
        todayPoint = new Point(0, 0);
        this.someDate = new GregorianCalendar();
        this.someDate.setTime(date);
    }

    public PDPDatePickerDialog(Control c, boolean showTrim) {
        super(c.getShell());
        this.noTrim = !showTrim;
        this.p = c.getShell();
        cell = c;
        this.shell = this.noTrim ? new Shell(this.p, 65536) : new Shell(this.p, 65600);
        this.shell.setLayout((Layout)new FillLayout(512));
        this.shell.setText("Calendar");
        todayPoint = new Point(0, 0);
    }

    public PDPDatePickerDialog(Control c, boolean showTrim, Date date, int format) {
        super(c.getShell());
        this.noTrim = !showTrim;
        this.p = c.getShell();
        cell = c;
        this.shell = this.noTrim ? new Shell(this.p, 65536) : new Shell(this.p, 65600);
        this.shell.setLayout((Layout)new FillLayout(512));
        this.shell.setText("Calendar");
        todayPoint = new Point(0, 0);
        this.someDate = new GregorianCalendar();
        this.someDate.setTime(date);
    }

    public Date open() {
        this.createPartControl((Composite)this.shell);
        this.shell.pack();
        Point pt = this.getAbsoluteLocation(cell);
        if (this.noTrim) {
            this.shell.setBounds(pt.x, pt.y, 170, 135);
        } else {
            this.shell.setBounds(pt.x, pt.y, 175, 164);
        }
        this.contain();
        this.shell.setVisible(true);
        this.shell.setFocus();
        this.cursor.setSelection(PDPDatePickerDialog.todayPoint.y, PDPDatePickerDialog.todayPoint.x);
        while (!this.p.isDisposed() & this.input == null) {
            if (this.p.getDisplay().readAndDispatch()) continue;
            this.p.getDisplay().sleep();
        }
        this.shell.dispose();
        return this.input;
    }

    public void createPartControl(Composite parent) {
        this.grey = new Color((Device)parent.getDisplay(), new RGB(175, 175, 175));
        this.red = new Color((Device)parent.getDisplay(), new RGB(255, 0, 0));
        this.yellow = new Color((Device)parent.getDisplay(), new RGB(255, 255, 180));
        this.black = new Color((Device)parent.getDisplay(), new RGB(0, 0, 0));
        this.white = new Color((Device)parent.getDisplay(), new RGB(255, 255, 255));
        this.bluegrey = new Color((Device)parent.getDisplay(), new RGB(220, 220, 250));
        int height = 18;
        FormLayout layout = new FormLayout();
        this.shell.setLayout((Layout)layout);
        this.table = new Table((Composite)this.shell, 65540);
        header = new Table((Composite)this.shell, 4);
        this.monthField = new CCombo((Composite)this.shell, 0x800004);
        this.yearField = new Text((Composite)this.shell, 0x1800000);
        this.yearField.setTextLimit(4);
        Button leftButton = new Button((Composite)this.shell, 0x804004);
        Button rightButton = new Button((Composite)this.shell, 8519684);
        FormData headerData = new FormData();
        header.setLayoutData((Object)headerData);
        headerData.bottom = new FormAttachment((Control)this.table, 15);
        headerData.width = 152;
        FormData tableData = new FormData();
        this.table.setLayoutData((Object)tableData);
        tableData.width = 152;
        tableData.height = 72;
        tableData.bottom = new FormAttachment(100, 0);
        FormData rightButtonData = new FormData();
        rightButton.setLayoutData((Object)rightButtonData);
        rightButtonData.right = new FormAttachment((Control)header, -3, 131072);
        rightButtonData.height = height;
        rightButtonData.bottom = new FormAttachment((Control)header, -3);
        FormData yearData = new FormData();
        this.yearField.setLayoutData((Object)yearData);
        yearData.right = new FormAttachment((Control)rightButton, 0, 16384);
        yearData.bottom = new FormAttachment((Control)header, -3);
        yearData.height = height;
        yearData.width = 38;
        FormData leftButtonData = new FormData();
        leftButton.setLayoutData((Object)leftButtonData);
        leftButtonData.height = height;
        leftButtonData.bottom = new FormAttachment((Control)header, -3);
        leftButtonData.right = new FormAttachment((Control)this.yearField, 0, 16384);
        FormData monthData = new FormData();
        this.monthField.setLayoutData((Object)monthData);
        monthData.bottom = new FormAttachment((Control)header, -3);
        monthData.left = new FormAttachment((Control)header, 3, 16384);
        monthData.height = height;
        monthData.width = 70;
        this.monthField.setItems(months);
        TableColumn hc0 = new TableColumn(header, 16384);
        hc0.setWidth(0);
        hc0.setResizable(false);
        TableColumn[] hcols = new TableColumn[7];
        int i = 0;
        while (i < 7) {
            hcols[i] = new TableColumn(header, 0x1000000);
            hcols[i].setWidth(24);
            ++i;
        }
        TableItem label = new TableItem(header, 131072, 0);
        label.setText(new String[]{" ", "M", "T", "W", "T", "F", "S", "S"});
        label.setBackground(this.yellow);
        TableColumn tc0 = new TableColumn(this.table, 16384);
        tc0.setWidth(0);
        tc0.setResizable(false);
        this.cols = new TableColumn[7];
        int i2 = 0;
        while (i2 < 7) {
            this.cols[i2] = new TableColumn(this.table, 0x1000000);
            this.cols[i2].setWidth(24);
            ++i2;
        }
        FocusListener listener = new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (e.getSource() == header) {
                    PDPDatePickerDialog.this.table.setFocus();
                }
                if (e.getSource() == PDPDatePickerDialog.this.yearField) {
                    PDPDatePickerDialog.this.yearField.setSelection(2, 4);
                }
            }

            public void focusLost(FocusEvent e) {
                if (e.getSource() == PDPDatePickerDialog.this.monthField && PDPDatePickerDialog.this.monthField.getText().length() == 0) {
                    PDPDatePickerDialog.this.monthField.setFocus();
                }
            }
        };
        header.addFocusListener(listener);
        this.yearField.addFocusListener(listener);
        this.monthField.addFocusListener(listener);
        this.table.addFocusListener(listener);
        new MouseHandler(this);
        this.model = this.someDate == null ? new PDPDatePickerModel(true) : new PDPDatePickerModel(this.someDate, true);
        this.viewer = new TableViewer(this.table);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.model);
        this.monthField.select(this.model.getMonth());
        this.yearField.setText(String.valueOf(this.model.getYear()));
        this.cursor = new TableCursor(this.table, 0);
        this.cursor.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (PDPDatePickerDialog.this.cursor.getColumn() == 0) {
                    PDPDatePickerDialog.this.cursor.setSelection(PDPDatePickerDialog.this.cursor.getRow(), 1);
                }
                if (event.character == '\r') {
                    TableItem item = PDPDatePickerDialog.this.cursor.getRow();
                    int col = PDPDatePickerDialog.this.cursor.getColumn();
                    int cell = PDPDatePickerDialog.this.table.indexOf(item) * 7 + col;
                    int d = Integer.parseInt(item.getText(col));
                    int m = PDPDatePickerDialog.this.monthField.getSelectionIndex() + 1;
                    int y = Integer.parseInt(PDPDatePickerDialog.this.yearField.getText());
                    if (cell <= PDPDatePickerDialog.this.model.getStart()) {
                        int n = m = PDPDatePickerDialog.this.monthField.getSelectionIndex() == 0 ? 12 : PDPDatePickerDialog.this.monthField.getSelectionIndex();
                    }
                    if (PDPDatePickerDialog.this.model.getEnd() < cell) {
                        int n = m = PDPDatePickerDialog.this.monthField.getSelectionIndex() == 11 ? 1 : PDPDatePickerDialog.this.monthField.getSelectionIndex() + 2;
                    }
                    if (cell <= PDPDatePickerDialog.this.model.getStart() && PDPDatePickerDialog.this.monthField.getSelectionIndex() == 0) {
                        --y;
                    }
                    if (PDPDatePickerDialog.this.model.getEnd() < cell && PDPDatePickerDialog.this.monthField.getSelectionIndex() == 11) {
                        ++y;
                    }
                    String dd = String.valueOf(d).length() < 2 ? "0" + String.valueOf(d) : String.valueOf(d);
                    String mm = String.valueOf(m).length() < 2 ? "0" + String.valueOf(m) : String.valueOf(m);
                    PDPDatePickerDialog.this.input = PDPDateFormatter.dateFromString(dd, mm, String.valueOf(y));
                    PDPDatePickerDialog.this.shell.close();
                }
            }
        });
        this.yearField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x1000001) {
                    PDPDatePickerDialog.this.yearField.removeVerifyListener(PDPDatePickerDialog.this.vy);
                    PDPDatePickerDialog.this.yearField.setText(String.valueOf(Integer.parseInt(PDPDatePickerDialog.this.yearField.getText()) + 1));
                    PDPDatePickerDialog.this.yearField.setSelection(0);
                    PDPDatePickerDialog.this.yearField.addVerifyListener(PDPDatePickerDialog.this.vy);
                }
                if (event.keyCode == 0x1000002) {
                    PDPDatePickerDialog.this.yearField.removeVerifyListener(PDPDatePickerDialog.this.vy);
                    PDPDatePickerDialog.this.yearField.setText(String.valueOf(Integer.parseInt(PDPDatePickerDialog.this.yearField.getText()) - 1));
                    PDPDatePickerDialog.this.yearField.setSelection(4);
                    PDPDatePickerDialog.this.yearField.addVerifyListener(PDPDatePickerDialog.this.vy);
                }
            }
        });
        this.monthField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDPDatePickerDialog.this.change();
            }
        });
        leftButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDPDatePickerDialog.this.yearField.removeVerifyListener(PDPDatePickerDialog.this.vy);
                int year = Integer.parseInt(PDPDatePickerDialog.this.yearField.getText());
                PDPDatePickerDialog.this.yearField.setText(String.valueOf(year - 1));
                PDPDatePickerDialog.this.yearField.addVerifyListener(PDPDatePickerDialog.this.vy);
                PDPDatePickerDialog.this.change();
            }
        });
        rightButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDPDatePickerDialog.this.yearField.removeVerifyListener(PDPDatePickerDialog.this.vy);
                int year = Integer.parseInt(PDPDatePickerDialog.this.yearField.getText());
                PDPDatePickerDialog.this.yearField.setText(String.valueOf(year + 1));
                PDPDatePickerDialog.this.yearField.addVerifyListener(PDPDatePickerDialog.this.vy);
                PDPDatePickerDialog.this.change();
            }
        });
        this.yearField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (PDPDatePickerDialog.this.yearField.getText() != "") {
                    PDPDatePickerDialog.this.change();
                }
            }
        });
        final class MMoveListener
        implements MouseMoveListener {
            MMoveListener() {
            }

            public void mouseMove(MouseEvent e) {
                int i;
                Point point = new Point(e.x, e.y);
                int height = PDPDatePickerDialog.this.table.getItemHeight();
                int row = e.y / height;
                if (row > 5) {
                    return;
                }
                TableItem item = PDPDatePickerDialog.this.table.getItem(row);
                int col = 0;
                if (item != null) {
                    col = -1;
                    i = 0;
                    int n = PDPDatePickerDialog.this.table.getColumnCount();
                    while (i < n) {
                        Rectangle bounds = item.getBounds(i);
                        if (bounds.contains(point)) {
                            col = i;
                            break;
                        }
                        ++i;
                    }
                }
                i = 0;
                while (i < 6) {
                    int k = 1;
                    while (k < 8) {
                        PDPDatePickerDialog.this.table.getItem(i).setBackground(k, PDPDatePickerDialog.this.white);
                        ++k;
                    }
                    ++i;
                }
                item.setBackground(col, PDPDatePickerDialog.this.bluegrey);
            }
        }
        this.table.addMouseMoveListener((MouseMoveListener)new MMoveListener());
        this.table.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                int i = 0;
                while (i < 6) {
                    int k = 1;
                    while (k < 8) {
                        PDPDatePickerDialog.this.table.getItem(i).setBackground(k, PDPDatePickerDialog.this.white);
                        ++k;
                    }
                    ++i;
                }
            }
        });
        final class CursorMouseListener
        implements MouseListener {
            CursorMouseListener() {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                TableItem item = PDPDatePickerDialog.this.cursor.getRow();
                int col = PDPDatePickerDialog.this.cursor.getColumn();
                int cell = PDPDatePickerDialog.this.table.indexOf(item) * 7 + col;
                int d = Integer.parseInt(item.getText(col));
                int m = PDPDatePickerDialog.this.monthField.getSelectionIndex() + 1;
                int y = Integer.parseInt(PDPDatePickerDialog.this.yearField.getText());
                if (cell <= PDPDatePickerDialog.this.model.getStart()) {
                    int n = m = PDPDatePickerDialog.this.monthField.getSelectionIndex() == 0 ? 12 : PDPDatePickerDialog.this.monthField.getSelectionIndex();
                }
                if (PDPDatePickerDialog.this.model.getEnd() < cell) {
                    int n = m = PDPDatePickerDialog.this.monthField.getSelectionIndex() == 11 ? 1 : PDPDatePickerDialog.this.monthField.getSelectionIndex() + 2;
                }
                if (cell <= PDPDatePickerDialog.this.model.getStart() && PDPDatePickerDialog.this.monthField.getSelectionIndex() == 0) {
                    --y;
                }
                if (PDPDatePickerDialog.this.model.getEnd() < cell && PDPDatePickerDialog.this.monthField.getSelectionIndex() == 11) {
                    ++y;
                }
                String dd = String.valueOf(d).length() < 2 ? "0" + String.valueOf(d) : String.valueOf(d);
                String mm = String.valueOf(m).length() < 2 ? "0" + String.valueOf(m) : String.valueOf(m);
                PDPDatePickerDialog.this.input = PDPDateFormatter.dateFromString(dd, mm, String.valueOf(y));
                PDPDatePickerDialog.this.shell.close();
            }

            public void mouseUp(MouseEvent e) {
            }
        }
        CursorMouseListener cml = new CursorMouseListener();
        this.cursor.addMouseListener((MouseListener)cml);
        final class MonthModifyListener
        implements ModifyListener {
            String text;
            String t;
            int length;
            int match;

            MonthModifyListener() {
            }

            public void modifyText(ModifyEvent e) {
                PDPDatePickerDialog.this.monthField.removeModifyListener((ModifyListener)this);
                this.text = PDPDatePickerDialog.this.monthField.getText();
                this.length = this.text.length();
                while (!this.valid(this.text) & this.length != 0) {
                    this.text = this.t = this.text.substring(0, --this.length);
                }
                if (this.match == -1) {
                    PDPDatePickerDialog.this.monthField.setText(this.length > 1 ? this.text.substring(0, this.length - 1) : "");
                    PDPDatePickerDialog.this.monthField.setSelection(new Point(this.length - 1, this.length - 1));
                } else {
                    PDPDatePickerDialog.this.monthField.setSelection(new Point(this.length, months[this.match].length()));
                    PDPDatePickerDialog.this.change();
                }
                PDPDatePickerDialog.this.monthField.addModifyListener((ModifyListener)this);
            }

            private boolean valid(String t) {
                this.match = -1;
                int i = 0;
                while (i < 12) {
                    if (this.length == 0) break;
                    if (t.regionMatches(true, 0, months[i], 0, this.length)) {
                        this.match = i;
                        PDPDatePickerDialog.this.monthField.setText(months[i]);
                    }
                    ++i;
                }
                return this.match != -1;
            }
        }
        this.vm = new MonthModifyListener();
        this.monthField.addModifyListener(this.vm);
        final class VerifyYear
        implements VerifyListener {
            VerifyYear() {
            }

            public void verifyText(VerifyEvent event) {
                event.doit = false;
                if (Character.isDigit(event.character)) {
                    event.doit = true;
                } else if (event.character == '\b' || event.character == '\u007f') {
                    event.doit = true;
                } else if (event.character == '\u1000003' || event.character == '\u1000004') {
                    event.doit = true;
                } else if (event.character == '\r') {
                    event.doit = true;
                }
            }
        }
        this.vy = new VerifyYear();
        this.yearField.addVerifyListener(this.vy);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent me) {
                Point point = new Point(me.x, me.y);
                TableItem item = PDPDatePickerDialog.this.table.getItem(point);
                if (item != null) {
                    int col = -1;
                    int i = 0;
                    int n = PDPDatePickerDialog.this.table.getColumnCount();
                    while (i < n) {
                        Rectangle bounds = item.getBounds(i);
                        if (bounds.contains(point)) {
                            col = i;
                            break;
                        }
                        ++i;
                    }
                    if (col > -1) {
                        PDPDatePickerDialog.this.table.deselectAll();
                        int cell = PDPDatePickerDialog.this.table.indexOf(item) * 7 + col;
                        int d = Integer.parseInt(item.getText(col));
                        int m = PDPDatePickerDialog.this.monthField.getText().length() == 0 ? 1 : PDPDatePickerDialog.this.monthField.getSelectionIndex() + 1;
                        int y = PDPDatePickerDialog.this.yearField.getText().length() == 0 ? 0 : Integer.parseInt(PDPDatePickerDialog.this.yearField.getText());
                        if (cell <= PDPDatePickerDialog.this.model.getStart()) {
                            int n2 = m = PDPDatePickerDialog.this.monthField.getSelectionIndex() == 0 ? 12 : PDPDatePickerDialog.this.monthField.getSelectionIndex();
                        }
                        if (PDPDatePickerDialog.this.model.getEnd() < cell) {
                            int n3 = m = PDPDatePickerDialog.this.monthField.getSelectionIndex() == 11 ? 1 : PDPDatePickerDialog.this.monthField.getSelectionIndex() + 2;
                        }
                        if (cell <= PDPDatePickerDialog.this.model.getStart() && PDPDatePickerDialog.this.monthField.getSelectionIndex() == 0) {
                            --y;
                        }
                        if (PDPDatePickerDialog.this.model.getEnd() < cell && PDPDatePickerDialog.this.monthField.getSelectionIndex() == 11) {
                            ++y;
                        }
                        String dd = String.valueOf(d).length() < 2 ? "0" + String.valueOf(d) : String.valueOf(d);
                        String mm = String.valueOf(m).length() < 2 ? "0" + String.valueOf(m) : String.valueOf(m);
                        PDPDatePickerDialog.this.input = PDPDateFormatter.dateFromString(dd, mm, String.valueOf(y));
                        PDPDatePickerDialog.this.shell.close();
                    }
                }
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void change() {
        int m = this.monthField.getSelectionIndex();
        int y = Integer.parseInt(this.yearField.getText());
        GregorianCalendar now = new GregorianCalendar();
        int mNow = now.get(2);
        int yNow = now.get(1);
        PDPDatePickerModel oldModel = this.model;
        this.model = m == mNow & y == yNow ? new PDPDatePickerModel(true) : new PDPDatePickerModel(new GregorianCalendar(y, m, 1), true);
        oldModel.fireEvent(this.model, "UI Action");
    }

    public Point getAbsoluteLocation() {
        int x = 0;
        int y = 0;
        while (true) {
            x += PDPDatePickerDialog.cell.getBounds().x;
            y += PDPDatePickerDialog.cell.getBounds().y;
            Shell owner = cell.getShell();
            if (owner == cell) break;
            cell = owner;
        }
        return new Point(x, y);
    }

    public Point getAbsoluteLocation(Control c) {
        Rectangle parentRect = c.getDisplay().map((Control)c.getParent(), null, c.getBounds());
        while (true) {
            int cfr_ignored_0 = c.getBounds().x;
            int cfr_ignored_1 = c.getBounds().y;
            Shell owner = c.getShell();
            if (owner == c) break;
            c = owner;
        }
        return new Point(parentRect.x, parentRect.y);
    }

    public void contain() {
        Shell parent = this.getParent();
        Rectangle pBounds = parent.getBounds();
        Rectangle myBounds = this.getShell().getBounds();
        if (!pBounds.contains(myBounds.x, myBounds.y) || !pBounds.contains(myBounds.x + myBounds.width, myBounds.y + myBounds.height)) {
            int xDelta = pBounds.x + pBounds.width - (myBounds.x + myBounds.width);
            int yDelta = pBounds.y + pBounds.height - (myBounds.y + myBounds.height);
            if (xDelta > 0) {
                xDelta = 0;
            }
            if (yDelta > 0) {
                yDelta = 0;
            }
            this.getShell().setLocation(myBounds.x + xDelta, myBounds.y + yDelta);
        }
    }

    public class MouseHandler
    implements MouseListener,
    MouseMoveListener {
        private Shell shell;
        private PDPDatePickerDialog dialog;
        private boolean down = false;
        private int dX;
        private int dY;

        public MouseHandler(PDPDatePickerDialog d) {
            this.dialog = d;
            this.shell = this.dialog.getShell();
            this.shell.addMouseListener((MouseListener)this);
            this.shell.addMouseMoveListener((MouseMoveListener)this);
        }

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            this.down = true;
            this.dX = e.x;
            this.dY = e.y;
        }

        public void mouseUp(MouseEvent e) {
            this.down = false;
        }

        public void mouseMove(MouseEvent e) {
            if (!this.down) {
                return;
            }
            Point dP = this.shell.getLocation();
            Point absP = new Point(dP.x - this.dX + e.x, dP.y - this.dY + e.y);
            this.shell.setLocation(absP);
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        StructuredViewer viewer = null;

        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
            this.viewer = (StructuredViewer)v;
            if (oldInput != newInput) {
                if (oldInput != null) {
                    ((PDPDatePickerModel)oldInput).removePropertyChangeListener(this);
                }
                if (newInput != null) {
                    ((PDPDatePickerModel)newInput).addPropertyChangeListener(this);
                }
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            this.inputChanged((Viewer)this.viewer, e.getOldValue(), e.getNewValue());
            Control control = this.viewer.getControl();
            if (control != null && !control.isDisposed()) {
                control.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ViewContentProvider.this.viewer.refresh();
                        if (PDPDatePickerDialog.this.cursor != null) {
                            PDPDatePickerDialog.this.cursor.redraw();
                        }
                    }
                });
            }
        }

        public void dispose() {
            if (PDPDatePickerDialog.this.grey != null & !PDPDatePickerDialog.this.grey.isDisposed()) {
                PDPDatePickerDialog.this.grey.dispose();
            }
            if (PDPDatePickerDialog.this.red != null & !PDPDatePickerDialog.this.red.isDisposed()) {
                PDPDatePickerDialog.this.red.dispose();
            }
            if (PDPDatePickerDialog.this.yellow != null & !PDPDatePickerDialog.this.yellow.isDisposed()) {
                PDPDatePickerDialog.this.yellow.dispose();
            }
            if (PDPDatePickerDialog.this.black != null & !PDPDatePickerDialog.this.black.isDisposed()) {
                PDPDatePickerDialog.this.black.dispose();
            }
            if (PDPDatePickerDialog.this.white != null & !PDPDatePickerDialog.this.white.isDisposed()) {
                PDPDatePickerDialog.this.white.dispose();
            }
            if (PDPDatePickerDialog.this.bluegrey != null & !PDPDatePickerDialog.this.bluegrey.isDisposed()) {
                PDPDatePickerDialog.this.bluegrey.dispose();
            }
        }

        public Object[] getElements(Object parent) {
            int[][] array = PDPDatePickerDialog.this.model.getMonthArray();
            int[][] paddedArray = new int[6][8];
            int i = 0;
            while (i < 6) {
                int j = 0;
                while (j < 8) {
                    paddedArray[i][j] = j == 0 ? 0 : array[i][j - 1];
                    ++j;
                }
                ++i;
            }
            return paddedArray;
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private int start;
        private int end;
        private int today;

        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            TableItem[] items = PDPDatePickerDialog.this.table.getItems();
            if (items.length == 6 & index == 7) {
                int i = 0;
                while (i < 6) {
                    int k = 0;
                    while (k < 7) {
                        PDPDatePickerDialog.this.table.getItems()[i].setForeground(k + 1, PDPDatePickerDialog.this.black);
                        ++k;
                    }
                    ++i;
                }
                this.start = PDPDatePickerDialog.this.model.getStart();
                this.end = PDPDatePickerDialog.this.model.getEnd();
                this.today = PDPDatePickerDialog.this.model.getToday();
                i = 0;
                while (i < this.start) {
                    items[0].setForeground(i + 1, PDPDatePickerDialog.this.grey);
                    ++i;
                }
                if (42 - this.end > 7) {
                    i = 7 - (42 % this.end - 7);
                    while (i < 7) {
                        items[4].setForeground(i + 1, PDPDatePickerDialog.this.grey);
                        ++i;
                    }
                    i = 0;
                    while (i < 7) {
                        items[5].setForeground(i + 1, PDPDatePickerDialog.this.grey);
                        ++i;
                    }
                } else {
                    i = 7 - 42 % this.end;
                    while (i < 7) {
                        items[5].setForeground(i + 1, PDPDatePickerDialog.this.grey);
                        ++i;
                    }
                }
                if (this.today != -1) {
                    items[this.today / 7].setForeground(1 + this.today % 7, PDPDatePickerDialog.this.red);
                }
            }
            todayPoint.x = 1 + PDPDatePickerDialog.this.model.getWhere() % 7;
            todayPoint.y = PDPDatePickerDialog.this.model.getWhere() / 7;
            return String.valueOf(((int[])obj)[index]);
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }

        public Image getImage(Object obj) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

