/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.control;

import com.ibm.pdp.widgets.ui.control.PDPAbstractControl;
import com.ibm.pdp.widgets.ui.swt.control.internal.PDPComboToolTip;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class PDPCombo
extends PDPAbstractControl {
    ModifyListener modifyListener;
    KeyListener keyListener;
    private boolean isTraversePrevouis = false;
    private boolean isTraverseNext = false;
    private boolean disableArrowKeyUp;
    private boolean disableArrowKeyDown;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPCombo(Composite parent, int style) {
        super(parent, style);
        this.defaultBackground = null;
        this.getCCombo().addModifyListener(this.getModifyListener());
    }

    public void setItems(String[] items) {
        ((CCombo)this.swtControl).setItems(items);
    }

    public void setItems(String[] items, String[] tooltips) {
        ((PDPComboToolTip)this.swtControl).removeAll();
        int i = 0;
        while (i < items.length) {
            ((PDPComboToolTip)this.swtControl).add(items[i], tooltips[i]);
            ++i;
        }
    }

    public void setEditable(boolean editable, boolean swteditable) {
        this.editable = editable;
        this.getCCombo().setEditable(swteditable);
        if (!swteditable) {
            this.setBackground(this.getReadOnlyColor());
        } else {
            this.setBackground(this.getDefaultColor());
        }
    }

    public CCombo getCCombo() {
        return (CCombo)this.getInternalSwtControl();
    }

    protected void initialize(int style) {
        this.swtControl = new PDPComboToolTip(this, style);
        this.setLayout((Layout)new FillLayout());
        this.getCCombo().addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                PDPCombo.this.getCCombo().setSelection(new Point(0, 0));
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                PDPCombo.this.getCCombo().setSelection(new Point(0, 0));
            }
        });
        this.keyListener = new KeyListener(){

            public void keyReleased(KeyEvent event) {
                this.handleArrowKeys(event);
            }

            public void keyPressed(KeyEvent event) {
                this.handleArrowKeys(event);
            }

            private void handleArrowKeys(KeyEvent event) {
                if (event.keyCode == 0x1000001) {
                    event.doit = !PDPCombo.this.disableArrowKeyUp;
                    PDPCombo.this.disableArrowKeyUp = false;
                } else if (event.keyCode == 0x1000002) {
                    event.doit = !PDPCombo.this.disableArrowKeyDown;
                    PDPCombo.this.disableArrowKeyDown = false;
                }
            }
        };
        this.getCCombo().addKeyListener(this.keyListener);
    }

    protected ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){
                int match;
                int length;

                public void modifyText(ModifyEvent e) {
                    if (!PDPCombo.this.isEditable()) {
                        PDPCombo.this.getCCombo().removeModifyListener((ModifyListener)this);
                        PDPCombo.this.setDisplayText(PDPCombo.this.value == null ? "" : PDPCombo.this.value);
                        PDPCombo.this.getCCombo().addModifyListener((ModifyListener)this);
                        return;
                    }
                    this.match = -1;
                    this.length = -1;
                    PDPCombo.this.getCCombo().removeModifyListener((ModifyListener)this);
                    String text = PDPCombo.this.getCCombo().getText();
                    this.length = text.length();
                    while (!this.Valid(text) & this.length != 0) {
                        String t;
                        text = t = text.substring(0, --this.length);
                    }
                    if (this.match == -1) {
                        PDPCombo.this.getCCombo().setText(this.length > 1 ? text.substring(0, this.length - 1) : "");
                        PDPCombo.this.getCCombo().setSelection(new Point(this.length - 1, this.length - 1));
                    } else {
                        PDPCombo.this.getCCombo().setSelection(new Point(0, 0));
                        Object newValue = PDPCombo.this.getDisplayText();
                        if (PDPCombo.this.isValidationRequired() && PDPCombo.this.isValid(newValue) == null) {
                            PDPCombo.this.updateValue(newValue);
                            PDPCombo.this.notifyChanges(false);
                        }
                    }
                    PDPCombo.this.getCCombo().addModifyListener((ModifyListener)this);
                }

                private boolean Valid(String t) {
                    int i = 0;
                    while (i < PDPCombo.this.getCCombo().getItemCount()) {
                        if (this.length == 0) break;
                        if (t.equals(PDPCombo.this.getCCombo().getItem(i))) {
                            this.match = i;
                            PDPCombo.this.getCCombo().setText(PDPCombo.this.getCCombo().getItem(i));
                            PDPCombo.this.getCCombo().setSelection(new Point(0, 0));
                            break;
                        }
                        ++i;
                    }
                    return this.match != -1;
                }
            };
        }
        return this.modifyListener;
    }

    protected void computePattern() {
    }

    public void setDisplayText(Object value) {
        if (this.modifyListener != null) {
            this.getCCombo().removeModifyListener(this.modifyListener);
        }
        this.getCCombo().setText(value.toString());
        this.getCCombo().setSelection(new Point(0, 0));
        if (this.modifyListener != null) {
            this.getCCombo().addModifyListener(this.modifyListener);
        }
    }

    protected Object getDisplayText() {
        return this.getCCombo().getText();
    }

    public String getText() {
        return this.getCCombo().getText();
    }

    public void select(int value) {
        this.getCCombo().select(value);
    }

    protected void handleFocusGained() {
        if (this.isTraverseNext || this.isTraversePrevouis) {
            this.getInternalSwtControl().traverse(8);
            this.isTraverseNext = false;
            this.isTraversePrevouis = false;
        } else if (!this.isEditable()) {
            this.getInternalSwtControl().traverse(8);
        } else {
            super.handleFocusGained();
            this.getCCombo().setFocus();
        }
    }

    protected void handleFocusLost() {
        this.isTraversePrevouis = false;
        this.isTraverseNext = false;
        super.handleFocusLost();
    }

    public boolean isValidString(String newValue) {
        int i = 0;
        while (i < this.getCCombo().getItemCount()) {
            if (this.getCCombo().getItem(i).equals(newValue)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean canMoveWithArrowUp() {
        return false;
    }

    public boolean canMoveWithArrowDown() {
        return false;
    }
}

