/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.control;

import com.ibm.pdp.widgets.ui.control.PDPAbstractControl;
import com.ibm.pdp.widgets.ui.control.PDPFormToolkit;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;

public class PDPBoolean
extends PDPAbstractControl {
    ModifyListener modifyListener;
    String label = null;
    boolean isMouseClicked = false;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2012.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPBoolean(Composite parent, int style, String label) {
        this(parent, style);
        this.initializeLabel(label);
    }

    public PDPBoolean(Composite parent, int style) {
        super(parent, style);
        if (!(parent instanceof Table) && parent.getParent() != null && !(parent.getParent() instanceof Table)) {
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 1: {
                            if (event.keyCode != 13) break;
                            PDPBoolean.this.getInternalSwtControl().traverse(16);
                        }
                    }
                }
            };
            int[] text_events = new int[]{1};
            int i = 0;
            while (i < text_events.length) {
                ((Button)this.getInternalSwtControl()).addListener(text_events[i], listener);
                ++i;
            }
        }
        SelectionAdapter selectListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PDPBoolean.this.value = new Boolean(PDPBoolean.this.getButtonControl().getSelection());
                PDPBoolean.this.notifyChanges(false);
            }
        };
        ((Button)this.getInternalSwtControl()).addSelectionListener((SelectionListener)selectListener);
    }

    protected void initialize(int style) {
        this.swtControl = new PDPFormToolkit(this.getDisplay()).createButton(this, this.label, 32);
        this.setLayout((Layout)new FillLayout());
    }

    public void initializeLabel(String label) {
        Button button = (Button)this.swtControl;
        if (label != null) {
            button.setText(label);
        }
    }

    public void setEditable(boolean editable, boolean swteditable) {
        this.editable = editable;
        this.swtControl.setEnabled(swteditable);
        if (!swteditable) {
            this.setBackground(this.getReadOnlyColor());
        } else {
            this.setBackground(this.getDefaultColor());
        }
    }

    protected ModifyListener getModifyListener() {
        if (this.modifyListener == null) {
            this.modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Object newValue = PDPBoolean.this.getDisplayText();
                    if (PDPBoolean.this.isValidationRequired() && PDPBoolean.this.isValid(newValue) == null) {
                        PDPBoolean.this.updateValue(newValue);
                        PDPBoolean.this.notifyChanges(false);
                    }
                }
            };
        }
        return this.modifyListener;
    }

    protected void computePattern() {
    }

    protected void handleFocusGained() {
        if (!this.isEditable() && !this.isMouseClicked) {
            this.getInternalSwtControl().traverse(16);
        } else {
            super.handleFocusGained();
        }
    }

    protected void handleFocusLost() {
        if (!this.isEditable() && !this.isMouseClicked) {
            return;
        }
        super.handleFocusLost();
        this.isMouseClicked = false;
    }

    protected Button getButtonControl() {
        return (Button)this.getInternalSwtControl();
    }

    protected Object getDisplayText() {
        return this.value.toString();
    }

    public void setDisplayText(Object value) {
        if (value != null) {
            this.getButtonControl().setSelection(this.getBooleanValue());
        } else {
            this.getButtonControl().setSelection(false);
        }
    }

    public boolean getBooleanValue() {
        return new Boolean(this.getValue().toString());
    }

    public void setBooleanValue(boolean value) {
        super.setValue(new Boolean(value));
    }
}

