/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.control;

import com.ibm.pdp.widgets.ui.control.PDPAbstractControl;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public abstract class PDPAbstractPicker
extends PDPAbstractControl {
    private List<Button> buttons;
    PDPAbstractControl pdpControl;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPAbstractPicker(Composite parent, int style) {
        super(parent, style);
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 1: {
                        if (event.keyCode == 0x100000B && PDPAbstractPicker.this.isEditable()) {
                            Object tmpValue = PDPAbstractPicker.this.openDialogBox((Control)PDPAbstractPicker.this.buttons.get(0));
                            if (tmpValue != null) {
                                PDPAbstractPicker.this.setValue(tmpValue);
                                PDPAbstractPicker.this.setDisplayText(tmpValue);
                                PDPAbstractPicker.this.notifyChanges(true);
                            }
                            if (!PDPAbstractPicker.this.getInternalSwtControl().isDisposed()) {
                                PDPAbstractPicker.this.getInternalSwtControl().setFocus();
                            }
                        }
                        if (event.keyCode != 127 || !PDPAbstractPicker.this.isEditable()) break;
                        PDPAbstractPicker.this.removeValue();
                    }
                }
            }
        };
        int[] text_events = new int[]{1};
        int i = 0;
        while (i < text_events.length) {
            ((Text)this.getInternalSwtControl()).addListener(text_events[i], listener);
            ++i;
        }
    }

    protected void removeValue() {
    }

    protected Button getInternalSwtButton() {
        return this.buttons.get(0);
    }

    public Object getSwtButton() {
        return this.buttons.get(0);
    }

    protected PDPAbstractControl getInternalPDPControl() {
        return this.pdpControl;
    }

    public void setEditable(boolean editable, boolean swteditable) {
        this.editable = editable;
        this.getInternalPDPControl().setEditable(editable, swteditable);
        this.getInternalSwtButton().setEnabled(editable);
        if (!swteditable) {
            this.setBackground(this.getReadOnlyColor());
        } else {
            this.setBackground(this.getDefaultColor());
        }
    }

    public boolean setFocus() {
        return super.setFocus();
    }

    public void setValue(Object value) {
        this.pdpControl.setValue(value);
        super.setValue(value);
    }

    protected void setContentAssistOpen(boolean isContentAssistOpen) {
        this.pdpControl.setContentAssistOpen(isContentAssistOpen);
        super.setContentAssistOpen(isContentAssistOpen);
    }

    protected void initialize(int style) {
        this.setLayout(new PDPDialogLayout());
        this.buttons = new ArrayList<Button>();
        this.pdpControl = this.createPDPControl(this, style);
        this.swtControl = this.pdpControl.getInternalSwtControl();
        this.createButton(this, style);
        this.buttons.get(0).addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Object tmpValue = PDPAbstractPicker.this.openDialogBox((Control)PDPAbstractPicker.this.buttons.get(0));
                if (tmpValue != null) {
                    PDPAbstractPicker.this.setValue(tmpValue);
                    PDPAbstractPicker.this.setDisplayText(tmpValue);
                    PDPAbstractPicker.this.notifyChanges(true);
                }
                if (!PDPAbstractPicker.this.getInternalSwtControl().isDisposed()) {
                    PDPAbstractPicker.this.getInternalSwtControl().setFocus();
                }
            }
        });
    }

    protected Button createButton(Composite parent, int style) {
        int buttonStyle = (style & 0x800000) == 0 ? 525312 : 0x880400;
        Button result = new Button(parent, buttonStyle);
        if (this.buttons.isEmpty()) {
            result.setText("..");
        }
        this.buttons.add(result);
        return result;
    }

    public void setDisplayText(Object value) {
        if (this.pdpControl == null || this.pdpControl.isDisposed()) {
            return;
        }
        this.pdpControl.setDisplayText(value != null ? value : "");
    }

    protected Object getDisplayText() {
        return this.pdpControl.getDisplayText();
    }

    protected void setValidationRequired(boolean validationRequired) {
        super.setValidationRequired(validationRequired);
        this.pdpControl.setValidationRequired(validationRequired);
    }

    protected boolean isValidationRequired() {
        return super.isValidationRequired() && this.pdpControl.isValidationRequired();
    }

    public boolean isValidString(String newValue) {
        return this.pdpControl.isValidString(newValue);
    }

    protected void computePattern() {
    }

    protected void handleFocusGained() {
        if (this.isEditable()) {
            this.setBackground(this.getDefaultColor());
        } else {
            this.setBackground(this.getReadOnlyColor());
        }
    }

    protected void handleFocusLost() {
        if (this.value != null && this.value != this.getInternalPDPControl().getValue() && !this.value.toString().equals(this.getInternalPDPControl().getValue().toString())) {
            this.value = this.getInternalPDPControl().getValue();
            this.notifyChanges(true);
        } else if (!this.isEditable()) {
            this.setDisplayText(this.getValue().toString());
        }
    }

    public Object getCellEditorValue() {
        this.value = this.getInternalPDPControl().getCellEditorValue();
        return this.value;
    }

    protected void updateValue(Object newValue) {
        this.value = newValue;
    }

    public PDPAbstractControl getPDPControl() {
        return this.pdpControl;
    }

    public void setPDPControl(PDPAbstractControl pdpControl) {
        this.pdpControl = pdpControl;
    }

    protected abstract Object openDialogBox(Control var1);

    protected abstract PDPAbstractControl createPDPControl(Composite var1, int var2);

    private class PDPDialogLayout
    extends Layout {
        private PDPDialogLayout() {
        }

        public void layout(Composite editor, boolean force) {
            Rectangle bounds = editor.getClientArea();
            boolean hasImage = false;
            for (Button button : PDPAbstractPicker.this.buttons) {
                if (button.getImage() == null) continue;
                hasImage = true;
            }
            int bSize = hasImage ? 22 : 16;
            Point size = new Point(bSize * PDPAbstractPicker.this.buttons.size(), bSize);
            for (Button button : PDPAbstractPicker.this.buttons) {
                button.computeSize(bSize, bSize, force);
            }
            if (PDPAbstractPicker.this.pdpControl != null) {
                PDPAbstractPicker.this.pdpControl.setBounds(0, 0, bounds.width - size.x, bounds.height);
            }
            int i = 0;
            while (i < PDPAbstractPicker.this.buttons.size()) {
                ((Button)PDPAbstractPicker.this.buttons.get(i)).setBounds(bounds.width - bSize * (i + 1), 0, bSize, bounds.height);
                ++i;
            }
        }

        public Point computeSize(Composite editor, int wHint, int hHint, boolean force) {
            Point contentsSize = PDPAbstractPicker.this.pdpControl.computeSize(-1, -1, force);
            return new Point(editor.getClientArea().x, contentsSize.y);
        }
    }
}

