/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.control;

import com.ibm.pdp.widgets.ui.contentassist.PDPContentProposal;
import com.ibm.pdp.widgets.ui.contentassist.PDPContentProposalAdapter;
import com.ibm.pdp.widgets.ui.contentassist.PDPContentProposalProvider;
import com.ibm.pdp.widgets.ui.contentassist.PDPTextContentAdapter;
import com.ibm.pdp.widgets.ui.formatter.IPDPFormatter;
import com.ibm.pdp.widgets.ui.notification.PDPAdapter;
import com.ibm.pdp.widgets.ui.notification.PDPNotification;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PDPAbstractControl
extends Composite
implements ICellEditorValidator {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Pattern pattern;
    private String errorMessage;
    protected String defaultErrorMessage;
    protected Control swtControl;
    protected Object value;
    protected Object element;
    protected String property;
    private boolean notificationRequired = true;
    private boolean validationRequired = true;
    FocusListener focusListener;
    protected boolean editable = true;
    protected Color defaultBackground = null;
    protected boolean isInError = false;
    private IPDPFormatter formatter;
    private List<PDPAdapter> adapters = new ArrayList<PDPAdapter>();
    private boolean isContentAssistOpen = false;
    private IContentProposal currentProposal = null;
    boolean autoRaiseContentAssit = false;

    public PDPAbstractControl(Composite parent, int style) {
        super(parent, 0);
        this.initialize(style);
        if (this.swtControl != null) {
            this.swtControl.addFocusListener(this.getFocusListener());
        }
        this.defaultBackground = this.swtControl.getBackground();
    }

    public boolean isNotificationRequired() {
        return this.notificationRequired;
    }

    public void setNotificationRequired(boolean notificationRequired) {
        this.notificationRequired = notificationRequired;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    public boolean isValidString(String newValue) {
        boolean result = true;
        if ("".equals(newValue)) {
            return true;
        }
        if (this.pattern != null) {
            Matcher m = this.pattern.matcher(newValue);
            result = m.matches();
        }
        if (!result) {
            this.setBackground(this.getErrorColor());
            this.setErrorMessage(this.defaultErrorMessage);
        } else if (this.isEditable()) {
            this.setBackground(this.getDefaultColor());
        } else {
            this.setBackground(this.getReadOnlyColor());
        }
        return result;
    }

    public Object getElement() {
        return this.element;
    }

    public void setElement(Object element) {
        this.element = element;
    }

    public final String isValid(Object newValue) {
        return this.isBasicValid(newValue, true);
    }

    protected String isBasicValid(Object newValue, boolean raiseError) {
        if (newValue != null) {
            boolean isValidString = this.isValidString(newValue.toString());
            if (!isValidString) {
                if (raiseError) {
                    this.setStatus(newValue + " " + this.getErrorMessage());
                }
                return this.getErrorMessage();
            }
            this.setStatus("");
            return null;
        }
        return null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    protected Control getInternalSwtControl() {
        return this.swtControl;
    }

    public Object getSwtControl() {
        return this.swtControl;
    }

    public void setValue(Object value, boolean mustSetDisplay) {
        this.isInError = false;
        this.value = value;
        this.setValidationRequired(false);
        if (mustSetDisplay) {
            this.setDisplayText(value);
        }
        this.isValid(value);
        this.setValidationRequired(true);
    }

    public void setValue(Object value) {
        this.setValue(value, true);
    }

    public Object getValue() {
        return this.value;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    protected boolean isValidationRequired() {
        return this.validationRequired;
    }

    protected void setValidationRequired(boolean validationRequired) {
        this.validationRequired = validationRequired;
    }

    protected final void notifyChanges(boolean isFocusLost) {
        if (this.isContentAssistOpen()) {
            return;
        }
        if (this.notificationRequired && this.adapters != null) {
            int i = 0;
            while (i < this.adapters.size()) {
                PDPNotification notification = new PDPNotification((Object)this);
                PDPAdapter adapter = this.adapters.get(i);
                if (!adapter.isOnFocusLost()) {
                    adapter.notifyChanged(notification);
                } else if (isFocusLost) {
                    adapter.notifyChanged(notification);
                }
                ++i;
            }
        }
    }

    protected FocusListener getFocusListener() {
        if (this.focusListener == null) {
            this.focusListener = new FocusListener(){

                public void focusLost(FocusEvent e) {
                    PDPAbstractControl.this.handleFocusLost();
                }

                public void focusGained(FocusEvent e) {
                    PDPAbstractControl.this.handleFocusGained();
                }
            };
        }
        return this.focusListener;
    }

    protected void handleFocusGained() {
        if (this.isEditable()) {
            this.setBackground(this.getDefaultColor());
        } else {
            this.setBackground(this.getReadOnlyColor());
        }
        this.setValidationRequired(false);
        if (this.isInError) {
            this.setDisplayText(this.getDisplayText());
            this.isInError = false;
        } else if (this.value != null) {
            this.setDisplayText(this.value);
        }
        this.setValidationRequired(true);
    }

    protected void handleFocusLost() {
        if (this.getDisplayText() == null || !this.isValidString(this.getDisplayText().toString())) {
            this.isInError = true;
            return;
        }
        this.updateValue(this.value);
        this.notifyChanges(true);
        this.isInError = false;
        this.setValidationRequired(false);
        if (this.value != null) {
            this.setDisplayText(this.value);
        }
        this.setValidationRequired(true);
        if (this.value != null) {
            this.isValid(this.value);
        }
        this.setStatus("");
    }

    public Object getCellEditorValue() {
        if (this.value != null && this.isValidString(this.value.toString())) {
            this.updateValue(this.value);
            this.notifyChanges(false);
        }
        return this.getValue();
    }

    public void setCellEditorValue(Object value) {
        this.setValue(value);
    }

    protected void updateValue(Object newValue) {
        this.value = newValue;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.swtControl.setBackground(color);
    }

    public IPDPFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(IPDPFormatter formatter) {
        this.formatter = formatter;
    }

    public abstract void setEditable(boolean var1, boolean var2);

    protected Color getReadOnlyColor() {
        Color color = this.swtControl.getDisplay().getSystemColor(15);
        return color;
    }

    protected Color getErrorColor() {
        Color color = this.swtControl.getDisplay().getSystemColor(3);
        return color;
    }

    protected Color getDefaultColor() {
        return this.defaultBackground;
    }

    protected Color getWarningColor() {
        Color color = this.swtControl.getDisplay().getSystemColor(7);
        return color;
    }

    protected void setStatus(String message) {
    }

    protected abstract void initialize(int var1);

    protected abstract Object getDisplayText();

    protected Object format(Object value) {
        if (this.formatter == null) {
            return value;
        }
        return this.formatter.format(value);
    }

    public List<PDPAdapter> getAdapters() {
        return this.adapters;
    }

    public abstract void setDisplayText(Object var1);

    protected abstract void computePattern();

    public IContentProposal getCurrentProposal() {
        return this.currentProposal;
    }

    public boolean isContentAssistOpen() {
        return this.isContentAssistOpen;
    }

    protected void setContentAssistOpen(boolean isContentAssistOpen) {
        this.isContentAssistOpen = isContentAssistOpen;
    }

    protected final void initContentAssist(ILabelProvider labelProvider, Composite composite, final boolean propagateOnCaAccepted) {
        try {
            PDPContentProposalProvider proposalProvider = new PDPContentProposalProvider(this, labelProvider);
            final PDPContentProposalAdapter adapter = new PDPContentProposalAdapter(this.swtControl, composite, new PDPTextContentAdapter(), proposalProvider, labelProvider){};
            adapter.addContentProposalListener(new IContentProposalListener(){

                public void proposalAccepted(IContentProposal contentProposal) {
                    PDPAbstractControl.this.currentProposal = contentProposal;
                    Object tmpValue = ((PDPContentProposal)contentProposal).getObject();
                    PDPAbstractControl.this.setContentAssistOpen(false);
                    PDPAbstractControl.this.setValue(tmpValue);
                    PDPAbstractControl.this.setDisplayText(PDPAbstractControl.this.getValue());
                    if (propagateOnCaAccepted && tmpValue != null) {
                        PDPAbstractControl.this.notifyChanges(true);
                    }
                    if (!PDPAbstractControl.this.getInternalSwtControl().isDisposed()) {
                        PDPAbstractControl.this.getInternalSwtControl().setFocus();
                        if (PDPAbstractControl.this.getInternalSwtControl() instanceof Text) {
                            Text text = (Text)PDPAbstractControl.this.getInternalSwtControl();
                            text.setSelection(text.getText().length());
                        }
                    }
                    if (PDPAbstractControl.this.autoRaiseContentAssit()) {
                        adapter.pdpOpenProposalPopup();
                        PDPAbstractControl.this.setAutoRaiseContentAssit(false);
                    }
                }
            });
            adapter.addContentProposalListener(new IContentProposalListener2(){

                public void proposalPopupOpened(ContentProposalAdapter adapter) {
                    PDPAbstractControl.this.currentProposal = null;
                    PDPAbstractControl.this.setContentAssistOpen(true);
                }

                public void proposalPopupClosed(ContentProposalAdapter adapter) {
                    PDPAbstractControl.this.setContentAssistOpen(false);
                }
            });
        }
        catch (ParseException parseException) {}
    }

    protected boolean autoRaiseContentAssit() {
        return this.autoRaiseContentAssit;
    }

    protected void setAutoRaiseContentAssit(boolean autoRaiseContentAssit) {
        this.autoRaiseContentAssit = autoRaiseContentAssit;
    }

    public List<Object> getContentProposals(List<Object> proposals, String contents, int position) {
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add("ProposalOne");
        objects.add("ProposalTwo");
        objects.add("ProposalThree");
        ArrayList<ArrayList<Object>> list = new ArrayList<ArrayList<Object>>();
        int i = 0;
        while (i < objects.size()) {
            String text = objects.get(i).toString();
            if (text != null && text.length() >= contents.length() && text.substring(0, position).equalsIgnoreCase(contents.substring(0, position))) {
                list.add(objects);
            }
            ++i;
        }
        return objects;
    }

    public boolean canMoveWithArrowLeft() {
        if (this.getSwtControl() instanceof Text) {
            Text text = (Text)this.getSwtControl();
            return text.getCaretPosition() <= 0 || text.getSelectionCount() == text.getText().length();
        }
        return true;
    }

    public boolean canMoveWithArrowRight() {
        if (this.getSwtControl() instanceof Text) {
            Text text = (Text)this.getSwtControl();
            return text.getText().length() <= text.getCaretPosition();
        }
        return true;
    }

    public boolean canMoveWithArrowUp() {
        return true;
    }

    public boolean canMoveWithArrowDown() {
        return true;
    }
}

