/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.contentassist;

import com.ibm.pdp.widgets.ui.control.PDPText;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.IControlContentAdapter2;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class PDPTextContentAdapter
implements IControlContentAdapter,
IControlContentAdapter2 {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2015, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    PDPText pdpText = null;

    public PDPTextContentAdapter() {
    }

    public PDPTextContentAdapter(PDPText pdpText) {
        this.pdpText = pdpText;
    }

    public String getControlContents(Control control) {
        return ((Text)control).getText();
    }

    public void setControlContents(Control control, String text, int cursorPosition) {
        ((Text)control).setText(text);
        ((Text)control).setSelection(cursorPosition, cursorPosition);
    }

    public void insertControlContents(Control control, String text, int cursorPosition) {
        Text textField = (Text)control;
        Point selection = textField.getSelection();
        textField.insert(text);
        if (cursorPosition < text.length()) {
            textField.setSelection(selection.x + cursorPosition, selection.x + cursorPosition);
        }
    }

    public int getCursorPosition(Control control) {
        return ((Text)control).getCaretPosition();
    }

    public Rectangle getInsertionBounds(Control control) {
        Text text = (Text)control;
        Point caretOrigin = text.getCaretLocation();
        return new Rectangle(caretOrigin.x + text.getClientArea().x, caretOrigin.y + text.getClientArea().y + 3, 1, text.getLineHeight());
    }

    public void setCursorPosition(Control control, int position) {
        ((Text)control).setSelection(new Point(position, position));
    }

    public Point getSelection(Control control) {
        return ((Text)control).getSelection();
    }

    public void setSelection(Control control, Point range) {
        ((Text)control).setSelection(range);
    }
}

