/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.celleditor;

import com.ibm.pdp.widgets.ui.celleditor.IPDPCellEditorWrapper;
import com.ibm.pdp.widgets.ui.celleditor.PDPAbstractCellModifier;
import com.ibm.pdp.widgets.ui.celleditor.PDPContentProvider;
import com.ibm.pdp.widgets.ui.celleditor.PDPGenericCellEditor;
import com.ibm.pdp.widgets.ui.control.PDPAbstractControl;
import com.ibm.pdp.widgets.ui.notification.PDPAdapter;
import com.ibm.pdp.widgets.ui.notification.PDPNotification;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellNavigationStrategy;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.FocusCellHighlighter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.SWTFocusCellManager;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.jface.viewers.TreeViewerFocusCellManager;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class PDPCellEditorHandler {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected static boolean isDoubleClickSelection = false;
    protected IPDPCellEditorWrapper _cellEditorWrapper;
    protected CellEditor[] _cellEditors = null;
    protected PDPGenericCellEditor _cellEditor = null;
    String[] _arrayProperties = null;
    boolean _isOnSelectionChange = false;
    boolean _isOnTraverse = false;
    int _selectedColumnIndex = -1;
    int _lastSelectedColumnIndex = -1;
    Widget _currentWidget = null;
    Widget _lastWidget = null;
    boolean _isMouseActivaton = false;
    boolean _isUpdating = false;
    Object _element = null;
    String _property = null;
    Object _value = null;
    boolean _isFirstClickSelection = true;
    boolean _markFocusCell = true;
    boolean _interceptCollapseExpandEvent = true;
    boolean _forceEditOnSelection = true;
    public Event _traverseEvent = null;
    boolean isCellEditorActive = false;

    public PDPCellEditorHandler(IPDPCellEditorWrapper cellEditorWrapper, String[] arrayProperties) {
        this._cellEditorWrapper = cellEditorWrapper;
        this._arrayProperties = arrayProperties;
        this.initCellEditors();
    }

    public PDPCellEditorHandler(IPDPCellEditorWrapper cellEditorWrapper, String[] arrayProperties, boolean isFirstClickSelection) {
        this._cellEditorWrapper = cellEditorWrapper;
        this._arrayProperties = arrayProperties;
        this._isFirstClickSelection = isFirstClickSelection;
        this.initCellEditors();
    }

    public PDPCellEditorHandler(IPDPCellEditorWrapper cellEditorWrapper, String[] arrayProperties, boolean isFirstClickSelection, boolean markFocusCell) {
        this._cellEditorWrapper = cellEditorWrapper;
        this._arrayProperties = arrayProperties;
        this._isFirstClickSelection = isFirstClickSelection;
        this._markFocusCell = markFocusCell;
        this.initCellEditors();
    }

    public PDPCellEditorHandler(IPDPCellEditorWrapper cellEditorWrapper, String[] arrayProperties, boolean isFirstClickSelection, boolean markFocusCell, boolean interceptCollapseExpandEvent) {
        this._cellEditorWrapper = cellEditorWrapper;
        this._arrayProperties = arrayProperties;
        this._isFirstClickSelection = isFirstClickSelection;
        this._markFocusCell = markFocusCell;
        this._interceptCollapseExpandEvent = interceptCollapseExpandEvent;
        this.initCellEditors();
    }

    public PDPCellEditorHandler(IPDPCellEditorWrapper cellEditorWrapper, String[] arrayProperties, boolean isFirstClickSelection, boolean markFocusCell, boolean interceptCollapseExpandEvent, boolean forceEditOnSelection) {
        this._cellEditorWrapper = cellEditorWrapper;
        this._arrayProperties = arrayProperties;
        this._isFirstClickSelection = isFirstClickSelection;
        this._markFocusCell = markFocusCell;
        this._interceptCollapseExpandEvent = interceptCollapseExpandEvent;
        this._forceEditOnSelection = forceEditOnSelection;
        this.initCellEditors();
    }

    protected void initCellEditors() {
        boolean hasForeignControl = false;
        CellEditor[] cellEditors = this.getColumnViewer().getCellEditors();
        if (cellEditors == null) {
            cellEditors = this._cellEditorWrapper.getCellEditors(this._arrayProperties);
        }
        if (cellEditors != null) {
            ColumnViewerEditorActivationStrategy actSupport;
            this.getColumnViewer().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (PDPCellEditorHandler.this._forceEditOnSelection) {
                        PDPCellEditorHandler.this.selectionChangeEvent(event);
                    } else if (PDPCellEditorHandler.this.getColumnViewer().isCellEditorActive()) {
                        PDPCellEditorHandler.this.selectionChangeEvent(event);
                    }
                }
            });
            if (!isDoubleClickSelection) {
                this.getColumnViewer().getControl().addMouseListener(new MouseListener(){

                    public void mouseUp(MouseEvent arg0) {
                    }

                    public void mouseDown(MouseEvent arg0) {
                    }

                    public void mouseDoubleClick(MouseEvent arg0) {
                        PDPCellEditorHandler.this.getColumnViewer().cancelEditing();
                    }
                });
            }
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    switch (event.type) {
                        case 31: {
                            if (event.detail != 16 && event.detail != 8) break;
                            PDPCellEditorHandler.this.traverse(event);
                        }
                    }
                }
            };
            this.getColumnViewer().getControl().addListener(31, listener);
            this._cellEditors = cellEditors;
            CellEditor[] cellEditorArray = cellEditors;
            int n = cellEditors.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditor editor = cellEditorArray[n2];
                if (editor != null) {
                    Control control;
                    Listener traverseListener = new Listener(){

                        public void handleEvent(Event event) {
                            if (event.detail == 16 || event.detail == 8 || event.detail == 4 || event.detail == 2 || event.keyCode == 0x1000002 || event.keyCode == 0x1000001 || event.keyCode == 0x1000003 || event.keyCode == 0x1000004) {
                                PDPCellEditorHandler.this.traverse(event);
                            }
                        }
                    };
                    if (editor.getControl() != null && editor.getControl() instanceof PDPAbstractControl) {
                        control = (Control)((PDPAbstractControl)editor.getControl()).getSwtControl();
                        if (!control.isListening(31)) {
                            control.addListener(31, traverseListener);
                        }
                        this.addValueChangeListner(editor);
                    } else {
                        control = editor.getControl();
                        if (control != null && !control.isListening(31)) {
                            control.addListener(31, traverseListener);
                        }
                        hasForeignControl = true;
                    }
                }
                ++n2;
            }
            if (hasForeignControl) {
                return;
            }
            this.getColumnViewer().setCellEditors(cellEditors);
            this.getColumnViewer().setColumnProperties(this._arrayProperties);
            CellNavigationStrategy cellNavigationStategy = new CellNavigationStrategy(){

                public ViewerCell findSelectedCell(ColumnViewer viewer, ViewerCell currentSelectedCell, Event event) {
                    if (currentSelectedCell == null) {
                        return null;
                    }
                    switch (event.keyCode) {
                        case 9: {
                            PDPCellEditorHandler.this.traverse(event);
                            if (event.stateMask == 131072) {
                                return currentSelectedCell.getNeighbor(4, false);
                            }
                            if (event.stateMask != 0) break;
                            return currentSelectedCell.getNeighbor(8, false);
                        }
                    }
                    return super.findSelectedCell(viewer, currentSelectedCell, event);
                }

                public boolean isNavigationEvent(ColumnViewer viewer, Event event) {
                    switch (event.keyCode) {
                        case 9: {
                            if (!(event.stateMask == 131072 | event.stateMask == 0)) break;
                            return true;
                        }
                    }
                    return super.isNavigationEvent(viewer, event);
                }

                public boolean isExpandEvent(ColumnViewer viewer, ViewerCell cellToExpand, Event event) {
                    if (viewer instanceof TreeViewer && PDPCellEditorHandler.this._interceptCollapseExpandEvent && event.stateMask == 262144) {
                        switch (event.keyCode) {
                            case 0x1000002: 
                            case 0x1000004: {
                                return true;
                            }
                        }
                        return false;
                    }
                    return false;
                }

                public void expand(ColumnViewer viewer, ViewerCell cellToExpand, Event event) {
                    if (viewer instanceof TreeViewer && PDPCellEditorHandler.this._interceptCollapseExpandEvent && cellToExpand != null && cellToExpand.getElement() != null) {
                        TreeViewer treeViewer = (TreeViewer)viewer;
                        treeViewer.expandToLevel(cellToExpand.getElement(), 1);
                        int i = 0;
                        while (i < treeViewer.getTree().getColumnCount()) {
                            treeViewer.getTree().getColumn(i).pack();
                            ++i;
                        }
                    }
                }

                public boolean isCollapseEvent(ColumnViewer viewer, ViewerCell cellToCollapse, Event event) {
                    if (viewer instanceof TreeViewer && PDPCellEditorHandler.this._interceptCollapseExpandEvent && event.stateMask == 262144) {
                        switch (event.keyCode) {
                            case 0x1000001: 
                            case 0x1000003: {
                                return true;
                            }
                        }
                        return false;
                    }
                    return false;
                }

                public void collapse(ColumnViewer viewer, ViewerCell cellToCollapse, Event event) {
                    if (viewer instanceof TreeViewer && PDPCellEditorHandler.this._interceptCollapseExpandEvent) {
                        try {
                            if (cellToCollapse != null && cellToCollapse.getElement() != null) {
                                TreeViewer treeViewer = (TreeViewer)viewer;
                                treeViewer.collapseToLevel(cellToCollapse.getElement(), 1);
                                int i = 0;
                                while (i < treeViewer.getTree().getColumnCount()) {
                                    treeViewer.getTree().getColumn(i).pack();
                                    ++i;
                                }
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            };
            if (this.getColumnViewer() instanceof TreeViewer) {
                TreeViewer treeViewer = (TreeViewer)this.getColumnViewer();
                TreeViewerFocusCellManager focusCellManager = new TreeViewerFocusCellManager(treeViewer, (FocusCellHighlighter)new PDPFocusCellHighlighter((ColumnViewer)treeViewer, this._markFocusCell), cellNavigationStategy);
                actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)treeViewer){

                    protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                        boolean result;
                        PDPCellEditorHandler.this._selectedColumnIndex = ((ViewerCell)event.getSource()).getColumnIndex();
                        PDPCellEditorHandler.this._currentWidget = ((ViewerCell)event.getSource()).getItem();
                        PDPCellEditorHandler.this._isMouseActivaton = PDPCellEditorHandler.this.isMouseActivationEvent(event);
                        boolean bl = result = event.eventType == 5 || PDPCellEditorHandler.this._isMouseActivaton || event.eventType == 1 && (event.keyCode == 13 || event.keyCode == 0x100000B) || event.eventType == 4;
                        if (result) {
                            result = !PDPCellEditorHandler.this.isContentAssistActive();
                        }
                        return result;
                    }
                };
                TreeViewerEditor.create((TreeViewer)treeViewer, (SWTFocusCellManager)focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
            } else {
                TableViewer tableViewer = (TableViewer)this.getColumnViewer();
                SWTFocusCellManager focusCellManager = null;
                actSupport = new ColumnViewerEditorActivationStrategy((ColumnViewer)tableViewer){

                    protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
                        PDPCellEditorHandler.this._selectedColumnIndex = ((ViewerCell)event.getSource()).getColumnIndex();
                        PDPCellEditorHandler.this._currentWidget = ((ViewerCell)event.getSource()).getItem();
                        PDPCellEditorHandler.this._isMouseActivaton = PDPCellEditorHandler.this.isMouseActivationEvent(event);
                        return event.eventType == 5 || PDPCellEditorHandler.this._isMouseActivaton || event.eventType == 1 && (event.keyCode == 13 || event.keyCode == 0x100000B) || event.eventType == 4;
                    }
                };
                TableViewerEditor.create((TableViewer)tableViewer, focusCellManager, (ColumnViewerEditorActivationStrategy)actSupport, (int)58);
            }
        }
    }

    protected void addValueChangeListner(CellEditor editor) {
        if (editor == null || editor.getControl() == null || ((PDPAbstractControl)editor.getControl()).getAdapters() == null) {
            return;
        }
        if (!((PDPAbstractControl)editor.getControl()).getAdapters().isEmpty()) {
            return;
        }
        PDPAdapter changeTracker = new PDPAdapter(true){

            public void notifyChanged(PDPNotification notification) {
                PDPCellEditorHandler.this.changeEvent(notification);
                if (this.isOnFocusLost() && !PDPCellEditorHandler.this._isOnTraverse) {
                    PDPCellEditorHandler.this.getColumnViewer().cancelEditing();
                }
            }
        };
        ((PDPAbstractControl)editor.getControl()).getAdapters().add(changeTracker);
    }

    protected boolean isMouseActivationEvent(ColumnViewerEditorActivationEvent event) {
        boolean result;
        if (isDoubleClickSelection) {
            return event.eventType == 3;
        }
        boolean bl = result = event.eventType == 2 && event.sourceEvent != null && ((MouseEvent)event.sourceEvent).button == 1;
        if (!this._isFirstClickSelection && result) {
            PDPGenericCellEditor genericCellEditor;
            result = this._currentWidget == this._lastWidget && this._selectedColumnIndex == this._lastSelectedColumnIndex;
            this._lastSelectedColumnIndex = this._selectedColumnIndex;
            this._lastWidget = this._currentWidget;
            if (!result && this.getColumnViewer().isCellEditorActive() && (genericCellEditor = this.getCurrentCellEditor()) != null) {
                this._isUpdating = true;
                this.getColumnViewer().cancelEditing();
                this._element = genericCellEditor.getElement();
                this._property = genericCellEditor.getProperty();
                this._value = genericCellEditor.getValue();
                PDPAbstractCellModifier modifier = (PDPAbstractCellModifier)this.getColumnViewer().getCellModifier();
                if (this._element != null) {
                    Object newElement = modifier._modify(this._element, this._property, this._value);
                    if (newElement != this._element) {
                        genericCellEditor.setElement(newElement);
                    }
                    this._element = null;
                    this._property = null;
                    this._value = null;
                }
                this._isUpdating = false;
            }
        }
        return result;
    }

    public void changeEvent(PDPNotification notification) {
        Object newElement;
        Composite parent;
        PDPAbstractControl control = (PDPAbstractControl)((Object)notification.getSource());
        String property = control.getProperty();
        Object element = control.getElement();
        Object value = control.getValue();
        if ((element == null || property == null) && (parent = control.getParent()) instanceof PDPAbstractControl) {
            control = (PDPAbstractControl)parent;
            property = control.getProperty();
            element = control.getElement();
        }
        if (this.getColumnViewer().getCellModifier().canModify(element, property) && (newElement = ((PDPAbstractCellModifier)this.getColumnViewer().getCellModifier())._modify(element, property, value)) != element) {
            control.setElement(newElement);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void traverse(Event event) {
        Object newElement;
        this._traverseEvent = event;
        this._isMouseActivaton = false;
        String property = null;
        Object value = null;
        Object element = null;
        ColumnViewer viewer = this.getColumnViewer();
        if (event.detail != 2 && event.detail != 4 && event.detail != 8 && event.detail != 16 && event.keyCode != 0x1000002 && event.keyCode != 0x1000001 && event.keyCode != 0x1000003 && event.keyCode != 0x1000004) {
            return;
        }
        if (event.keyCode == 262144 || (event.stateMask & 0x40000) != 0) {
            event.doit = true;
            return;
        }
        int columnIndex = 0;
        PDPGenericCellEditor abstractCellEditor = null;
        boolean isEditing = this.getColumnViewer().isCellEditorActive();
        if (!(isEditing || event.detail != 8 && event.detail != 16)) {
            event.doit = true;
            return;
        }
        boolean canMoveWithArrowL = true;
        boolean canMoveWithArrowR = true;
        boolean canMoveWithArrowU = true;
        boolean canMoveWithArrowD = true;
        if (event.detail == 2) {
            if (isEditing) {
                this.getColumnViewer().cancelEditing();
                return;
            } else {
                this.getColumnViewer().getControl().getParent().getParent().setFocus();
            }
            return;
        }
        CellEditor[] cellEditorArray = this._cellEditors;
        int n = this._cellEditors.length;
        int n2 = 0;
        while (n2 < n) {
            CellEditor editor = cellEditorArray[n2];
            if (editor instanceof PDPGenericCellEditor && editor.isActivated()) {
                abstractCellEditor = (PDPGenericCellEditor)editor;
                property = abstractCellEditor.getProperty();
                value = abstractCellEditor.getValue();
                if (abstractCellEditor.getPDPControl() != null && abstractCellEditor.getPDPControl().isContentAssistOpen()) {
                    return;
                }
                if (!(abstractCellEditor.getControl() instanceof PDPAbstractControl)) break;
                canMoveWithArrowL = ((PDPAbstractControl)abstractCellEditor.getControl()).canMoveWithArrowLeft();
                canMoveWithArrowR = ((PDPAbstractControl)abstractCellEditor.getControl()).canMoveWithArrowRight();
                canMoveWithArrowU = ((PDPAbstractControl)abstractCellEditor.getControl()).canMoveWithArrowUp();
                canMoveWithArrowD = ((PDPAbstractControl)abstractCellEditor.getControl()).canMoveWithArrowDown();
                break;
            }
            ++columnIndex;
            ++n2;
        }
        if (property != null && isEditing) {
            element = ((StructuredSelection)this.getColumnViewer().getSelection()).getFirstElement();
        }
        if ((newElement = ((StructuredSelection)this.getColumnViewer().getSelection()).getFirstElement()) == null) {
            Object input = this.getColumnViewer().getInput();
            if (input instanceof List) {
                List list = (List)input;
                if (list.size() <= 0) return;
                newElement = list.get(0);
            } else {
                if (input == null) return;
                newElement = input;
            }
            columnIndex = -1;
        }
        switch (event.detail) {
            case 4: {
                newElement = this.findNextEditableLine(newElement);
                if (newElement == null) {
                    if (isEditing) {
                        this.getColumnViewer().cancelEditing();
                    }
                    event.doit = true;
                    this.modifyElement(element, property, value);
                    return;
                }
                int newColumnIndex = this.editColumnOrNextPossible(newElement, columnIndex - 1);
                if (newColumnIndex == columnIndex) break;
                columnIndex = this.editColumnOrNextPossible(newElement, -1);
                break;
            }
            case 8: {
                int newColumnIndex = this.editColumnOrPreviousPossible(newElement, columnIndex);
                if (newColumnIndex >= columnIndex) {
                    if ((newElement = this.findPreviousEditableLine(newElement)) == null) {
                        if (isEditing) {
                            this.getColumnViewer().cancelEditing();
                        }
                        event.doit = true;
                        this.modifyElement(element, property, value);
                        return;
                    }
                    columnIndex = this.editColumnOrPreviousPossible(newElement, this.getColumnViewer().getColumnProperties().length);
                    break;
                }
                columnIndex = newColumnIndex;
                break;
            }
            case 16: {
                int newColumnIndex = this.editColumnOrNextPossible(newElement, columnIndex);
                if (newColumnIndex <= columnIndex) {
                    if ((newElement = this.findNextEditableLine(newElement)) == null) {
                        if (isEditing) {
                            this.getColumnViewer().cancelEditing();
                        }
                        event.doit = true;
                        this.modifyElement(element, property, value);
                        return;
                    }
                    columnIndex = this.editColumnOrNextPossible(newElement, -1);
                    break;
                }
                columnIndex = newColumnIndex;
            }
        }
        switch (event.keyCode) {
            case 0x1000002: {
                if (!canMoveWithArrowD) {
                    event.doit = true;
                    return;
                }
                if ((newElement = this.findNextEditableLine(newElement)) == null) {
                    if (isEditing) {
                        this.getColumnViewer().cancelEditing();
                    }
                    event.doit = true;
                    this.modifyElement(element, property, value);
                    return;
                }
                int newColumnIndex = this.editColumnOrNextPossible(newElement, columnIndex - 1);
                if (newColumnIndex == columnIndex) break;
                columnIndex = this.editColumnOrNextPossible(newElement, -1);
                break;
            }
            case 0x1000001: {
                if (!canMoveWithArrowU) {
                    event.doit = true;
                    return;
                }
                if ((newElement = this.findPreviousEditableLine(newElement)) == null) {
                    if (isEditing) {
                        this.getColumnViewer().cancelEditing();
                    }
                    event.doit = true;
                    this.modifyElement(element, property, value);
                    return;
                }
                int newColumnIndex = this.editColumnOrNextPossible(newElement, columnIndex - 1);
                if (newColumnIndex == columnIndex) break;
                columnIndex = this.editColumnOrNextPossible(newElement, -1);
                break;
            }
            case 0x1000003: {
                if (!canMoveWithArrowL) {
                    event.doit = true;
                    return;
                }
                int newColumnIndex = this.editColumnOrPreviousPossible(newElement, columnIndex);
                if (newColumnIndex >= columnIndex) {
                    if ((newElement = this.findPreviousEditableLine(newElement)) == null) {
                        if (isEditing) {
                            this.getColumnViewer().cancelEditing();
                        }
                        event.doit = true;
                        this.modifyElement(element, property, value);
                        return;
                    }
                    columnIndex = this.editColumnOrPreviousPossible(newElement, this.getColumnViewer().getColumnProperties().length);
                    break;
                }
                columnIndex = newColumnIndex;
                break;
            }
            case 0x1000004: {
                if (!canMoveWithArrowR) {
                    event.doit = true;
                    return;
                }
                int newColumnIndex = this.editColumnOrNextPossible(newElement, columnIndex);
                if (newColumnIndex <= columnIndex) {
                    if ((newElement = this.findNextEditableLine(newElement)) == null) {
                        if (isEditing) {
                            this.getColumnViewer().cancelEditing();
                        }
                        event.doit = true;
                        this.modifyElement(element, property, value);
                        return;
                    }
                    columnIndex = this.editColumnOrNextPossible(newElement, -1);
                    break;
                }
                columnIndex = newColumnIndex;
            }
        }
        Object modifiedElement = this.modifyElement(element, property, value);
        if (newElement == element && modifiedElement != newElement) {
            newElement = modifiedElement;
        }
        event.doit = false;
        StructuredSelection structuredSelection = new StructuredSelection(newElement);
        try {
            this._cellEditorWrapper.setSelection((ISelection)structuredSelection, true);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this._cellEditorWrapper.setSelection((ISelection)structuredSelection, true);
            columnIndex = this.editColumnOrNextPossible(newElement, -1);
        }
        this._selectedColumnIndex = columnIndex;
        if (isEditing) {
            this.getColumnViewer().cancelEditing();
        }
        if (columnIndex >= 0) {
            this._lastWidget = null;
            if (this.getColumnViewer() instanceof TreeViewer) {
                TreeViewer treeViewer = (TreeViewer)this.getColumnViewer();
                treeViewer.expandToLevel(newElement, 0);
            }
            this._isOnTraverse = true;
            viewer.editElement(newElement, columnIndex);
            viewer.editElement(newElement, columnIndex);
            this._isOnTraverse = false;
        }
        this._traverseEvent = null;
    }

    protected Object modifyElement(Object element, String property, Object value) {
        Object newElement = element;
        if (element != null && property != null) {
            ColumnViewer viewer = this.getColumnViewer();
            this._isUpdating = true;
            if (viewer.getCellModifier().canModify(element, property)) {
                newElement = ((PDPAbstractCellModifier)viewer.getCellModifier())._modify(element, property, value);
            }
            this._isUpdating = false;
        }
        return newElement;
    }

    protected ColumnViewer getColumnViewer() {
        return this._cellEditorWrapper.getColumnViewer();
    }

    public PDPGenericCellEditor getCurrentCellEditor() {
        if (this._cellEditors != null) {
            CellEditor[] cellEditorArray = this._cellEditors;
            int n = this._cellEditors.length;
            int n2 = 0;
            while (n2 < n) {
                CellEditor editor = cellEditorArray[n2];
                PDPGenericCellEditor abstractCellEditor = (PDPGenericCellEditor)editor;
                if (editor != null && editor.isActivated()) {
                    return abstractCellEditor;
                }
                ++n2;
            }
        }
        return null;
    }

    public boolean isUpdating() {
        return this._isUpdating;
    }

    public void isUpdating(boolean isUpdating) {
        this._isUpdating = isUpdating;
    }

    public void restoreCellEditorState() {
        Object selection = ((StructuredSelection)this.getColumnViewer().getSelection()).getFirstElement();
        if (selection != null) {
            PDPGenericCellEditor cellEditor;
            if (this.isCellEditorActive) {
                this.getColumnViewer().editElement(selection, this._selectedColumnIndex);
                this.isCellEditorActive = false;
            }
            if ((cellEditor = this.getCurrentCellEditor()) != null) {
                cellEditor.setReadonly(false);
            }
            if (this._cellEditor != null) {
                this._cellEditor.setReadonly(false);
            }
        } else if (this._cellEditor != null) {
            this._cellEditor.setReadonly(false);
        }
    }

    public void saveCellEditorState() {
        if (this.getColumnViewer().isCellEditorActive()) {
            this._cellEditor = this.getCurrentCellEditor();
            if (this._cellEditor != null) {
                this.isCellEditorActive = true;
                this.getColumnViewer().cancelEditing();
                this._cellEditor.setReadonly(true);
            }
        }
    }

    protected boolean hasOneCellEditable(Object newElement) {
        int nbCols = this.getColumnViewer().getColumnProperties().length;
        int nbNonEditable = 0;
        int i = -1;
        while (i < nbCols - 1) {
            String property = (String)this.getColumnViewer().getColumnProperties()[++i];
            if (this.getColumnViewer().getCellModifier().canModify(newElement, property)) continue;
            ++nbNonEditable;
        }
        return nbCols != nbNonEditable;
    }

    protected int editColumnOrNextPossible(Object newElement, int selectedColumn) {
        int column = selectedColumn;
        int nbCols = this.getColumnViewer().getColumnProperties().length;
        while (column < nbCols - 1) {
            String property = (String)this.getColumnViewer().getColumnProperties()[++column];
            if (!this.getColumnViewer().getCellModifier().canModify(newElement, property)) continue;
            return column;
        }
        column = -1;
        while (column < selectedColumn && column < this.getColumnViewer().getColumnProperties().length - 1) {
            if (!this.getColumnViewer().getCellModifier().canModify(newElement, (String)this.getColumnViewer().getColumnProperties()[++column])) continue;
            return column;
        }
        return -1;
    }

    protected int editColumnOrPreviousPossible(Object newElement, int selectedColumn) {
        int column = selectedColumn;
        while (column > 0) {
            if (!this.getColumnViewer().getCellModifier().canModify(newElement, (String)this.getColumnViewer().getColumnProperties()[--column])) continue;
            return column;
        }
        column = this.getColumnViewer().getColumnProperties().length;
        while (selectedColumn < column) {
            if (!this.getColumnViewer().getCellModifier().canModify(newElement, (String)this.getColumnViewer().getColumnProperties()[--column])) continue;
            return column;
        }
        return -1;
    }

    protected Object findPreviousEditableLine(Object element) {
        if (this.getColumnViewer() instanceof TreeViewer) {
            return this.findPreviousEditableLineForTree(element);
        }
        if (this.getColumnViewer() instanceof TableViewer) {
            return this.findPreviousEditableLineForTable(element);
        }
        return null;
    }

    protected Object findNextEditableLine(Object element) {
        if (this.getColumnViewer() instanceof TreeViewer) {
            return this.findNextEditableLineForTree(element);
        }
        if (this.getColumnViewer() instanceof TableViewer) {
            return this.findNextEditableLineForTable(element);
        }
        return null;
    }

    protected Object findNextEditableLineForTree(Object element) {
        PDPContentProvider provider = (PDPContentProvider)this.getColumnViewer().getContentProvider();
        Object[] objects = provider.getAllElements(provider.getOwner(element));
        if (objects != null && objects.length > 0) {
            boolean found = false;
            int i = 0;
            while (i < objects.length) {
                if (found && this.hasOneCellEditable(objects[i])) {
                    return objects[i];
                }
                if (objects[i] == element) {
                    int index = i + 1;
                    found = index != objects.length;
                }
                ++i;
            }
            if (!found && objects.length > 0 && this.hasOneCellEditable(objects[objects.length - 1])) {
                return objects[objects.length - 1];
            }
            return null;
        }
        return null;
    }

    protected Object findNextEditableLineForTable(Object element) {
        Object newElement = element;
        Object[] objects = null;
        if (this.getColumnViewer().getInput() instanceof List) {
            objects = ((List)this.getColumnViewer().getInput()).toArray();
        } else if (this.getColumnViewer().getContentProvider() instanceof IStructuredContentProvider) {
            IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.getColumnViewer().getContentProvider();
            objects = contentProvider.getElements(this.getColumnViewer().getInput());
        } else {
            objects = new Object[]{};
        }
        if (this.getColumnViewer().getComparator() != null) {
            this.getColumnViewer().getComparator().sort((Viewer)this.getColumnViewer(), objects);
        }
        ArrayList<Object> _items = new ArrayList<Object>(objects.length);
        int i = 0;
        while (i < objects.length) {
            _items.add(objects[i]);
            ++i;
        }
        int currentIdx = _items.indexOf(element);
        while (currentIdx < _items.size() - 1) {
            if (this.hasOneCellEditable(newElement = _items.get(++currentIdx))) break;
        }
        return newElement;
    }

    protected Object findPreviousEditableLineForTree(Object element) {
        PDPContentProvider provider = (PDPContentProvider)this.getColumnViewer().getContentProvider();
        Object[] objects = provider.getAllElements(provider.getOwner(element));
        if (objects.length > 0) {
            Object previous = objects[0];
            boolean found = false;
            int i = 0;
            while (i < objects.length) {
                if (found && this.hasOneCellEditable(objects[i])) {
                    if (previous == element) {
                        return null;
                    }
                    return previous;
                }
                if (objects[i] == element) {
                    found = true;
                } else {
                    previous = objects[i];
                }
                ++i;
            }
            return previous;
        }
        return null;
    }

    protected Object findPreviousEditableLineForTable(Object element) {
        Object newElement = element;
        Object[] objects = null;
        if (this.getColumnViewer().getInput() instanceof List) {
            objects = ((List)this.getColumnViewer().getInput()).toArray();
        } else if (this.getColumnViewer().getContentProvider() instanceof IStructuredContentProvider) {
            IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.getColumnViewer().getContentProvider();
            objects = contentProvider.getElements(this.getColumnViewer().getInput());
        } else {
            objects = new Object[]{};
        }
        if (this.getColumnViewer().getComparator() != null) {
            this.getColumnViewer().getComparator().sort((Viewer)this.getColumnViewer(), objects);
        }
        ArrayList<Object> _items = new ArrayList<Object>(objects.length);
        int i = 0;
        while (i < objects.length) {
            _items.add(objects[i]);
            ++i;
        }
        int currentIdx = _items.indexOf(element);
        while (currentIdx > 0) {
            if (this.hasOneCellEditable(newElement = _items.get(--currentIdx))) break;
        }
        return newElement;
    }

    protected void selectionChangeEvent(SelectionChangedEvent event) {
        if (!isDoubleClickSelection && this._isMouseActivaton && this._selectedColumnIndex >= 0 && this._selectedColumnIndex < this.getColumnViewer().getColumnProperties().length) {
            this._isMouseActivaton = false;
            if (!this._isOnSelectionChange) {
                this._isOnSelectionChange = true;
                if (this.getColumnViewer() instanceof TreeViewer) {
                    this.getColumnViewer().cancelEditing();
                }
                PDPAbstractCellModifier modifier = (PDPAbstractCellModifier)this.getColumnViewer().getCellModifier();
                if (this._element != null) {
                    modifier._modify(this._element, this._property, this._value);
                    this._element = null;
                    this._property = null;
                    this._value = null;
                }
                if (this.getColumnViewer() instanceof TreeViewer) {
                    Object selectedElement = ((StructuredSelection)event.getSelection()).getFirstElement();
                    this._selectedColumnIndex = this.editColumnOrPreviousPossible(selectedElement, this._selectedColumnIndex + 1);
                    if (selectedElement != null && this._selectedColumnIndex >= 0) {
                        this.getColumnViewer().editElement(selectedElement, this._selectedColumnIndex);
                        this.addValueChangeListner(this.getCurrentCellEditor());
                    }
                }
                this._isOnSelectionChange = false;
            }
        } else if (!this._isOnSelectionChange && !this._isFirstClickSelection) {
            PDPAbstractCellModifier modifier = (PDPAbstractCellModifier)this.getColumnViewer().getCellModifier();
            if (this._element != null) {
                modifier._modify(this._element, this._property, this._value);
                this._element = null;
                this._property = null;
                this._value = null;
            }
        }
    }

    public void triggerEditorActivationEvent(ColumnViewerEditorActivationEvent event) {
        if (event.eventType == 2 && this.getColumnViewer().isCellEditorActive()) {
            PDPGenericCellEditor genericCellEditor = this.getCurrentCellEditor();
            this.addValueChangeListner(genericCellEditor);
            if (genericCellEditor != null) {
                this._isUpdating = true;
                this.getColumnViewer().cancelEditing();
                this._element = genericCellEditor.getElement();
                this._property = genericCellEditor.getProperty();
                this._value = genericCellEditor.getValue();
                this._isUpdating = false;
            }
        }
    }

    protected boolean isContentAssistActive() {
        CellEditor[] cellEditorArray = this._cellEditors;
        int n = this._cellEditors.length;
        int n2 = 0;
        while (n2 < n) {
            PDPGenericCellEditor abstractCellEditor;
            CellEditor editor = cellEditorArray[n2];
            if (editor instanceof PDPGenericCellEditor && editor.isActivated() && (abstractCellEditor = (PDPGenericCellEditor)editor).getPDPControl() != null && abstractCellEditor.getPDPControl().isContentAssistOpen()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static class PDPFocusCellHighlighter
    extends FocusCellHighlighter {
        public PDPFocusCellHighlighter(ColumnViewer viewer, final boolean markFocusCell) {
            super(viewer);
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    if ((event.detail & 2) > 0) {
                        ViewerCell focusCell = PDPFocusCellHighlighter.this.getFocusCell();
                        if (markFocusCell && focusCell != null) {
                            PDPFocusCellHighlighter.this.markFocusedCell(event, focusCell);
                        }
                    }
                }
            };
            viewer.getControl().addListener(40, listener);
        }

        protected void focusCellChanged(ViewerCell newCell, ViewerCell oldCell) {
            int width;
            int x;
            Rectangle rect;
            super.focusCellChanged(newCell, oldCell);
            if (newCell != null) {
                rect = newCell.getBounds();
                x = newCell.getColumnIndex() != 0 ? rect.x : 0;
                width = newCell.getColumnIndex() != 0 ? rect.width : rect.x + rect.width;
                newCell.getControl().redraw(x, rect.y - 1, width, rect.height + 1, true);
            }
            if (oldCell != null && !oldCell.getItem().isDisposed()) {
                rect = oldCell.getBounds();
                x = oldCell.getColumnIndex() != 0 ? rect.x : 0;
                width = oldCell.getColumnIndex() != 0 ? rect.width : rect.x + rect.width;
                oldCell.getControl().redraw(x, rect.y - 1, width, rect.height + 1, true);
            }
        }

        private void markFocusedCell(Event event, ViewerCell cell) {
            if (cell.getItem().isDisposed() || cell.getItem().getDisplay().isDisposed()) {
                return;
            }
            Color background = cell.getItem().getDisplay().getSystemColor(15);
            Color foreground = cell.getControl().getForeground();
            GC gc = event.gc;
            gc.setBackground(background);
            gc.fillRectangle(event.getBounds());
            background = cell.getBackground();
            gc.setBackground(background);
            gc.setForeground(foreground);
            gc.fillRectangle(cell.getBounds());
            event.detail &= 0xFFFFFFFD;
        }
    }
}

