/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.celleditor;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public abstract class PDPAbstractDialog
extends Dialog {
    private static Control cell;
    private Shell p;
    private Shell shell;
    private String input;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPAbstractDialog(Control c, String title) {
        super(c.getShell());
        this.p = c.getShell();
        cell = c;
        this.shell = new Shell(c.getShell(), 65536);
        this.shell.setLayout((Layout)new FillLayout(512));
        this.shell.setText(title);
    }

    public abstract void createPartControl(Composite var1);

    public String open() {
        this.createPartControl((Composite)this.shell);
        Point point = this.shell.computeSize(-1, -1);
        this.shell.pack();
        Point pt = this.getAbsoluteLocation(cell);
        this.shell.setBounds(pt.x - point.x, pt.y, point.x + 5, point.y + 5);
        this.contain();
        this.shell.setVisible(true);
        this.shell.setFocus();
        while (!this.shell.isDisposed()) {
            if (this.p.getDisplay().readAndDispatch()) continue;
            this.p.getDisplay().sleep();
        }
        this.shell.dispose();
        return this.input;
    }

    public void close() {
        this.shell.dispose();
    }

    protected void contain() {
        Shell parent = this.getParent();
        Rectangle pBounds = parent.getBounds();
        Rectangle myBounds = this.getShell().getBounds();
        if (!pBounds.contains(myBounds.x, myBounds.y) || !pBounds.contains(myBounds.x + myBounds.width, myBounds.y + myBounds.height)) {
            int xDelta = pBounds.x + pBounds.width - (myBounds.x + myBounds.width);
            int yDelta = pBounds.y + pBounds.height - (myBounds.y + myBounds.height);
            if (xDelta > 0) {
                xDelta = 0;
            }
            if (yDelta > 0) {
                yDelta = 0;
            }
            this.getShell().setLocation(myBounds.x + xDelta, myBounds.y + yDelta);
        }
    }

    public Shell getShell() {
        return this.shell;
    }

    private Point getAbsoluteLocation(Control c) {
        Rectangle parentRect = c.getDisplay().map((Control)c.getParent(), null, c.getBounds());
        while (true) {
            int cfr_ignored_0 = c.getBounds().x;
            int cfr_ignored_1 = c.getBounds().y;
            Shell owner = c.getShell();
            if (owner == c) break;
            c = owner;
        }
        return new Point(parentRect.x, parentRect.y);
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }
}

