/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.widgets.ui.celleditor;

import com.ibm.pdp.widgets.ui.celleditor.PDPGenericCellEditor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Widget;

public abstract class PDPAbstractCellModifier
implements ICellModifier {
    protected ColumnViewer viewer;
    private boolean isUpdating = false;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public PDPAbstractCellModifier(ColumnViewer viewer) {
        this.viewer = viewer;
    }

    public final boolean canModify(Object element, String property) {
        boolean result;
        boolean bl = result = !this.isUpdating && this.canModifyValue(element, property);
        if (result && this.viewer.getColumnProperties() != null) {
            int column = this.getColumnIndex(property);
            if (this.viewer.getColumnProperties().length >= column && this.viewer.getCellEditors()[column] instanceof PDPGenericCellEditor) {
                PDPGenericCellEditor editor = (PDPGenericCellEditor)this.viewer.getCellEditors()[column];
                editor.setProperty(property);
            }
        }
        return result;
    }

    public final void modify(Object element, String property, Object value) {
        this._modify(element, property, value);
    }

    public Object _modify(Object oldElement, String property, Object value) {
        Object newElement = oldElement;
        if (newElement == null) {
            return newElement;
        }
        this.isUpdating = true;
        Object object = newElement instanceof Widget ? ((Widget)newElement).getData() : newElement;
        try {
            PDPGenericCellEditor cellEditor = (PDPGenericCellEditor)this.getCellEditor(property);
            if (!cellEditor.getPDPControl().isValidString(value == null ? "" : value.toString())) {
                this.isUpdating = false;
                return newElement;
            }
        }
        catch (ClassCastException classCastException) {
            this.setNewElementValue(newElement, property, value);
            this.isUpdating = false;
            return newElement;
        }
        if (this.forceModify(object, property, value)) {
            try {
                newElement = this.setNewElementValue(object, property, value);
                this.viewer.refresh(newElement);
            }
            catch (Exception ex) {
                this.isUpdating = false;
                PDPAbstractCellModifier.rethrow(ex);
            }
        }
        this.isUpdating = false;
        return newElement;
    }

    public static RuntimeException rethrow(Throwable t) {
        throw (RuntimeException)t;
    }

    public boolean forceModify(Object element, String property, Object value) {
        Object tmp = this.getElementValue(element, property);
        if (tmp == value) {
            return false;
        }
        return tmp == null || !tmp.equals(value);
    }

    private int getColumnIndex(String property) {
        int size = this.viewer.getColumnProperties().length;
        int i = 0;
        while (i < size) {
            if (this.viewer.getColumnProperties()[i].equals(property)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public CellEditor getCellEditor(String property) {
        if (this.viewer.getColumnProperties() == null || property == null) {
            return null;
        }
        int i = 0;
        while (i < this.viewer.getColumnProperties().length) {
            if (property.equals(this.viewer.getColumnProperties()[i])) {
                if (this.viewer.getCellEditors().length > i) {
                    return this.viewer.getCellEditors()[i];
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public final Object getValue(Object element, String property) {
        CellEditor cellEditor = this.getCellEditor(property);
        if (cellEditor instanceof PDPGenericCellEditor) {
            ((PDPGenericCellEditor)cellEditor).setElement(element);
        }
        return this.getElementValue(element, property);
    }

    public abstract boolean canModifyValue(Object var1, String var2);

    public abstract Object getElementValue(Object var1, String var2);

    public abstract void setElementValue(Object var1, String var2, Object var3);

    public Object setNewElementValue(Object element, String property, Object value) {
        this.setElementValue(element, property, value);
        return element;
    }
}

