/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.flatui;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;

public abstract class TableViewerImpl
implements TraverseListener {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2002, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    protected boolean fIsActivating = false;
    protected boolean fSingleClickCellSelect = false;
    protected CellEditor fCellEditor;
    protected CellEditor[] fCellEditors;
    protected ICellModifier fCellModifier;
    protected String[] fColumnProperties;
    protected Item fTableItem;
    protected int fColumnNumber;
    protected ICellEditorListener fCellEditorListener;

    protected TableViewerImpl() {
        this.initCellEditorListener();
    }

    protected void activateCellEditor() {
        String property;
        Object element;
        if (this.fCellEditors != null && this.fCellEditors[this.fColumnNumber] != null && this.fCellModifier != null && this.fCellModifier.canModify(element = this.fTableItem.getData(), property = this.fColumnProperties[this.fColumnNumber])) {
            this.fCellEditor = this.fCellEditors[this.fColumnNumber];
            this.fCellEditor.addListener(this.fCellEditorListener);
            Object value = this.fCellModifier.getValue(element, property);
            this.fCellEditor.setValue(value);
            Control control = this.fCellEditor.getControl();
            this.fCellEditor.activate();
            if (control != null) {
                this.setLayoutData(this.fCellEditor.getLayoutData());
                this.setEditor(control, this.fTableItem, this.fColumnNumber);
                this.fCellEditor.setFocus();
            }
        }
    }

    protected final void activateCellEditor(MouseEvent event) {
        if (this.fTableItem == null || this.fTableItem.isDisposed()) {
            return;
        }
        int columns = this.getColumnCount();
        int columnToEdit = -1;
        Rectangle bounds = null;
        int i = 0;
        while (i < columns) {
            bounds = this.getBounds(this.fTableItem, i);
            if (bounds.contains(event.x, event.y)) {
                columnToEdit = i;
                break;
            }
            ++i;
        }
        if (columnToEdit == -1 || bounds == null) {
            return;
        }
        this.fColumnNumber = columnToEdit;
        this.activateCellEditor();
    }

    public void activateFirstCellEditor() {
        if (this.fCellEditors != null) {
            int columnNumber = -1;
            int i = 0;
            while (i < this.fCellEditors.length) {
                if (this.fCellEditors[i] != null) {
                    columnNumber = i;
                    break;
                }
                ++i;
            }
            if (columnNumber > -1 && this.fCellModifier != null) {
                this.fColumnNumber = columnNumber;
                this.activateCellEditor();
            }
        }
    }

    public void applyEditorValue() {
        CellEditor c = this.fCellEditor;
        if (c != null) {
            this.fCellEditor = null;
            Item t = this.fTableItem;
            if (t != null && !t.isDisposed()) {
                this.saveEditorValue(c, t);
            }
            this.setEditor(null, null, 0);
            c.removeListener(this.fCellEditorListener);
            c.deactivate();
        }
    }

    public void cancelEditing() {
        if (this.fCellEditor != null) {
            this.setEditor(null, null, 0);
            this.fCellEditor.removeListener(this.fCellEditorListener);
            this.fCellEditor.deactivate();
            this.fCellEditor = null;
        }
    }

    public void editElement(Object element, int column) {
        if (this.fCellEditor != null) {
            this.applyEditorValue();
        }
        this.setSelection(new StructuredSelection(element), true);
        Item[] selection = this.getSelection();
        if (selection.length != 1) {
            return;
        }
        this.fTableItem = selection[0];
        this.showSelection();
        this.fColumnNumber = column;
        this.activateCellEditor();
    }

    protected abstract Rectangle getBounds(Item var1, int var2);

    public CellEditor[] getCellEditors() {
        return this.fCellEditors;
    }

    public ICellModifier getCellModifier() {
        return this.fCellModifier;
    }

    protected abstract int getColumnCount();

    public Object[] getColumnProperties() {
        return this.fColumnProperties;
    }

    protected abstract Item[] getSelection();

    public void handleMouseDoubleClick(MouseEvent event) {
    }

    public void handleMouseDown(MouseEvent event) {
        Item[] items;
        if (event.button != 1) {
            return;
        }
        boolean wasActivated = this.isCellEditorActive();
        if (wasActivated) {
            this.applyEditorValue();
        }
        if ((items = this.getSelection()).length != 1) {
            this.fTableItem = null;
            return;
        }
        if (this.fTableItem != items[0]) {
            this.fTableItem = items[0];
            if (!this.fSingleClickCellSelect) {
                return;
            }
        }
        if (this.fIsActivating || wasActivated) {
            return;
        }
        this.fIsActivating = true;
        this.postActivation(event);
    }

    private void handleRightArrow(TraverseEvent e) {
    }

    private void handleDownArrow(TraverseEvent e) {
    }

    private void handleLeftArrow(TraverseEvent e) {
    }

    private void handleUpArrow(TraverseEvent e) {
    }

    private void handleTabNext(TraverseEvent e) {
        if (this.fCellEditors != null && this.fCellModifier != null && this.fCellEditors.length > this.fColumnNumber + 1) {
            int start = this.fColumnNumber + 1;
            String property = null;
            Object element = this.fTableItem.getData();
            int i = start;
            while (i < this.fCellEditors.length) {
                if (this.fCellEditors[i] != null && this.fCellModifier.canModify(element, property = this.fColumnProperties[i])) {
                    this.fColumnNumber = i;
                    e.doit = false;
                    break;
                }
                ++i;
            }
            if (!e.doit) {
                this.startActivationThread();
            }
        }
    }

    private void handleTabPrevious(TraverseEvent e) {
        if (this.fCellEditors != null && this.fCellModifier != null) {
            int start = this.fCellEditors.length >= this.fColumnNumber - 1 ? this.fColumnNumber - 1 : this.fCellEditors.length - 1;
            String property = null;
            Object element = this.fTableItem.getData();
            int i = start;
            while (i >= 0) {
                if (this.fCellEditors[i] != null && this.fCellModifier.canModify(element, property = this.fColumnProperties[i])) {
                    this.fColumnNumber = i;
                    e.doit = false;
                    break;
                }
                --i;
            }
            if (!e.doit) {
                this.startActivationThread();
            }
        }
    }

    protected void initCellEditorListener() {
        this.fCellEditorListener = new ICellEditorListener(){

            public void editorValueChanged(boolean oldValidState, boolean newValidState) {
            }

            public void cancelEditor() {
                TableViewerImpl.this.cancelEditing();
            }

            public void applyEditorValue() {
                TableViewerImpl.this.applyEditorValue();
            }
        };
    }

    public boolean isCellEditorActive() {
        return this.fCellEditor != null;
    }

    public void keyTraversed(TraverseEvent e) {
        if (e.detail == 16) {
            this.applyEditorValue();
            this.handleTabNext(e);
        } else if (e.detail == 8) {
            this.applyEditorValue();
            this.handleTabPrevious(e);
        } else if (e.keyCode == 0x1000004) {
            this.handleRightArrow(e);
        } else if (e.keyCode == 0x1000003) {
            this.handleLeftArrow(e);
        } else if (e.keyCode == 0x1000001) {
            this.handleUpArrow(e);
        } else if (e.keyCode == 0x1000002) {
            this.handleDownArrow(e);
        }
    }

    private void postActivation(final MouseEvent event) {
        if (!this.fIsActivating) {
            return;
        }
        new Thread(){

            public void run() {
                if (TableViewerImpl.this.fIsActivating) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            TableViewerImpl.this.activateCellEditor(event);
                            (this).TableViewerImpl.this.fIsActivating = false;
                        }
                    });
                }
            }
        }.start();
    }

    protected void saveEditorValue(CellEditor cellEditor, Item tableItem) {
        if (this.fCellModifier != null) {
            cellEditor.isValueValid();
            String property = null;
            if (this.fColumnProperties != null && this.fColumnNumber < this.fColumnProperties.length) {
                property = this.fColumnProperties[this.fColumnNumber];
            }
            this.fCellModifier.modify((Object)tableItem, property, cellEditor.getValue());
        }
    }

    public void setCellEditors(CellEditor[] editors) {
        this.fCellEditors = editors;
        int i = 0;
        while (i < editors.length) {
            Control control;
            if (editors[i] != null && (control = editors[i].getControl()) != null) {
                control.addTraverseListener((TraverseListener)this);
            }
            ++i;
        }
    }

    public void setCellModifier(ICellModifier modifier) {
        this.fCellModifier = modifier;
    }

    public void setColumnProperties(String[] columnProperties) {
        this.fColumnProperties = columnProperties;
    }

    protected abstract void setEditor(Control var1, Item var2, int var3);

    protected abstract void setLayoutData(CellEditor.LayoutData var1);

    protected abstract void setSelection(StructuredSelection var1, boolean var2);

    protected abstract void showSelection();

    public boolean getSingleClickCellSelect() {
        return this.fSingleClickCellSelect;
    }

    public void setSingleClickCellSelect(boolean singleClickCellSelect) {
        this.fSingleClickCellSelect = singleClickCellSelect;
    }

    public void setTableItem(Item item) {
        this.fTableItem = item;
    }

    private void startActivationThread() {
        new Thread(){

            public void run() {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        TableViewerImpl.this.activateCellEditor();
                        (this).TableViewerImpl.this.fIsActivating = false;
                    }
                });
            }
        }.start();
    }
}

