/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.flatui;

import com.ibm.etools.webtools.flatui.SnappyTableViewer;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckable;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class SnappyCheckboxTableViewer
extends SnappyTableViewer
implements ICheckable {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2002, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ListenerList checkStateListeners = new ListenerList(1);

    public SnappyCheckboxTableViewer(Composite parent) {
        this(parent, 2048);
    }

    public SnappyCheckboxTableViewer(Composite parent, int style) {
        this(SnappyCheckboxTableViewer.createTable(parent, style));
    }

    public static SnappyCheckboxTableViewer newCheckList(Composite parent, int style) {
        Table table = new Table(parent, 0x20 | style);
        return new SnappyCheckboxTableViewer(table);
    }

    public SnappyCheckboxTableViewer(Table table) {
        super(table);
    }

    public void addCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.add((Object)listener);
    }

    protected static Table createTable(Composite parent, int style) {
        Table table = new Table(parent, 0x20 | style);
        new TableColumn(table, 0);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        table.setLayout((Layout)layout);
        return table;
    }

    private void fireCheckStateChanged(final CheckStateChangedEvent event) {
        Object[] array = this.checkStateListeners.getListeners();
        int i = 0;
        while (i < array.length) {
            final ICheckStateListener l = (ICheckStateListener)array[i];
            Platform.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.checkStateChanged(event);
                }

                public void handleException(Throwable e) {
                    super.handleException(e);
                    SnappyCheckboxTableViewer.this.removeCheckStateListener(l);
                }
            });
            ++i;
        }
    }

    public boolean getChecked(Object element) {
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getChecked();
        }
        return false;
    }

    public Object[] getCheckedElements() {
        TableItem[] children = this.getTable().getItems();
        ArrayList<Object> v = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            if (item.getChecked()) {
                v.add(item.getData());
            }
            ++i;
        }
        return v.toArray();
    }

    public boolean getGrayed(Object element) {
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            return ((TableItem)widget).getGrayed();
        }
        return false;
    }

    public Object[] getGrayedElements() {
        TableItem[] children = this.getTable().getItems();
        ArrayList<Object> v = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            if (item.getGrayed()) {
                v.add(item.getData());
            }
            ++i;
        }
        return v.toArray();
    }

    public void handleSelect(SelectionEvent event) {
        if (event.detail == 32) {
            super.handleSelect(event);
            TableItem item = (TableItem)event.item;
            Object data = item.getData();
            if (data != null) {
                this.fireCheckStateChanged(new CheckStateChangedEvent((ICheckable)this, data, item.getChecked()));
            }
        } else {
            super.handleSelect(event);
        }
    }

    protected void preservingSelection(Runnable updateCode) {
        Object data;
        TableItem item;
        TableItem[] children = this.getTable().getItems();
        HashSet<Object> checked = new HashSet<Object>(children.length);
        HashSet<Object> grayed = new HashSet<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            item = children[i];
            data = item.getData();
            if (data != null) {
                if (item.getChecked()) {
                    checked.add(data);
                }
                if (item.getGrayed()) {
                    grayed.add(data);
                }
            }
            ++i;
        }
        super.preservingSelection(updateCode);
        children = this.getTable().getItems();
        i = 0;
        while (i < children.length) {
            item = children[i];
            data = item.getData();
            if (data != null) {
                item.setChecked(checked.contains(data));
                item.setGrayed(grayed.contains(data));
            }
            ++i;
        }
    }

    public void removeCheckStateListener(ICheckStateListener listener) {
        this.checkStateListeners.remove((Object)listener);
    }

    public void setAllChecked(boolean state) {
        TableItem[] children = this.getTable().getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            item.setChecked(state);
            ++i;
        }
    }

    public void setAllGrayed(boolean state) {
        TableItem[] children = this.getTable().getItems();
        int i = 0;
        while (i < children.length) {
            TableItem item = children[i];
            item.setGrayed(state);
            ++i;
        }
    }

    public boolean setChecked(Object element, boolean state) {
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            ((TableItem)widget).setChecked(state);
            return true;
        }
        return false;
    }

    public void setCheckedElements(Object[] elements) {
        HashSet<Object> set = new HashSet<Object>(elements.length * 2 + 1);
        int i = 0;
        while (i < elements.length) {
            set.add(elements[i]);
            ++i;
        }
        TableItem[] items = this.getTable().getItems();
        int i2 = 0;
        while (i2 < items.length) {
            TableItem item = items[i2];
            Object element = item.getData();
            if (element != null) {
                boolean check = set.contains(element);
                if (item.getChecked() != check) {
                    item.setChecked(check);
                }
            }
            ++i2;
        }
    }

    public boolean setGrayed(Object element, boolean state) {
        Widget widget = this.findItem(element);
        if (widget instanceof TableItem) {
            ((TableItem)widget).setGrayed(state);
            return true;
        }
        return false;
    }

    public void setGrayedElements(Object[] elements) {
        HashSet<Object> set = new HashSet<Object>(elements.length * 2 + 1);
        int i = 0;
        while (i < elements.length) {
            set.add(elements[i]);
            ++i;
        }
        TableItem[] items = this.getTable().getItems();
        int i2 = 0;
        while (i2 < items.length) {
            TableItem item = items[i2];
            Object element = item.getData();
            if (element != null) {
                boolean gray = set.contains(element);
                if (item.getGrayed() != gray) {
                    item.setGrayed(gray);
                }
            }
            ++i2;
        }
    }
}

