/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.flatui;

import com.ibm.etools.webtools.flatui.SingleColumnResizer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class MultiColumnResizer
extends SingleColumnResizer {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2002, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TableColumn[] fTableColumns;
    private int fTableColumnCount;
    protected final Table fTable;
    protected int fOldTableWidth;
    int fTotalColumnWidth = 0;
    int[] fProportions;
    int[] fRatios;
    private int[] fOldColumnWidths;
    protected boolean fFirstTime = true;
    private boolean fFirstFlatTable = true;
    private boolean fIsFlatColumnsResize = false;
    private boolean fIconColumn = false;
    protected boolean fHasFlatHeader = false;
    private boolean fMouseDown = false;
    protected Label[] fHeaderLabels;
    protected Composite fHeaderContainer;
    protected Composite[] fHeaderLabelBoxes;
    protected int fNumHeaders;
    private int fNumTextLabels;
    private int fNumSeparators;
    private int[] fFlatTableRatios;
    private float[] fFlatTablePpts;
    private static final int ICON_WIDTH = 19;
    private static final int SEPARATOR_WIDTH = 4;
    protected int[] fOrigXCoord;
    protected int[] fOrigYCoord;

    public MultiColumnResizer(Table table) {
        super(table);
        this.fTable = table;
        this.initialize(this.fTable, null);
    }

    public MultiColumnResizer(Table table, Label[] hLabels, int[] colRatios) {
        super(table);
        this.fTable = table;
        if (hLabels != null) {
            int i;
            this.fHeaderLabels = hLabels;
            this.fHeaderLabelBoxes = new Composite[this.fHeaderLabels.length];
            if (this.fHeaderLabels != null) {
                i = 0;
                while (i < this.fHeaderLabels.length) {
                    this.fHeaderLabelBoxes[i] = this.fHeaderLabels[i].getParent();
                    ++i;
                }
                this.fHeaderContainer = this.fHeaderLabelBoxes[0].getParent();
            }
            this.fHasFlatHeader = true;
            this.fNumHeaders = this.fHeaderLabels.length;
            this.fNumTextLabels = (this.fNumHeaders - 1) / 2;
            this.fNumSeparators = this.fNumHeaders - 1 - this.fNumTextLabels;
            this.fFlatTableRatios = new int[this.fNumTextLabels];
            this.fFlatTableRatios = (int[])(colRatios != null ? colRatios : null);
            this.fFlatTablePpts = new float[this.fNumTextLabels];
            this.fHeaderLabels[1].addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    MultiColumnResizer.this.mouseEnterEvent(e);
                }
            });
            this.fHeaderLabels[3].addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseEnter(MouseEvent e) {
                    MultiColumnResizer.this.mouseEnterEvent(e);
                }
            });
            this.fHeaderLabels[3].addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    MultiColumnResizer.this.setMouseDown(true);
                }

                public void mouseUp(MouseEvent e) {
                    MultiColumnResizer.this.setMouseDown(false);
                }

                public void mouseDoubleClick(MouseEvent e) {
                    MultiColumnResizer.this.handleDoubleClick(2);
                }
            });
            this.fHeaderLabels[1].addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    MultiColumnResizer.this.setMouseDown(true);
                }

                public void mouseUp(MouseEvent e) {
                    MultiColumnResizer.this.setMouseDown(false);
                }

                public void mouseDoubleClick(MouseEvent e) {
                    MultiColumnResizer.this.handleDoubleClick(0);
                }
            });
            this.fHeaderLabels[1].addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if (MultiColumnResizer.this.getMouseDown()) {
                        MultiColumnResizer.this.mouseUpEvent(e, 1);
                    }
                }
            });
            this.fHeaderLabels[3].addMouseMoveListener(new MouseMoveListener(){

                public void mouseMove(MouseEvent e) {
                    if (MultiColumnResizer.this.getMouseDown()) {
                        MultiColumnResizer.this.mouseUpEvent(e, 3);
                    }
                }
            });
            this.fTableColumnCount = this.fTable.getColumnCount();
            this.fTableColumns = new TableColumn[this.fTableColumnCount];
            i = 0;
            while (i < this.fTableColumnCount) {
                this.fTableColumns[i] = this.fTable.getColumn(i);
                ++i;
            }
            Display.getDefault().syncExec((Runnable)new Thread(){

                public void run() {
                    MultiColumnResizer.this.flatTableResized();
                }
            });
            this.fTable.getHorizontalBar().addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    MultiColumnResizer.this.handleHorizontalScroll(e);
                }
            });
        } else {
            this.initialize(this.fTable, this.fRatios);
        }
    }

    public MultiColumnResizer(Table table, boolean fHasIconColumn) {
        super(table);
        this.fTable = table;
        this.fIconColumn = fHasIconColumn;
        if (this.fIconColumn) {
            this.fTable.getColumn(0).setWidth(19);
            this.fTable.getColumn(1).setWidth(this.fTable.getClientArea().width - 19);
            int i = 0;
            while (i < this.fTable.getColumnCount()) {
                this.fTable.getColumn(i).setResizable(false);
                ++i;
            }
        } else {
            this.initialize(this.fTable, null);
        }
    }

    public MultiColumnResizer(Table table, int[] ppts) {
        super(table);
        this.fTable = table;
        this.initialize(this.fTable, ppts);
    }

    protected final void handleDoubleClick(int columnIndex) {
    }

    public void handleEvent(Event event) {
        if (this.fTable != null && !this.fTable.isDisposed()) {
            if (!this.fIconColumn) {
                if (this.fTable.getClientArea().width != this.fOldTableWidth) {
                    this.saveOldTableWidth();
                    if (this.fHasFlatHeader) {
                        Display.getDefault().asyncExec((Runnable)new Thread(){

                            public void run() {
                                MultiColumnResizer.this.flatTableResized();
                            }
                        });
                    } else if (this.fFirstTime) {
                        Display.getDefault().asyncExec((Runnable)new Thread(){

                            public void run() {
                                MultiColumnResizer.this.resizeColumnsToFit(MultiColumnResizer.this.fTable.getClientArea().width);
                                MultiColumnResizer.this.fFirstTime = false;
                            }
                        });
                    } else {
                        Display.getDefault().asyncExec((Runnable)new Thread(){

                            public void run() {
                                MultiColumnResizer.this.resizeColumnsToFit(MultiColumnResizer.this.fTable.getClientArea().width);
                            }
                        });
                    }
                } else if (this.fHasFlatHeader) {
                    Display.getDefault().asyncExec((Runnable)new Thread(){

                        public void run() {
                            MultiColumnResizer.this.flatTableResized();
                        }
                    });
                }
            } else {
                Display.getDefault().asyncExec((Runnable)new Thread(){

                    public void run() {
                        if (!MultiColumnResizer.this.fTable.isDisposed()) {
                            MultiColumnResizer.this.fTable.getColumn(0).setWidth(19);
                            MultiColumnResizer.this.fTable.getColumn(1).setWidth(MultiColumnResizer.this.fTable.getClientArea().width - 19);
                        }
                    }
                });
            }
            final ScrollBar hSB = this.fTable.getHorizontalBar();
            Display.getDefault().asyncExec((Runnable)new Thread(){

                public void run() {
                    if (!MultiColumnResizer.this.fTable.isDisposed() && hSB != null && MultiColumnResizer.this.fHasFlatHeader) {
                        hSB.setEnabled(true);
                    }
                }
            });
        }
    }

    protected final void columnsResized() {
        if (!this.fFirstTime) {
            int[] currentColumnWidths = new int[this.fTableColumnCount];
            int tableClientArea = this.fTable.getClientArea().width;
            currentColumnWidths[0] = this.fTable.getColumn(0).getWidth();
            currentColumnWidths[1] = tableClientArea - currentColumnWidths[0];
            this.fTable.getColumn(this.fTableColumnCount - 1).setWidth(currentColumnWidths[1]);
            if (!currentColumnWidths.equals(this.fOldColumnWidths)) {
                this.saveOldColumnWidths();
                this.fRatios = new int[this.fTableColumnCount];
                int i = 0;
                while (i < this.fTableColumnCount) {
                    this.fRatios[i] = currentColumnWidths[i];
                    ++i;
                }
                this.setProportions(this.fRatios);
            }
        }
    }

    private void initialize(Table table, int[] ppts) {
        this.fTableColumnCount = table.getColumnCount();
        this.fTableColumns = new TableColumn[this.fTableColumnCount];
        int i = 0;
        while (i < this.fTableColumnCount) {
            this.fTableColumns[i] = table.getColumn(i);
            if (i == this.fTableColumnCount - 1) {
                table.getColumn(i).setResizable(false);
            }
            ++i;
        }
        table.getColumn(0).addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Display.getDefault().asyncExec((Runnable)new Thread(){

                    public void run() {
                        MultiColumnResizer.this.columnsResized();
                    }
                });
            }
        });
        this.setProportions(ppts);
        this.saveOldTableWidth();
        this.saveOldColumnWidths();
        Display.getDefault().asyncExec((Runnable)new Thread(){

            public void run() {
                MultiColumnResizer.this.resizeColumnsToFit(MultiColumnResizer.this.fOldTableWidth);
            }
        });
    }

    protected final void resizeColumnsToFit(int tableWidth) {
        int totalCount = 0;
        if (!this.fTable.isDisposed()) {
            int i = 0;
            while (i < this.fTableColumnCount) {
                totalCount += this.fProportions[i];
                ++i;
            }
            if (totalCount != 0) {
                i = 0;
                while (i < this.fTableColumnCount) {
                    int newWidth = tableWidth * this.fProportions[i] / totalCount;
                    this.fTableColumns[i].setWidth(newWidth);
                    this.fTotalColumnWidth += newWidth;
                    ++i;
                }
                int delta = tableWidth - this.fTotalColumnWidth;
                int oldWidth = this.fTableColumns[this.fTableColumnCount - 1].getWidth();
                this.fTableColumns[this.fTableColumnCount - 1].setWidth(oldWidth + delta);
                totalCount = 0;
                this.fTotalColumnWidth = 0;
            }
        }
    }

    private void saveOldTableWidth() {
        this.fOldTableWidth = this.fTable.getClientArea().width;
    }

    private void saveOldColumnWidths() {
        this.fOldColumnWidths = new int[this.fTableColumnCount];
        this.fOldColumnWidths[0] = this.fTable.getColumn(0).getWidth();
        this.fOldColumnWidths[1] = this.fTable.getClientArea().width - this.fOldColumnWidths[1];
    }

    private void setProportions(int[] ppts) {
        this.fProportions = new int[this.fTableColumnCount];
        if (ppts != null) {
            int i = 0;
            while (i < this.fTableColumnCount) {
                if (ppts[i] != 0) {
                    this.fProportions[i] = ppts[i];
                }
                ++i;
            }
            ppts = null;
        } else {
            int i = 0;
            while (i < this.fTableColumnCount) {
                int w = this.fTableColumns[i].getWidth();
                this.fProportions[i] = w <= 0 ? this.fTableColumns[i].getText().length() : w;
                ++i;
            }
        }
    }

    protected final void mouseUpEvent(MouseEvent e, final int separatorIndex) {
        final int eX = e.x;
        Display.getDefault().asyncExec((Runnable)new Thread(){

            public void run() {
                MultiColumnResizer.this.fHeaderContainer.setSize(MultiColumnResizer.this.fTable.getClientArea().width, MultiColumnResizer.this.fHeaderContainer.getSize().y);
                int firstLabelWidth = MultiColumnResizer.this.fHeaderLabelBoxes[separatorIndex - 1].getSize().x + eX;
                if (firstLabelWidth <= 0) {
                    firstLabelWidth = 0;
                }
                int columnIndex = 0;
                if (separatorIndex != 1) {
                    columnIndex = separatorIndex - 2;
                }
                int tableOffset = 2;
                if (separatorIndex > 1) {
                    tableOffset = 4;
                }
                MultiColumnResizer.this.fTable.getColumn(columnIndex).setWidth(firstLabelWidth + tableOffset);
                MultiColumnResizer.this.fHeaderLabelBoxes[separatorIndex - 1].setBounds(MultiColumnResizer.this.fHeaderLabelBoxes[separatorIndex - 1].getBounds().x, MultiColumnResizer.this.fHeaderLabelBoxes[separatorIndex - 1].getBounds().y, firstLabelWidth, MultiColumnResizer.this.fHeaderLabelBoxes[separatorIndex - 1].getSize().y);
                MultiColumnResizer.this.fHeaderLabels[separatorIndex - 1].setSize(MultiColumnResizer.this.fHeaderLabelBoxes[separatorIndex - 1].getBounds().width - 1, MultiColumnResizer.this.fHeaderLabelBoxes[separatorIndex - 1].getSize().y - 2);
                int yBounds = MultiColumnResizer.this.fHeaderLabelBoxes[separatorIndex - 1].getBounds().y;
                int i = separatorIndex;
                while (i < MultiColumnResizer.this.fHeaderLabels.length) {
                    if (i == MultiColumnResizer.this.fHeaderLabels.length - 1) {
                        int headerEnd_x = MultiColumnResizer.this.fHeaderLabelBoxes[MultiColumnResizer.this.fHeaderLabels.length - 2].getBounds().x + MultiColumnResizer.this.fHeaderLabelBoxes[MultiColumnResizer.this.fHeaderLabels.length - 2].getBounds().width;
                        if (headerEnd_x < MultiColumnResizer.this.fTable.getClientArea().width) {
                            MultiColumnResizer.this.fHeaderLabelBoxes[i].setBounds(headerEnd_x, 0, MultiColumnResizer.this.fTable.getClientArea().width - headerEnd_x, MultiColumnResizer.this.fHeaderLabelBoxes[i].getSize().y);
                            MultiColumnResizer.this.fHeaderLabels[i].setSize(MultiColumnResizer.this.fTable.getClientArea().width - headerEnd_x, MultiColumnResizer.this.fHeaderLabelBoxes[i].getSize().y - 2);
                        }
                    } else if (i % 2 == 0) {
                        MultiColumnResizer.this.fHeaderLabelBoxes[i].setBounds(MultiColumnResizer.this.fHeaderLabelBoxes[i - 1].getBounds().x + 4, yBounds, MultiColumnResizer.this.fHeaderLabelBoxes[i].getSize().x, MultiColumnResizer.this.fHeaderLabelBoxes[i].getSize().y);
                        MultiColumnResizer.this.fHeaderLabels[i].setSize(MultiColumnResizer.this.fHeaderLabelBoxes[i].getSize().x - 1, MultiColumnResizer.this.fHeaderLabelBoxes[i].getSize().y - 2);
                    } else {
                        MultiColumnResizer.this.fHeaderLabelBoxes[i].setBounds(MultiColumnResizer.this.fHeaderLabelBoxes[i - 1].getBounds().x + MultiColumnResizer.this.fHeaderLabelBoxes[i - 1].getBounds().width, yBounds, 4, MultiColumnResizer.this.fHeaderLabelBoxes[i].getSize().y);
                        MultiColumnResizer.this.fHeaderLabels[i].setSize(3, MultiColumnResizer.this.fHeaderLabelBoxes[i].getSize().y - 2);
                    }
                    ++i;
                }
            }
        });
        this.fIsFlatColumnsResize = true;
        Display.getDefault().asyncExec((Runnable)new Thread(){

            public void run() {
                MultiColumnResizer.this.flatTableResized();
            }
        });
    }

    protected final void flatTableResized() {
        if (!this.fTable.isDisposed()) {
            int tableClientArea = this.fTable.getClientArea().width;
            int netTableWidth = tableClientArea - this.fNumSeparators * 4;
            int netOldTableWidth = this.fOldTableWidth - this.fNumSeparators * 4;
            this.fHeaderContainer.setSize(netTableWidth + this.fNumSeparators * 4, this.fHeaderContainer.getSize().y);
            if (this.fFirstFlatTable) {
                int totalRatio = 0;
                if (this.fFlatTableRatios != null) {
                    int i = 0;
                    while (i < this.fFlatTableRatios.length) {
                        totalRatio += this.fFlatTableRatios[i];
                        ++i;
                    }
                    i = 0;
                    while (i < this.fFlatTableRatios.length) {
                        if (totalRatio != 0) {
                            this.fFlatTablePpts[i] = (float)this.fFlatTableRatios[i] / (float)totalRatio;
                        }
                        ++i;
                    }
                } else {
                    totalRatio = this.fNumTextLabels;
                    int i = 0;
                    while (i < this.fNumTextLabels) {
                        if (totalRatio != 0) {
                            this.fFlatTablePpts[i] = 1.0f / (float)totalRatio;
                        }
                        ++i;
                    }
                }
                this.fFirstFlatTable = false;
            } else if (this.fIsFlatColumnsResize) {
                int i = 0;
                while (i < this.fNumTextLabels) {
                    if (netOldTableWidth != 0) {
                        this.fFlatTablePpts[i] = (float)this.fHeaderLabelBoxes[i * 2].getBounds().width / (float)netOldTableWidth;
                    }
                    ++i;
                }
                this.fIsFlatColumnsResize = false;
            }
            this.resizeFlatTableColumns(netTableWidth);
        }
    }

    private void resizeFlatTableColumns(int tableWidth) {
        int currentBound_x = 0;
        int currentBound_y = 0;
        int labelWidth = 0;
        int barSelect = this.fTable.getHorizontalBar().getSelection();
        int i = 0;
        while (i < this.fNumHeaders) {
            if (i == this.fNumHeaders - 1) {
                this.fHeaderLabelBoxes[i].setBounds(currentBound_x, 0, this.fTable.getClientArea().width - currentBound_x, this.fHeaderLabelBoxes[i].getSize().y);
                this.fHeaderLabels[i].setSize(this.fHeaderLabelBoxes[i].getBounds().width - 1, this.fHeaderLabelBoxes[i].getSize().y - 2);
            } else if (i % 2 == 0) {
                int j = 0;
                if (i != 0) {
                    j = i / 2;
                }
                labelWidth = (int)(this.fFlatTablePpts[j] * (float)tableWidth);
                int xBound = 0;
                if (i == 0) {
                    xBound = barSelect != 0 ? -barSelect : 0;
                    this.fHeaderLabelBoxes[0].setBounds(xBound, 0, labelWidth, this.fHeaderLabelBoxes[i].getSize().y);
                } else {
                    this.fHeaderLabelBoxes[i].setBounds(currentBound_x, currentBound_y, labelWidth, this.fHeaderLabelBoxes[i].getSize().y);
                }
                this.fHeaderLabels[i].setSize(labelWidth - 1, this.fHeaderLabelBoxes[i].getSize().y - 2);
                if (j == 0) {
                    this.fTableColumns[0].setWidth(labelWidth + 2);
                    currentBound_x += labelWidth + xBound;
                } else {
                    this.fTableColumns[j].setWidth(labelWidth + 4);
                    currentBound_x += labelWidth;
                }
            } else {
                this.fHeaderLabelBoxes[i].setBounds(currentBound_x, currentBound_y, 4, this.fHeaderLabelBoxes[i].getSize().y);
                this.fHeaderLabels[i].setSize(3, this.fHeaderLabelBoxes[i].getSize().y - 2);
                currentBound_x += 4;
            }
            ++i;
        }
        if (barSelect == 0) {
            this.saveHeaderCoordinates();
        } else {
            i = 1;
            while (i < this.fHeaderLabels.length - 1) {
                this.fOrigXCoord[i] = this.fHeaderLabelBoxes[i].getBounds().x + barSelect;
                ++i;
            }
        }
    }

    protected final void mouseEnterEvent(MouseEvent e) {
        Cursor resizeCursor = new Cursor((Device)Display.getCurrent(), 9);
        Control control = (Control)e.widget;
        control.setCursor(resizeCursor);
    }

    protected final void handleHorizontalScroll(Event e) {
        ScrollBar horizontalBar = (ScrollBar)e.widget;
        final int newOriginX = horizontalBar.getSelection();
        Display.getDefault().syncExec((Runnable)new Thread(){

            public void run() {
                int i = 0;
                while (i < MultiColumnResizer.this.fNumHeaders - 1) {
                    MultiColumnResizer.this.fHeaderLabelBoxes[i].setBounds(MultiColumnResizer.this.fOrigXCoord[i] - newOriginX, MultiColumnResizer.this.fOrigYCoord[i], MultiColumnResizer.this.fHeaderLabelBoxes[i].getBounds().width, MultiColumnResizer.this.fHeaderLabelBoxes[i].getSize().y);
                    if (i == MultiColumnResizer.this.fHeaderLabels.length - 1) {
                        MultiColumnResizer.this.fHeaderLabels[i].setSize(3, MultiColumnResizer.this.fHeaderLabelBoxes[i].getSize().y - 2);
                    } else {
                        MultiColumnResizer.this.fHeaderLabels[i].setSize(MultiColumnResizer.this.fHeaderLabelBoxes[i].getBounds().width - 1, MultiColumnResizer.this.fHeaderLabelBoxes[i].getSize().y - 2);
                    }
                    ++i;
                }
            }
        });
    }

    private void saveHeaderCoordinates() {
        this.fOrigXCoord = new int[this.fHeaderLabels.length];
        this.fOrigYCoord = new int[this.fHeaderLabels.length];
        int i = 0;
        while (i < this.fHeaderLabels.length - 1) {
            this.fOrigXCoord[i] = this.fHeaderLabelBoxes[i].getBounds().x;
            this.fOrigYCoord[i] = this.fHeaderLabelBoxes[i].getBounds().y;
            ++i;
        }
    }

    protected final void setMouseDown(boolean mouseDown) {
        this.fMouseDown = mouseDown;
    }

    protected final boolean getMouseDown() {
        return this.fMouseDown;
    }
}

