/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.webtools.flatui;

import com.ibm.etools.webtools.flatui.IFlatPageSection;
import com.ibm.etools.webtools.flatui.ToggleControl;
import com.ibm.etools.webtools.flatui.WidgetFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public abstract class FlatPageSection
extends ContentViewer
implements IFlatPageSection {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2002, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int SELECTION = 1;
    private String fHeaderColorKey = "__default__header__";
    protected static final int WHINT = 200;
    protected static final int LEFT_SEC_WHINT = 110;
    private String fHeaderText;
    protected int fHSpan = 1;
    protected Composite fSectionControl;
    protected Label fHeader;
    protected Control fSeparator;
    private String fDescription;
    protected Composite fParent;
    protected Label fDescriptionLabel;
    protected ToggleControl fToggle;
    protected boolean fReadOnly;
    protected boolean fAddSeparator = true;
    protected boolean fDescriptionPainted = true;
    protected final boolean fHeaderPainted = true;
    protected boolean fCollapsable = true;
    private boolean fCollapsed = false;
    protected WidgetFactory fWf;

    public FlatPageSection() {
        if (SWT.getPlatform().equals("motif")) {
            this.fDescriptionPainted = false;
        }
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
    }

    protected abstract Composite createClient(Composite var1);

    public Control createControl(Composite parent) {
        this.fParent = parent;
        Composite secCon = this.fWf.createComposite(this.fParent);
        SectionLayout slayout = new SectionLayout();
        secCon.setLayout((Layout)slayout);
        secCon.setData((Object)this);
        Color headerColor = this.fWf.getColor(this.getHeaderColorKey());
        this.fHeader = this.fWf.createHeadingLabel(secCon, this.getHeaderText(), headerColor, 64);
        if (this.fCollapsable) {
            this.fToggle = new ToggleControl(secCon, 0);
            FontData[] fd = JFaceResources.getBannerFont().getFontData();
            if (fd != null) {
                this.fToggle.setHeight(fd[0].getHeight());
            }
            this.fToggle.setBackground(this.fWf.getBackgroundColor());
            this.fToggle.setActiveDecorationColor(this.fWf.getHyperlinkColor());
            this.fToggle.setDecorationColor(this.fWf.getColor("__compSep"));
            this.fToggle.setActiveCursor(this.fWf.getHyperlinkCursor());
            this.fToggle.setName(this.getHeaderText());
            this.fToggle.setDescription(this.getDescription());
            this.fToggle.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean collapsed = FlatPageSection.this.fToggle.getSelection();
                    FlatPageSection.this.setCollapsed(collapsed);
                }
            });
        }
        if (this.fAddSeparator) {
            this.fSeparator = this.fWf.createCompositeSeparator(secCon);
        }
        if (this.fDescriptionPainted && this.fDescription != null) {
            this.fDescriptionLabel = this.fWf.createLabel(secCon, this.fDescription, 64);
        }
        this.fSectionControl = this.createClient(secCon);
        this.setCollapsed(this.fCollapsed);
        this.refresh();
        return secCon;
    }

    public ISelectionChangedListener createTblSelChngLstnr() {
        ISelectionChangedListener selectionChangedListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FlatPageSection.this.handleTableSelectionChanged(event);
            }
        };
        return selectionChangedListener;
    }

    protected void reflow() {
        Composite comp;
        if (this.fSectionControl != null && !this.fSectionControl.isDisposed() && (comp = this.fSectionControl.getParent()) != null && !comp.isDisposed()) {
            comp.layout(true);
            Composite parent = comp.getParent();
            if (parent != null && !parent.isDisposed()) {
                parent.layout(true);
            }
        }
    }

    protected CCombo createCombo(Composite parent, String label) {
        this.fWf.createLabel(parent, label);
        CCombo combo = this.fWf.createCCombo(parent);
        GridData gd = new GridData(772);
        combo.setLayoutData((Object)gd);
        return combo;
    }

    protected Text createText(int style, Composite parent, String label) {
        this.fWf.createLabel(parent, label);
        Text text = this.fWf.createText(parent, "", style);
        GridData gd = new GridData(772);
        text.setLayoutData((Object)gd);
        return text;
    }

    protected Text createText(Composite parent, String label) {
        return this.createText(parent, label, 1);
    }

    protected Text createText(Composite parent, String label, int span) {
        this.fWf.createLabel(parent, label);
        Text text = this.fWf.createText(parent, "");
        GridData gd = new GridData(772);
        gd.horizontalSpan = span;
        text.setLayoutData((Object)gd);
        return text;
    }

    protected Text createText(Composite parent, int span) {
        Text text = this.fWf.createText(parent, "");
        GridData gd = new GridData(772);
        gd.horizontalSpan = span;
        text.setLayoutData((Object)gd);
        return text;
    }

    public void dispose() {
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
    }

    public void doGlobalAction(String actionId) {
    }

    public final String getDescription() {
        return this.fDescription;
    }

    public String getHeaderColorKey() {
        return this.fHeaderColorKey;
    }

    public final String getHeaderText() {
        return this.fHeaderText;
    }

    public boolean isReadOnly() {
        return this.fReadOnly;
    }

    protected final void setAddSeparator(boolean newAddSeparator) {
        this.fAddSeparator = newAddSeparator;
    }

    private String trimNewLines(String text) {
        StringBuffer buff = new StringBuffer();
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            if (c == '\n') {
                buff.append(' ');
            } else {
                buff.append(c);
            }
            ++i;
        }
        return buff.toString();
    }

    protected void setDescription(String newDescription) {
        this.fDescription = this.trimNewLines(newDescription);
        if (this.fDescriptionLabel != null) {
            this.fDescriptionLabel.setText(newDescription);
        }
    }

    public void setFocus() {
        if (this.fSectionControl != null && !this.fSectionControl.isDisposed()) {
            this.fSectionControl.getParent().setFocus();
        }
    }

    public void setGridData(Control control) {
        GridData gd = new GridData(770);
        gd.widthHint = 200;
        gd.horizontalSpan = this.getHSpan();
        control.setLayoutData((Object)gd);
    }

    protected int getHSpan() {
        return this.fHSpan;
    }

    protected void setHSpan(int span) {
        this.fHSpan = span;
    }

    public final void setHeaderColorKey(String newHeaderColorKey) {
        this.fHeaderColorKey = newHeaderColorKey;
    }

    protected final void setHeaderText(String newHeaderText) {
        this.fHeaderText = newHeaderText;
        if (this.fHeader != null) {
            this.fHeader.setText(this.fHeaderText);
        }
    }

    public final void setReadOnly(boolean newReadOnly) {
        this.fReadOnly = newReadOnly;
    }

    public void propertyChange(PropertyChangeEvent arg0) {
        FontData[] fd;
        if (this.fHeader != null && !this.fHeader.isDisposed()) {
            this.fHeader.setFont(JFaceResources.getBannerFont());
        }
        if (this.fToggle != null && !this.fToggle.isDisposed() && (fd = JFaceResources.getBannerFont().getFontData()) != null) {
            this.fToggle.setHeight(fd[0].getHeight());
        }
        if (this.fSectionControl != null && !this.fSectionControl.isDisposed()) {
            this.reflow();
            this.fSectionControl.layout(true);
        }
    }

    public final boolean getCollapsable() {
        return this.fCollapsable;
    }

    public Control getControl() {
        return this.fSectionControl;
    }

    public void setCollapsed(boolean collapsed) {
        this.fCollapsed = collapsed;
        if (this.fToggle != null) {
            this.fToggle.setSelection(collapsed);
            this.reflow();
            if (this.fDescriptionLabel != null) {
                this.fDescriptionLabel.setVisible(!collapsed);
            }
            if (this.fSectionControl != null) {
                this.fSectionControl.setVisible(!collapsed);
            }
        }
    }

    public final void setCollapsable(boolean collapsable) {
        this.fCollapsable = collapsable;
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent e) {
    }

    class SectionLayout
    extends Layout {
        int vspacing = 3;
        int sepHeight = 2;

        SectionLayout() {
        }

        protected Point computeSize(Composite parent, int wHint, int hHint, boolean flush) {
            int width = 0;
            int height = 0;
            int cwidth = 0;
            int collapsedHeight = 0;
            if (wHint != -1) {
                width = wHint;
            }
            if (hHint != -1) {
                height = hHint;
            }
            cwidth = width;
            if (FlatPageSection.this.fSectionControl != null) {
                Point csize = FlatPageSection.this.fSectionControl.computeSize(-1, -1, flush);
                if (width == 0) {
                    cwidth = width = csize.x;
                }
                if (height == 0) {
                    height = csize.y;
                }
            }
            Point toggleSize = null;
            if (FlatPageSection.this.fCollapsable && FlatPageSection.this.fToggle != null) {
                toggleSize = FlatPageSection.this.fToggle.computeSize(-1, -1, flush);
            }
            if (hHint == -1 && FlatPageSection.this.fHeader != null) {
                int hwidth = cwidth;
                if (toggleSize != null) {
                    hwidth = cwidth - toggleSize.x - 5;
                }
                Point hsize = FlatPageSection.this.fHeader.computeSize(hwidth, -1, flush);
                height += hsize.y;
                collapsedHeight = hsize.y;
                height += this.vspacing;
            }
            if (hHint == -1 && FlatPageSection.this.fAddSeparator) {
                height += this.sepHeight;
                height += this.vspacing;
                collapsedHeight += this.vspacing + this.sepHeight;
            }
            if (hHint == -1 && FlatPageSection.this.fDescriptionPainted && FlatPageSection.this.fDescriptionLabel != null) {
                Point dsize = FlatPageSection.this.fDescriptionLabel.computeSize(cwidth, -1, flush);
                height += dsize.y;
                height += this.vspacing;
            }
            if (FlatPageSection.this.fToggle != null && FlatPageSection.this.fToggle.getSelection()) {
                height = collapsedHeight;
            }
            return new Point(width, height);
        }

        protected void layout(Composite parent, boolean flush) {
            int width = parent.getClientArea().width;
            int height = parent.getClientArea().height;
            int y = 0;
            Point toggleSize = null;
            if (FlatPageSection.this.fCollapsable) {
                toggleSize = FlatPageSection.this.fToggle.computeSize(-1, -1, flush);
            }
            if (FlatPageSection.this.fHeader != null) {
                int availableWidth = width;
                if (toggleSize != null) {
                    availableWidth = width - toggleSize.x - 5;
                }
                Point hsize = FlatPageSection.this.fHeader.computeSize(availableWidth, -1, flush);
                int hx = 0;
                if (FlatPageSection.this.fToggle != null && toggleSize != null) {
                    int ty = y + hsize.y - toggleSize.y;
                    FlatPageSection.this.fToggle.setBounds(0, ty, toggleSize.x, toggleSize.y);
                    hx = toggleSize.x;
                }
                FlatPageSection.this.fHeader.setBounds(hx, y, availableWidth, hsize.y);
                y += hsize.y + this.vspacing;
            }
            if (FlatPageSection.this.fAddSeparator && FlatPageSection.this.fSeparator != null) {
                FlatPageSection.this.fSeparator.setBounds(0, y, width, 2);
                y += this.sepHeight + this.vspacing;
            }
            if (FlatPageSection.this.fToggle != null && FlatPageSection.this.fToggle.getSelection()) {
                return;
            }
            if (FlatPageSection.this.fDescriptionPainted && FlatPageSection.this.fDescriptionLabel != null) {
                Point dsize = FlatPageSection.this.fDescriptionLabel.computeSize(width, -1, flush);
                FlatPageSection.this.fDescriptionLabel.setBounds(0, y, width, dsize.y);
                y += dsize.y + this.vspacing;
            }
            if (FlatPageSection.this.fSectionControl != null) {
                FlatPageSection.this.fSectionControl.setBounds(0, y, width, height - y);
            }
        }
    }
}

