/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacMacroParameter;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacSegmentCall;
import com.ibm.pdp.mdl.pacbase.PacWLineF;
import com.ibm.pdp.mdl.pacbase.PacWLineText;
import com.ibm.pdp.w3.generate.analyser.pacmodeltow3model.GenerationLanguage;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3TextWorkingLineImpl;
import java.util.Iterator;

public class W3TextWorkingLine
extends W3TextWorkingLineImpl
implements W3Interface {
    private W3CommonDescription w3Header = null;
    private int[] BLANC1 = new int[]{1, 2};
    private int[] NULIM = new int[]{3, 2};
    private int[] NULI8 = new int[]{5, 3};
    private int[] SUITE = new int[]{8, 1};
    private int[] TEXT = new int[]{9, 65};
    private int[] DIMTA = new int[]{74, 5};
    private int[] PROGR = new int[]{79, 6};
    private int[] CORUM = new int[]{85, 6};
    private int[] FILLER_A = new int[]{91, 8};
    private int[] PICTUC = new int[]{99, 13};
    private int[] USAGEI = new int[]{112, 1};
    private int[] XINDC = new int[]{113, 1};
    private int[] B3UN = new int[]{114, 1};
    private int[] B1UN = new int[]{115, 1};
    private int[] XPARM = new int[]{116, 1};
    private int[] TYBLO2 = new int[]{117, 1};
    private int[] NUVERB = new int[]{118, 4};
    private int[] DESCA = new int[]{122, 1};
    private int[] VARIA = new int[]{123, 1};
    private int[] CORUB = new int[]{124, 6};
    private int[] TYRUB = new int[]{130, 1};
    private PacProgram programToGenerate;
    private PacWLineText pacWLineText;
    private PacWLineF pacWLineF;
    private String codeMacroEnCoursT;
    private int numberOfLineEnCoursT;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public W3TextWorkingLine(PacProgram pgm, PacWLineText wlt) {
        this.programToGenerate = pgm;
        this.pacWLineText = wlt;
        this.initToSpace();
        this.init();
    }

    public W3TextWorkingLine(PacProgram pgm, PacWLineF wlf) {
        this.programToGenerate = pgm;
        this.pacWLineF = wlf;
        this.initToSpace();
        this.initF();
    }

    public W3TextWorkingLine(PacProgram pgm, PacWLineF wlf, String codeMacroEnCours, int numberOfLine) {
        this.programToGenerate = pgm;
        this.pacWLineF = wlf;
        this.codeMacroEnCoursT = codeMacroEnCours;
        this.numberOfLineEnCoursT = numberOfLine;
        this.initToSpace();
        this.initF();
    }

    private void initToSpace() {
        this.setBLANC1(_BLANCS);
        this.setNULIM(_BLANCS);
        this.setNULI8(_BLANCS);
        this.setSUITE(_BLANCS);
        this.setTEXT(_260BLANCS);
        this.setDIMTA(_BLANCS);
        this.setPROGR(_BLANCS);
        this.setCORUM(_BLANCS);
        this.setFILLER_A(_BLANCS);
        this.setPICTUC(_BLANCS);
        this.setUSAGEI(_BLANCS);
        this.setXINDC(_BLANCS);
        this.setB3UN(_BLANCS);
        this.setB1UN(_BLANCS);
        this.setXPARM(_BLANCS);
        this.setTYBLO2(_BLANCS);
        this.setNUVERB(_BLANCS);
        this.setDESCA(_BLANCS);
        this.setVARIA(_BLANCS);
        this.setCORUB(_BLANCS);
        this.setTYRUB(_BLANCS);
    }

    protected void init() {
        this.w3Header = new W3CommonDescription(this.programToGenerate);
        this.w3Header.setB3A_Value("S");
        this.w3Header.setCOCA_Value("7");
        this.w3Header.setIED_Value("12");
        this.w3Header.setB6_Value(this.pacWLineText.getCobolPosition());
        this.w3Header.setB7_Value(this.pacWLineText.getLineNumber());
        this.w3Header.setB8_Value("999999");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setNULIM(this.pacWLineText.getCobolPosition());
        this.setNULI8(this.pacWLineText.getLineNumber());
        this.setSUITE("*");
        this.setTEXT(this.pacWLineText.getText());
        this.setUSAGEI("R");
        this.setXINDC("X");
        this.setB3UN("B");
        this.setB1UN("K");
        this.setXPARM("0");
    }

    protected void initF() {
        String generationLang;
        this.w3Header = new W3CommonDescription(this.programToGenerate);
        this.w3Header.setB3A_Value("S");
        this.w3Header.setCOCA_Value("7");
        this.w3Header.setIED_Value("12");
        this.w3Header.setB6_Value(this.pacWLineF.getCobolPosition());
        this.w3Header.setB7_Value(this.pacWLineF.getLineNumber());
        this.w3Header.setB8_Value("999999");
        this.setNULIM(this.pacWLineF.getCobolPosition());
        this.setNULI8(this.pacWLineF.getLineNumber());
        this.setSUITE("F");
        this.setTEXT("SD: ?? BIB: ?? SEL: ________ FORM: I DESC: _ NIV: 1 ORG: _ SS: _ ");
        String codeSDProg = this.pacWLineF.getCommonDescription().getCodeInProgram();
        String codeSDBib = "";
        codeSDBib = this.pacWLineF.getDataStructure() != null ? this.pacWLineF.getDataStructure().getName() : this.pacWLineF.getNativeCall();
        String selectEnreg = "";
        this.setUSAGEI("R");
        this.setXINDC("X");
        this.setB3UN("B");
        this.setB1UN("K");
        this.setXPARM("0");
        for (PacSegmentCall aSegmentCall : this.pacWLineF.getSegmentCalls()) {
            String codEnregistrement = aSegmentCall.getCodeInProgram();
            DataAggregate dg = aSegmentCall.getSegment();
            String codeSegdataAgg = dg.getName().substring(2, 4);
            if (codEnregistrement.length() > 0) {
                if (!codEnregistrement.equals(codeSegdataAgg)) {
                    selectEnreg = codeSegdataAgg.concat("=").concat(codEnregistrement);
                    continue;
                }
                selectEnreg = selectEnreg.concat(codEnregistrement);
                continue;
            }
            selectEnreg = selectEnreg.concat(codeSegdataAgg);
        }
        if (this.pacWLineF.getNativeSelection() != null && this.pacWLineF.getNativeSelection().length() > 0) {
            selectEnreg = this.pacWLineF.getNativeSelection();
        }
        if (selectEnreg.length() < 8) {
            int i = selectEnreg.length();
            while (i < 8) {
                selectEnreg = selectEnreg.concat(" ");
                ++i;
            }
        }
        String typeFormat = String.valueOf(this.pacWLineF.getCommonDescription().getFormatType()).substring(1);
        String typeDesc = "";
        typeDesc = String.valueOf(this.pacWLineF.getCommonDescription().getGeneratedDescriptionType()).equals("_None") ? " " : String.valueOf(this.pacWLineF.getCommonDescription().getGeneratedDescriptionType()).substring(1);
        String niveau = String.valueOf(this.pacWLineF.getCommonDescription().getCobolRecordLevel()).substring(1);
        String organisation = "";
        organisation = String.valueOf(this.pacWLineF.getCommonDescription().getOrganization()).equals("_None") || String.valueOf(this.pacWLineF.getCommonDescription().getOrganization()).equals("_S") ? " " : String.valueOf(this.pacWLineF.getCommonDescription().getOrganization()).substring(1);
        String sousSchema = " ";
        if (this.pacWLineF.getCommonDescription().getSubScheme().trim().length() > 0) {
            sousSchema = this.pacWLineF.getCommonDescription().getSubScheme();
        }
        String groupSegment = "";
        if (this.pacWLineF.isGroupSegments()) {
            groupSegment = "*";
        }
        if ((generationLang = GenerationLanguage.getGenerationLanguage()).equals("FR")) {
            this.setTEXT("SD: ".concat(codeSDProg).concat(" BIB: ").concat(codeSDBib).concat(" SEL: ").concat(selectEnreg).concat(" FORM: ").concat(typeFormat).concat(" DESC: ").concat(typeDesc).concat(" NIV: ").concat(niveau).concat(" ORG: ").concat(organisation).concat(" SS: ").concat(sousSchema).concat(groupSegment));
        } else {
            this.setTEXT("SD: ".concat(codeSDProg).concat("  DL: ").concat(codeSDBib).concat(" SEL: ").concat(selectEnreg).concat(" PICT: ").concat(typeFormat).concat(" DESC: ").concat(typeDesc).concat(" LEV: ").concat(niveau).concat(" ORG: ").concat(organisation).concat(" SS: ").concat(sousSchema).concat(groupSegment));
        }
        if (this.programToGenerate.getCPLines() != null && this.codeMacroEnCoursT != null) {
            String nulim = this.getNULIM();
            String nuli8 = this.getNULI8();
            String text = this.getTEXT();
            String originalWLineF = "1234567890123456789012345678901234567".concat(nulim).concat(nuli8).concat("F").concat(text);
            for (Object obj : this.programToGenerate.getCPLines()) {
                String nameOfMacro = ((PacCPLine)obj).getMacro().getName();
                int numberOfLineOfMacro = ((PacCPLine)obj).getLineNumber();
                if (!nameOfMacro.equals(this.codeMacroEnCoursT) || numberOfLineOfMacro != this.numberOfLineEnCoursT || !(obj instanceof PacCPLine)) continue;
                PacCPLine cpLine = (PacCPLine)obj;
                String textDeparamedSave = W3TextWorkingLine.ReplaceParametersInFLine(originalWLineF, cpLine);
                this.setTEXT(textDeparamedSave.substring(43));
                this.setNULIM(textDeparamedSave.substring(37, 39));
                this.w3Header.setB6_Value(textDeparamedSave.substring(37, 39));
                this.setNULI8(textDeparamedSave.substring(39, 42));
                this.w3Header.setB7_Value(textDeparamedSave.substring(39, 42));
            }
        }
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
    }

    private int getBLANC1Length() {
        return this.BLANC1[1];
    }

    private int getNULIMLength() {
        return this.NULIM[1];
    }

    private int getNULI8Length() {
        return this.NULI8[1];
    }

    private int getSUITELength() {
        return this.SUITE[1];
    }

    private int getTEXTLength() {
        return this.TEXT[1];
    }

    private int getDIMTALength() {
        return this.DIMTA[1];
    }

    private int getPROGRLength() {
        return this.PROGR[1];
    }

    private int getCORUMLength() {
        return this.CORUM[1];
    }

    private int getFILLER_ALength() {
        return this.FILLER_A[1];
    }

    private int getPICTUCLength() {
        return this.PICTUC[1];
    }

    private int getUSAGEILength() {
        return this.USAGEI[1];
    }

    private int getXINDCLength() {
        return this.XINDC[1];
    }

    private int getB3UNLength() {
        return this.B3UN[1];
    }

    private int getB1UNLength() {
        return this.B1UN[1];
    }

    private int getXPARMLength() {
        return this.XPARM[1];
    }

    private int getTYBLO2Length() {
        return this.TYBLO2[1];
    }

    private int getNUVERBLength() {
        return this.NUVERB[1];
    }

    private int getDESCALength() {
        return this.DESCA[1];
    }

    private int getVARIALength() {
        return this.VARIA[1];
    }

    private int getCORUBLength() {
        return this.CORUB[1];
    }

    private int getTYRUBLength() {
        return this.TYRUB[1];
    }

    public void setBLANC1(String value) {
        super.setBLANC1((value + _BLANCS).substring(0, this.getBLANC1Length()));
    }

    public void setNULIM(String value) {
        super.setNULIM((value + _BLANCS).substring(0, this.getNULIMLength()));
    }

    public void setNULI8(String value) {
        super.setNULI8((value + _BLANCS).substring(0, this.getNULI8Length()));
    }

    public void setSUITE(String value) {
        super.setSUITE((value + _BLANCS).substring(0, this.getSUITELength()));
    }

    public void setTEXT(String value) {
        super.setTEXT((value + _260BLANCS).substring(0, this.getTEXTLength()));
    }

    public void setDIMTA(String value) {
        int lgTot = (_ZERO + value).length();
        int lgDIMTA = this.getDIMTALength();
        super.setDIMTA((_ZERO + value).substring(lgTot - lgDIMTA, lgTot));
    }

    public void setPROGR(String value) {
        super.setPROGR((value + _BLANCS).substring(0, this.getPROGRLength()));
    }

    public void setCORUM(String value) {
        super.setCORUM((value + _BLANCS).substring(0, this.getCORUMLength()));
    }

    public void setFILLER_A(String value) {
        super.setFILLER_A((value + _BLANCS).substring(0, this.getFILLER_ALength()));
    }

    public void setPICTUC(String value) {
        super.setPICTUC((value + _BLANCS).substring(0, this.getPICTUCLength()));
    }

    public void setUSAGEI(String value) {
        super.setUSAGEI((value + _BLANCS).substring(0, this.getUSAGEILength()));
    }

    public void setXINDC(String value) {
        super.setXINDC((value + _BLANCS).substring(0, this.getXINDCLength()));
    }

    public void setB3UN(String value) {
        super.setB3UN((value + _BLANCS).substring(0, this.getB3UNLength()));
    }

    public void setB1UN(String value) {
        super.setB1UN((value + _BLANCS).substring(0, this.getB1UNLength()));
    }

    public void setXPARM(String value) {
        super.setXPARM((value + _BLANCS).substring(0, this.getXPARMLength()));
    }

    public void setTYBLO2(String value) {
        super.setTYBLO2((value + _BLANCS).substring(0, this.getTYBLO2Length()));
    }

    public void setNUVERB(String value) {
        super.setNUVERB((value + _BLANCS).substring(0, this.getNUVERBLength()));
    }

    public void setDESCA(String value) {
        super.setDESCA((value + _BLANCS).substring(0, this.getDESCALength()));
    }

    public void setVARIA(String value) {
        super.setVARIA((value + _BLANCS).substring(0, this.getVARIALength()));
    }

    public void setCORUB(String value) {
        super.setCORUB((value + _BLANCS).substring(0, this.getCORUBLength()));
    }

    public void setTYRUB(String value) {
        super.setTYRUB((value + _BLANCS).substring(0, this.getTYRUBLength()));
    }

    public W3CommonDescription getW3Header() {
        return this.w3Header;
    }

    public String getText() {
        return this.text;
    }

    private static String ReplaceParametersInFLine(String originalWLineF, PacCPLine cpLine) {
        StringBuilder result = new StringBuilder(originalWLineF);
        Iterator itParam = cpLine.getParameters().iterator();
        StringBuilder selection = new StringBuilder(originalWLineF.substring(63, 71).trim());
        int decalageInSel = 0;
        boolean selectionChanged = false;
        while (itParam.hasNext()) {
            PacMacroParameter param = (PacMacroParameter)itParam.next();
            String id = param.getId();
            int parameterIndex = originalWLineF.indexOf(id);
            while (parameterIndex != -1) {
                boolean sameLength;
                Object value = param.getValue();
                if (((String)value).startsWith("D=") || ((String)value).startsWith("E=") || ((String)value).startsWith("S=")) {
                    value = ((String)value).substring(2);
                }
                if ("17_19_20_37_39_40".indexOf(String.valueOf(parameterIndex)) != -1) {
                    value = (String)value + "  ";
                    value = ((String)value).substring(0, 2);
                    value = ((String)value).replaceAll(" ", "0");
                } else if ("47_55".indexOf(String.valueOf(parameterIndex)) != -1) {
                    if (((String)value).length() > 2) {
                        value = "**";
                    } else {
                        value = (String)value + "  ";
                        value = ((String)value).substring(0, 2);
                    }
                }
                boolean bl = sameLength = ((String)value).length() == 2;
                if (sameLength) {
                    result.replace(parameterIndex, parameterIndex + 2, (String)value);
                } else if (parameterIndex >= 63 && parameterIndex <= 70) {
                    selectionChanged = true;
                    int indexInSelection = parameterIndex - 63 + decalageInSel;
                    selection.replace(indexInSelection, indexInSelection + 2, (String)value);
                    decalageInSel = ((String)value).length() - 2;
                }
                parameterIndex = originalWLineF.indexOf(id, parameterIndex + 1);
            }
        }
        if (selectionChanged) {
            if (selection.length() < 8) {
                while (selection.length() < 8) {
                    selection = selection.append(" ");
                }
            } else {
                selection = new StringBuilder("********");
            }
            result.replace(63, 71, selection.toString());
        }
        return result.toString();
    }
}

