/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.pacbase.PacCDLineDataStructure;
import com.ibm.pdp.mdl.pacbase.PacDataAggregate;
import com.ibm.pdp.mdl.pacbase.PacDataAggregateTypeValues;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacSegmentCall;
import com.ibm.pdp.mdl.pacbase.PacWLineF;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3DataElement;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3SegmentImpl;
import java.util.ArrayList;
import java.util.Iterator;

public class W3SegmentLine
extends W3SegmentImpl
implements W3Interface {
    private W3CommonDescription w3Header = null;
    private ArrayList<W3DataElement> compositionLines;
    private int[] COFIC = new int[]{1, 2};
    private int[] NUENR = new int[]{3, 2};
    private int[] FILLER_C = new int[]{5, 2};
    private int[] FILLER_B = new int[]{7, 5};
    private int[] VALST = new int[]{12, 10};
    private int[] COMOU = new int[]{22, 6};
    private int[] VALMO1 = new int[]{28, 5};
    private int[] VALMO2 = new int[]{33, 5};
    private int[] VALMO3 = new int[]{38, 5};
    private int[] VALMO4 = new int[]{43, 5};
    private int[] VALMO5 = new int[]{48, 5};
    private int[] VALMO6 = new int[]{53, 5};
    private int[] STECO1 = new int[]{58, 1};
    private int[] STECO2 = new int[]{59, 1};
    private int[] STECO3 = new int[]{60, 1};
    private int[] STECO4 = new int[]{61, 1};
    private int[] STECO5 = new int[]{62, 1};
    private int[] STECO6 = new int[]{63, 1};
    private int[] NBENR = new int[]{64, 4};
    private int[] NBOCC = new int[]{68, 9};
    private int[] BLANC = new int[]{77, 4};
    private int[] LIBSEG = new int[]{81, 36};
    static final String _QUOTE = new String("'");
    static final String _QUOTEDOUBLE = new String("\"");
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public W3SegmentLine(PacProgram aPgm, PacCDLineDataStructure aMds, PacSegmentCall aMr, int aLenOfRecord, boolean isWLF, PacWLineF pwlf, DataAggregate aDataAggregate) {
        this.w3Header = new W3CommonDescription(aPgm);
        this.init(aPgm, aMds, aMr, aLenOfRecord, isWLF, pwlf, aDataAggregate);
    }

    private void init(PacProgram aPgm, PacCDLineDataStructure aPcdlds, PacSegmentCall aPsc, int aLenOfRecord, boolean isWLF, PacWLineF pwlf, DataAggregate aDataAggregate) {
        this.w3Header.setB1_Value("F");
        this.w3Header.setB3A_Value("S");
        this.w3Header.setIED_Value("00");
        String cofic = "  ";
        if (isWLF && pwlf.getDataStructure() != null) {
            cofic = pwlf.getDataStructure().getName();
            this.w3Header.setB2_Value(cofic);
            this.w3Header.setB4_Value(cofic);
        }
        this.w3Header.setB6_Value(aPsc.getSegment().getName().substring(2));
        this.w3Header.setCOCA_Value("2");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setCOFIC(cofic);
        this.setNUENR(aPsc.getSegment().getName().substring(2));
        this.setFILLER_C(_BLANCS);
        this.setFILLER_B(_BLANCS);
        this.setVALST(_BLANCS);
        this.setCOMOU(_BLANCS);
        this.setVALMO1(_BLANCS);
        this.setVALMO2(_BLANCS);
        this.setVALMO3(_BLANCS);
        this.setVALMO4(_BLANCS);
        this.setVALMO5(_BLANCS);
        this.setVALMO6(_BLANCS);
        this.setSTECO1(_BLANCS);
        this.setSTECO2(_BLANCS);
        this.setSTECO3(_BLANCS);
        this.setSTECO4(_BLANCS);
        this.setSTECO5(_BLANCS);
        this.setSTECO6(_BLANCS);
        this.setNBENR("0000");
        this.setNBOCC("000000000");
        this.setBLANC(_BLANCS);
        this.setLIBSEG(aPsc.getSegment().getLabel());
        PacDataAggregate pacdag = null;
        Iterator extensionsDA = aDataAggregate.getExtensions().iterator();
        while (extensionsDA.hasNext()) {
            try {
                pacdag = (PacDataAggregate)extensionsDA.next();
            }
            catch (ClassCastException classCastException) {}
        }
        if (pacdag == null) {
            return;
        }
        if (!pacdag.getDataAggregateType().equals(PacDataAggregateTypeValues._G_LITERAL)) {
            if (pacdag.getAlias().substring(2).equals("00")) {
                this.setVALST(pacdag.getStructureCode());
            } else if (pacdag.getStructureCodeValue().length() > 0) {
                this.setVALST(pacdag.getStructureCodeValue());
            }
        } else {
            String tableNumber = pacdag.getTableAttributes().getTableNumber();
            Object tableNumber06 = tableNumber + "      ";
            tableNumber06 = ((String)tableNumber06).substring(0, 6);
            this.setVALST((String)tableNumber06);
        }
        this.setCOMOU(pacdag.getActionCode());
        if (pacdag.getAlias().substring(2).equals("00")) {
            this.setCOMOU(pacdag.getActionCode());
        } else if (pacdag.getActionCodeValue().length() > 0) {
            this.setCOMOU(pacdag.getActionCodeValue());
        }
        if (pacdag.getCreationCode().trim().length() > 0) {
            if (pacdag.getCreationCode().startsWith(_QUOTE) || pacdag.getCreationCode().startsWith(_QUOTEDOUBLE)) {
                this.setVALMO1(pacdag.getCreationCode());
            } else {
                this.setVALMO1("'".concat(pacdag.getCreationCode()).concat("'"));
            }
        }
        if (pacdag.getModificationCode().trim().length() > 0) {
            if (pacdag.getModificationCode().startsWith(_QUOTE) || pacdag.getModificationCode().startsWith(_QUOTEDOUBLE)) {
                this.setVALMO2(pacdag.getModificationCode());
            } else {
                this.setVALMO2("'".concat(pacdag.getModificationCode()).concat("'"));
            }
        }
        if (pacdag.getDeletionCode().trim().length() > 0) {
            if (pacdag.getDeletionCode().startsWith(_QUOTE) || pacdag.getDeletionCode().startsWith(_QUOTEDOUBLE)) {
                this.setVALMO3(pacdag.getDeletionCode());
            } else {
                this.setVALMO3("'".concat(pacdag.getDeletionCode()).concat("'"));
            }
        }
        if (pacdag.getInType4Code().trim().length() > 0) {
            if (pacdag.getInType4Code().startsWith(_QUOTE) || pacdag.getInType4Code().startsWith(_QUOTEDOUBLE)) {
                this.setVALMO4(pacdag.getInType4Code());
            } else {
                this.setVALMO4("'".concat(pacdag.getInType4Code()).concat("'"));
            }
        }
        if (pacdag.getInType5Code().trim().length() > 0) {
            if (pacdag.getInType5Code().startsWith(_QUOTE) || pacdag.getInType5Code().startsWith(_QUOTEDOUBLE)) {
                this.setVALMO5(pacdag.getInType5Code());
            } else {
                this.setVALMO5("'".concat(pacdag.getInType5Code()).concat("'"));
            }
        }
        if (pacdag.getInType6Code().trim().length() > 0) {
            if (pacdag.getInType6Code().startsWith(_QUOTE) || pacdag.getInType6Code().startsWith(_QUOTEDOUBLE)) {
                this.setVALMO6(pacdag.getInType6Code());
            } else {
                this.setVALMO6("'".concat(pacdag.getInType6Code()).concat("'"));
            }
        }
        if (pacdag.getTableSize() > 0) {
            String tableSizeValue = String.valueOf(pacdag.getTableSize());
            String str = "0000" + tableSizeValue;
            String tableSizeDigit = str.substring(str.length() - 4);
            this.setNBENR(String.valueOf(tableSizeDigit));
        }
        if (pacdag.getPresenceCheck() != null) {
            this.setSTECO1(pacdag.getPresenceCheck().getInCreation().getName().substring(1));
            this.setSTECO2(pacdag.getPresenceCheck().getInModification().getName().substring(1));
            this.setSTECO3(pacdag.getPresenceCheck().getInDeletion().getName().substring(1));
            this.setSTECO4(pacdag.getPresenceCheck().getInType4().getName().substring(1));
            this.setSTECO5(pacdag.getPresenceCheck().getInType5().getName().substring(1));
            this.setSTECO6(pacdag.getPresenceCheck().getInType6().getName().substring(1));
        }
    }

    private int getCOFICLength() {
        return this.COFIC[1];
    }

    private int getNUENRLength() {
        return this.NUENR[1];
    }

    private int getFILLER_CLength() {
        return this.FILLER_C[1];
    }

    private int getFILLER_BLength() {
        return this.FILLER_B[1];
    }

    private int getVALSTLength() {
        return this.VALST[1];
    }

    private int getCOMOULength() {
        return this.COMOU[1];
    }

    private int getVALMO1Length() {
        return this.VALMO1[1];
    }

    private int getVALMO2Length() {
        return this.VALMO2[1];
    }

    private int getVALMO3Length() {
        return this.VALMO3[1];
    }

    private int getVALMO4Length() {
        return this.VALMO4[1];
    }

    private int getVALMO5Length() {
        return this.VALMO5[1];
    }

    private int getVALMO6Length() {
        return this.VALMO6[1];
    }

    private int getSTECO1Length() {
        return this.STECO1[1];
    }

    private int getSTECO2Length() {
        return this.STECO2[1];
    }

    private int getSTECO3Length() {
        return this.STECO3[1];
    }

    private int getSTECO4Length() {
        return this.STECO4[1];
    }

    private int getSTECO5Length() {
        return this.STECO5[1];
    }

    private int getSTECO6Length() {
        return this.STECO6[1];
    }

    private int getNBENRLength() {
        return this.NBENR[1];
    }

    private int getNBOCCLength() {
        return this.NBOCC[1];
    }

    private int getBLANCLength() {
        return this.BLANC[1];
    }

    private int getLIBSEGLength() {
        return this.LIBSEG[1];
    }

    public void setCOFIC(String value) {
        super.setCOFIC((value + _BLANCS).substring(0, this.getCOFICLength()));
    }

    public void setNUENR(String value) {
        super.setNUENR((value + _BLANCS).substring(0, this.getNUENRLength()));
    }

    public void setFILLER_C(String value) {
        super.setFILLER_C((value + _BLANCS).substring(0, this.getFILLER_CLength()));
    }

    public void setFILLER_B(String value) {
        super.setFILLER_B((value + _BLANCS).substring(0, this.getFILLER_BLength()));
    }

    public void setVALST(String value) {
        super.setVALST((value + _BLANCS).substring(0, this.getVALSTLength()));
    }

    public void setCOMOU(String value) {
        super.setCOMOU((value + _BLANCS).substring(0, this.getCOMOULength()));
    }

    public void setVALMO1(String value) {
        super.setVALMO1((value + _BLANCS).substring(0, this.getVALMO1Length()));
    }

    public void setVALMO2(String value) {
        super.setVALMO2((value + _BLANCS).substring(0, this.getVALMO2Length()));
    }

    public void setVALMO3(String value) {
        super.setVALMO3((value + _BLANCS).substring(0, this.getVALMO3Length()));
    }

    public void setVALMO4(String value) {
        super.setVALMO4((value + _BLANCS).substring(0, this.getVALMO4Length()));
    }

    public void setVALMO5(String value) {
        super.setVALMO5((value + _BLANCS).substring(0, this.getVALMO5Length()));
    }

    public void setVALMO6(String value) {
        super.setVALMO6((value + _BLANCS).substring(0, this.getVALMO6Length()));
    }

    public void setSTECO1(String value) {
        super.setSTECO1((value + _BLANCS).substring(0, this.getSTECO1Length()));
    }

    public void setSTECO2(String value) {
        super.setSTECO2((value + _BLANCS).substring(0, this.getSTECO2Length()));
    }

    public void setSTECO3(String value) {
        super.setSTECO3((value + _BLANCS).substring(0, this.getSTECO3Length()));
    }

    public void setSTECO4(String value) {
        super.setSTECO4((value + _BLANCS).substring(0, this.getSTECO4Length()));
    }

    public void setSTECO5(String value) {
        super.setSTECO5((value + _BLANCS).substring(0, this.getSTECO5Length()));
    }

    public void setSTECO6(String value) {
        super.setSTECO6((value + _BLANCS).substring(0, this.getSTECO6Length()));
    }

    public void setNBENR(String value) {
        super.setNBENR((value + _BLANCS).substring(0, this.getNBENRLength()));
    }

    public void setNBOCC(String value) {
        super.setNBOCC((value + _BLANCS).substring(0, this.getNBOCCLength()));
    }

    public void setBLANC(String value) {
        super.setBLANC((value + _BLANCS).substring(0, this.getBLANCLength()));
    }

    public void setLIBSEG(String value) {
        super.setLIBSEG((value + _BLANCS).substring(0, this.getLIBSEGLength()));
    }

    public W3CommonDescription getW3Header() {
        return this.w3Header;
    }

    public ArrayList<W3DataElement> getCompositionLines() {
        return this.compositionLines;
    }

    public void setCompositionLines(ArrayList<W3DataElement> compositionLines) {
        this.compositionLines = compositionLines;
    }
}

