/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacReport;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3ReportImpl;

public class W3ReportLine
extends W3ReportImpl
implements W3Interface {
    private W3CommonDescription w3Header = null;
    private PacProgram programToGenerate;
    private PacReport report;
    private int[] COFIC = new int[]{1, 2};
    private int[] COETA = new int[]{3, 1};
    private int[] LIETA = new int[]{4, 30};
    private int[] ETCOM = new int[]{34, 36};
    private int[] NATEC = new int[]{70, 1};
    private int[] TYETA = new int[]{71, 1};
    private int[] LOLIB = new int[]{72, 3};
    private int[] NBCAV = new int[]{75, 2};
    private int[] NBCAP = new int[]{77, 2};
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public W3ReportLine(PacProgram pgm, PacReport rep) {
        this.programToGenerate = pgm;
        this.report = rep;
        this.w3Header = new W3CommonDescription(pgm);
        this.initToSpace();
        this.init();
    }

    private void init() {
        this.w3Header.setB1_Value("H");
        this.w3Header.setB2_Value(this.report.getName());
        this.w3Header.setB3A_Value("B");
        this.w3Header.setCOCA_Value("B");
        this.w3Header.setIED_Value("00");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setCOFIC(this.report.getName().substring(0, 2));
        this.setCOETA(this.report.getName().substring(2));
        this.setLIETA(this.report.getLabel());
        this.setNATEC(String.valueOf(this.report.getReportNature()).substring(1));
        this.setTYETA(String.valueOf(this.report.getReportType()).substring(1));
        String nbCaracValue = String.valueOf(this.report.getLabelLength());
        String str = "000" + nbCaracValue;
        String nbCaracDigit = str.substring(str.length() - 3);
        this.setLOLIB(String.valueOf(nbCaracDigit));
        String nbcavValue = String.valueOf(this.report.getIntegerPartLength());
        String nbcav = "00" + nbcavValue;
        String nbcavDigit = nbcav.substring(nbcav.length() - 2);
        this.setNBCAV(String.valueOf(nbcavDigit));
        String nbcapValue = String.valueOf(this.report.getDecimalPartLength());
        String nbcap = "00" + nbcapValue;
        String nbcapDigit = nbcap.substring(nbcap.length() - 2);
        this.setNBCAP(String.valueOf(nbcapDigit));
    }

    private void initToSpace() {
        this.setCOFIC(_BLANCS);
        this.setCOETA(_BLANCS);
        this.setLIETA(_BLANCS);
        this.setETCOM(_BLANCS);
        this.setNATEC(_BLANCS);
        this.setTYETA(_BLANCS);
        this.setLOLIB(_BLANCS);
        this.setNBCAV(_BLANCS);
        this.setNBCAP(_BLANCS);
    }

    private int getCOFICLength() {
        return this.COFIC[1];
    }

    private int getCOETALength() {
        return this.COETA[1];
    }

    private int getLIETALength() {
        return this.LIETA[1];
    }

    private int getETCOMLength() {
        return this.ETCOM[1];
    }

    private int getNATECLength() {
        return this.NATEC[1];
    }

    private int getTYETALength() {
        return this.TYETA[1];
    }

    private int getLOLIBLength() {
        return this.LOLIB[1];
    }

    private int getNBCAVLength() {
        return this.NBCAV[1];
    }

    private int getNBCAPLength() {
        return this.NBCAP[1];
    }

    public void setCOFIC(String value) {
        super.setCOFIC((value + _BLANCS).substring(0, this.getCOFICLength()));
    }

    public void setCOETA(String value) {
        super.setCOETA((value + _BLANCS).substring(0, this.getCOETALength()));
    }

    public void setLIETA(String value) {
        super.setLIETA((value + _BLANCS).substring(0, this.getLIETALength()));
    }

    public void setETCOM(String value) {
        super.setETCOM((value + _BLANCS).substring(0, this.getETCOMLength()));
    }

    public void setNATEC(String value) {
        super.setNATEC((value + _BLANCS).substring(0, this.getNATECLength()));
    }

    public void setTYETA(String value) {
        super.setTYETA((value + _BLANCS).substring(0, this.getTYETALength()));
    }

    public void setLOLIB(String value) {
        super.setLOLIB((value + _BLANCS).substring(0, this.getLOLIBLength()));
    }

    public void setNBCAV(String value) {
        super.setNBCAV((value + _BLANCS).substring(0, this.getNBCAVLength()));
    }

    public void setNBCAP(String value) {
        super.setNBCAP((value + _BLANCS).substring(0, this.getNBCAPLength()));
    }

    public W3CommonDescription getW3Header() {
        return this.w3Header;
    }
}

