/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.pdp.mdl.pacbase.PacLabel;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacReport;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3ReportLayoutImpl;

public class W3ReportLayoutLine
extends W3ReportLayoutImpl
implements W3Interface {
    private W3CommonDescription w3Header = null;
    private PacProgram programToGenerate;
    private PacReport currentReport;
    private PacLabel currentLabel;
    private int[] COFIC = new int[]{1, 2};
    private int[] COETA = new int[]{3, 1};
    private int[] NULIB = new int[]{4, 2};
    private int[] NULI4 = new int[]{6, 2};
    private int[] SAVED9 = new int[]{8, 1};
    private int[] NUPOL = new int[]{9, 1};
    private int[] LOLIB = new int[]{10, 3};
    private int[] LIBELL = new int[]{13, 66};
    private int[] FILLER = new int[]{79, 38};
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public W3ReportLayoutLine(PacProgram pgm, PacReport rep, PacLabel reportLabel) {
        this.programToGenerate = pgm;
        this.currentReport = rep;
        this.currentLabel = reportLabel;
        this.w3Header = new W3CommonDescription(pgm);
        this.initToSpace();
        this.init();
    }

    private void init() {
        this.w3Header.setB1_Value("H");
        this.w3Header.setB2_Value(this.currentReport.getName());
        this.w3Header.setB3A_Value("L");
        this.w3Header.setB4_Value(this.currentReport.getName().substring(0, 2));
        this.w3Header.setB5_Value(this.currentReport.getName().substring(2));
        this.w3Header.setCOCA_Value("4");
        this.w3Header.setIED_Value("00");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setCOFIC(String.valueOf(this.currentReport.getName().substring(0, 2)));
        this.setCOETA(this.currentReport.getName().substring(2));
        this.setNULIB(String.valueOf(this.currentLabel.getLabelID()));
        String jumpType = String.valueOf(this.currentLabel.getJumpType());
        this.setSAVED9("1");
        if (jumpType.equals("_STAR")) {
            this.setSAVED9("*");
        } else {
            this.setSAVED9(jumpType.substring(1, 2));
        }
        this.setNUPOL(String.valueOf(this.currentLabel.getFontCode()));
        this.setLOLIB("000");
    }

    private void initToSpace() {
        this.setCOFIC(_BLANCS);
        this.setCOETA(_BLANCS);
        this.setNULIB(_BLANCS);
        this.setNULI4(_BLANCS);
        this.setSAVED9(_BLANCS);
        this.setNUPOL(_BLANCS);
        this.setLOLIB(_BLANCS);
        this.setLIBELL(_BLANCS);
        this.setFILLER(_260BLANCS);
    }

    private int getCOFICLength() {
        return this.COFIC[1];
    }

    private int getCOETALength() {
        return this.COETA[1];
    }

    private int getNULIBLength() {
        return this.NULIB[1];
    }

    private int getNULI4Length() {
        return this.NULI4[1];
    }

    private int getSAVED9Length() {
        return this.SAVED9[1];
    }

    private int getNUPOLLength() {
        return this.NUPOL[1];
    }

    private int getLOLIBLength() {
        return this.LOLIB[1];
    }

    private int getLIBELLLength() {
        return this.LIBELL[1];
    }

    private int getFILLERLength() {
        return this.FILLER[1];
    }

    public void setCOFIC(String value) {
        super.setCOFIC((value + _BLANCS).substring(0, this.getCOFICLength()));
    }

    public void setCOETA(String value) {
        super.setCOETA((value + _BLANCS).substring(0, this.getCOETALength()));
    }

    public void setNULIB(String value) {
        String str = "00" + value;
        super.setNULIB(str.substring(str.length() - this.getNULIBLength()));
    }

    public void setNULI4(String value) {
        String str = "00" + value;
        super.setNULI4(str.substring(str.length() - this.getNULI4Length()));
    }

    public void setSAVED9(String value) {
        super.setSAVED9((value + _BLANCS).substring(0, this.getSAVED9Length()));
    }

    public void setNUPOL(String value) {
        super.setNUPOL((value + _BLANCS).substring(0, this.getNUPOLLength()));
    }

    public void setLOLIB(String value) {
        super.setLOLIB((value + _BLANCS).substring(0, this.getLOLIBLength()));
    }

    public void setLIBELL(String value) {
        super.setLIBELL((value + _260BLANCS).substring(0, this.getLIBELLLength()));
    }

    public void setFILLER(String value) {
        super.setFILLER((value + _260BLANCS).substring(0, this.getFILLERLength()));
    }

    public W3CommonDescription getW3Header() {
        return this.w3Header;
    }
}

