/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacReport;
import com.ibm.pdp.mdl.pacbase.PacTarget;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3ReportElementCallImpl;

public class W3ReportElementCall
extends W3ReportElementCallImpl
implements W3Interface {
    private W3CommonDescription w3Header = null;
    private PacProgram programToGenerate;
    private PacReport currentReport;
    private PacTarget currentTarget;
    private int[] COFIC = new int[]{1, 2};
    private int[] COETA = new int[]{3, 1};
    private int[] STRUC = new int[]{4, 2};
    private int[] DEBRU = new int[]{6, 3};
    private int[] NULRU = new int[]{9, 1};
    private int[] CORUB = new int[]{10, 6};
    private int[] LORUBS = new int[]{16, 3};
    private int[] PICTUS = new int[]{19, 14};
    private int[] OPERA = new int[]{33, 1};
    private int[] RUSOUW = new int[]{34, 1};
    private int[] RUSOUF = new int[]{35, 2};
    private int[] RUSOUE = new int[]{37, 2};
    private int[] RUSOUR = new int[]{39, 6};
    private int[] RUSOUI = new int[]{45, 3};
    private int[] CONDIE = new int[]{48, 32};
    private int[] PICTUC = new int[]{80, 13};
    private int[] LIRUB = new int[]{93, 18};
    private int[] FILLER = new int[]{111, 3};
    private int[] NBCRU = new int[]{114, 1};
    private int[] SUPIC = new int[]{115, 1};
    private int[] SUCON = new int[]{116, 1};
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public W3ReportElementCall(PacProgram pgm, PacReport rep, PacTarget structureEditionLine) {
        this.programToGenerate = pgm;
        this.currentReport = rep;
        this.currentTarget = structureEditionLine;
        this.w3Header = new W3CommonDescription(pgm);
        this.initToSpace();
        this.init();
    }

    private void init() {
        this.w3Header.setB1_Value("H");
        this.w3Header.setB2_Value(this.currentReport.getName());
        this.w3Header.setB3A_Value("S");
        this.w3Header.setB4_Value(this.currentReport.getName().substring(0, 2));
        this.w3Header.setB5_Value(this.currentReport.getName().substring(2));
        this.w3Header.setB9AB_Value("0 ");
        this.w3Header.setCOCA_Value("6");
        this.w3Header.setIED_Value("00");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setCOFIC(String.valueOf(this.currentReport.getName().substring(0, 2)));
        this.setCOETA(this.currentReport.getName().substring(2));
        this.setNULRU("0");
    }

    private void initToSpace() {
        this.setCOFIC(_BLANCS);
        this.setCOETA(_BLANCS);
        this.setSTRUC(_BLANCS);
        this.setDEBRU(_BLANCS);
        this.setNULRU(_BLANCS);
        this.setCORUB(_BLANCS);
        this.setLORUBS(_BLANCS);
        this.setPICTUS(_BLANCS);
        this.setOPERA(_BLANCS);
        this.setRUSOUW(_BLANCS);
        this.setRUSOUF(_BLANCS);
        this.setRUSOUE(_BLANCS);
        this.setRUSOUR(_BLANCS);
        this.setRUSOUI(_BLANCS);
        this.setCONDIE(_BLANCS);
        this.setPICTUC(_BLANCS);
        this.setLIRUB(_BLANCS);
        this.setFILLER(_BLANCS);
        this.setNBCRU(_BLANCS);
        this.setSUPIC(_BLANCS);
        this.setSUCON(_BLANCS);
    }

    private int getCOFICLength() {
        return this.COFIC[1];
    }

    private int getCOETALength() {
        return this.COETA[1];
    }

    private int getSTRUCLength() {
        return this.STRUC[1];
    }

    private int getDEBRULength() {
        return this.DEBRU[1];
    }

    private int getNULRULength() {
        return this.NULRU[1];
    }

    private int getCORUBLength() {
        return this.CORUB[1];
    }

    private int getLORUBSLength() {
        return this.LORUBS[1];
    }

    private int getPICTUSLength() {
        return this.PICTUS[1];
    }

    private int getOPERALength() {
        return this.OPERA[1];
    }

    private int getRUSOUWLength() {
        return this.RUSOUW[1];
    }

    private int getRUSOUFLength() {
        return this.RUSOUF[1];
    }

    private int getRUSOUELength() {
        return this.RUSOUE[1];
    }

    private int getRUSOURLength() {
        return this.RUSOUR[1];
    }

    private int getRUSOUILength() {
        return this.RUSOUI[1];
    }

    private int getCONDIELength() {
        return this.CONDIE[1];
    }

    private int getPICTUCLength() {
        return this.PICTUC[1];
    }

    private int getLIRUBLength() {
        return this.LIRUB[1];
    }

    private int getFILLERLength() {
        return this.FILLER[1];
    }

    private int getNBCRULength() {
        return this.NBCRU[1];
    }

    private int getSUPICLength() {
        return this.SUPIC[1];
    }

    private int getSUCONLength() {
        return this.SUCON[1];
    }

    public void setCOFIC(String value) {
        super.setCOFIC((value + _BLANCS).substring(0, this.getCOFICLength()));
    }

    public void setCOETA(String value) {
        super.setCOETA((value + _BLANCS).substring(0, this.getCOETALength()));
    }

    public void setSTRUC(String value) {
        super.setSTRUC((value + _BLANCS).substring(0, this.getSTRUCLength()));
    }

    public void setDEBRU(String value) {
        super.setDEBRU((value + _BLANCS).substring(0, this.getDEBRULength()));
    }

    public void setNULRU(String value) {
        super.setNULRU((value + _BLANCS).substring(0, this.getNULRULength()));
    }

    public void setCORUB(String value) {
        super.setCORUB((value + _BLANCS).substring(0, this.getCORUBLength()));
    }

    public void setLORUBS(String value) {
        super.setLORUBS((value + _BLANCS).substring(0, this.getLORUBSLength()));
    }

    public void setPICTUS(String value) {
        super.setPICTUS((value + _BLANCS).substring(0, this.getPICTUSLength()));
    }

    public void setOPERA(String value) {
        super.setOPERA((value + _BLANCS).substring(0, this.getOPERALength()));
    }

    public void setRUSOUW(String value) {
        super.setRUSOUW((value + _BLANCS).substring(0, this.getRUSOUWLength()));
    }

    public void setRUSOUF(String value) {
        super.setRUSOUF((value + _BLANCS).substring(0, this.getRUSOUFLength()));
    }

    public void setRUSOUE(String value) {
        super.setRUSOUE((value + _BLANCS).substring(0, this.getRUSOUELength()));
    }

    public void setRUSOUR(String value) {
        super.setRUSOUR((value + _BLANCS).substring(0, this.getRUSOURLength()));
    }

    public void setRUSOUI(String value) {
        super.setRUSOUI((value + _BLANCS).substring(0, this.getRUSOUILength()));
    }

    public void setCONDIE(String value) {
        super.setCONDIE((value + _BLANCS).substring(0, this.getCONDIELength()));
    }

    public void setPICTUC(String value) {
        super.setPICTUC((value + _BLANCS).substring(0, this.getPICTUCLength()));
    }

    public void setLIRUB(String value) {
        super.setLIRUB((value + _BLANCS).substring(0, this.getLIRUBLength()));
    }

    public void setFILLER(String value) {
        super.setFILLER((value + _BLANCS).substring(0, this.getFILLERLength()));
    }

    public void setNBCRU(String value) {
        super.setNBCRU((value + _BLANCS).substring(0, this.getNBCRULength()));
    }

    public void setSUPIC(String value) {
        super.setSUPIC((value + _BLANCS).substring(0, this.getSUPICLength()));
    }

    public void setSUCON(String value) {
        super.setSUCON((value + _BLANCS).substring(0, this.getSUCONLength()));
    }

    public W3CommonDescription getW3Header() {
        return this.w3Header;
    }
}

