/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.pdp.mdl.pacbase.PacCategory;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacReport;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3ReportDescriptionImpl;

public class W3ReportDescriptionLine
extends W3ReportDescriptionImpl
implements W3Interface {
    private W3CommonDescription w3Header = null;
    private PacProgram programToGenerate;
    private PacReport currentReport;
    private PacCategory currentCategory;
    private int[] COFIC = new int[]{1, 2};
    private int[] COETA = new int[]{3, 1};
    private int[] BLANC1 = new int[]{4, 2};
    private int[] NULIG = new int[]{6, 3};
    private int[] CATEG = new int[]{9, 2};
    private int[] BLANC2 = new int[]{11, 1};
    private int[] TYCAT = new int[]{12, 1};
    private int[] CARAC = new int[]{13, 3};
    private int[] STRUC = new int[]{16, 2};
    private int[] NLIB5 = new int[]{18, 2};
    private int[] SAUT = new int[]{20, 2};
    private int[] TYSAU = new int[]{22, 1};
    private int[] LIMAX = new int[]{23, 2};
    private int[] PERFF = new int[]{25, 2};
    private int[] PERFS = new int[]{27, 2};
    private int[] SECTI = new int[]{29, 2};
    private int[] BLANC3 = new int[]{31, 13};
    private int[] CONDI = new int[]{35, 44};
    private int[] FILLER = new int[]{79, 38};
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public W3ReportDescriptionLine(PacProgram pgm, PacReport rep) {
        this.programToGenerate = pgm;
        this.currentReport = rep;
        this.w3Header = new W3CommonDescription(pgm);
        this.initToSpace();
        this.init1();
    }

    public W3ReportDescriptionLine(PacProgram pgm, PacReport rep, PacCategory reportCategory) {
        this.programToGenerate = pgm;
        this.currentReport = rep;
        this.currentCategory = reportCategory;
        this.w3Header = new W3CommonDescription(pgm);
        this.initToSpace();
        this.initN();
    }

    private void init1() {
        this.w3Header.setB1_Value("H");
        this.w3Header.setB2_Value(this.currentReport.getName());
        this.w3Header.setB3A_Value("P");
        this.w3Header.setB4_Value(this.currentReport.getName().substring(0, 2));
        this.w3Header.setB5_Value(this.currentReport.getName().substring(2));
        this.w3Header.setB7_Value("000");
        this.w3Header.setCOCA_Value("5");
        this.w3Header.setIED_Value("00");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setCOFIC(String.valueOf(this.currentReport.getName().substring(0, 2)));
        this.setCOETA(this.currentReport.getName().substring(2));
        this.setNULIG("000");
        this.setTYCAT("E");
        String nbCaracValue = String.valueOf(this.currentReport.getLineLength());
        String str = "000" + nbCaracValue;
        String nbCaracDigit = str.substring(str.length() - 3);
        this.setCARAC(String.valueOf(nbCaracDigit));
        this.setSTRUC("00");
        this.setNLIB5("00");
        this.setSAUT("00");
        String option = String.valueOf(this.currentReport.getWriteOption());
        this.setTYSAU(" ");
        if (option.equals("_STAR")) {
            this.setTYSAU("*");
        } else if (option.equals("_None")) {
            this.setTYSAU(" ");
        }
        this.setLIMAX(String.valueOf(this.currentReport.getLinesPerPage()));
        String tableSize = this.currentReport.getTableSize();
        if (this.currentReport.getTableSize().trim().length() == 0) {
            tableSize = "    ";
        }
        this.setPERFF(tableSize.substring(0, 2));
        this.setPERFS(tableSize.substring(2));
        String sectiStr = String.valueOf(this.currentReport.getSectionPriority());
        String sectiSize = "00" + sectiStr;
        this.setSECTI(sectiSize.substring(sectiSize.length() - 2));
        this.setBLANC3(this.currentReport.getEditionComment());
    }

    private void initN() {
        this.w3Header.setB1_Value("H");
        this.w3Header.setB2_Value(this.currentReport.getName());
        this.w3Header.setB3A_Value("P");
        this.w3Header.setB4_Value(this.currentReport.getName().substring(0, 2));
        this.w3Header.setB5_Value(this.currentReport.getName().substring(2));
        this.w3Header.setB6_Value(this.currentCategory.getCategoryID());
        this.w3Header.setCOCA_Value("5");
        this.w3Header.setIED_Value("00");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setCOFIC(String.valueOf(this.currentReport.getName().substring(0, 2)));
        this.setCOETA(this.currentReport.getName().substring(2));
        this.setCATEG(this.currentCategory.getCategoryID());
        this.setLIMAX("00");
        this.setSECTI("00");
    }

    private void initToSpace() {
        this.setCOFIC(_BLANCS);
        this.setCOETA(_BLANCS);
        this.setBLANC1(_BLANCS);
        this.setNULIG(_BLANCS);
        this.setCATEG(_BLANCS);
        this.setBLANC2(_BLANCS);
        this.setTYCAT(_BLANCS);
        this.setCARAC(_BLANCS);
        this.setSTRUC(_BLANCS);
        this.setNLIB5(_BLANCS);
        this.setSAUT(_BLANCS);
        this.setTYSAU(_BLANCS);
        this.setLIMAX(_BLANCS);
        this.setPERFF(_BLANCS);
        this.setPERFS(_BLANCS);
        this.setSECTI(_BLANCS);
        this.setBLANC3(_BLANCS);
        this.setCONDI(_BLANCS);
        this.setFILLER(_BLANCS);
    }

    private int getCOFICLength() {
        return this.COFIC[1];
    }

    private int getCOETALength() {
        return this.COETA[1];
    }

    private int getBLANC1Length() {
        return this.BLANC1[1];
    }

    private int getNULIGLength() {
        return this.NULIG[1];
    }

    private int getCATEGLength() {
        return this.CATEG[1];
    }

    private int getBLANC2Length() {
        return this.BLANC2[1];
    }

    private int getTYCATLength() {
        return this.TYCAT[1];
    }

    private int getCARACLength() {
        return this.CARAC[1];
    }

    private int getSTRUCLength() {
        return this.STRUC[1];
    }

    private int getNLIB5Length() {
        return this.NLIB5[1];
    }

    private int getSAUTLength() {
        return this.SAUT[1];
    }

    private int getTYSAULength() {
        return this.TYSAU[1];
    }

    private int getLIMAXLength() {
        return this.LIMAX[1];
    }

    private int getPERFFLength() {
        return this.PERFF[1];
    }

    private int getPERFSLength() {
        return this.PERFS[1];
    }

    private int getSECTILength() {
        return this.SECTI[1];
    }

    private int getBLANC3Length() {
        return this.BLANC3[1];
    }

    private int getCONDILength() {
        return this.CONDI[1];
    }

    private int getFILLERLength() {
        return this.FILLER[1];
    }

    public void setCOFIC(String value) {
        super.setCOFIC((value + _BLANCS).substring(0, this.getCOFICLength()));
    }

    public void setCOETA(String value) {
        super.setCOETA((value + _BLANCS).substring(0, this.getCOETALength()));
    }

    public void setBLANC1(String value) {
        super.setBLANC1((value + _BLANCS).substring(0, this.getBLANC1Length()));
    }

    public void setNULIG(String value) {
        super.setNULIG((value + _BLANCS).substring(0, this.getNULIGLength()));
    }

    public void setCATEG(String value) {
        super.setCATEG((value + _BLANCS).substring(0, this.getCATEGLength()));
    }

    public void setBLANC2(String value) {
        super.setBLANC2((value + _BLANCS).substring(0, this.getBLANC2Length()));
    }

    public void setTYCAT(String value) {
        super.setTYCAT((value + _BLANCS).substring(0, this.getTYCATLength()));
    }

    public void setCARAC(String value) {
        super.setCARAC((value + _BLANCS).substring(0, this.getCARACLength()));
    }

    public void setSTRUC(String value) {
        String str = "00" + value;
        super.setSTRUC(str.substring(str.length() - this.getSTRUCLength()));
    }

    public void setNLIB5(String value) {
        String str = "00" + value;
        super.setNLIB5(str.substring(str.length() - this.getNLIB5Length()));
    }

    public void setSAUT(String value) {
        String str = "00" + value;
        super.setSAUT(str.substring(str.length() - this.getSAUTLength()));
    }

    public void setTYSAU(String value) {
        super.setTYSAU((value + _BLANCS).substring(0, this.getTYSAULength()));
    }

    public void setLIMAX(String value) {
        super.setLIMAX((value + _BLANCS).substring(0, this.getLIMAXLength()));
    }

    public void setPERFF(String value) {
        super.setPERFF((value + _BLANCS).substring(0, this.getPERFFLength()));
    }

    public void setPERFS(String value) {
        super.setPERFS((value + _BLANCS).substring(0, this.getPERFSLength()));
    }

    public void setSECTI(String value) {
        super.setSECTI((value + _BLANCS).substring(0, this.getSECTILength()));
    }

    public void setBLANC3(String value) {
        super.setBLANC3((value + _BLANCS).substring(0, this.getBLANC3Length()));
    }

    public void setCONDI(String value) {
        super.setCONDI((value + _BLANCS).substring(0, this.getCONDILength()));
    }

    public void setFILLER(String value) {
        super.setFILLER((value + _BLANCS).substring(0, this.getFILLERLength()));
    }

    public W3CommonDescription getW3Header() {
        return this.w3Header;
    }
}

