/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.pdp.mdl.pacbase.PacCDLineDataStructure;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacInputAidGLine;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.mdl.pacbase.PacWLineF;
import com.ibm.pdp.mdl.pacbase.util.PacInputAidCompletedDetailManager;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3ProgramImpl;
import java.util.List;

public class W3ProgramLine
extends W3ProgramImpl
implements W3Interface {
    private W3CommonDescription w3Header = null;
    private int[] _BLANC1 = new int[]{1, 4};
    private int[] _PROGR = new int[]{5, 6};
    private int[] _NOMEN = new int[]{11, 6};
    private int[] _AUTEU = new int[]{17, 30};
    private int[] _VARIA = new int[]{47, 1};
    private int[] _CATAL = new int[]{48, 1};
    private int[] _CONTI = new int[]{49, 1};
    private int[] _FILLER_A = new int[]{50, 1};
    private int[] _XSQLRE = new int[]{51, 1};
    private int[] _OPAVP = new int[]{52, 1};
    private int[] _OPAPR = new int[]{53, 1};
    private int[] _CPCOB = new int[]{54, 8};
    private int[] _TYPRO = new int[]{62, 1};
    private int[] _NAPRO = new int[]{63, 1};
    private int[] _TYPRE = new int[]{64, 1};
    private int[] _SESSIG = new int[]{65, 5};
    private int[] _NATEC = new int[]{70, 1};
    private int[] _SYFPR = new int[]{71, 1};
    private int[] _COUMAX = new int[]{72, 1};
    private int[] _SYMIN = new int[]{73, 1};
    private int[] _OPTET = new int[]{74, 1};
    private int[] _OPQUE = new int[]{75, 1};
    private int[] _BLANC = new int[]{76, 8};
    private int[] _SESSID = new int[]{84, 5};
    private int[] _FILLER_B = new int[]{89, 1};
    private int[] _NUVERG = new int[]{90, 3};
    private int[] _COFIM = new int[]{93, 20};
    private int[] _NBGEN = new int[]{113, 3};
    private int[] _ETPRO = new int[]{116, 1};
    protected PacProgram programToGenerate;
    private PacProgramVariantValues variant;
    StringBuffer permanentFiles = new StringBuffer();
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2018.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public W3ProgramLine(PacProgram aProg) {
        this.variant = aProg.getVariante();
        this.programToGenerate = aProg;
        this.w3Header = new W3CommonDescription(aProg);
        this.init();
    }

    private void init() {
        this.w3Header.setB3A_Value("B");
        this.w3Header.setCOCA_Value("0");
        this.w3Header.setIED_Value("03");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setBLANC1("");
        this.setPROGR(this.programToGenerate.getName());
        this.setNOMEN(this.programToGenerate.getName());
        this.setAUTEU(this.programToGenerate.getLabel());
        this.setVARIA(this.variant.getName().substring(1));
        this.setCATAL("");
        this.setCONTI(_BLANCS);
        this.setXSQLRE(_BLANCS);
        if (this.programToGenerate.isSQLIndicator()) {
            this.setXSQLRE("-");
        }
        this.setOPAVP(_BLANCS);
        this.setOPAPR(_BLANCS);
        this.setCPCOB(this.programToGenerate.getProgramID());
        this.setTYPRO("P");
        this.setNAPRO(this.programToGenerate.getProgramStructure().getLiteral().substring(1));
        if (String.valueOf(this.programToGenerate.getPresenceValidation()).equals("_None")) {
            this.setTYPRE(_BLANCS);
        } else {
            this.setTYPRE(this.programToGenerate.getPresenceValidation().toString().substring(1, 2));
        }
        this.setSESSIG("9999Z");
        this.setNATEC("P");
        for (Object objGO : this.programToGenerate.getGOLines()) {
            String descOfGOLine;
            if (objGO instanceof PacInputAidGLine) {
                List ls = new PacInputAidCompletedDetailManager().getAsGLineList((PacInputAidGLine)objGO, false);
                for (PacInputAidCompletedDetailManager.AsGLine iagl : ls) {
                    String descOfGOLine2 = iagl.getDescription();
                    String desc = descOfGOLine2.trim();
                    if (desc.length() > 20) {
                        String fixedLabel = W3ProgramLine.trimRight(descOfGOLine2.substring(0, 20));
                        String variableLabel = W3ProgramLine.trimRight(descOfGOLine2.substring(20));
                        desc = fixedLabel.concat(variableLabel);
                    }
                    if (!desc.equals("SUBPRO=YES")) continue;
                    this.setNATEC("D");
                }
                continue;
            }
            if (!(objGO instanceof PacGLine) || !(descOfGOLine = ((PacGLine)objGO).getDescription()).trim().equals("SUBPRO=YES")) continue;
            this.setNATEC("D");
        }
        this.setOPTET(_BLANCS);
        this.setOPQUE(_BLANCS);
        this.setBLANC(_BLANCS);
        this.setSESSID("0001Z");
        this.setNUVERG(_BLANCS);
        this.setCOFIM(_BLANCS);
        this.setNBGEN("000");
        this.setETPRO("S");
        this.setMainFileSynchronisation();
        this.setFILLER_B(_BLANCS);
        this.setFILLER_A(_BLANCS);
    }

    private int getBLANC1Length() {
        return this._BLANC1[1];
    }

    private int getPROGRLength() {
        return this._PROGR[1];
    }

    private int getNOMENLength() {
        return this._NOMEN[1];
    }

    private int getAUTEULength() {
        return this._AUTEU[1];
    }

    private int getVARIALength() {
        return this._VARIA[1];
    }

    private int getCATALLength() {
        return this._CATAL[1];
    }

    private int getCONTILength() {
        return this._CONTI[1];
    }

    private int getFILLER_ALength() {
        return this._FILLER_A[1];
    }

    private int getXSQLRELength() {
        return this._XSQLRE[1];
    }

    private int getOPAVPLength() {
        return this._OPAVP[1];
    }

    private int getOPAPRLength() {
        return this._OPAPR[1];
    }

    private int getCPCOBLength() {
        return this._CPCOB[1];
    }

    private int getTYPROLength() {
        return this._TYPRO[1];
    }

    private int getNAPROLength() {
        return this._NAPRO[1];
    }

    private int getTYPRELength() {
        return this._TYPRE[1];
    }

    private int getSESSIGLength() {
        return this._SESSIG[1];
    }

    private int getNATECLength() {
        return this._NATEC[1];
    }

    private int getSYFPRLength() {
        return this._SYFPR[1];
    }

    private int getCOUMAXLength() {
        return this._COUMAX[1];
    }

    private int getSYMINLength() {
        return this._SYMIN[1];
    }

    private int getOPTETLength() {
        return this._OPTET[1];
    }

    private int getOPQUELength() {
        return this._OPQUE[1];
    }

    private int getBLANCLength() {
        return this._BLANC[1];
    }

    private int getSESSIDLength() {
        return this._SESSID[1];
    }

    private int getFILLER_BLength() {
        return this._FILLER_B[1];
    }

    private int getNUVERGLength() {
        return this._NUVERG[1];
    }

    private int getCOFIMLength() {
        return this._COFIM[1];
    }

    private int getNBGENLength() {
        return this._NBGEN[1];
    }

    private int getETPROLength() {
        return this._ETPRO[1];
    }

    public StringBuffer getPermanentFiles() {
        return new StringBuffer(this.permanentFiles);
    }

    public void setBLANC1(String value) {
        super.setBLANC1((value + _BLANCS).substring(0, this.getBLANC1Length()));
    }

    public void setPROGR(String value) {
        super.setPROGR((value + _BLANCS).substring(0, this.getPROGRLength()));
    }

    public void setNOMEN(String value) {
        super.setNOMEN((value + _BLANCS).substring(0, this.getNOMENLength()));
    }

    public void setAUTEU(String value) {
        super.setAUTEU((value + _BLANCS).substring(0, this.getAUTEULength()));
    }

    public void setVARIA(String value) {
        super.setVARIA((value + _BLANCS).substring(0, this.getVARIALength()));
    }

    public void setCATAL(String value) {
        super.setCATAL((value + _BLANCS).substring(0, this.getCATALLength()));
    }

    public void setCONTI(String value) {
        super.setCONTI((value + _BLANCS).substring(0, this.getCONTILength()));
    }

    public void setFILLER_A(String value) {
        super.setFILLER_A((value + _BLANCS).substring(0, this.getFILLER_ALength()));
    }

    public void setXSQLRE(String value) {
        super.setXSQLRE((value + _BLANCS).substring(0, this.getXSQLRELength()));
    }

    public void setOPAVP(String value) {
        super.setOPAVP((value + _BLANCS).substring(0, this.getOPAVPLength()));
    }

    public void setOPAPR(String value) {
        super.setOPAPR((value + _BLANCS).substring(0, this.getOPAPRLength()));
    }

    public void setCPCOB(String value) {
        super.setCPCOB((value + _BLANCS).substring(0, this.getCPCOBLength()));
    }

    public void setTYPRO(String value) {
        super.setTYPRO((value + _BLANCS).substring(0, this.getTYPROLength()));
    }

    public void setNAPRO(String value) {
        super.setNAPRO((value + _BLANCS).substring(0, this.getNAPROLength()));
    }

    public void setTYPRE(String value) {
        super.setTYPRE((value + _BLANCS).substring(0, this.getTYPRELength()));
    }

    public void setSESSIG(String value) {
        super.setSESSIG((value + _BLANCS).substring(0, this.getSESSIGLength()));
    }

    public void setNATEC(String value) {
        super.setNATEC((value + _BLANCS).substring(0, this.getNATECLength()));
    }

    public void setSYFPR(String value) {
        super.setSYFPR((value + _BLANCS).substring(0, this.getSYFPRLength()));
    }

    public void setCOUMAX(String value) {
        super.setCOUMAX((value + _BLANCS).substring(0, this.getCOUMAXLength()));
    }

    public void setSYMIN(String value) {
        super.setSYMIN((value + _BLANCS).substring(0, this.getSYMINLength()));
    }

    public void setOPTET(String value) {
        super.setOPTET((value + _BLANCS).substring(0, this.getOPTETLength()));
    }

    public void setOPQUE(String value) {
        super.setOPQUE((value + _BLANCS).substring(0, this.getOPQUELength()));
    }

    public void setBLANC(String value) {
        super.setBLANC((value + _BLANCS).substring(0, this.getBLANCLength()));
    }

    public void setSESSID(String value) {
        super.setSESSID((value + _BLANCS).substring(0, this.getSESSIDLength()));
    }

    public void setFILLER_B(String value) {
        super.setFILLER_B((value + _BLANCS).substring(0, this.getFILLER_BLength()));
    }

    public void setNUVERG(String value) {
        super.setNUVERG((value + _BLANCS).substring(0, this.getNUVERGLength()));
    }

    public void setCOFIM(String value) {
        super.setCOFIM((value + _BLANCS).substring(0, this.getCOFIMLength()));
    }

    public void setNBGEN(String value) {
        super.setNBGEN((value + _BLANCS).substring(0, this.getNBGENLength()));
    }

    public void setETPRO(String value) {
        super.setETPRO((value + _BLANCS).substring(0, this.getETPROLength()));
    }

    public static String trimRight(String name) {
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        return new String(value, 0, end + 1);
    }

    private void setMainFileSynchronisation() {
        int maxSynchroPermanent = 0;
        int maxSynchroLevel = 0;
        int maxBreakLevel = 0;
        for (Object obj : this.programToGenerate.getCDLines()) {
            try {
                PacCDLineDataStructure mds = (PacCDLineDataStructure)obj;
                if (String.valueOf(mds.getUsage()).substring(1).equals("D") || String.valueOf(mds.getCommonDescription().getOrganization()).substring(1).equals("X") || String.valueOf(mds.getCommonDescription().getOrganization()).substring(1).equals("Y")) continue;
                if (String.valueOf(mds.getUsage()).substring(1).equals("P") && mds.getSyncLevel() > maxSynchroPermanent) {
                    maxSynchroPermanent = mds.getSyncLevel();
                }
                if (mds.getSyncLevel() > maxSynchroLevel) {
                    maxSynchroLevel = mds.getSyncLevel();
                }
                if (mds.getBreakLevel() > maxBreakLevel) {
                    maxBreakLevel = mds.getBreakLevel();
                }
                if (!String.valueOf(mds.getUsage()).substring(1).equals("P")) continue;
                this.permanentFiles.append(mds.getCommonDescription().getCodeInProgram());
            }
            catch (ClassCastException classCastException) {
                try {
                    PacWLineF cfr_ignored_0 = (PacWLineF)obj;
                }
                catch (ClassCastException classCastException2) {}
            }
        }
        this.setSYFPR(String.valueOf(maxSynchroPermanent));
        this.setSYMIN(String.valueOf(maxSynchroLevel));
        this.setCOUMAX(String.valueOf(maxBreakLevel));
        this.setCOFIM(this.permanentFiles.toString());
    }
}

