/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.icu.util.GregorianCalendar;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacInputAidGLine;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.util.PacInputAidCompletedDetailManager;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3LibraryImpl;
import java.util.List;

public class W3LibraryLine
extends W3LibraryImpl
implements W3Interface {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010,2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private W3CommonDescription w3Header = null;
    private int[] _APPLI = new int[]{1, 3};
    private int[] _LIBIB = new int[]{4, 36};
    private int[] _INVDA = new int[]{40, 1};
    private int[] _CARVE = new int[]{41, 1};
    private int[] _OPTET = new int[]{42, 1};
    private int[] _OPQUE = new int[]{43, 1};
    private int[] _NLPAG = new int[]{44, 2};
    private int[] _SUPSA = new int[]{46, 1};
    private int[] _SUPCO = new int[]{47, 1};
    private int[] _R7 = new int[]{48, 1};
    private int[] _OPAVP = new int[]{49, 1};
    private int[] _OPAPR = new int[]{50, 1};
    private int[] _LANGA = new int[]{51, 1};
    private int[] _VARIA = new int[]{52, 1};
    private int[] _TYPRO = new int[]{53, 1};
    private int[] _APPLIC = new int[]{54, 3};
    private int[] _R8 = new int[]{57, 1};
    private int[] _NIVEAU = new int[]{58, 1};
    private int[] _ETABI = new int[]{59, 1};
    private int[] _BIPOR = new int[]{60, 4};
    private int[] _CVEXT = new int[]{64, 1};
    private int[] _QUOTE = new int[]{65, 1};
    private int[] _FORDA = new int[]{66, 1};
    private int[] _DECPO = new int[]{67, 1};
    private int[] _VARIB = new int[]{68, 1};
    private int[] _COFOR = new int[]{69, 1};
    private int[] _SECUR = new int[]{70, 1};
    private int[] _CARHO = new int[]{71, 1};
    private int[] _FILLER = new int[]{72, 1};
    private int[] _DACTYR = new int[]{73, 1};
    private int[] _DACTYV = new int[]{74, 2};
    private int[] _DATEC = new int[]{76, 10};
    private int[] _CODUTI = new int[]{86, 8};
    private int[] _SESSI = new int[]{94, 8};
    private int[] _XLANG = new int[]{102, 1};
    private int[] _XUTPR = new int[]{103, 4};
    private int[] _SIGLE = new int[]{107, 10};
    private int[] _CTRAN = new int[]{117, 4};
    private int[] _DAT8 = new int[]{121, 8};
    private int[] _IOVFD = new int[]{129, 1};
    private int[] _FORIND = new int[]{130, 25};
    private int[] _XBREAK = new int[]{155, 1};
    private int[] _RELEAS = new int[]{156, 7};
    private int[] _GENMIP = new int[]{163, 1};
    private int[] _COPIBM = new int[]{164, 1};
    protected PacProgram programToGenerate;

    public W3LibraryLine(PacProgram pgm, PacLibrary lib) {
        this.programToGenerate = pgm;
        this.w3Header = new W3CommonDescription(pgm);
        this.init(lib);
    }

    private void init(PacLibrary lib) {
        this.w3Header.setOREDIT_Value("  ");
        this.w3Header.setCOMEDI_Value("  ");
        this.w3Header.setB1_Value("  ");
        this.w3Header.setB2_Value(lib.getName());
        this.w3Header.setB3A_Value("B");
        this.w3Header.setCOCA_Value("*");
        this.w3Header.setIED_Value("00");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setAPPLI(lib.getName());
        this.setLIBIB(lib.getLabel());
        this.setINVDA(" ");
        this.setCARVE(lib.getCobolType().getName().substring(1));
        this.setOPTET("*");
        this.setOPQUE(" ");
        this.setNLPAG("60");
        this.setSUPSA("O");
        this.setSUPCO("O");
        this.setR7("N");
        this.setOPAVP(" ");
        this.setOPAPR(" ");
        this.setLANGA(String.valueOf(lib.getGeneratedLanguage()).substring(1));
        this.setVARIA(lib.getCobolType().getName().substring(1));
        this.setTYPRO("P");
        this.setAPPLIC(lib.getName());
        this.setR8("N");
        this.setNIVEAU("3");
        this.setETABI("1");
        this.setBIPOR("A0A1");
        this.setCVEXT("1");
        this.setQUOTE(String.valueOf(lib.getAlphanumericDelimiter()));
        this.setFORDA(String.valueOf(lib.getGeneratedDateFormat()).substring(1));
        this.setDECPO(String.valueOf(lib.getDecimalPointDelimiter()));
        this.setVARIB(String.valueOf(lib.getMapType()).substring(1));
        this.setCOFOR(" ");
        this.setSECUR(" ");
        this.setCARHO(" ");
        this.setFILLER(" ");
        this.setDACTYR(String.valueOf(lib.getCenturySystemDate()).substring(1));
        this.setDACTYV(String.valueOf(lib.getCenturyReferenceYear()));
        String squelLang = lib.getSkeletonLanguage().getLiteral().substring(1);
        String day = "00" + String.valueOf(GregorianCalendar.getInstance().get(5));
        String month = "00" + String.valueOf(GregorianCalendar.getInstance().get(2) + 1);
        String year = "0000" + String.valueOf(GregorianCalendar.getInstance().get(1));
        String todayDate = squelLang.equals("EN") ? month.substring(month.length() - 2) + "/" + day.substring(day.length() - 2) + "/" + year.substring(year.length() - 4) : day.substring(day.length() - 2) + "/" + month.substring(month.length() - 2) + "/" + year.substring(year.length() - 4);
        if (System.getProperty("ProgramGeneration.W1.junit.process") != null && System.getProperty("ProgramGeneration.W2.junit.process") != null) {
            this.setDATEC("JUNIT");
        } else {
            this.setDATEC(todayDate);
        }
        this.setCODUTI("ADMIN   ");
        this.setSESSI("9999000 ");
        if (squelLang.equals("FR")) {
            this.setXLANG("F");
        } else {
            this.setXLANG("A");
        }
        this.setXUTPR("    ");
        this.setSIGLE("          ");
        this.setCTRAN("BVAP");
        year = "00" + String.valueOf(GregorianCalendar.getInstance().get(1));
        todayDate = squelLang.equals("EN") ? month.substring(month.length() - 2) + "/" + day.substring(day.length() - 2) + "/" + year.substring(year.length() - 2) : day.substring(day.length() - 2) + "/" + month.substring(month.length() - 2) + "/" + year.substring(year.length() - 2);
        if (System.getProperty("ProgramGeneration.W1.junit.process") != null && System.getProperty("ProgramGeneration.W2.junit.process") != null) {
            this.setDAT8("JUNIT");
        } else {
            this.setDAT8(todayDate);
        }
        this.setIOVFD(" ");
        this.setFORIND("                         ");
        this.setXBREAK("0");
        this.setGENMIP("");
        this.setCOPIBM("");
        block0: for (Object objGO : lib.getGOLines()) {
            if (objGO instanceof PacInputAidGLine) {
                List ls = new PacInputAidCompletedDetailManager().getAsGLineList((PacInputAidGLine)objGO, false);
                for (PacInputAidCompletedDetailManager.AsGLine iagl : ls) {
                    String descOfGOLine = iagl.getDescription();
                    String desc = descOfGOLine.trim();
                    if (desc.length() > 20) {
                        String fixedLabel = W3LibraryLine.trimRight(descOfGOLine.substring(0, 20));
                        String variableLabel = W3LibraryLine.trimRight(descOfGOLine.substring(20));
                        desc = fixedLabel.concat(variableLabel);
                    }
                    if (desc.equals("BREAKDATE=YES")) {
                        this.setXBREAK("1");
                    }
                    if (desc.equals("COPYRIGHT=IBM")) {
                        this.setGENMIP("");
                        this.setCOPIBM("1");
                    }
                    if (this.getXBREAK().equals("1") && this.getCOPIBM() != null && this.getCOPIBM().equals("1")) continue block0;
                }
                continue;
            }
            if (!(objGO instanceof PacGLine)) continue;
            String descOfGOLine = ((PacGLine)objGO).getDescription();
            if (descOfGOLine.trim().equals("BREAKDATE=YES")) {
                this.setXBREAK("1");
            }
            if (descOfGOLine.trim().equals("COPYRIGHT=IBM")) {
                this.setGENMIP("");
                this.setCOPIBM("1");
            }
            if (this.getXBREAK().equals("1") && this.getCOPIBM() != null && this.getCOPIBM().equals("1")) break;
        }
        if (System.getProperty("ProgramGeneration.W1.junit.process") != null && System.getProperty("ProgramGeneration.W2.junit.process") != null) {
            this.setRELEAS("9.1.2");
        } else {
            this.setRELEAS("9.8.0");
        }
    }

    private int getAPPLILength() {
        return this._APPLI[1];
    }

    private int getLIBIBLength() {
        return this._LIBIB[1];
    }

    private int getINVDALength() {
        return this._INVDA[1];
    }

    private int getCARVELength() {
        return this._CARVE[1];
    }

    private int getOPTETLength() {
        return this._OPTET[1];
    }

    private int getOPQUELength() {
        return this._OPQUE[1];
    }

    private int getNLPAGLength() {
        return this._NLPAG[1];
    }

    private int getSUPSALength() {
        return this._SUPSA[1];
    }

    private int getSUPCOLength() {
        return this._SUPCO[1];
    }

    private int getR7Length() {
        return this._R7[1];
    }

    private int getOPAVPLength() {
        return this._OPAVP[1];
    }

    private int getOPAPRLength() {
        return this._OPAPR[1];
    }

    private int getLANGALength() {
        return this._LANGA[1];
    }

    private int getVARIALength() {
        return this._VARIA[1];
    }

    private int getTYPROLength() {
        return this._TYPRO[1];
    }

    private int getAPPLICLength() {
        return this._APPLIC[1];
    }

    private int getR8Length() {
        return this._R8[1];
    }

    private int getNIVEAULength() {
        return this._NIVEAU[1];
    }

    private int getETABILength() {
        return this._ETABI[1];
    }

    private int getBIPORLength() {
        return this._BIPOR[1];
    }

    private int getCVEXTLength() {
        return this._CVEXT[1];
    }

    private int getQUOTELength() {
        return this._QUOTE[1];
    }

    private int getFORDALength() {
        return this._FORDA[1];
    }

    private int getDECPOLength() {
        return this._DECPO[1];
    }

    private int getVARIBLength() {
        return this._VARIB[1];
    }

    private int getCOFORLength() {
        return this._COFOR[1];
    }

    private int getSECURLength() {
        return this._SECUR[1];
    }

    private int getCARHOLength() {
        return this._CARHO[1];
    }

    private int getFILLERLength() {
        return this._FILLER[1];
    }

    private int getDACTYRLength() {
        return this._DACTYR[1];
    }

    private int getDACTYVLength() {
        return this._DACTYV[1];
    }

    private int getDATECLength() {
        return this._DATEC[1];
    }

    private int getCODUTILength() {
        return this._CODUTI[1];
    }

    private int getSESSILength() {
        return this._SESSI[1];
    }

    private int getXLANGLength() {
        return this._XLANG[1];
    }

    private int getXUTPRLength() {
        return this._XUTPR[1];
    }

    private int getSIGLELength() {
        return this._SIGLE[1];
    }

    private int getCTRANLength() {
        return this._CTRAN[1];
    }

    private int getDAT8Length() {
        return this._DAT8[1];
    }

    private int getIOVFDLength() {
        return this._IOVFD[1];
    }

    private int getFORINDLength() {
        return this._FORIND[1];
    }

    private int getXBREAKLength() {
        return this._XBREAK[1];
    }

    private int getRELEASLength() {
        return this._RELEAS[1];
    }

    private int getGENMIPLength() {
        return this._GENMIP[1];
    }

    private int getCOPIBMLength() {
        return this._COPIBM[1];
    }

    public void setAPPLI(String value) {
        super.setAPPLI((value + _BLANCS).substring(0, this.getAPPLILength()));
    }

    public void setLIBIB(String value) {
        super.setLIBIB((value + _BLANCS).substring(0, this.getLIBIBLength()));
    }

    public void setINVDA(String value) {
        super.setINVDA((value + _BLANCS).substring(0, this.getINVDALength()));
    }

    public void setCARVE(String value) {
        super.setCARVE((value + _BLANCS).substring(0, this.getCARVELength()));
    }

    public void setOPTET(String value) {
        super.setOPTET((value + _BLANCS).substring(0, this.getOPTETLength()));
    }

    public void setOPQUE(String value) {
        super.setOPQUE((value + _BLANCS).substring(0, this.getOPQUELength()));
    }

    public void setNLPAG(String value) {
        super.setNLPAG((value + _BLANCS).substring(0, this.getNLPAGLength()));
    }

    public void setSUPSA(String value) {
        super.setSUPSA((value + _BLANCS).substring(0, this.getSUPSALength()));
    }

    public void setSUPCO(String value) {
        super.setSUPCO((value + _BLANCS).substring(0, this.getSUPCOLength()));
    }

    public void setR7(String value) {
        super.setR7((value + _BLANCS).substring(0, this.getR7Length()));
    }

    public void setOPAVP(String value) {
        super.setOPAVP((value + _BLANCS).substring(0, this.getOPAVPLength()));
    }

    public void setOPAPR(String value) {
        super.setOPAPR((value + _BLANCS).substring(0, this.getOPAPRLength()));
    }

    public void setLANGA(String value) {
        super.setLANGA((value + _BLANCS).substring(0, this.getLANGALength()));
    }

    public void setVARIA(String value) {
        super.setVARIA((value + _BLANCS).substring(0, this.getVARIALength()));
    }

    public void setTYPRO(String value) {
        super.setTYPRO((value + _BLANCS).substring(0, this.getTYPROLength()));
    }

    public void setAPPLIC(String value) {
        super.setAPPLIC((value + _BLANCS).substring(0, this.getAPPLICLength()));
    }

    public void setR8(String value) {
        super.setR8((value + _BLANCS).substring(0, this.getR8Length()));
    }

    public void setNIVEAU(String value) {
        super.setNIVEAU((value + _BLANCS).substring(0, this.getNIVEAULength()));
    }

    public void setETABI(String value) {
        super.setETABI((value + _BLANCS).substring(0, this.getETABILength()));
    }

    public void setBIPOR(String value) {
        super.setBIPOR((value + _BLANCS).substring(0, this.getBIPORLength()));
    }

    public void setCVEXT(String value) {
        super.setCVEXT((value + _BLANCS).substring(0, this.getCVEXTLength()));
    }

    public void setQUOTE(String value) {
        super.setQUOTE((value + _BLANCS).substring(0, this.getQUOTELength()));
    }

    public void setFORDA(String value) {
        super.setFORDA((value + _BLANCS).substring(0, this.getFORDALength()));
    }

    public void setDECPO(String value) {
        super.setDECPO((value + _BLANCS).substring(0, this.getDECPOLength()));
    }

    public void setVARIB(String value) {
        super.setVARIB((value + _BLANCS).substring(0, this.getVARIBLength()));
    }

    public void setCOFOR(String value) {
        super.setCOFOR((value + _BLANCS).substring(0, this.getCOFORLength()));
    }

    public void setSECUR(String value) {
        super.setSECUR((value + _BLANCS).substring(0, this.getSECURLength()));
    }

    public void setCARHO(String value) {
        super.setCARHO((value + _BLANCS).substring(0, this.getCARHOLength()));
    }

    public void setFILLER(String value) {
        super.setFILLER((value + _BLANCS).substring(0, this.getFILLERLength()));
    }

    public void setDACTYR(String value) {
        super.setDACTYR((value + _BLANCS).substring(0, this.getDACTYRLength()));
    }

    public void setDACTYV(String value) {
        super.setDACTYV((value + _BLANCS).substring(0, this.getDACTYVLength()));
    }

    public void setDATEC(String value) {
        super.setDATEC((value + _BLANCS).substring(0, this.getDATECLength()));
    }

    public void setCODUTI(String value) {
        super.setCODUTI((value + _BLANCS).substring(0, this.getCODUTILength()));
    }

    public void setSESSI(String value) {
        super.setSESSI((value + _BLANCS).substring(0, this.getSESSILength()));
    }

    public void setXLANG(String value) {
        super.setXLANG((value + _BLANCS).substring(0, this.getXLANGLength()));
    }

    public void setXUTPR(String value) {
        super.setXUTPR((value + _BLANCS).substring(0, this.getXUTPRLength()));
    }

    public void setSIGLE(String value) {
        super.setSIGLE((value + _BLANCS).substring(0, this.getSIGLELength()));
    }

    public void setCTRAN(String value) {
        super.setCTRAN((value + _BLANCS).substring(0, this.getCTRANLength()));
    }

    public void setDAT8(String value) {
        super.setDAT8((value + _BLANCS).substring(0, this.getDAT8Length()));
    }

    public void setIOVFD_Value(String value) {
        super.setIOVFD((value + _BLANCS).substring(0, this.getIOVFDLength()));
    }

    public void setFORIND(String value) {
        super.setFORIND((value + _BLANCS).substring(0, this.getFORINDLength()));
    }

    public void setXBREAK(String value) {
        super.setXBREAK((value + _BLANCS).substring(0, this.getXBREAKLength()));
    }

    public void setRELEAS(String value) {
        super.setRELEAS((value + _BLANCS).substring(0, this.getRELEASLength()));
    }

    public void setGENMIP(String value) {
        super.setGENMIP((value + _BLANCS).substring(0, this.getGENMIPLength()));
    }

    public void setCOPIBM(String value) {
        super.setCOPIBM((value + _BLANCS).substring(0, this.getCOPIBMLength()));
    }

    public static String trimRight(String name) {
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        return new String(value, 0, end + 1);
    }
}

