/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3CommentLineImpl;

public class W3GLine
extends W3CommentLineImpl
implements W3Interface {
    private W3CommonDescription w3Header = null;
    private PacProgram programToGenerate;
    private PacGLine currentGLine;
    private int[] ADENR = new int[]{1, 8};
    private int[] LGDOVR = new int[]{9, 8};
    private int[] NULIG = new int[]{17, 3};
    private int[] DOCAP = new int[]{20, 1};
    private int[] SYNCO = new int[]{21, 6};
    private int[] ENTITE = new int[]{27, 6};
    private int[] NULI8 = new int[]{33, 3};
    private int[] VCOCA = new int[]{36, 2};
    private int[] VB0FAM = new int[]{38, 1};
    private int[] VB1FAM = new int[]{39, 2};
    private int[] VB3IPR = new int[]{41, 2};
    private int[] COCA = new int[]{43, 2};
    private int[] LGDOC = new int[]{45, 1};
    private int[] SYNMO = new int[]{46, 20};
    private int[] SYNOP = new int[]{66, 40};
    private int[] FILLER = new int[]{106, 11};
    private int[] SYNNB = new int[]{117, 2};
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public W3GLine(PacProgram pgm, PacGLine agLine, boolean gcline, int numberOfLine) {
        this.programToGenerate = pgm;
        this.currentGLine = agLine;
        this.w3Header = new W3CommonDescription(pgm);
        this.initToSpace();
        this.init(gcline, numberOfLine);
    }

    public W3GLine(PacProgram pgm, String lineTyp, String lineDesc, boolean gcline, int numberOfLine) {
        this.programToGenerate = pgm;
        this.w3Header = new W3CommonDescription(pgm);
        this.initToSpace();
        this.init(lineTyp, lineDesc, gcline, numberOfLine);
    }

    private void init(String lineTyp, String lineDesc, boolean gcline, int numberOfLine) {
        this.w3Header.setB3A_Value("C");
        if (gcline) {
            this.w3Header.setB6_Value("C");
        } else {
            this.w3Header.setB6_Value("O");
        }
        String str = "000" + String.valueOf(++numberOfLine);
        this.w3Header.setB8_Value(str.substring(str.length() - this.getNULIGLength()));
        this.w3Header.setCOCA_Value("V3");
        this.w3Header.setIED_Value("05");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setNULIG(this.w3Header.getB8_Value().trim());
        this.setDOCAP(lineTyp);
        this.setENTITE(this.w3Header.getB2());
        this.setVCOCA("0 ");
        this.setVB1FAM("K ");
        this.setVB3IPR("C ");
        this.setCOCA("0 ");
        if (lineDesc.length() > 20) {
            this.setSYNMO(lineDesc.substring(0, 20));
            this.setSYNOP(lineDesc.substring(20));
        } else {
            this.setSYNOP(lineDesc);
        }
    }

    private void init(boolean gcline, int numberOfLine) {
        this.w3Header.setB3A_Value("C");
        if (gcline) {
            this.w3Header.setB6_Value("C");
        } else {
            this.w3Header.setB6_Value("O");
        }
        String str = "000" + String.valueOf(++numberOfLine);
        this.w3Header.setB8_Value(str.substring(str.length() - this.getNULIGLength()));
        this.w3Header.setCOCA_Value("V3");
        this.w3Header.setIED_Value("05");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setNULIG(this.w3Header.getB8_Value().trim());
        this.setDOCAP(this.currentGLine.getLineType());
        this.setENTITE(this.w3Header.getB2());
        this.setVCOCA("0 ");
        this.setVB1FAM("K ");
        this.setVB3IPR("C ");
        this.setCOCA("0 ");
        this.setSYNMO(this.currentGLine.getDescription());
    }

    private void initToSpace() {
        this.setADENR(_BLANCS);
        this.setLGDOVR(_BLANCS);
        this.setNULIG(_BLANCS);
        this.setDOCAP(_BLANCS);
        this.setSYNCO(_BLANCS);
        this.setENTITE(_BLANCS);
        this.setNULI8(_BLANCS);
        this.setVCOCA(_BLANCS);
        this.setVB0FAM(_BLANCS);
        this.setVB1FAM(_BLANCS);
        this.setVB3IPR(_BLANCS);
        this.setCOCA(_BLANCS);
        this.setLGDOC(_BLANCS);
        this.setSYNMO(_BLANCS);
        this.setSYNOP(_BLANCS);
        this.setFILLER(_BLANCS);
        this.setSYNNB(_BLANCS);
    }

    private int getADENRLength() {
        return this.ADENR[1];
    }

    private int getLGDOVRLength() {
        return this.LGDOVR[1];
    }

    private int getNULIGLength() {
        return this.NULIG[1];
    }

    private int getDOCAPLength() {
        return this.DOCAP[1];
    }

    private int getSYNCOLength() {
        return this.SYNCO[1];
    }

    private int getENTITELength() {
        return this.ENTITE[1];
    }

    private int getNULI8Length() {
        return this.NULI8[1];
    }

    private int getVCOCALength() {
        return this.VCOCA[1];
    }

    private int getVB0FAMLength() {
        return this.VB0FAM[1];
    }

    private int getVB1FAMLength() {
        return this.VB1FAM[1];
    }

    private int getVB3IPRLength() {
        return this.VB3IPR[1];
    }

    private int getCOCALength() {
        return this.COCA[1];
    }

    private int getLGDOCLength() {
        return this.LGDOC[1];
    }

    private int getSYNMOLength() {
        return this.SYNMO[1];
    }

    private int getSYNOPLength() {
        return this.SYNOP[1];
    }

    private int getFILLERLength() {
        return this.FILLER[1];
    }

    private int getSYNNBLength() {
        return this.SYNNB[1];
    }

    public void setADENR(String value) {
        super.setADENR((value + _BLANCS).substring(0, this.getADENRLength()));
    }

    public void setLGDOVR(String value) {
        super.setLGDOVR((value + _BLANCS).substring(0, this.getLGDOVRLength()));
    }

    public void setNULIG(String value) {
        super.setNULIG((value + _BLANCS).substring(0, this.getNULIGLength()));
    }

    public void setDOCAP(String value) {
        super.setDOCAP((value + _BLANCS).substring(0, this.getDOCAPLength()));
    }

    public void setSYNCO(String value) {
        super.setSYNCO((value + _BLANCS).substring(0, this.getSYNCOLength()));
    }

    public void setENTITE(String value) {
        super.setENTITE((value + _BLANCS).substring(0, this.getENTITELength()));
    }

    public void setNULI8(String value) {
        super.setNULI8((value + _BLANCS).substring(0, this.getNULI8Length()));
    }

    public void setVCOCA(String value) {
        super.setVCOCA((value + _BLANCS).substring(0, this.getVCOCALength()));
    }

    public void setVB0FAM(String value) {
        super.setVB0FAM((value + _BLANCS).substring(0, this.getVB0FAMLength()));
    }

    public void setVB1FAM(String value) {
        super.setVB1FAM((value + _BLANCS).substring(0, this.getVB1FAMLength()));
    }

    public void setVB3IPR(String value) {
        super.setVB3IPR((value + _BLANCS).substring(0, this.getVB3IPRLength()));
    }

    public void setCOCA(String value) {
        super.setCOCA((value + _BLANCS).substring(0, this.getCOCALength()));
    }

    public void setLGDOC(String value) {
        super.setLGDOC((value + _BLANCS).substring(0, this.getLGDOCLength()));
    }

    public void setSYNMO(String value) {
        super.setSYNMO((value + _BLANCS).substring(0, this.getSYNMOLength()));
    }

    public void setSYNOP(String value) {
        super.setSYNOP((value + _BLANCS).substring(0, this.getSYNOPLength()));
    }

    public void setFILLER(String value) {
        super.setFILLER((value + _BLANCS).substring(0, this.getFILLERLength()));
    }

    public void setSYNNB(String value) {
        super.setSYNNB((value + _BLANCS).substring(0, this.getSYNNBLength()));
    }

    public W3CommonDescription getW3Header() {
        return this.w3Header;
    }
}

