/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.pacbase.PacCDLineDataStructure;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3dataStructureImpl;

public class W3DataStructureLine
extends W3dataStructureImpl
implements W3Interface {
    private W3CommonDescription w3Header = null;
    private PacProgram programToGenerate;
    private PacCDLineDataStructure currentCDLineDS;
    private DataUnit currentLineDS;
    private int[] COFIC = new int[]{1, 2};
    private int[] LIFIC = new int[]{3, 30};
    private int[] FICOM = new int[]{33, 44};
    private int[] NATEC = new int[]{77, 1};
    private int[] ECONT = new int[]{78, 1};
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public W3DataStructureLine(PacProgram pgm, PacCDLineDataStructure acdLineDS) {
        this.programToGenerate = pgm;
        this.currentCDLineDS = acdLineDS;
        this.initToSpace();
        this.init();
    }

    public W3DataStructureLine(PacProgram pgm, DataUnit aLineDS) {
        this.programToGenerate = pgm;
        this.currentLineDS = aLineDS;
        this.w3Header = new W3CommonDescription(pgm);
        this.initToSpace();
        this.init();
    }

    private void init() {
        this.w3Header.setB1_Value("F");
        this.w3Header.setB3A_Value("B");
        this.w3Header.setCOCA_Value("A");
        this.w3Header.setIED_Value("00");
        this.w3Header.setB2_Value(this.currentLineDS.getName());
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setCOFIC(this.currentLineDS.getName());
        this.setLIFIC(this.currentLineDS.getLabel());
        this.setNATEC("Z");
    }

    private void initToSpace() {
        this.setCOFIC(_BLANCS);
        this.setLIFIC(_BLANCS);
        this.setFICOM(_BLANCS);
        this.setNATEC(_BLANCS);
        this.setECONT(_BLANCS);
    }

    private int getCOFICLength() {
        return this.COFIC[1];
    }

    private int getLIFICLength() {
        return this.LIFIC[1];
    }

    private int getFICOMLength() {
        return this.FICOM[1];
    }

    private int getNATECLength() {
        return this.NATEC[1];
    }

    private int getECONTLength() {
        return this.ECONT[1];
    }

    public void setCOFIC(String value) {
        super.setCOFIC((value + _BLANCS).substring(0, this.getCOFICLength()));
    }

    public void setLIFIC(String value) {
        super.setLIFIC((value + _BLANCS).substring(0, this.getLIFICLength()));
    }

    public void setFICOM(String value) {
        super.setFICOM((value + _BLANCS).substring(0, this.getFICOMLength()));
    }

    public void setNATEC(String value) {
        super.setNATEC((value + _BLANCS).substring(0, this.getNATECLength()));
    }

    public void setECONT(String value) {
        super.setECONT((value + _BLANCS).substring(0, this.getECONTLength()));
    }
}

