/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacMacroParameter;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacWLineDataElement;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3DataElementWorkingLineImpl;
import java.util.Iterator;

public class W3DataItemWorkingLine
extends W3DataElementWorkingLineImpl
implements W3Interface {
    private W3CommonDescription w3Header = null;
    public static final String _pictureLabel = "PICTURE";
    private int[] BLANC1 = new int[]{1, 2};
    private int[] NULIM = new int[]{3, 2};
    private int[] NULI8 = new int[]{5, 3};
    private int[] SUITE = new int[]{8, 1};
    private int[] NBNIV = new int[]{9, 17};
    private int[] DECLA = new int[]{26, 48};
    private int[] DIMTA = new int[]{74, 5};
    private int[] PROGR = new int[]{79, 6};
    private int[] CORUM = new int[]{85, 6};
    private int[] FILLER_A = new int[]{91, 8};
    private int[] PICTUC = new int[]{99, 13};
    private int[] USAGEI = new int[]{112, 1};
    private int[] XINDC = new int[]{113, 1};
    private int[] B3UN = new int[]{114, 1};
    private int[] B1UN = new int[]{115, 1};
    private int[] XPARM = new int[]{116, 1};
    private int[] TYBLO2 = new int[]{117, 1};
    private int[] NUVERB = new int[]{118, 4};
    private int[] DESCA = new int[]{122, 1};
    private int[] VARIA = new int[]{123, 1};
    private int[] CORUB = new int[]{124, 6};
    private int[] TYRUB = new int[]{130, 1};
    private PacProgram programToGenerate;
    private PacWLineDataElement wLineDataElement;
    private String codeMacroEnCoursE;
    private int numberOfLineEnCoursT;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public W3DataItemWorkingLine(PacProgram pgm, PacWLineDataElement wli, String codeMacroEnCours, int numberOfLine) {
        this.programToGenerate = pgm;
        this.wLineDataElement = wli;
        this.codeMacroEnCoursE = codeMacroEnCours != null ? codeMacroEnCours.trim() : null;
        this.numberOfLineEnCoursT = numberOfLine;
        this.initToSpace();
        this.init();
    }

    private void initToSpace() {
        this.setBLANC1(_BLANCS);
        this.setNULIM(_BLANCS);
        this.setNULI8(_BLANCS);
        this.setSUITE(_BLANCS);
        this.setNBNIV(_BLANCS);
        this.setDECLA(_BLANCS);
        this.setDIMTA(_BLANCS);
        this.setPROGR(_BLANCS);
        this.setCORUM(_BLANCS);
        this.setFILLER_A(_BLANCS);
        this.setPICTUC(_BLANCS);
        this.setUSAGEI(_BLANCS);
        this.setXINDC(_BLANCS);
        this.setB3UN(_BLANCS);
        this.setB1UN(_BLANCS);
        this.setXPARM(_BLANCS);
        this.setTYBLO2(_BLANCS);
        this.setNUVERB(_BLANCS);
        this.setDESCA(_BLANCS);
        this.setCORUB(_BLANCS);
        this.setTYRUB(_BLANCS);
    }

    protected void init() {
        this.w3Header = new W3CommonDescription(this.programToGenerate);
        this.w3Header.setCOCA_Value("7");
        this.w3Header.setB3A_Value("S");
        this.w3Header.setIED_Value("12");
        this.w3Header.setB6_Value(this.wLineDataElement.getCobolPosition());
        String str = this.wLineDataElement.getLineNumber();
        String linenumber = (str + _BLANCS + _BLANCS).substring(0, this.w3Header.getB7Length());
        this.w3Header.setB7_Value(linenumber);
        this.w3Header.setB8_Value("999999");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setNULIM(this.wLineDataElement.getCobolPosition());
        this.setNULI8(this.wLineDataElement.getLineNumber());
        this.setSUITE(this.wLineDataElement.getType().getLiteral().substring(1));
        String nameOfDElt = "";
        if (this.wLineDataElement.getDataElement() != null) {
            nameOfDElt = this.wLineDataElement.getDataElement().getName();
            String workingLine = W3DataItemWorkingLine.cleanEndOfField(this.wLineDataElement.getTextBefore()) + nameOfDElt + this.wLineDataElement.getTextAfter();
            this.setNBNIV(workingLine);
            if (workingLine.length() > 16) {
                this.setNBNIV(workingLine.substring(0, 17));
                this.setDECLA(workingLine.substring(17));
            }
        }
        this.setCORUB(nameOfDElt);
        this.setDIMTA(this.wLineDataElement.getOccurs());
        this.setXINDC("X");
        this.setB3UN("B");
        this.setB1UN("K");
        this.setXPARM("0");
        if (this.programToGenerate.getCPLines() != null && this.codeMacroEnCoursE != null) {
            for (Object obj : this.programToGenerate.getCPLines()) {
                String lineToDeparamed2;
                String nameOfMacro = ((PacCPLine)obj).getMacro().getName();
                int numberOfLineOfMacro = ((PacCPLine)obj).getLineNumber();
                if (!nameOfMacro.equals(this.codeMacroEnCoursE) || numberOfLineOfMacro != this.numberOfLineEnCoursT || !(obj instanceof PacCPLine)) continue;
                Iterator parameterForLine = ((PacCPLine)obj).getParameters().iterator();
                String textDeparamedSave = null;
                String textDeparamedNivSave = null;
                String textDeparamedNulimSave = null;
                String textDeparamedNuli8Save = null;
                String textDeparamedOccursSave = null;
                while (parameterForLine.hasNext()) {
                    PacMacroParameter param = (PacMacroParameter)parameterForLine.next();
                    String idParam = param.getId();
                    String valueParam = param.getValue();
                    if (valueParam.length() <= 0) continue;
                    if (this.wLineDataElement.getNativeCall() != null && this.wLineDataElement.getNativeCall().length() > 0) {
                        String textDeparamedNiv;
                        int lengthNativCall = this.wLineDataElement.getNativeCall().length();
                        String textToDeparamNiv = textDeparamedNivSave == null ? W3DataItemWorkingLine.cleanEndOfField(this.wLineDataElement.getTextBefore() + this.wLineDataElement.getNativeCall().substring(0, lengthNativCall) + this.wLineDataElement.getTextAfter()) : textDeparamedNivSave;
                        textDeparamedNivSave = textDeparamedNiv = W3DataItemWorkingLine.replace(textToDeparamNiv, idParam, valueParam);
                    } else {
                        String textDeparamed;
                        Object textToDeparam = textDeparamedSave == null ? W3DataItemWorkingLine.cleanEndOfField(this.wLineDataElement.getTextBefore()) + this.wLineDataElement.getDataElement().getName() + this.wLineDataElement.getTextAfter() : textDeparamedSave;
                        textDeparamedSave = textDeparamed = W3DataItemWorkingLine.replace((String)textToDeparam, idParam, valueParam);
                    }
                    String textToDeparamNulim = textDeparamedNulimSave == null ? this.wLineDataElement.getCobolPosition() : textDeparamedNulimSave;
                    String textDeparamedNulim = W3DataItemWorkingLine.replace(textToDeparamNulim, idParam, valueParam);
                    this.setNULIM(textDeparamedNulim);
                    this.w3Header.setB6_Value(textDeparamedNulim);
                    textDeparamedNulimSave = textDeparamedNulim;
                    String textToDeparamNuli8 = textDeparamedNuli8Save == null ? this.wLineDataElement.getLineNumber() : textDeparamedNuli8Save;
                    String textDeparamedNuli8 = W3DataItemWorkingLine.replace(textToDeparamNuli8, idParam, valueParam);
                    this.setNULI8(textDeparamedNuli8);
                    this.w3Header.setB7_Value(textDeparamedNuli8);
                    textDeparamedNuli8Save = textDeparamedNuli8;
                    String textToDeparamOccurs = textDeparamedOccursSave == null ? this.wLineDataElement.getOccurs() : textDeparamedOccursSave;
                    String textDeparamedOccurs = W3DataItemWorkingLine.replace(textToDeparamOccurs, idParam, valueParam);
                    String strDimta = "00000" + textDeparamedOccurs;
                    String DimtaS = strDimta.substring(strDimta.length() - 5);
                    this.setDIMTA(DimtaS);
                    textDeparamedOccursSave = textDeparamedOccurs = DimtaS;
                }
                String lineToDeparamed1 = textDeparamedNivSave;
                if (lineToDeparamed1 != null) {
                    String newCorub = W3DataItemWorkingLine.getDataElementCodeForWLineDescription(lineToDeparamed1);
                    this.setCORUB(newCorub);
                    String prefE = "E=";
                    String prefix = "";
                    lineToDeparamed1 = W3DataItemWorkingLine.replace(lineToDeparamed1, prefE, prefix);
                    String prefD = "D=";
                    lineToDeparamed1 = W3DataItemWorkingLine.replace(lineToDeparamed1, prefD, prefix);
                    String prefS = "S=";
                    lineToDeparamed1 = W3DataItemWorkingLine.replace(lineToDeparamed1, prefS, prefix);
                    this.setNBNIV(lineToDeparamed1);
                    if (lineToDeparamed1.length() > 16) {
                        this.setNBNIV(lineToDeparamed1.substring(0, 17));
                        this.setDECLA(lineToDeparamed1.substring(17));
                    }
                }
                if ((lineToDeparamed2 = textDeparamedSave) != null) {
                    String newCorub = W3DataItemWorkingLine.getDataElementCodeForWLineDescription(lineToDeparamed2);
                    this.setCORUB(newCorub);
                    String prefE = "E=";
                    String prefix = "";
                    lineToDeparamed2 = W3DataItemWorkingLine.replace(lineToDeparamed2, prefE, prefix);
                    String prefD = "D=";
                    lineToDeparamed2 = W3DataItemWorkingLine.replace(lineToDeparamed2, prefD, prefix);
                    String prefS = "S=";
                    lineToDeparamed1 = W3DataItemWorkingLine.replace(lineToDeparamed2, prefS, prefix);
                    this.setNBNIV(lineToDeparamed2);
                    if (lineToDeparamed2.length() > 16) {
                        this.setNBNIV(lineToDeparamed2.substring(0, 17));
                        this.setDECLA(lineToDeparamed2.substring(17));
                    }
                }
                this.setPROGR(this.codeMacroEnCoursE);
                if (this.wLineDataElement.getType() == null) continue;
                this.setSUITE(this.wLineDataElement.getType().getLiteral().substring(1));
            }
        }
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
    }

    public static String replace(String originalText, String subStringToFind, String subStringToReplaceWith) {
        int s = 0;
        int e = 0;
        StringBuffer newText = new StringBuffer();
        while ((e = originalText.indexOf(subStringToFind, s)) >= 0) {
            newText.append(originalText.substring(s, e));
            newText.append(subStringToReplaceWith);
            s = e + subStringToFind.length();
        }
        newText.append(originalText.substring(s));
        return newText.toString();
    }

    public static String getDataElementCodeForWLineDescription(String wLineDescription) {
        String dataElementCode = null;
        int startPosition = wLineDescription.indexOf(45);
        if (startPosition == -1) {
            return null;
        }
        int endPosition = -1;
        int i = startPosition;
        while (i < wLineDescription.length()) {
            char charact = wLineDescription.charAt(i);
            if (!Character.isLetterOrDigit(charact) && charact != '$' && charact != '-' && charact != '=') {
                endPosition = i;
                break;
            }
            ++i;
        }
        if (endPosition != -1) {
            wLineDescription = wLineDescription.substring(0, endPosition);
        }
        endPosition = wLineDescription.lastIndexOf(45) + 1;
        int dataElementCodeLength = wLineDescription.length() - endPosition;
        String dataElementCodeToAnalize = wLineDescription.substring(endPosition);
        if (dataElementCodeToAnalize.length() > 0 && dataElementCodeToAnalize.charAt(1) == '=' && dataElementCodeToAnalize.charAt(0) == 'E') {
            dataElementCodeLength = wLineDescription.length() - (endPosition += 2);
        }
        if (dataElementCodeLength >= 1 && dataElementCodeLength <= 6) {
            dataElementCode = wLineDescription.substring(endPosition);
        }
        if (dataElementCode == null) {
            return null;
        }
        dataElementCode = dataElementCode.toUpperCase();
        return dataElementCode;
    }

    public static String cleanEndOfField(String name) {
        int end = name.length() - 1;
        char[] value = name.toCharArray();
        while (end >= 0 && value[end] <= ' ') {
            --end;
        }
        return new String(value, 0, end + 1);
    }

    private int getBLANC1Length() {
        return this.BLANC1[1];
    }

    private int getNULIMLength() {
        return this.NULIM[1];
    }

    private int getNULI8Length() {
        return this.NULI8[1];
    }

    private int getSUITELength() {
        return this.SUITE[1];
    }

    private int getNBNIVLength() {
        return this.NBNIV[1];
    }

    private int getDECLALength() {
        return this.DECLA[1];
    }

    private int getDIMTALength() {
        return this.DIMTA[1];
    }

    private int getPROGRLength() {
        return this.PROGR[1];
    }

    private int getCORUMLength() {
        return this.CORUM[1];
    }

    private int getFILLER_ALength() {
        return this.FILLER_A[1];
    }

    private int getPICTUCLength() {
        return this.PICTUC[1];
    }

    private int getUSAGEILength() {
        return this.USAGEI[1];
    }

    private int getXINDCLength() {
        return this.XINDC[1];
    }

    private int getB3UNLength() {
        return this.B3UN[1];
    }

    private int getB1UNLength() {
        return this.B1UN[1];
    }

    private int getXPARMLength() {
        return this.XPARM[1];
    }

    private int getTYBLO2Length() {
        return this.TYBLO2[1];
    }

    private int getNUVERBLength() {
        return this.NUVERB[1];
    }

    private int getDESCALength() {
        return this.DESCA[1];
    }

    private int getVARIALength() {
        return this.VARIA[1];
    }

    private int getCORUBLength() {
        return this.CORUB[1];
    }

    private int getTYRUBLength() {
        return this.TYRUB[1];
    }

    public void setBLANC1(String value) {
        super.setBLANC1((value + _BLANCS).substring(0, this.getBLANC1Length()));
    }

    public void setNULIM(String value) {
        super.setNULIM((value + _BLANCS).substring(0, this.getNULIMLength()));
    }

    public void setNULI8(String value) {
        super.setNULI8((value + _BLANCS).substring(0, this.getNULI8Length()));
    }

    public void setSUITE(String value) {
        super.setSUITE((value + _BLANCS).substring(0, this.getSUITELength()));
    }

    public void setNBNIV(String value) {
        super.setNBNIV((value + _BLANCS).substring(0, this.getNBNIVLength()));
    }

    public void setDECLA(String value) {
        super.setDECLA((value + _BLANCS).substring(0, this.getDECLALength()));
    }

    public void setDIMTA(String value) {
        int lgTot = (_ZERO + value).length();
        int lgDIMTA = this.getDIMTALength();
        super.setDIMTA((_ZERO + value).substring(lgTot - lgDIMTA, lgTot));
    }

    public void setPROGR(String value) {
        super.setPROGR((value + _BLANCS).substring(0, this.getPROGRLength()));
    }

    public void setCORUM(String value) {
        super.setCORUM((value + _BLANCS).substring(0, this.getCORUMLength()));
    }

    public void setFILLER_A(String value) {
        super.setFILLER_A((value + _BLANCS).substring(0, this.getFILLER_ALength()));
    }

    public void setPICTUC(String value) {
        super.setPICTUC((value + _BLANCS).substring(0, this.getPICTUCLength()));
    }

    public void setUSAGEI(String value) {
        super.setUSAGEI((value + _BLANCS).substring(0, this.getUSAGEILength()));
    }

    public void setXINDC(String value) {
        super.setXINDC((value + _BLANCS).substring(0, this.getXINDCLength()));
    }

    public void setB3UN(String value) {
        super.setB3UN((value + _BLANCS).substring(0, this.getB3UNLength()));
    }

    public void setB1UN(String value) {
        super.setB1UN((value + _BLANCS).substring(0, this.getB1UNLength()));
    }

    public void setXPARM(String value) {
        super.setXPARM((value + _BLANCS).substring(0, this.getXPARMLength()));
    }

    public void setTYBLO2(String value) {
        super.setTYBLO2((value + _BLANCS).substring(0, this.getTYBLO2Length()));
    }

    public void setNUVERB(String value) {
        super.setNUVERB((value + _BLANCS).substring(0, this.getNUVERBLength()));
    }

    public void setDESCA(String value) {
        super.setDESCA((value + _BLANCS).substring(0, this.getDESCALength()));
    }

    public void setVARIA(String value) {
        super.setVARIA((value + _BLANCS).substring(0, this.getVARIALength()));
    }

    public void setCORUB(String value) {
        super.setCORUB((value + _BLANCS).substring(0, this.getCORUBLength()));
    }

    public void setTYRUB(String value) {
        super.setTYRUB((value + _BLANCS).substring(0, this.getTYRUBLength()));
    }

    public W3CommonDescription getW3Header() {
        return this.w3Header;
    }

    public void setW3Header(W3CommonDescription header) {
        this.w3Header = header;
    }
}

