/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.impl.PacDLineImpl;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3DataElementDocumentationImpl;

public class W3DataElementDocumentation
extends W3DataElementDocumentationImpl
implements W3Interface {
    private W3CommonDescription w3Header = null;
    private PacProgram programToGenerate;
    private DataElement dataElement;
    private PacDLineImpl docElement;
    private int[] CORUB = new int[]{1, 6};
    private int[] NULIG = new int[]{7, 3};
    private int[] VALRU = new int[]{10, 13};
    private int[] TYCOD = new int[]{23, 1};
    private int[] SAVED = new int[]{24, 1};
    private int[] SIGNI = new int[]{25, 54};
    private int[] TYVAL = new int[]{79, 1};
    private int[] BORNEI = new int[]{80, 10};
    private int[] TYBORI = new int[]{90, 1};
    private int[] BORNES = new int[]{91, 10};
    private int[] TYBORS = new int[]{101, 1};
    private int[] NBLTC = new int[]{102, 1};
    private int[] LONTC = new int[]{103, 2};
    private int[] ADRC = new int[]{105, 6};
    private int[] FILLER_A = new int[]{111, 6};
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public W3DataElementDocumentation(PacProgram pgm, DataElement kDataElement, String header, PacDLineImpl dLine, int noLigDoc) {
        this.programToGenerate = pgm;
        this.dataElement = kDataElement;
        this.docElement = dLine;
        this.w3Header = new W3CommonDescription(this.programToGenerate);
        this.w3Header.setFileCommonDescriptionValue(new StringBuffer(header));
        this.w3Header.setCOCA_Value("E");
        this.w3Header.setIED_Value(header.substring(55, 57));
        this.w3Header.setB1_Value("F ");
        this.w3Header.setB2_Value(header.substring(11, 13));
        this.w3Header.setB4_Value(header.substring(11, 13));
        this.w3Header.setB9AB_Value(String.valueOf(noLigDoc));
        this.initToSpace();
        this.init();
    }

    private void initToSpace() {
        this.setCORUB(_BLANCS);
        this.setNULIG(_BLANCS);
        this.setVALRU(_BLANCS);
        this.setTYCOD(_BLANCS);
        this.setSAVED(_BLANCS);
        this.setSIGNI(_BLANCS);
        this.setTYVAL(_BLANCS);
        this.setBORNEI(_BLANCS);
        this.setTYBORI(_BLANCS);
        this.setBORNES(_BLANCS);
        this.setTYBORS(_BLANCS);
        this.setNBLTC("0");
        this.setLONTC("00");
        this.setADRC("000000");
        this.setFILLER_A(_BLANCS);
    }

    private void init() {
        String allowedVal = this.docElement.getAllowedValues();
        this.setVALRU(allowedVal);
        this.setTYCOD(this.docElement.getLineType());
        this.setSAVED(this.docElement.getMore());
        this.setSIGNI(this.docElement.getDescription());
        this.setTYVAL("V");
        if (allowedVal != null) {
            if (allowedVal.contains("(") || allowedVal.contains(")")) {
                this.setTYVAL("B");
            }
            String firstAllowedVal = allowedVal.substring(0, 1);
            String lastAllowedVal = " ";
            int lgValue = allowedVal.length();
            lastAllowedVal = allowedVal.length() > 9 ? allowedVal.substring(9, 10) : allowedVal.substring(lgValue - 1);
            if (allowedVal.startsWith("(") && allowedVal.endsWith(")")) {
                lastAllowedVal = ")";
            }
            if (firstAllowedVal.equals(")") || firstAllowedVal.equals("(")) {
                this.setTYBORI(firstAllowedVal);
                if (!lastAllowedVal.equals(")") && !lastAllowedVal.equals("(")) {
                    this.setBORNEI(" ".concat(allowedVal.substring(1)));
                } else {
                    int blancCar = allowedVal.indexOf(" ");
                    this.setBORNEI(" ".concat(allowedVal.substring(1, blancCar)));
                    this.setBORNES(allowedVal.substring(++blancCar, --lgValue));
                }
            }
            if (lastAllowedVal.equals(")") || lastAllowedVal.equals("(")) {
                this.setTYBORS(lastAllowedVal);
                if (!firstAllowedVal.equals(")") && !firstAllowedVal.equals("(")) {
                    this.setBORNES(allowedVal.substring(0, --lgValue));
                }
            }
        }
    }

    private int getCORUBLength() {
        return this.CORUB[1];
    }

    private int getNULIGLength() {
        return this.NULIG[1];
    }

    private int getVALRULength() {
        return this.VALRU[1];
    }

    private int getTYCODLength() {
        return this.TYCOD[1];
    }

    private int getSAVEDLength() {
        return this.SAVED[1];
    }

    private int getSIGNILength() {
        return this.SIGNI[1];
    }

    private int getTYVALLength() {
        return this.TYVAL[1];
    }

    private int getBORNEILength() {
        return this.BORNEI[1];
    }

    private int getTYBORILength() {
        return this.TYBORI[1];
    }

    private int getBORNESLength() {
        return this.BORNES[1];
    }

    private int getTYBORSLength() {
        return this.TYBORS[1];
    }

    private int getNBLTCLength() {
        return this.NBLTC[1];
    }

    private int getLONTCLength() {
        return this.LONTC[1];
    }

    private int getADRCLength() {
        return this.ADRC[1];
    }

    private int getFILLER_ALength() {
        return this.FILLER_A[1];
    }

    public void setCORUB(String value) {
        super.setCORUB((value + _BLANCS).substring(0, this.getCORUBLength()));
    }

    public void setNULIG(String value) {
        String str = "000" + value;
        super.setNULIG(str.substring(str.length() - this.getNULIGLength()));
    }

    public void setVALRU(String value) {
        super.setVALRU((value + _BLANCS).substring(0, this.getVALRULength()));
    }

    public void setTYCOD(String value) {
        super.setTYCOD((value + _BLANCS).substring(0, this.getTYCODLength()));
    }

    public void setSAVED(String value) {
        super.setSAVED((value + _BLANCS).substring(0, this.getSAVEDLength()));
    }

    public void setSIGNI(String value) {
        super.setSIGNI((value + _260BLANCS).substring(0, this.getSIGNILength()));
    }

    public void setTYVAL(String value) {
        super.setTYVAL((value + _BLANCS).substring(0, this.getTYVALLength()));
    }

    public void setBORNEI(String value) {
        super.setBORNEI((value + _BLANCS).substring(0, this.getBORNEILength()));
    }

    public void setTYBORI(String value) {
        super.setTYBORI((value + _BLANCS).substring(0, this.getTYBORILength()));
    }

    public void setBORNES(String value) {
        super.setBORNES((value + _BLANCS).substring(0, this.getBORNESLength()));
    }

    public void setTYBORS(String value) {
        super.setTYBORS((value + _BLANCS).substring(0, this.getTYBORSLength()));
    }

    public void setNBLTC(String value) {
        String str = "0" + value;
        super.setNBLTC(str.substring(str.length() - this.getNBLTCLength()));
    }

    public void setLONTC(String value) {
        String str = "00" + value;
        super.setLONTC(str.substring(str.length() - this.getLONTCLength()));
    }

    public void setADRC(String value) {
        String str = "00" + value;
        super.setADRC(str.substring(str.length() - this.getADRCLength()));
    }

    public void setFILLER_A(String value) {
        super.setFILLER_A((value + _BLANCS).substring(0, this.getFILLER_ALength()));
    }

    public W3CommonDescription getW3Header() {
        return this.w3Header;
    }
}

