/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataAggregateDescription;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataElement;
import com.ibm.pdp.mdl.kernel.DataElementDescription;
import com.ibm.pdp.mdl.kernel.DataUnion;
import com.ibm.pdp.mdl.kernel.DataUnionDescription;
import com.ibm.pdp.mdl.kernel.Filler;
import com.ibm.pdp.mdl.kernel.RadicalEntityExtension;
import com.ibm.pdp.mdl.pacbase.PacBlankWhenZeroValues;
import com.ibm.pdp.mdl.pacbase.PacCDLineDataStructure;
import com.ibm.pdp.mdl.pacbase.PacDataCall;
import com.ibm.pdp.mdl.pacbase.PacDataCallMore;
import com.ibm.pdp.mdl.pacbase.PacDataElement;
import com.ibm.pdp.mdl.pacbase.PacDataElementDescription;
import com.ibm.pdp.mdl.pacbase.PacDataElementInternalUsageValues;
import com.ibm.pdp.mdl.pacbase.PacDataElementTypeValues;
import com.ibm.pdp.mdl.pacbase.PacFiller;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacSegmentCall;
import com.ibm.pdp.mdl.pacbase.PacWLineF;
import com.ibm.pdp.mdl.pacbase.converter.PacPictureParser;
import com.ibm.pdp.mdl.pacbase.util.PacTransformationDataElementType;
import com.ibm.pdp.pacbase.generate.util.ExtractUtil;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.IncrementString;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3DataElementImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class W3DataElement
extends W3DataElementImpl
implements W3Interface {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2019.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private W3CommonDescription w3Header = null;
    private StringBuffer lineValue;
    private ArrayList<W3DataElement> w3dechildren = new ArrayList();
    public static final char DISPLAY_USAGE = 'D';
    private int[] COFIC = new int[]{1, 2};
    private int[] NUENR = new int[]{3, 2};
    private int[] NULIG = new int[]{5, 3};
    private int[] CORUB = new int[]{8, 6};
    private int[] CORTOT = new int[]{14, 4};
    private int[] REPET = new int[]{18, 3};
    private int[] NRURE = new int[]{21, 2};
    private int[] INDIC = new int[]{23, 1};
    private int[] STRCO = new int[]{24, 6};
    private int[] CLASC = new int[]{30, 1};
    private int[] LCONT = new int[]{31, 1};
    private int[] NEGAT = new int[]{32, 1};
    private int[] SCONT = new int[]{33, 1};
    private int[] VCONT = new int[]{34, 10};
    private int[] COFIM3 = new int[]{44, 10};
    private int[] COFIM = new int[]{44, 2};
    private int[] NUENM = new int[]{46, 2};
    private int[] CORUM = new int[]{48, 6};
    private int[] PICTUS = new int[]{54, 14};
    private int[] PICTUC = new int[]{68, 13};
    private int[] SUPIC = new int[]{81, 1};
    private int[] LORUBI = new int[]{82, 5};
    private int[] LORUBE = new int[]{87, 5};
    private int[] PICTUI = new int[]{92, 10};
    private int[] USAGEI = new int[]{102, 1};
    private int[] PICTUE = new int[]{103, 10};
    private int[] LORUBS = new int[]{113, 3};
    private int[] FILLER = new int[]{116, 5};
    private int[] TYRUB = new int[]{121, 1};
    private int[] VARIA = new int[]{122, 1};
    private PacCDLineDataStructure currentCDLineDS;
    private PacProgram programToGenerate;
    private PacSegmentCall currentSegCall;
    private DataCall currentdatacall;
    private PacWLineF currentWLineF;
    private Filler currentfiller;
    private int currentlinenumber = -1;
    private IncrementString currentlinenumberS;
    private int currentLevel = 10;
    private boolean isFromWLineF = false;

    public W3DataElement(StringBuffer sb) {
        this.lineValue = sb;
    }

    public W3DataElement(PacProgram pgm, PacCDLineDataStructure acdLineDS, PacSegmentCall asegCall, DataCall aDc, int linenumber, boolean isWLF, PacWLineF wlf, int currentLev, int i) {
        this.init(pgm, acdLineDS, asegCall, aDc, linenumber, isWLF, wlf, currentLev, i);
        this.currentfiller = null;
        this.currentdatacall = aDc;
        this.initSpecificDataCall();
    }

    public W3DataElement(PacProgram pgm, PacCDLineDataStructure acdLineDS, PacSegmentCall asegCall, DataCall aDc, IncrementString linenumber, boolean isWLF, PacWLineF wlf, int currentLev, int i) {
        this.init(pgm, acdLineDS, asegCall, aDc, linenumber, isWLF, wlf, currentLev, i);
        this.currentfiller = null;
        this.currentdatacall = aDc;
        this.initSpecificDataCall();
    }

    public W3DataElement(PacProgram pgm, PacCDLineDataStructure acdLineDS, PacSegmentCall asegCall, DataCall aDc, int linenumber, IncrementString linenumberS, boolean isWLF, PacWLineF wlf, int currentLev, int i) {
        this.init(pgm, acdLineDS, asegCall, aDc, linenumber, linenumberS, isWLF, wlf, currentLev, i);
        this.currentfiller = null;
        this.currentdatacall = aDc;
        this.initSpecificDataCall();
    }

    public W3DataElement(PacProgram pgm, PacCDLineDataStructure acdLineDS, PacSegmentCall asegCall, DataCall aDCall, int linenumber, IncrementString linenumberS, Filler afiller, boolean isWLF, PacWLineF wlf, int currentLev, int indMoreLine) {
        this.currentdatacall = null;
        this.currentfiller = afiller;
        this.init(pgm, acdLineDS, asegCall, aDCall, linenumber, linenumberS, isWLF, wlf, currentLev, indMoreLine);
        this.initSpecificFiller();
    }

    private void init(PacProgram pgm, PacCDLineDataStructure acdLineDS, PacSegmentCall asegCall, DataCall aDc, int linenumber, boolean isWLF, PacWLineF wlf, int cLevel, int indMoreLine) {
        this.programToGenerate = pgm;
        this.currentCDLineDS = acdLineDS;
        this.currentWLineF = wlf;
        this.currentSegCall = asegCall;
        this.currentdatacall = aDc;
        this.currentlinenumber = linenumber;
        this.isFromWLineF = isWLF;
        this.currentLevel = cLevel;
        this.w3Header = new W3CommonDescription(this.programToGenerate);
        this.initToSpace();
        this.initForAllTypes(indMoreLine);
    }

    private void init(PacProgram pgm, PacCDLineDataStructure acdLineDS, PacSegmentCall asegCall, DataCall aDc, IncrementString linenumber, boolean isWLF, PacWLineF wlf, int cLevel, int indMoreLine) {
        this.programToGenerate = pgm;
        this.currentCDLineDS = acdLineDS;
        this.currentWLineF = wlf;
        this.currentSegCall = asegCall;
        this.currentdatacall = aDc;
        this.currentlinenumberS = linenumber;
        this.isFromWLineF = isWLF;
        this.currentLevel = cLevel;
        this.w3Header = new W3CommonDescription(this.programToGenerate);
        this.initToSpace();
        this.initForAllTypes(indMoreLine);
    }

    private void init(PacProgram pgm, PacCDLineDataStructure acdLineDS, PacSegmentCall asegCall, DataCall aDc, int linenumber, IncrementString linenumberS, boolean isWLF, PacWLineF wlf, int cLevel, int indMoreLine) {
        this.programToGenerate = pgm;
        this.currentCDLineDS = acdLineDS;
        this.currentWLineF = wlf;
        this.currentSegCall = asegCall;
        this.currentdatacall = aDc;
        this.currentlinenumber = linenumber;
        this.currentlinenumberS = linenumberS;
        this.isFromWLineF = isWLF;
        this.currentLevel = cLevel;
        this.w3Header = new W3CommonDescription(this.programToGenerate);
        this.initToSpace();
        this.initForAllTypes(indMoreLine);
    }

    private void initToSpace() {
        this.setCOFIC(_BLANCS);
        this.setNUENR(_BLANCS);
        this.setNULIG(_BLANCS);
        this.setCORUB(_BLANCS);
        this.setCORTOT(_BLANCS);
        this.setREPET(_BLANCS);
        this.setNRURE(_BLANCS);
        this.setINDIC(_BLANCS);
        this.setSTRCO(_BLANCS);
        this.setCLASC(_BLANCS);
        this.setLCONT(_BLANCS);
        this.setNEGAT(_BLANCS);
        this.setSCONT(_BLANCS);
        this.setVCONT(_BLANCS);
        this.setCOFIM(_BLANCS);
        this.setNUENM(_BLANCS);
        this.setCORUM(_BLANCS);
        this.setPICTUS(_BLANCS);
        this.setPICTUC(_BLANCS);
        this.setSUPIC(_BLANCS);
        this.setLORUBI(_BLANCS);
        this.setLORUBE(_BLANCS);
        this.setPICTUI(_BLANCS);
        this.setUSAGEI(_BLANCS);
        this.setPICTUE(_BLANCS);
        this.setLORUBS(_BLANCS);
        this.setFILLER(_BLANCS);
        this.setTYRUB(_BLANCS);
        this.setVARIA(_BLANCS);
    }

    private void initForAllTypes(int indMoreLine) {
        if (this.isFromWLineF) {
            this.w3Header.setB3A_Value("U");
            if (this.currentWLineF.getDataStructure() != null) {
                this.currentWLineF.getDataStructure().getName();
            } else {
                this.currentWLineF.getNativeCall();
            }
        } else {
            this.w3Header.setB3A_Value("U");
        }
        this.w3Header.setCOCA_Value("3");
        this.w3Header.setIED_Value(String.valueOf(this.currentLevel));
        this.w3Header.setB1_Value("F ");
        this.w3Header.setB6_Value(this.currentSegCall.getSegment().getName().substring(2));
        String B7Value = this.currentlinenumberS.nextString();
        this.w3Header.setB7_Value(B7Value);
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setNUENR(this.currentSegCall.getSegment().getName().substring(2));
        this.setNULIG("100");
        if (this.currentdatacall != null) {
            String nbCaracValue = String.valueOf(this.currentdatacall.getMaximumCardinality());
            String str = "000" + nbCaracValue;
            String nbCaracDigit = str.substring(str.length() - 3);
            this.setREPET(String.valueOf(nbCaracDigit));
            if (this.currentdatacall.getDataDescription() != null) {
                this.setCORTOT(this.currentdatacall.getDataDescription().getLabel());
            }
            EList extensions = this.currentdatacall.getExtensions();
            this.updateDataCall((List)extensions, indMoreLine);
        }
        this.setNRURE("00");
        this.setTYRUB("R");
    }

    private void initSpecificFiller() {
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setCORUB("FILLER");
        String nbCaracValue = String.valueOf(this.currentfiller.getMaximumCardinality());
        String str = "000" + nbCaracValue;
        String nbCaracDigit = str.substring(str.length() - 3);
        this.setREPET(String.valueOf(nbCaracDigit));
        int indMoreLine = 0;
        EList extensionsList = this.currentfiller.getExtensions();
        this.updateDataCall((List)extensionsList, indMoreLine);
        PacFiller pacFill = null;
        int i = 0;
        while (i < extensionsList.size()) {
            Object object = extensionsList.get(i);
            if (object instanceof PacFiller) {
                pacFill = (PacFiller)object;
                break;
            }
            ++i;
        }
        if (pacFill != null) {
            this.setPICTUI(pacFill.getFormat());
            this.setPICTUE(pacFill.getFormat());
            this.setPICTUS(pacFill.getFormat());
            this.setUSAGEI(pacFill.getUsage().getLiteral().substring(1));
            PacPictureParser pp = new PacPictureParser(pacFill.getFormat());
            char usageChar = pacFill.getUsage().getLiteral().charAt(1);
            String lengthOfFill = String.valueOf(ExtractUtil.GetLength((PacPictureParser)pp, (char)usageChar, (char)'X'));
            this.setLORUBS(lengthOfFill);
            this.setLORUBI(lengthOfFill);
            this.setLORUBE(lengthOfFill);
        }
    }

    private void initSpecificDataCall() {
        if (this.currentfiller == null && this.currentdatacall != null) {
            if (this.currentdatacall.getDataDefinition() != null && this.currentdatacall.getDataDescription() == null) {
                if (this.currentdatacall.getDataDefinition() instanceof DataElement) {
                    DataElement dataelement = (DataElement)this.currentdatacall.getDataDefinition();
                    this.initFromDataDefinition(dataelement);
                } else if (this.currentdatacall.getDataDefinition() instanceof DataAggregate) {
                    DataAggregate dataaggregate = (DataAggregate)this.currentdatacall.getDataDefinition();
                    this.initFromDataDefinition(dataaggregate);
                } else if (this.currentdatacall.getDataDefinition() instanceof DataUnion) {
                    DataUnion dataunion = (DataUnion)this.currentdatacall.getDataDefinition();
                    this.initFromDataDefinition(dataunion);
                }
            }
            if (this.currentdatacall.getDataDefinition() == null && this.currentdatacall.getDataDescription() != null) {
                if (this.currentdatacall.getDataDescription() instanceof DataElementDescription) {
                    this.initFromDataDescription((DataElementDescription)this.currentdatacall.getDataDescription());
                } else if (this.currentdatacall.getDataDescription() instanceof DataAggregateDescription) {
                    this.initFromDataDescription((DataAggregateDescription)this.currentdatacall.getDataDescription());
                } else if (this.currentdatacall.getDataDescription() instanceof DataUnionDescription) {
                    this.initFromDataDescription((DataUnionDescription)this.currentdatacall.getDataDescription());
                }
            }
        }
    }

    private void initFromDataDefinition(DataElement dicl) {
        PacDataElementDescription pacded = null;
        Iterator extensions = dicl.getDataDescription().getExtensions().iterator();
        while (extensions.hasNext()) {
            try {
                pacded = (PacDataElementDescription)extensions.next();
            }
            catch (ClassCastException classCastException) {}
        }
        PacDataElement pdelt = null;
        for (RadicalEntityExtension entityExtension : dicl.getExtensions()) {
            if (!(entityExtension instanceof PacDataElement)) continue;
            pdelt = (PacDataElement)entityExtension;
        }
        if (pdelt == null) {
            return;
        }
        String variantGeneration = pdelt.getGenerationParameter().getCobolType().getName().substring(1);
        this.setVARIA(variantGeneration);
        this.setCORUB(dicl.getName());
        this.setCORTOT(dicl.getLabel());
        if (pacded != null) {
            PacDataElementDescription pacdedPar = null;
            if (pacded.getParent() != null) {
                DataElement parentDataElement = pacded.getParent();
                this.setCORTOT(parentDataElement.getLabel());
                Iterator extensionsPar = parentDataElement.getDataDescription().getExtensions().iterator();
                while (extensionsPar.hasNext()) {
                    try {
                        pacdedPar = (PacDataElementDescription)extensionsPar.next();
                    }
                    catch (ClassCastException classCastException) {}
                }
            }
            if (pacded.getOutputFormat().length() > 0) {
                this.setPICTUS(pacded.getOutputFormat());
                if (pacded.getOutputFormat().length() > 14) {
                    this.setPICTUC(pacded.getOutputFormat().substring(14));
                }
            } else if (pacdedPar != null && pacdedPar.getOutputFormat() != null) {
                this.setPICTUS(pacdedPar.getOutputFormat());
                if (pacdedPar.getOutputFormat().length() > 14) {
                    this.setPICTUC(pacdedPar.getOutputFormat().substring(14));
                }
            }
            if (pacded.getInternalFormat().length() > 0) {
                this.setPICTUI(pacded.getInternalFormat());
            } else if (pacdedPar != null && pacdedPar.getInternalFormat() != null) {
                this.setPICTUI(pacdedPar.getInternalFormat());
            }
            if (pacded.getInputFormat().length() > 0) {
                this.setPICTUE(pacded.getInputFormat());
            } else if (pacdedPar != null && pacdedPar.getInputFormat() != null) {
                this.setPICTUE(pacdedPar.getInputFormat());
            }
            char usage = PacbaseModelService.GetUsage((DataElement)((DataElement)pacded.getOwner())).getLiteral().charAt(1);
            this.setUSAGEI(pacded.getInternalUsage().getLiteral().substring(1));
            if (!pacded.getType().equals(PacDataElementTypeValues._L_LITERAL)) {
                this.setLORUBS(String.valueOf(ExtractUtil.GetCobolLength((PacDataElementDescription)pacded, (String)"S", (char)usage)));
                this.setLORUBI(String.valueOf(ExtractUtil.GetCobolLength((PacDataElementDescription)pacded, (String)"I", (char)usage)));
                this.setLORUBE(String.valueOf(ExtractUtil.GetCobolLength((PacDataElementDescription)pacded, (String)"E", (char)usage)));
            } else {
                this.setLORUBI("00000");
                this.setLORUBE("00000");
                this.setLORUBS("000");
            }
            if (PacTransformationDataElementType.transformDataElementType((PacDataElementTypeValues)pacded.getType()).trim().length() > 0) {
                this.setTYRUB(PacTransformationDataElementType.transformDataElementType((PacDataElementTypeValues)pacded.getType()));
            }
            if (pacdedPar != null) {
                char usageP = PacbaseModelService.GetUsage((DataElement)((DataElement)pacdedPar.getOwner())).getLiteral().charAt(1);
                PacDataElementInternalUsageValues usageDE = PacbaseModelService.GetUsage((DataElement)dicl);
                this.setUSAGEI(usageDE.getLiteral().substring(1));
                if (!pacdedPar.getType().equals(PacDataElementTypeValues._L_LITERAL)) {
                    if (pacded.getOutputFormat().length() < 1) {
                        this.setLORUBS(String.valueOf(ExtractUtil.GetCobolLength((PacDataElementDescription)pacdedPar, (String)"S", (char)usageP)));
                    }
                    if (pacded.getInternalFormat().length() < 1) {
                        this.setLORUBI(String.valueOf(ExtractUtil.GetCobolLength((PacDataElementDescription)pacdedPar, (String)"I", (char)usageP)));
                    }
                    if (pacded.getInputFormat().length() < 1) {
                        this.setLORUBE(String.valueOf(ExtractUtil.GetCobolLength((PacDataElementDescription)pacdedPar, (String)"E", (char)usageP)));
                    }
                } else {
                    this.setLORUBI("00000");
                    this.setLORUBE("00000");
                    this.setLORUBS("000");
                }
                if (pacded.getType().equals(PacDataElementTypeValues._INHERITED_LITERAL)) {
                    this.setTYRUB(PacTransformationDataElementType.transformDataElementType((PacDataElementTypeValues)pacdedPar.getType()));
                } else {
                    this.setTYRUB(PacTransformationDataElementType.transformDataElementType((PacDataElementTypeValues)pacded.getType()));
                }
            }
            if (pacded.getBlkWhenZero().equals(PacBlankWhenZeroValues._TRUE_LITERAL)) {
                this.setSUPIC("Z");
            } else if (pacded.getBlkWhenZero().equals(PacBlankWhenZeroValues._FALSE_LITERAL)) {
                this.setSUPIC("");
            } else if (pacdedPar != null) {
                if (pacdedPar.getBlkWhenZero().equals(PacBlankWhenZeroValues._TRUE_LITERAL)) {
                    this.setSUPIC("Z");
                }
                if (pacdedPar.getBlkWhenZero().equals(PacBlankWhenZeroValues._FALSE_LITERAL)) {
                    this.setSUPIC("");
                }
            }
            if (this.getPICTUI().trim().equals("TS")) {
                String LORUBI = W3DataElement.trimLeft(this.getLORUBI().trim());
                this.setPICTUI("X(" + LORUBI + ")");
            }
            if (this.getPICTUE().trim().equals("TS")) {
                String LORUBE = W3DataElement.trimLeft(this.getLORUBE().trim());
                this.setPICTUE("X(" + LORUBE + ")");
            }
            if (this.getPICTUS().trim().equals("TS")) {
                String LORUBS = W3DataElement.trimLeft(this.getLORUBS().trim());
                this.setPICTUS("X(" + LORUBS + ")");
            }
        }
    }

    public static String trimLeft(String s) {
        int i = 0;
        while (i < s.length() && s.charAt(i) == '0') {
            ++i;
        }
        return s.substring(i);
    }

    private void initFromDataDefinition(DataAggregate rcl) {
        this.setCORUB(rcl.getName());
        this.setNRURE("**");
        this.setSUPIC(" ");
        this.setLORUBI("00000");
        this.setLORUBE("00000");
        this.setPICTUI("          ");
        this.setUSAGEI(" ");
        this.setPICTUE("          ");
        this.setLORUBS("000");
        this.setFILLER("     ");
    }

    private void initFromDataDefinition(DataUnion du) {
        this.setCORUB(du.getName());
    }

    private void initFromDataDescription(DataElementDescription ded) {
        Iterator extensions = ded.getExtensions().iterator();
        PacDataElementDescription pacExt = null;
        while (extensions.hasNext()) {
            Object obj = extensions.next();
            if (!(obj instanceof PacDataElementDescription)) continue;
            pacExt = (PacDataElementDescription)obj;
            break;
        }
        this.setCORUB(ded.getName());
        this.setPICTUI(pacExt.getInternalFormat());
        this.setPICTUE(pacExt.getInternalFormat());
        this.setPICTUS(pacExt.getInternalFormat());
    }

    private void initFromDataDescription(DataAggregateDescription dad) {
        this.setCORUB(dad.getName());
        this.setCORTOT(dad.getLabel());
        this.setNRURE("00");
        this.setSUPIC(" ");
        this.setPICTUI("          ");
        this.setUSAGEI(" ");
        this.setPICTUE("          ");
        this.setLORUBS("000");
        this.setFILLER("     ");
    }

    private void initFromDataDescription(DataUnionDescription dud) {
        this.setCORUB(dud.getName());
        this.setNRURE("R*");
        this.setPICTUI("          ");
        this.setUSAGEI(" ");
        this.setPICTUE("          ");
        this.setLORUBS("000");
        this.setFILLER("     ");
    }

    private void updateDataCall(List extensions, int indMoreLine) {
        EList extensMoreLine;
        PacDataCall pacDataCall = null;
        PacFiller pacFiller = null;
        int i = 0;
        while (i < extensions.size()) {
            Object object = extensions.get(i);
            if (object instanceof PacDataCall) {
                pacDataCall = (PacDataCall)object;
                break;
            }
            if (object instanceof PacFiller) {
                pacFiller = (PacFiller)object;
                break;
            }
            ++i;
        }
        if (pacDataCall != null) {
            this.setINDIC(pacDataCall.getSortKey());
            if (pacDataCall.getPresenceCheck() != null) {
                String ctlCreat = pacDataCall.getPresenceCheck().getInCreation().toString().substring(1);
                String ctlModi = pacDataCall.getPresenceCheck().getInModification().toString().substring(1);
                String ctlDele = pacDataCall.getPresenceCheck().getInDeletion().toString().substring(1);
                String ctlTyp4 = pacDataCall.getPresenceCheck().getInType4().toString().substring(1);
                String ctlTyp5 = pacDataCall.getPresenceCheck().getInType5().toString().substring(1);
                String ctlTyp6 = pacDataCall.getPresenceCheck().getInType6().toString().substring(1);
                if (String.valueOf(ctlCreat).equals("None")) {
                    ctlCreat = " ";
                }
                if (String.valueOf(ctlModi).equals("None")) {
                    ctlModi = " ";
                }
                if (String.valueOf(ctlDele).equals("None")) {
                    ctlDele = " ";
                }
                if (String.valueOf(ctlTyp4).equals("None")) {
                    ctlTyp4 = " ";
                }
                if (String.valueOf(ctlTyp5).equals("None")) {
                    ctlTyp5 = " ";
                }
                if (String.valueOf(ctlTyp6).equals("None")) {
                    ctlTyp6 = " ";
                }
                this.setSTRCO(ctlCreat.concat(ctlModi).concat(ctlDele).concat(ctlTyp4).concat(ctlTyp5).concat(ctlTyp6));
            }
            if (indMoreLine < 1) {
                String classe = pacDataCall.getClassControl().toString().substring(1);
                if (String.valueOf(pacDataCall.getClassControl()).equals("_None")) {
                    this.setCLASC(_BLANCS);
                } else {
                    this.setCLASC(classe);
                }
            }
            PacDataCallMore pacDataCallMor = null;
            extensMoreLine = pacDataCall.getMoreLines();
            if (extensMoreLine != null && extensMoreLine.size() > 0 && (pacDataCallMor = (PacDataCallMore)extensMoreLine.get(indMoreLine)) != null) {
                this.setLCONT(pacDataCallMor.getOperator());
                this.setNEGAT(pacDataCallMor.getNegation());
                this.setSCONT(pacDataCallMor.getControlType());
                this.setVCONT(pacDataCallMor.getControlValue());
                if (pacDataCallMor.getUpdateTarget().trim().length() > 0 && pacDataCallMor.getUpdateTarget().substring(0, 2).equals("R*")) {
                    this.w3Header.setCOCA_Value("31");
                    this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
                }
                if (pacDataCallMor.getUpdateTarget().trim().length() > 0) {
                    this.setCOFIM(pacDataCallMor.getUpdateTarget().substring(0, 2));
                }
                if (pacDataCallMor.getUpdateTarget().trim().length() > 2) {
                    this.setNUENM(pacDataCallMor.getUpdateTarget().substring(2, 4));
                    if (pacDataCallMor.getUpdateTarget().trim().length() > 4) {
                        this.setCORUM(pacDataCallMor.getUpdateTarget().substring(4));
                    } else if (!(this.getCOFIM().equals("Y*") || this.getCOFIM().equals("C*") || this.getCOFIM().equals("A*") || this.getSCONT().equals("W") || this.getSCONT().equals("C") || this.getSCONT().equals("R") || this.getSCONT().equals("I") || this.currentdatacall.getDataDefinition() == null)) {
                        this.setCORUM(this.currentdatacall.getDataDefinition().getName());
                    }
                }
            }
        }
        if (pacFiller != null) {
            this.setINDIC(pacFiller.getSortKey());
            PacDataCallMore pacDataCallMor = null;
            extensMoreLine = pacFiller.getMoreLines();
            if (extensMoreLine != null && extensMoreLine.size() > 0 && (pacDataCallMor = (PacDataCallMore)extensMoreLine.get(indMoreLine)) != null) {
                this.setLCONT(pacDataCallMor.getOperator());
                this.setNEGAT(pacDataCallMor.getNegation());
                this.setSCONT(pacDataCallMor.getControlType());
                this.setVCONT(pacDataCallMor.getControlValue());
                if (pacDataCallMor.getUpdateTarget().trim().length() > 0 && pacDataCallMor.getUpdateTarget().substring(0, 2).equals("R*")) {
                    this.w3Header.setCOCA_Value("31");
                    this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
                }
                if (pacDataCallMor.getUpdateTarget().trim().length() > 0) {
                    this.setCOFIM(pacDataCallMor.getUpdateTarget().substring(0, 2));
                }
                if (pacDataCallMor.getUpdateTarget().trim().length() > 2) {
                    this.setNUENM(pacDataCallMor.getUpdateTarget().substring(2, 4));
                    if (pacDataCallMor.getUpdateTarget().trim().length() > 4) {
                        this.setCORUM(pacDataCallMor.getUpdateTarget().substring(4));
                    } else if (!(this.getCOFIM().equals("Y*") || this.getCOFIM().equals("C*") || this.getCOFIM().equals("A*") || this.getSCONT().equals("W") || this.getSCONT().equals("C") || this.getSCONT().equals("R") || this.getSCONT().equals("I") || this.currentdatacall.getDataDefinition() == null)) {
                        this.setCORUM(this.currentdatacall.getDataDefinition().getName());
                    }
                }
            }
        }
    }

    private int getCOFICLength() {
        return this.COFIC[1];
    }

    private int getNUENRLength() {
        return this.NUENR[1];
    }

    private int getNULIGLength() {
        return this.NULIG[1];
    }

    private int getCORUBLength() {
        return this.CORUB[1];
    }

    private int getCORTOTLength() {
        return this.CORTOT[1];
    }

    private int getREPETLength() {
        return this.REPET[1];
    }

    private int getNRURELength() {
        return this.NRURE[1];
    }

    private int getINDICLength() {
        return this.INDIC[1];
    }

    private int getSTRCOLength() {
        return this.STRCO[1];
    }

    private int getCLASCLength() {
        return this.CLASC[1];
    }

    private int getLCONTLength() {
        return this.LCONT[1];
    }

    private int getNEGATLength() {
        return this.NEGAT[1];
    }

    private int getSCONTLength() {
        return this.SCONT[1];
    }

    private int getVCONTLength() {
        return this.VCONT[1];
    }

    private int getCOFIM3Length() {
        return this.COFIM3[1];
    }

    private int getCOFIMLength() {
        return this.COFIM[1];
    }

    private int getNUENMLength() {
        return this.NUENM[1];
    }

    private int getCORUMLength() {
        return this.CORUM[1];
    }

    private int getPICTUSLength() {
        return this.PICTUS[1];
    }

    private int getPICTUCLength() {
        return this.PICTUC[1];
    }

    private int getSUPICLength() {
        return this.SUPIC[1];
    }

    private int getLORUBILength() {
        return this.LORUBI[1];
    }

    private int getLORUBELength() {
        return this.LORUBE[1];
    }

    private int getPICTUILength() {
        return this.PICTUI[1];
    }

    private int getUSAGEILength() {
        return this.USAGEI[1];
    }

    private int getPICTUELength() {
        return this.PICTUE[1];
    }

    private int getLORUBSLength() {
        return this.LORUBS[1];
    }

    private int getFILLERLength() {
        return this.FILLER[1];
    }

    private int getTYRUBLength() {
        return this.TYRUB[1];
    }

    private int getVARIALength() {
        return this.VARIA[1];
    }

    private int getNUENRPosition() {
        return this.NUENR[0] - 1;
    }

    private int getNULIGPosition() {
        return this.NULIG[0] - 1;
    }

    private int getCORUBPosition() {
        return this.CORUB[0] - 1;
    }

    private int getCORTOTPosition() {
        return this.CORTOT[0] - 1;
    }

    private int getREPETPosition() {
        return this.REPET[0] - 1;
    }

    private int getNRUREPosition() {
        return this.NRURE[0] - 1;
    }

    private int getINDICPosition() {
        return this.INDIC[0] - 1;
    }

    private int getSTRCOPosition() {
        return this.STRCO[0] - 1;
    }

    private int getCLASCPosition() {
        return this.CLASC[0] - 1;
    }

    private int getLCONTPosition() {
        return this.LCONT[0] - 1;
    }

    private int getNEGATPosition() {
        return this.NEGAT[0] - 1;
    }

    private int getSCONTPosition() {
        return this.SCONT[0] - 1;
    }

    private int getVCONTPosition() {
        return this.VCONT[0] - 1;
    }

    private int getCOFIM3Position() {
        return this.COFIM3[0] - 1;
    }

    private int getCOFIMPosition() {
        return this.COFIM[0] - 1;
    }

    private int getNUENMPosition() {
        return this.NUENM[0] - 1;
    }

    private int getCORUMPosition() {
        return this.CORUM[0] - 1;
    }

    private int getPICTUSPosition() {
        return this.PICTUS[0] - 1;
    }

    private int getPICTUCPosition() {
        return this.PICTUC[0] - 1;
    }

    private int getSUPICPosition() {
        return this.SUPIC[0] - 1;
    }

    private int getLORUBIPosition() {
        return this.LORUBI[0] - 1;
    }

    private int getLORUBEPosition() {
        return this.LORUBE[0] - 1;
    }

    private int getPICTUIPosition() {
        return this.PICTUI[0] - 1;
    }

    private int getUSAGEIPosition() {
        return this.USAGEI[0] - 1;
    }

    private int getPICTUEPosition() {
        return this.PICTUE[0] - 1;
    }

    private int getLORUBSPosition() {
        return this.LORUBS[0] - 1;
    }

    private int getFILLERPosition() {
        return this.FILLER[0] - 1;
    }

    private int getTYRUBPosition() {
        return this.TYRUB[0] - 1;
    }

    private int getVARIAPosition() {
        return this.TYRUB[0] - 1;
    }

    public void setCOFIC(String value) {
        super.setCOFIC((value + _BLANCS).substring(0, this.getCOFICLength()));
    }

    public void setNUENR(String value) {
        super.setNUENR((value + _BLANCS).substring(0, this.getNUENRLength()));
    }

    public void setNULIG(String value) {
        String str = "000" + value;
        super.setNULIG(str.substring(str.length() - this.getNULIGLength()));
    }

    public void setCORUB(String value) {
        super.setCORUB((value + _BLANCS).substring(0, this.getCORUBLength()));
    }

    public void setCORTOT(String value) {
        super.setCORTOT((value + _BLANCS).substring(0, this.getCORTOTLength()));
    }

    public void setREPET(String value) {
        String str = "000" + value;
        super.setREPET(str.substring(str.length() - this.getREPETLength()));
    }

    public void setNRURE(String value) {
        String str = "00" + value;
        super.setNRURE(str.substring(str.length() - this.getNRURELength()));
    }

    public void setINDIC(String value) {
        super.setINDIC((value + _BLANCS).substring(0, this.getINDICLength()));
    }

    public void setSTRCO(String value) {
        super.setSTRCO((value + _BLANCS).substring(0, this.getSTRCOLength()));
    }

    public void setCLASC(String value) {
        super.setCLASC((value + _BLANCS).substring(0, this.getCLASCLength()));
    }

    public void setLCONT(String value) {
        super.setLCONT((value + _BLANCS).substring(0, this.getLCONTLength()));
    }

    public void setNEGAT(String value) {
        super.setNEGAT((value + _BLANCS).substring(0, this.getNEGATLength()));
    }

    public void setSCONT(String value) {
        super.setSCONT((value + _BLANCS).substring(0, this.getSCONTLength()));
    }

    public void setVCONT(String value) {
        super.setVCONT((value + _BLANCS).substring(0, this.getVCONTLength()));
    }

    public void setCOFIM(String value) {
        super.setCOFIM((value + _BLANCS).substring(0, this.getCOFIMLength()));
    }

    public void setNUENM(String value) {
        super.setNUENM((value + _BLANCS).substring(0, this.getNUENMLength()));
    }

    public void setCORUM(String value) {
        super.setCORUM((value + _BLANCS).substring(0, this.getCORUMLength()));
    }

    public void setPICTUS(String value) {
        super.setPICTUS((value + _BLANCS).substring(0, this.getPICTUSLength()));
    }

    public void setPICTUC(String value) {
        super.setPICTUC((value + _BLANCS).substring(0, this.getPICTUCLength()));
    }

    public void setSUPIC(String value) {
        super.setSUPIC((value + _BLANCS).substring(0, this.getSUPICLength()));
    }

    public void setLORUBI(String value) {
        String str = "00000" + value;
        super.setLORUBI(str.substring(str.length() - this.getLORUBILength()));
    }

    public void setLORUBE(String value) {
        String str = "00000" + value;
        super.setLORUBE(str.substring(str.length() - this.getLORUBELength()));
    }

    public void setPICTUI(String value) {
        super.setPICTUI((value + _BLANCS).substring(0, this.getPICTUILength()));
    }

    public void setUSAGEI(String value) {
        super.setUSAGEI((value + _BLANCS).substring(0, this.getUSAGEILength()));
    }

    public void setPICTUE(String value) {
        super.setPICTUE((value + _BLANCS).substring(0, this.getPICTUELength()));
    }

    public void setLORUBS(String value) {
        String str = "00000" + value;
        super.setLORUBS(str.substring(str.length() - this.getLORUBSLength()));
    }

    public void setFILLER(String value) {
        super.setFILLER((value + _BLANCS).substring(0, this.getFILLERLength()));
    }

    public void setTYRUB(String value) {
        super.setTYRUB((value + _BLANCS).substring(0, this.getTYRUBLength()));
    }

    public void setVARIA(String value) {
        super.setVARIA((value + _BLANCS).substring(0, this.getVARIALength()));
    }

    public ArrayList<W3DataElement> getW3dechildren() {
        return this.w3dechildren;
    }

    public void setW3dechildren(ArrayList<W3DataElement> w3dechildren) {
        this.w3dechildren = w3dechildren;
    }

    public String getNUENR_line() {
        return this.lineValue.substring(this.getNUENRPosition(), this.getNUENRPosition() + this.getNUENRLength());
    }

    public String getNULIG_line() {
        return this.lineValue.substring(this.getNULIGPosition(), this.getNULIGPosition() + this.getNULIGLength());
    }

    public String getCORUB_line() {
        return this.lineValue.substring(this.getCORUBPosition(), this.getCORUBPosition() + this.getCORUBLength());
    }

    public String getCORTOT_line() {
        return this.lineValue.substring(this.getCORTOTPosition(), this.getCORTOTPosition() + this.getCORTOTLength());
    }

    public String getREPET_line() {
        return this.lineValue.substring(this.getREPETPosition(), this.getREPETPosition() + this.getREPETLength());
    }

    public String getNRURE_line() {
        return this.lineValue.substring(this.getNRUREPosition(), this.getNRUREPosition() + this.getNRURELength());
    }

    public String getINDIC_line() {
        return this.lineValue.substring(this.getINDICPosition(), this.getINDICPosition() + this.getINDICLength());
    }

    public String getSTRCO_line() {
        return this.lineValue.substring(this.getSTRCOPosition(), this.getSTRCOPosition() + this.getSTRCOLength());
    }

    public String getCLASC_line() {
        return this.lineValue.substring(this.getCLASCPosition(), this.getCLASCPosition() + this.getCLASCLength());
    }

    public String getLCONT_line() {
        return this.lineValue.substring(this.getLCONTPosition(), this.getLCONTPosition() + this.getLCONTLength());
    }

    public String getNEGAT_line() {
        return this.lineValue.substring(this.getNEGATPosition(), this.getNEGATPosition() + this.getNEGATLength());
    }

    public String getSCONT_line() {
        return this.lineValue.substring(this.getSCONTPosition(), this.getSCONTPosition() + this.getSCONTLength());
    }

    public String getVCONT_line() {
        return this.lineValue.substring(this.getVCONTPosition(), this.getVCONTPosition() + this.getVCONTLength());
    }

    public String getCOFIM3_line() {
        return this.lineValue.substring(this.getCOFIM3Position(), this.getCOFIM3Position() + this.getCOFIM3Length());
    }

    public String getCOFIM_line() {
        return this.lineValue.substring(this.getCOFIMPosition(), this.getCOFIMPosition() + this.getCOFIMLength());
    }

    public String getNUENM_line() {
        return this.lineValue.substring(this.getNUENMPosition(), this.getNUENMPosition() + this.getNUENMLength());
    }

    public String getCORUM_line() {
        return this.lineValue.substring(this.getCORUMPosition(), this.getCORUMPosition() + this.getCORUMLength());
    }

    public String getPICTUS_line() {
        return this.lineValue.substring(this.getPICTUSPosition(), this.getPICTUSPosition() + this.getPICTUSLength());
    }

    public String getPICTUC_line() {
        return this.lineValue.substring(this.getPICTUCPosition(), this.getPICTUCPosition() + this.getPICTUCLength());
    }

    public String getSUPIC_line() {
        return this.lineValue.substring(this.getSUPICPosition(), this.getSUPICPosition() + this.getSUPICLength());
    }

    public String getLORUBI_line() {
        return this.lineValue.substring(this.getLORUBIPosition(), this.getLORUBIPosition() + this.getLORUBILength());
    }

    public String getLORUBE_line() {
        return this.lineValue.substring(this.getLORUBEPosition(), this.getLORUBEPosition() + this.getLORUBELength());
    }

    public String getPICTUI_line() {
        return this.lineValue.substring(this.getPICTUIPosition(), this.getPICTUIPosition() + this.getPICTUILength());
    }

    public String getUSAGEI_line() {
        return this.lineValue.substring(this.getUSAGEIPosition(), this.getUSAGEIPosition() + this.getUSAGEILength());
    }

    public String getPICTUE_line() {
        return this.lineValue.substring(this.getPICTUEPosition(), this.getPICTUEPosition() + this.getPICTUELength());
    }

    public String getLORUBS_line() {
        return this.lineValue.substring(this.getLORUBSPosition(), this.getLORUBSPosition() + this.getLORUBSLength());
    }

    public String getFILLER_line() {
        return this.lineValue.substring(this.getFILLERPosition(), this.getFILLERPosition() + this.getFILLERLength());
    }

    public String getTYRUB_line() {
        return this.lineValue.substring(this.getTYRUBPosition(), this.getTYRUBPosition() + this.getTYRUBLength());
    }

    public String getVARIA_line() {
        return this.lineValue.substring(this.getVARIAPosition(), this.getVARIAPosition() + this.getVARIALength());
    }

    public W3CommonDescription getW3Header() {
        return this.w3Header;
    }
}

