/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3CalledMacroImpl;

public class W3CPLine
extends W3CalledMacroImpl
implements W3Interface {
    private W3CommonDescription w3Header = null;
    private PacProgram programToGenerate;
    private PacCPLine currentCPLine;
    private int[] NULIM = new int[]{1, 2};
    private int[] FILLER = new int[]{3, 2};
    private int[] PROGR = new int[]{5, 6};
    private int[] NOMEN = new int[]{11, 6};
    private int[] ZOPAR = new int[]{17, 50};
    private int[] DELIM = new int[]{67, 1};
    private int[] XVENT = new int[]{68, 1};
    private int[] FILLER_A = new int[]{69, 9};
    private int[] SUITEM = new int[]{78, 1};
    private int[] TVPAR = new int[]{79, 20};
    private int[] XINDM = new int[]{99, 1};
    private int[] FILLER_B = new int[]{100, 13};
    private int[] B1UNB = new int[]{113, 1};
    private int[] B1UN = new int[]{114, 1};
    private int[] B3UN = new int[]{115, 1};
    private int[] B3UNB = new int[]{116, 1};
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public W3CPLine(PacProgram pgm, PacCPLine acpLine) {
        this.programToGenerate = pgm;
        this.currentCPLine = acpLine;
        this.w3Header = new W3CommonDescription(pgm);
        this.initToSpace();
        this.init();
    }

    private void init() {
        this.w3Header.setB3A_Value("K");
        this.w3Header.setB4_Value(this.currentCPLine.getMacro().getName());
        this.w3Header.setCOCA_Value("M");
        this.w3Header.setIED_Value("09");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setNULIM(String.valueOf(this.currentCPLine.getLineNumber()));
        this.setPROGR(this.w3Header.getB4());
        this.setZOPAR(this.currentCPLine.getMacro().getLabel());
        this.setDELIM("/");
    }

    private void initToSpace() {
        this.setNULIM(_BLANCS);
        this.setFILLER(_BLANCS);
        this.setPROGR(_BLANCS);
        this.setNOMEN(_BLANCS);
        this.setZOPAR(_BLANCS);
        this.setDELIM(_BLANCS);
        this.setXVENT(_BLANCS);
        this.setFILLER_A(_BLANCS);
        this.setSUITEM(_BLANCS);
        this.setTVPAR(_BLANCS);
        this.setXINDM(_BLANCS);
        this.setFILLER_B(_BLANCS);
        this.setB1UNB(_BLANCS);
        this.setB1UN(_BLANCS);
        this.setB3UNB(_BLANCS);
        this.setB3UN(_BLANCS);
    }

    private int getNULIMLength() {
        return this.NULIM[1];
    }

    private int getFILLERLength() {
        return this.FILLER[1];
    }

    private int getPROGRLength() {
        return this.PROGR[1];
    }

    private int getNOMENLength() {
        return this.NOMEN[1];
    }

    private int getZOPARLength() {
        return this.ZOPAR[1];
    }

    private int getDELIMLength() {
        return this.DELIM[1];
    }

    private int getXVENTLength() {
        return this.XVENT[1];
    }

    private int getFILLER_ALength() {
        return this.FILLER_A[1];
    }

    private int getSUITEMLength() {
        return this.SUITEM[1];
    }

    private int getTVPARLength() {
        return this.TVPAR[1];
    }

    private int getXINDMLength() {
        return this.XINDM[1];
    }

    private int getFILLER_BLength() {
        return this.FILLER_B[1];
    }

    private int getB1UNBLength() {
        return this.B1UNB[1];
    }

    private int getB1UNLength() {
        return this.B1UN[1];
    }

    private int getB3UNBLength() {
        return this.B3UNB[1];
    }

    private int getB3UNLength() {
        return this.B3UN[1];
    }

    public void setNULIM(String value) {
        String str = "00" + value;
        super.setNULIM(str.substring(str.length() - this.getNULIMLength()));
    }

    public void setFILLER(String value) {
        super.setFILLER((value + _BLANCS).substring(0, this.getFILLERLength()));
    }

    public void setPROGR(String value) {
        super.setPROGR((value + _BLANCS).substring(0, this.getPROGRLength()));
    }

    public void setNOMEN(String value) {
        super.setNOMEN((value + _BLANCS).substring(0, this.getNOMENLength()));
    }

    public void setZOPAR(String value) {
        super.setZOPAR((value + _BLANCS).substring(0, this.getZOPARLength()));
    }

    public void setDELIM(String value) {
        super.setDELIM((value + _BLANCS).substring(0, this.getDELIMLength()));
    }

    public void setXVENT(String value) {
        super.setXVENT((value + _BLANCS).substring(0, this.getXVENTLength()));
    }

    public void setFILLER_A(String value) {
        super.setFILLER_A((value + _BLANCS).substring(0, this.getFILLER_ALength()));
    }

    public void setSUITEM(String value) {
        super.setSUITEM((value + _BLANCS).substring(0, this.getSUITEMLength()));
    }

    public void setTVPAR(String value) {
        super.setTVPAR((value + _BLANCS).substring(0, this.getTVPARLength()));
    }

    public void setXINDM(String value) {
        super.setXINDM((value + _BLANCS).substring(0, this.getXINDMLength()));
    }

    public void setFILLER_B(String value) {
        super.setFILLER_B((value + _BLANCS).substring(0, this.getFILLER_BLength()));
    }

    public void setB1UNB(String value) {
        super.setB1UNB((value + _BLANCS).substring(0, this.getB1UNBLength()));
    }

    public void setB1UN(String value) {
        super.setB1UN((value + _BLANCS).substring(0, this.getB1UNLength()));
    }

    public void setB3UNB(String value) {
        super.setB3UNB((value + _BLANCS).substring(0, this.getB3UNBLength()));
    }

    public void setB3UN(String value) {
        super.setB3UN((value + _BLANCS).substring(0, this.getB3UNLength()));
    }

    public W3CommonDescription getW3Header() {
        return this.w3Header;
    }
}

