/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.w3LineDescription;

import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCDLineDataStructure;
import com.ibm.pdp.mdl.pacbase.PacCDLineReport;
import com.ibm.pdp.mdl.pacbase.PacOrganizationValues;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacReportCall;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CDLineInterace;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3CommonDescription;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3Interface;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3CDLineImpl;

public class W3CDLine
extends W3CDLineImpl
implements W3Interface,
W3CDLineInterace {
    private W3CommonDescription w3Header = null;
    protected PacProgram programToGenerate;
    protected PacCDLineDataStructure currentCDDataStructureline;
    protected PacCDLineReport currentCDReport;
    protected PacReportCall currentCodeReport;
    protected PacbaseLinksEntitiesService ples;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public W3CDLine(PacProgram pgm, PacCDLineDataStructure aCDDataStructure, PacbaseLinksEntitiesService pacbaseLinkEntityService) {
        this.programToGenerate = pgm;
        this.ples = pacbaseLinkEntityService;
        this.w3Header = new W3CommonDescription(pgm);
        this.currentCDDataStructureline = aCDDataStructure;
        this.initWithCDLineDataStructure();
    }

    public W3CDLine(PacProgram pgm, PacCDLineReport aCDReport, PacReportCall aReportCall) {
        this.programToGenerate = pgm;
        this.w3Header = new W3CommonDescription(pgm);
        this.currentCDReport = aCDReport;
        this.currentCodeReport = aReportCall;
        this.initToSpace();
        this.initWithPacCDLineReport();
    }

    private void initWithPacCDLineReport() {
        if (this.currentCodeReport.getReport().getName().length() > 0) {
            this.w3Header.setB2_Value(this.currentCodeReport.getReport().getName().substring(0, 2));
        }
        this.w3Header.setB3A_Value("H");
        this.w3Header.setB5_Value(this.currentCDReport.getCommonDescription().getCodeInProgram());
        this.w3Header.setB4_Value(this.programToGenerate.getName());
        this.w3Header.setCOCA_Value("1");
        this.w3Header.setIED_Value("08");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setCOFIC(String.valueOf(this.currentCDReport.getCommonDescription().getCodeInProgram()));
        if (this.currentCodeReport.getReport().getName().length() > 0) {
            this.setCOFCB(this.currentCodeReport.getReport().getName().substring(0, 2));
        }
        this.setNOEXT(this.currentCDReport.getExternalName());
        this.setORGAN(String.valueOf(this.currentCDReport.getCommonDescription().getOrganization()).substring(1));
        this.setACCES(String.valueOf(this.currentCDReport.getAccessMode()).substring(1));
        this.setRECMO(String.valueOf(this.currentCDReport.getCommonDescription().getBlockMode()).substring(1));
        this.setOUVER(String.valueOf(this.currentCDReport.getIOMode()).substring(1));
        this.setUNITE(String.valueOf(this.currentCDReport.getUnitType()).substring(1));
        this.setBLOCK(String.valueOf(this.currentCDReport.getBlockFactor()));
        this.setTYBLO(String.valueOf(this.currentCDReport.getBlockType()).substring(1));
        this.setNBCOU("0");
        this.setNBSYN("0");
        this.setUTFIC(this.currentCDReport.getUsage().getLiteral().substring(1));
        this.setCOSTR(_BLANCS);
        this.setNIVGR("0");
        this.setLOMAX("00000");
        this.setDOSNU(this.currentCDReport.getPhysicalUnitType());
        this.setDOSLP(this.currentCDReport.getPhysicalUnitTypeComplement().getLiteral().substring(1));
        this.setREKEY(this.currentCDReport.getAccessKeyDataElementCode());
        String suffixCodeInPgm = this.currentCodeReport.getSuffixInProgram();
        if (this.currentCodeReport.getReport().getName().length() > 0) {
            String suffixCodeEtat = this.currentCodeReport.getReport().getName().substring(2);
            if (!suffixCodeInPgm.equals(suffixCodeEtat)) {
                this.setARGUM(suffixCodeEtat + "=" + suffixCodeInPgm);
            } else {
                this.setARGUM(suffixCodeEtat);
            }
        }
        this.setTYPIC(String.valueOf(this.currentCDReport.getCommonDescription().getFormatType()).substring(1));
        this.setNIVEN(String.valueOf(this.currentCDReport.getCommonDescription().getCobolRecordLevel()).substring(1));
        this.setEMPLA("00");
        this.setPROGR(this.programToGenerate.getName());
        this.setB1UN("H");
        this.setB3UN("J");
        this.setNUORSD("00");
    }

    private void initWithCDLineDataStructure() {
        this.w3Header.setB3A_Value("H");
        this.w3Header.setB5_Value("currentCDDataStructureline.getCommonDescription().getCodeInProgram()");
        this.w3Header.setCOCA_Value("1");
        this.w3Header.setIED_Value("08");
        this.setPartieCommune(this.w3Header.getCommonSegmentValue().toString());
        this.setCOFIC(String.valueOf(this.currentCDDataStructureline.getCommonDescription().getCodeInProgram()));
        this.setNOEXT(this.currentCDDataStructureline.getExternalName());
        this.setORGAN(String.valueOf(this.currentCDDataStructureline.getCommonDescription().getOrganization()).substring(1));
        this.setACCES(String.valueOf(this.currentCDDataStructureline.getAccessMode()).substring(1));
        this.setRECMO(String.valueOf(this.currentCDDataStructureline.getCommonDescription().getBlockMode()).substring(1));
        this.setOUVER(String.valueOf(this.currentCDDataStructureline.getIOMode()).substring(1));
        this.setUNITE(String.valueOf(this.currentCDDataStructureline.getUnitType()).substring(1));
        this.setBLOCK(String.valueOf(this.currentCDDataStructureline.getBlockFactor()));
        this.setTYBLO(String.valueOf(this.currentCDDataStructureline.getBlockType()).substring(1));
        this.setNOKEY(this.currentCDDataStructureline.getFileStatus());
        if (this.currentCDDataStructureline.getCommonDescription().getOrganization().equals(PacOrganizationValues._Y_LITERAL)) {
            String nameServer = this.currentCDDataStructureline.getExternalName();
            String externalNameServer = "";
            RadicalEntity obj = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.programToGenerate, (String)nameServer, (String)"pacserver", (PacbaseLinksEntitiesService)this.ples);
            if (obj instanceof PacServer) {
                PacServer currentserver = (PacServer)obj;
                externalNameServer = currentserver.getProgramExternalName();
            }
            this.setNOKEY(externalNameServer);
        }
        this.setREKEY(this.currentCDDataStructureline.getAccessKeyDataElementCode());
        this.setNBCOU(String.valueOf(this.currentCDDataStructureline.getBreakLevel()));
        this.setNBSYN(String.valueOf(this.currentCDDataStructureline.getSyncLevel()));
        this.setUTFIC(this.currentCDDataStructureline.getUsage().getLiteral().substring(1));
        this.setCOSTR(this.currentCDDataStructureline.getRecordTypeDataElementCode());
        this.setCOFIR(String.valueOf(this.currentCDDataStructureline.getResultDataStructureCode()));
        this.setCOFIS(String.valueOf(this.currentCDDataStructureline.getSourceDataStructureCode()));
        this.setNIVGR(String.valueOf(this.currentCDDataStructureline.getTransactionBreakLevel()));
        this.setLOMAX("00000");
        this.setDOSNU(this.currentCDDataStructureline.getPhysicalUnitType());
        if (String.valueOf(this.currentCDDataStructureline.getPhysicalUnitTypeComplement()).equals("_None")) {
            this.setDOSLP(_BLANCS);
        } else {
            this.setDOSLP(String.valueOf(this.currentCDDataStructureline.getPhysicalUnitTypeComplement()).substring(1));
        }
        this.setARGUM(this.currentCDDataStructureline.getSortKeys());
        this.setTYPIC(String.valueOf(this.currentCDDataStructureline.getCommonDescription().getFormatType()).substring(1));
        this.setPRVER(String.valueOf(this.currentCDDataStructureline.getCommonDescription().getSubScheme()));
        if (String.valueOf(this.currentCDDataStructureline.getCommonDescription().getGeneratedDescriptionType()).equals("_None")) {
            this.setTYDES(_BLANCS);
        } else {
            this.setTYDES(String.valueOf(this.currentCDDataStructureline.getCommonDescription().getGeneratedDescriptionType()).substring(1));
        }
        this.setNIVEN(String.valueOf(this.currentCDDataStructureline.getCommonDescription().getCobolRecordLevel()).substring(1));
        this.setEMPLA("00");
        this.setSUIT1(_BLANCS);
        this.setPROGR(this.programToGenerate.getName());
        this.setETPRO(_BLANCS);
        this.setFICHP(_BLANCS);
        this.setNOMEN(_BLANCS);
        if (String.valueOf(this.currentCDDataStructureline.getUsage().getLiteral().substring(1)).equals("I") || String.valueOf(this.currentCDDataStructureline.getUsage().getLiteral().substring(1)).equals("J")) {
            this.setB1UN("H");
            this.setB3UN("J");
        } else {
            this.setB1UN("F");
            this.setB3UN("R");
        }
        this.setINGADR(_BLANCS);
        this.setNUORSD("00");
        this.setNUVERB(_BLANCS);
        this.setTYBLO2(_BLANCS);
        this.setDESCA(_BLANCS);
        this.setVARIA(_BLANCS);
    }

    private void initToSpace() {
        this.setCOFIC(_BLANCS);
        this.setCOFCB(_BLANCS);
        this.setNOEXT(_BLANCS);
        this.setORGAN(_BLANCS);
        this.setACCES(_BLANCS);
        this.setRECMO(_BLANCS);
        this.setOUVER(_BLANCS);
        this.setUNITE(_BLANCS);
        this.setBLOCK(_BLANCS);
        this.setTYBLO(_BLANCS);
        this.setNOKEY(_BLANCS);
        this.setREKEY(_BLANCS);
        this.setNBCOU(_BLANCS);
        this.setNBSYN(_BLANCS);
        this.setUTFIC(_BLANCS);
        this.setCOSTR(_BLANCS);
        this.setCOFIR(_BLANCS);
        this.setCOFIS(_BLANCS);
        this.setNIVGR(_BLANCS);
        this.setLOMAX(_BLANCS);
        this.setDOSNU(_BLANCS);
        this.setDOSLP(_BLANCS);
        this.setARGUM(_BLANCS);
        this.setTYPIC(_BLANCS);
        this.setPRVER(_BLANCS);
        this.setTYDES(_BLANCS);
        this.setNIVEN(_BLANCS);
        this.setEMPLA(_BLANCS);
        this.setSUIT1(_BLANCS);
        this.setPROGR(_BLANCS);
        this.setETPRO(_BLANCS);
        this.setFICHP(_BLANCS);
        this.setNOMEN(_BLANCS);
        this.setB1UN(_BLANCS);
        this.setB3UN(_BLANCS);
        this.setINGADR(_BLANCS);
        this.setNUORSD(_BLANCS);
        this.setNUVERB(_BLANCS);
        this.setTYBLO2(_BLANCS);
        this.setDESCA(_BLANCS);
        this.setVARIA(_BLANCS);
    }

    private int getCOFICLength() {
        return COFIC[1];
    }

    private int getCOFCBLength() {
        return COFCB[1];
    }

    private int getNOEXTLength() {
        return NOEXT[1];
    }

    private int getORGANLength() {
        return ORGAN[1];
    }

    private int getACCESLength() {
        return ACCES[1];
    }

    private int getRECMOLength() {
        return RECMO[1];
    }

    private int getOUVERLength() {
        return OUVER[1];
    }

    private int getUNITELength() {
        return UNITE[1];
    }

    private int getBLOCKLength() {
        return BLOCK[1];
    }

    private int getTYBLOLength() {
        return TYBLO[1];
    }

    private int getNOKEYLength() {
        return NOKEY[1];
    }

    private int getREKEYLength() {
        return REKEY[1];
    }

    private int getNBCOULength() {
        return NBCOU[1];
    }

    private int getNBSYNLength() {
        return NBSYN[1];
    }

    private int getUTFICLength() {
        return UTFIC[1];
    }

    private int getCOSTRLength() {
        return COSTR[1];
    }

    private int getCOFIRLength() {
        return COFIR[1];
    }

    private int getCOFISLength() {
        return COFIS[1];
    }

    private int getNIVGRLength() {
        return NIVGR[1];
    }

    private int getLOMAXLength() {
        return LOMAX[1];
    }

    private int getDOSNULength() {
        return DOSNU[1];
    }

    private int getDOSLPLength() {
        return DOSLP[1];
    }

    private int getARGUMLength() {
        return ARGUM[1];
    }

    private int getTYPICLength() {
        return TYPIC[1];
    }

    private int getPRVERLength() {
        return PRVER[1];
    }

    private int getTYDESLength() {
        return TYDES[1];
    }

    private int getNIVENLength() {
        return NIVEN[1];
    }

    private int getEMPLALength() {
        return EMPLA[1];
    }

    private int getSUIT1Length() {
        return SUIT1[1];
    }

    private int getPROGRLength() {
        return PROGR[1];
    }

    private int getETPROLength() {
        return ETPRO[1];
    }

    private int getFICHPLength() {
        return FICHP[1];
    }

    private int getNOMENLength() {
        return NOMEN[1];
    }

    private int getB1UNLength() {
        return B1UN[1];
    }

    private int getB3UNLength() {
        return B3UN[1];
    }

    private int getINGADRLength() {
        return INGADR[1];
    }

    private int getNUORSDLength() {
        return NUORSD[1];
    }

    private int getNUVERBLength() {
        return NUVERB[1];
    }

    private int getTYBLO2Length() {
        return TYBLO2[1];
    }

    private int getDESCALength() {
        return DESCA[1];
    }

    private int getVARIALength() {
        return VARIA[1];
    }

    public void setCOFIC(String value) {
        super.setCOFIC((value + _BLANCS).substring(0, this.getCOFICLength()));
    }

    public void setCOFCB(String value) {
        super.setCOFCB((value + _BLANCS).substring(0, this.getCOFCBLength()));
    }

    public void setNOEXT(String value) {
        super.setNOEXT((value + _BLANCS).substring(0, this.getNOEXTLength()));
    }

    public void setORGAN(String value) {
        super.setORGAN((value + _BLANCS).substring(0, this.getORGANLength()));
    }

    public void setACCES(String value) {
        super.setACCES((value + _BLANCS).substring(0, this.getACCESLength()));
    }

    public void setRECMO(String value) {
        super.setRECMO((value + _BLANCS).substring(0, this.getRECMOLength()));
    }

    public void setOUVER(String value) {
        super.setOUVER((value + _BLANCS).substring(0, this.getOUVERLength()));
    }

    public void setUNITE(String value) {
        super.setUNITE((value + _BLANCS).substring(0, this.getUNITELength()));
    }

    public void setBLOCK(String value) {
        String str = "0000" + value;
        super.setBLOCK(str.substring(str.length() - this.getBLOCKLength()));
    }

    public void setTYBLO(String value) {
        super.setTYBLO((value + _BLANCS).substring(0, this.getTYBLOLength()));
    }

    public void setNOKEY(String value) {
        super.setNOKEY((value + _BLANCS).substring(0, this.getNOKEYLength()));
    }

    public void setREKEY(String value) {
        super.setREKEY((value + _BLANCS).substring(0, this.getREKEYLength()));
    }

    public void setNBCOU(String value) {
        super.setNBCOU((value + _BLANCS).substring(0, this.getNBCOULength()));
    }

    public void setNBSYN(String value) {
        super.setNBSYN((value + _BLANCS).substring(0, this.getNBSYNLength()));
    }

    public void setUTFIC(String value) {
        super.setUTFIC((value + _BLANCS).substring(0, this.getUTFICLength()));
    }

    public void setCOSTR(String value) {
        super.setCOSTR((value + _BLANCS).substring(0, this.getCOSTRLength()));
    }

    public void setCOFIR(String value) {
        super.setCOFIR((value + _BLANCS).substring(0, this.getCOFIRLength()));
    }

    public void setCOFIS(String value) {
        super.setCOFIS((value + _BLANCS).substring(0, this.getCOFISLength()));
    }

    public void setNIVGR(String value) {
        super.setNIVGR((value + _BLANCS).substring(0, this.getNIVGRLength()));
    }

    public void setLOMAX(String value) {
        super.setLOMAX((value + _BLANCS).substring(0, this.getLOMAXLength()));
    }

    public void setDOSNU(String value) {
        super.setDOSNU((value + _BLANCS).substring(0, this.getDOSNULength()));
    }

    public void setDOSLP(String value) {
        super.setDOSLP((value + _BLANCS).substring(0, this.getDOSLPLength()));
    }

    public void setARGUM(String value) {
        super.setARGUM((value + _BLANCS).substring(0, this.getARGUMLength()));
    }

    public void setTYPIC(String value) {
        super.setTYPIC((value + _BLANCS).substring(0, this.getTYPICLength()));
    }

    public void setPRVER(String value) {
        super.setPRVER((value + _BLANCS).substring(0, this.getPRVERLength()));
    }

    public void setTYDES(String value) {
        super.setTYDES((value + _BLANCS).substring(0, this.getTYDESLength()));
    }

    public void setNIVEN(String value) {
        super.setNIVEN((value + _BLANCS).substring(0, this.getNIVENLength()));
    }

    public void setEMPLA(String value) {
        super.setEMPLA((value + _BLANCS).substring(0, this.getEMPLALength()));
    }

    public void setSUIT1(String value) {
        super.setSUIT1((value + _BLANCS).substring(0, this.getSUIT1Length()));
    }

    public void setPROGR(String value) {
        super.setPROGR((value + _BLANCS).substring(0, this.getPROGRLength()));
    }

    public void setETPRO(String value) {
        super.setETPRO((value + _BLANCS).substring(0, this.getETPROLength()));
    }

    public void setFICHP(String value) {
        super.setFICHP((value + _BLANCS).substring(0, this.getFICHPLength()));
    }

    public void setNOMEN(String value) {
        super.setNOMEN((value + _BLANCS).substring(0, this.getNOMENLength()));
    }

    public void setB1UN(String value) {
        super.setB1UN((value + _BLANCS).substring(0, this.getB1UNLength()));
    }

    public void setB3UN(String value) {
        super.setB3UN((value + _BLANCS).substring(0, this.getB3UNLength()));
    }

    public void setINGADR(String value) {
        super.setINGADR((value + _BLANCS).substring(0, this.getINGADRLength()));
    }

    public void setNUORSD(String value) {
        super.setNUORSD((value + _BLANCS).substring(0, this.getNUORSDLength()));
    }

    public void setNUVERB(String value) {
        super.setNUVERB((value + _BLANCS).substring(0, this.getNUVERBLength()));
    }

    public void setTYBLO2(String value) {
        super.setTYBLO2((value + _BLANCS).substring(0, this.getTYBLO2Length()));
    }

    public void setDESCA(String value) {
        super.setDESCA((value + _BLANCS).substring(0, this.getDESCALength()));
    }

    public void setVARIA(String value) {
        super.setVARIA((value + _BLANCS).substring(0, this.getVARIALength()));
    }

    public W3CommonDescription getW3Header() {
        return this.w3Header;
    }
}

