/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.pacmodeltow3model;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.macro.pacbase.merge.Merge;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacProgramVariantValues;
import com.ibm.pdp.mdl.pacbase.util.PacProgramWrapper;
import com.ibm.pdp.pacbase.generate.DefaultPacbaseGenerationImplementation;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.pacbase.generate.util.PacbaseProcessBuilder;
import com.ibm.pdp.pacbase.util.EBCDICCompare;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.w3.generate.analyser.pacmodeltow3model.PacToW3Model;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import org.eclipse.core.resources.ResourcesPlugin;

public class PacbaseGeneration
extends DefaultPacbaseGenerationImplementation {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    static final String _BLANCS = new String("                                                  ");
    private PacProgram program;
    private String destination;
    private PacToW3Model p2w3model = null;
    private String w1SortedFileName = "";
    private String w2SortedFileName = "";
    private static String w3CmdFile = isUnix ? "/../../script_linux/ScriptGprt35.sh" : "/ScriptGprt35.cmd";
    public static String _W3FILE_EXTENSION = ".w3";
    public static String _W1FILE_EXTENSION = ".w1";
    public static String _W2FILE_EXTENSION = ".w2";
    private ArrayList<StringBuilder> W3LinesToWrite = new ArrayList();
    TreeMap<String, List<String>> paramsTable;
    private static boolean isDirectExecCommand = true;
    final Comparator epCmp = new Comparator(){

        public int compare(StringBuilder o1, StringBuilder o2) {
            String st1 = o1.substring(0, 44);
            String st2 = o2.substring(0, 44);
            return EBCDICCompare.stringCompare((String)st1, (String)st2);
        }

        public int compare(Object o1, Object o2) {
            return this.compare((StringBuilder)o1, (StringBuilder)o2);
        }
    };

    static {
        isDirectExecCommand = !isUnix && "true".equals(System.getProperty("isDirectExecCommand"));
    }

    public PacbaseGeneration(String patternName, PacProgram pgm, String dest, String macroSource) {
        this.patternName = patternName;
        this.program = new PacProgramWrapper(pgm);
        this.destination = dest;
        this.virtualMacroSource = macroSource;
        int resolMode = PTEditorService.getResolvingMode();
        PTEditorService.setResolvingMode((int)3);
        this.init();
        PTEditorService.setResolvingMode((int)resolMode);
    }

    private void init() {
        this.findAndGetW3Lines();
        this.vapCobolGeneration();
        this.paramsTable = new TreeMap();
        for (Object obj : this.program.getCPLines()) {
            if (!(obj instanceof PacCPLine)) continue;
            PacCPLine cpLine = (PacCPLine)obj;
            this.paramsTable.put(PacbaseModelService.getInstance().getCPLineIdentifier(cpLine), PacbaseModelService.getInstance().formatCallCP(cpLine));
            this.p2w3model.getPacLinksEntitiesService().registerReference((RadicalEntity)cpLine.getMacro());
        }
        String path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        Merge merge = new Merge();
        merge.mergeFromFiles(this.cblgenFileName, this.paramsTable, path, "batch", (RadicalEntity)this.program, this.p2w3model.getPacLinksEntitiesService(), this.virtualMacroSource);
        if (PTTraceManager.getInstance().getTraceLevel("com.ibm.pdp.pac") > 0) {
            this.writeClbgenAfterMacroCalls(merge.getPublicationResult());
        }
        this.generatedInfo = merge.getNodeTreeConverter((RadicalEntity)this.program);
        if (this.program.getVariante().equals(PacProgramVariantValues._C_LITERAL)) {
            this.generatedInfo.setProperty("Reconcile", "false");
        }
        this.genericProblems = merge.getMergeProblems();
        this.ntiList = merge.getNodeTagInformations();
    }

    protected void vapCobolGeneration() {
        try {
            String[] command = this.getCommandLineForgenerator();
            PacbaseProcessBuilder pb = null;
            if (isDirectExecCommand) {
                HashMap<String, Object> env = new HashMap<String, Object>();
                env.put("COBPATH", ".");
                env.put("PAC7SC", "SC" + command[8]);
                env.put("PAC7GP", command[4]);
                env.put("PAC7W5", command[6]);
                env.put("PAC7W6", command[7]);
                env.put("PAC7TA", command[3] + "\\" + command[2] + ".TA");
                env.put("PAC7W1", command[3] + "\\" + command[2] + ".W1");
                env.put("PAC7W2", command[3] + "\\" + command[2] + ".W2");
                env.put("PAC7WC", command[3] + "\\" + command[2] + ".WC");
                env.put("PAC7W4", "PAC7W4");
                env.put("PAC7WB", command[3] + "\\" + command[2] + ".WB");
                env.put("PAC7AT", command[5]);
                env.put("PAC7EP", command[3] + "\\" + command[2] + ".EP");
                env.put("PAC7CR", command[3] + "\\" + command[2] + ".CR");
                String[] exeCommand = new String[]{command[1] + "/BVPACBW.EXE"};
                pb = PacbaseModelService.getInstance().instanciateProcess(exeCommand, env, command[1]);
            } else {
                pb = PacbaseModelService.getInstance().instanciateProcess(command);
            }
            pb.start();
            Thread out = new Thread((Runnable)new DefaultPacbaseGenerationImplementation.Threader(pb.getInputStream(), "output stream "));
            Thread err = new Thread((Runnable)new DefaultPacbaseGenerationImplementation.Threader(pb.getErrorStream(), "error stream "));
            out.start();
            err.start();
            pb.waitFor();
            if (isDirectExecCommand) {
                new File(command[3] + "/" + command[2] + ".CR").deleteOnExit();
                new File(command[3] + "/" + command[2] + ".TA").deleteOnExit();
                new File(command[3] + "/" + command[2] + ".W1").deleteOnExit();
                new File(command[3] + "/" + command[2] + ".W2").deleteOnExit();
                new File(command[3] + "/" + command[2] + ".WC").deleteOnExit();
                new File(command[3] + "/" + command[2] + ".WB").deleteOnExit();
                new File(command[3] + "/" + command[2] + ".EP").deleteOnExit();
            }
        }
        catch (Exception exception) {
            Util.rethrow((Throwable)exception);
        }
    }

    protected String[] getCommandLineForgenerator() {
        String cblFileName;
        String[] cmd = new String[]{"", "", "", "", "", "", "", "", "", ""};
        String userdir1 = PacbaseModelService.getInstance().getCommandFileForGeneration("/data/generator").getAbsolutePath();
        cmd[0] = userdir1 + File.separator + w3CmdFile;
        cmd[1] = userdir1;
        cmd[2] = Util.GetRandomString((int)6);
        String tempdir = System.getProperty("java.io.tmpdir");
        int end = tempdir.length();
        cmd[3] = isUnix ? tempdir : tempdir.substring(0, --end);
        cmd[4] = cblFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("program", ".cbl", true).getAbsolutePath();
        cmd[5] = this.cblgenFileName = PacbaseModelService.getInstance().createTmpFileForGeneration("program", ".cblgen", true).getAbsolutePath();
        cmd[6] = this.w1SortedFileName;
        cmd[7] = this.w2SortedFileName;
        cmd[8] = this.program.getSkeletonLanguage().getLiteral().substring(1);
        cmd[9] = userdir1.substring(0, 2);
        return cmd;
    }

    public PacProgram getProgram() {
        return this.program;
    }

    private String getProject() {
        return this.destination;
    }

    public PacbaseLinksEntitiesService getReferencedEntities() {
        return this.p2w3model.getPacLinksEntitiesService();
    }

    private void findAndGetW3Lines() {
        try {
            this.p2w3model = new PacToW3Model(this.patternName, this.getProject(), this.getProgram());
            this.W3LinesToWrite = this.p2w3model.getW3Lines();
            this.sortW3File(this.p2w3model);
            this.writeW3File(this.p2w3model);
        }
        catch (Exception ex) {
            Util.rethrow((Throwable)ex);
        }
    }

    private void sortW3File(PacToW3Model p2w3) {
        TreeSet<StringBuilder> li = new TreeSet<StringBuilder>(this.epCmp);
        li.addAll(this.W3LinesToWrite);
        Object[] epArray = li.toArray();
        this.W3LinesToWrite.clear();
        int j = 0;
        while (j < epArray.length) {
            try {
                StringBuilder ep = (StringBuilder)epArray[j];
                this.W3LinesToWrite.add(ep);
            }
            catch (Exception exception) {
                System.out.println("Problem on the sort");
                return;
            }
            ++j;
        }
    }

    private void writeW3File(PacToW3Model p2w3) {
        File file = PacbaseModelService.getInstance().createTmpFileForGeneration("program", true);
        this.w1SortedFileName = file.getAbsolutePath();
        File file2 = PacbaseModelService.getInstance().createTmpFileForGeneration("program", true);
        this.w2SortedFileName = file2.getAbsolutePath();
        try {
            FileWriter fileOutStream1 = new FileWriter(file);
            PrintWriter w1OutStream = new PrintWriter(fileOutStream1);
            FileWriter fileOutStream2 = new FileWriter(file2);
            PrintWriter w2OutStream = new PrintWriter(fileOutStream2);
            StringBuilder linePrior = new StringBuilder();
            int i = 0;
            while (i < this.W3LinesToWrite.size()) {
                StringBuilder line = this.W3LinesToWrite.get(i);
                if (!line.toString().equals(linePrior.toString())) {
                    String B3 = line.substring(17, 19);
                    String coca = line.substring(42, 44);
                    String nulim = line.substring(25, 27);
                    linePrior = line;
                    if (coca.equals("0 ") || coca.equals("R ") || coca.equals("M ") && nulim.trim().equals("00") || coca.equals("1 ") && (B3.equals("R ") || B3.equals("X ") || B3.equals("1 ")) || coca.equals("2 ") && (B3.equals("S ") || B3.equals("U ")) || coca.equals("7 ") && (B3.equals("R ") || B3.equals("X ") || B3.equals("W "))) {
                        w2OutStream.write(String.valueOf(line) + System.getProperty("line.separator"));
                        if (coca.equals("0 ")) {
                            w1OutStream.write(String.valueOf(line) + System.getProperty("line.separator"));
                        }
                    } else {
                        w1OutStream.write(String.valueOf(line) + System.getProperty("line.separator"));
                    }
                }
                ++i;
            }
            w1OutStream.close();
            w2OutStream.close();
            if (System.getProperty("ProgramGeneration.W1.junit.process") != null) {
                File jUnitFileW1 = PacbaseModelService.getInstance().createTmpFileForGeneration("program", true);
                System.setProperty("ProgramGeneration.W1.junit.process", jUnitFileW1.getCanonicalPath());
                System.out.println("Junit W1: " + jUnitFileW1.getCanonicalPath());
                PacbaseGeneration.copy(file, jUnitFileW1);
                File jUnitFileW2 = PacbaseModelService.getInstance().createTmpFileForGeneration("program", true);
                System.setProperty("ProgramGeneration.W2.junit.process", jUnitFileW2.getCanonicalPath());
                System.out.println("Junit W2: " + jUnitFileW2.getCanonicalPath());
                PacbaseGeneration.copy(file2, jUnitFileW2);
            }
        }
        catch (Exception e) {
            System.out.println("Erreur r\u00e9-\u00e9criture fichier " + file.getPath());
            e.printStackTrace();
        }
    }

    private static void copy(File source, File target) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(source);
        FileOutputStream out = new FileOutputStream(target);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }
}

