/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.pacmodeltow3model;

import com.ibm.pdp.framework.util.CharsetUtil;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.kernel.DataCall;
import com.ibm.pdp.mdl.kernel.DataUnit;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.pacbase.PacCDLineDataStructure;
import com.ibm.pdp.mdl.pacbase.PacCDLineReport;
import com.ibm.pdp.mdl.pacbase.PacDataStructureCall;
import com.ibm.pdp.mdl.pacbase.PacGLine;
import com.ibm.pdp.mdl.pacbase.PacInputAidGLine;
import com.ibm.pdp.mdl.pacbase.PacOrganizationValues;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacReportCall;
import com.ibm.pdp.mdl.pacbase.PacSegmentCall;
import com.ibm.pdp.mdl.pacbase.PacWLineDataElement;
import com.ibm.pdp.mdl.pacbase.PacWLineF;
import com.ibm.pdp.mdl.pacbase.PacWLineText;
import com.ibm.pdp.mdl.pacbase.PacbaseFactory;
import com.ibm.pdp.pacbase.generate.util.PacbaseLinksEntitiesService;
import com.ibm.pdp.pacbase.generate.util.PacbaseModelService;
import com.ibm.pdp.w3.generate.analyser.pacmodeltow3model.W3PacbaseAndKernelVisitor;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3DataElement;
import com.ibm.pdp.w3.generate.analyser.w3LineDescription.W3ProgramLine;
import com.ibm.pdp.w3.generate.mdl.W3Model.W3Program;
import com.ibm.pdp.w3.generate.mdl.W3Model.W3TextWorkingLine;
import com.ibm.pdp.w3.generate.mdl.W3Model.impl.W3LibraryImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

public class PacToW3Model {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2022.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private PacProgram generationEntryPoint;
    private String destination;
    private W3PacbaseAndKernelVisitor w3pkvisitor;
    private File w3ResultFile;
    PacbaseLinksEntitiesService ples;
    boolean _trace = false;
    String patternName;
    private ArrayList<StringBuilder> W3Lines = new ArrayList();

    public static List<PacSegmentCall> getSegmentCalls(PacCDLineDataStructure pCDLineDS, PacDataStructureCall pDataStructureCall) {
        ArrayList<PacSegmentCall> list;
        block4: {
            block5: {
                list = new ArrayList<PacSegmentCall>();
                if (pDataStructureCall.getSegmentCalls().size() != 0) break block5;
                DataUnit pDS = pDataStructureCall.getDataStructure();
                EList segmentDataCall = pDS.getComponents();
                for (Object object2 : segmentDataCall) {
                    DataAggregate segment = (DataAggregate)((DataCall)object2).getDataDefinition();
                    PacSegmentCall pSegmentCall = PacbaseFactory.eINSTANCE.createPacSegmentCall();
                    pSegmentCall.setSegment(segment);
                    pSegmentCall.setCodeInProgram(segment.getName().substring(2));
                    list.add(pSegmentCall);
                }
                break block4;
            }
            EList segmentCalls = pDataStructureCall.getSegmentCalls();
            boolean zeroIsselected = false;
            for (Object object : segmentCalls) {
                DataAggregate dag = ((PacSegmentCall)object).getSegment();
                if (dag.eIsProxy() || dag == null || dag.getName().length() <= 0) continue;
                if (dag.getName().substring(2).equals("00")) {
                    zeroIsselected = true;
                }
                list.add((PacSegmentCall)object);
            }
            if (zeroIsselected) break block4;
            DataUnit pDS = pDataStructureCall.getDataStructure();
            EList segmentDataCall = pDS.getComponents();
            for (Object object1 : segmentDataCall) {
                DataAggregate segment = (DataAggregate)((DataCall)object1).getDataDefinition();
                if (!segment.getName().substring(2).equals("00")) continue;
                PacSegmentCall pSegmentCall = PacbaseFactory.eINSTANCE.createPacSegmentCall();
                pSegmentCall.setSegment(segment);
                pSegmentCall.setCodeInProgram(segment.getName().substring(2));
                list.add(pSegmentCall);
                break;
            }
        }
        return list;
    }

    public PacToW3Model(IProject proj, PacProgram pgm) {
        this.generationEntryPoint = pgm;
        this.initReferencedProgram();
        this.transformToW3Model();
    }

    public PacToW3Model(String patternName, String dest, PacProgram pgm) {
        this.patternName = patternName;
        this.destination = dest;
        this.generationEntryPoint = pgm;
        this.initReferencedProgram();
        this.transformToW3Model();
    }

    private void initReferencedProgram() {
    }

    private void transformToW3Model() {
        this.scanPacbaseModel();
        this.computeAndSaveLengthAndPosition((W3Program)this.w3pkvisitor.getCurrentW3program());
        try {
            this.createW3Lines();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void handleException(Exception exc) {
        System.out.println("*** ERROR ***");
        exc.printStackTrace();
        System.out.println("*** ***** ***");
    }

    private void scanPacbaseModel() {
        this.w3pkvisitor = new W3PacbaseAndKernelVisitor(this.getPacLinksEntitiesService());
        this.w3pkvisitor.doSwitch((EObject)this.generationEntryPoint);
        this.w3pkvisitor.doSwitch((EObject)this.generationEntryPoint.getGenerationParameter());
        for (Object obj : this.generationEntryPoint.getGCLines()) {
            if (obj instanceof PacInputAidGLine) {
                this.processIAGCLine((PacInputAidGLine)obj);
                continue;
            }
            if (obj instanceof PacGLine) {
                this.processGCLine((PacGLine)obj);
                continue;
            }
            System.out.println("generateW3File: c koi cte -GC line ???" + obj.getClass().toString());
        }
        for (Object obj : this.generationEntryPoint.getGOLines()) {
            if (obj instanceof PacInputAidGLine) {
                this.processIAGOLine((PacInputAidGLine)obj);
                continue;
            }
            if (obj instanceof PacGLine) {
                this.processGOLine((PacGLine)obj);
                continue;
            }
            System.out.println("generateW3File: c koi cte -GO line ???" + obj.getClass().toString());
        }
        for (Object obj : this.generationEntryPoint.getCDLines()) {
            if (obj instanceof PacCDLineDataStructure) {
                this.processCDLine((PacCDLineDataStructure)obj);
                continue;
            }
            if (obj instanceof PacCDLineReport) {
                this.processCDLine((PacCDLineReport)obj);
                continue;
            }
            System.out.println("generateW3File: c koi cte CD line ???" + obj.getClass().toString());
        }
        for (Object obj : this.generationEntryPoint.getWLines()) {
            if (obj instanceof PacWLineText) {
                this.w3pkvisitor.doSwitch((EObject)((PacWLineText)obj));
                continue;
            }
            if (obj instanceof PacWLineDataElement) {
                this.w3pkvisitor.doSwitch((EObject)((PacWLineDataElement)obj));
                continue;
            }
            if (!(obj instanceof PacWLineF)) continue;
            this.processCDLine((PacWLineF)obj);
        }
    }

    private void processGCLine(PacGLine gcLine) {
        this.w3pkvisitor.setIsGCLine(true);
        this.w3pkvisitor.doSwitch((EObject)gcLine);
        this.w3pkvisitor.setIsGCLine(false);
    }

    private void processIAGCLine(PacInputAidGLine iagcLine) {
        this.w3pkvisitor.setIsGCLine(true);
        this.w3pkvisitor.doSwitch((EObject)iagcLine);
        this.w3pkvisitor.setIsGCLine(false);
    }

    private void processGOLine(PacGLine goLine) {
        this.w3pkvisitor.doSwitch((EObject)goLine);
    }

    private void processIAGOLine(PacInputAidGLine iagoLine) {
        this.w3pkvisitor.doSwitch((EObject)iagoLine);
    }

    private void processCDLine(PacCDLineDataStructure cdLineDS) {
        this.w3pkvisitor.setNameOfProject(this.destination);
        this.w3pkvisitor.doSwitch((EObject)cdLineDS);
        if (!cdLineDS.getCommonDescription().getOrganization().equals(PacOrganizationValues._X_LITERAL) && !cdLineDS.getCommonDescription().getOrganization().equals(PacOrganizationValues._Y_LITERAL)) {
            for (PacDataStructureCall aDsCall : cdLineDS.getDataStructureCalls()) {
                DataUnit ds = aDsCall.getDataStructure();
                this.w3pkvisitor.doSwitch((EObject)ds);
                for (PacSegmentCall aSegmentCall : PacToW3Model.getSegmentCalls(cdLineDS, aDsCall)) {
                    this.w3pkvisitor.doSwitch((EObject)aSegmentCall);
                }
            }
        }
    }

    private void processCDLine(PacCDLineReport cdLineReport) {
        this.w3pkvisitor.doSwitch((EObject)cdLineReport);
        if (!cdLineReport.getCommonDescription().getOrganization().equals(PacOrganizationValues._X_LITERAL)) {
            for (PacReportCall aReportCall : cdLineReport.getReportCalls()) {
                this.w3pkvisitor.doSwitch((EObject)aReportCall);
            }
        }
    }

    private void processCDLine(PacWLineF wLineF) {
        String typeEntiteDU;
        this.w3pkvisitor.setIsWLineF(true);
        this.w3pkvisitor.doSwitch((EObject)wLineF);
        W3TextWorkingLine tl22 = null;
        for (W3TextWorkingLine tl22 : this.w3pkvisitor.getCurrentW3program().getW3textworkingline()) {
        }
        String dataStructS = tl22.getTEXT().substring(12, 14);
        RadicalEntity obj = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.generationEntryPoint, (String)dataStructS, (String)(typeEntiteDU = "dataunit"), (PacbaseLinksEntitiesService)this.ples);
        if (obj instanceof DataUnit) {
            DataUnit du = (DataUnit)obj;
            this.w3pkvisitor.doSwitch((EObject)obj);
            String segmtSelected = null;
            if (tl22.getTEXT().length() > 20) {
                segmtSelected = tl22.getTEXT().substring(20, 29);
            }
            ArrayList<Object> listOfSegment = new ArrayList<Object>();
            boolean segZeroSelected = false;
            if (segmtSelected.trim().length() > 0) {
                int i = 0;
                while (i < 7) {
                    if (!segmtSelected.substring(i, i + 1).equals("=")) {
                        int n = i + 2;
                        String codOfsegment = segmtSelected.substring(i, n);
                        if (codOfsegment.equals("00")) {
                            segZeroSelected = true;
                        }
                        if (codOfsegment.trim().length() > 0) {
                            listOfSegment.add(codOfsegment);
                        }
                        ++i;
                        ++i;
                        continue;
                    }
                    break;
                }
            } else {
                EList segmentDataCall = du.getComponents();
                for (Object e : segmentDataCall) {
                    DataAggregate segment = (DataAggregate)((DataCall)e).getDataDefinition();
                    listOfSegment.add(segment.getName().substring(2));
                }
            }
            if (!segZeroSelected) {
                listOfSegment.add("00");
            }
            for (String string : listOfSegment) {
                String typeEntiteDA = "dataaggregate";
                String codOfSegmS = dataStructS + string;
                RadicalEntity objS = PacbaseModelService.SearchRadicalEntityDuringGeneration((RadicalEntity)this.generationEntryPoint, (String)codOfSegmS, (String)typeEntiteDA, (PacbaseLinksEntitiesService)this.ples);
                if (objS instanceof DataAggregate) {
                    DataAggregate segment = (DataAggregate)objS;
                    PacSegmentCall pSegmentCall = PacbaseFactory.eINSTANCE.createPacSegmentCall();
                    pSegmentCall.setSegment(segment);
                    pSegmentCall.setCodeInProgram(segment.getName());
                    this.w3pkvisitor.doSwitch((EObject)pSegmentCall);
                    continue;
                }
                System.out.println("PacToW3Model PROBLEME LOADRESOURCE2 instanceof DataAggregate: ");
            }
        } else {
            System.out.println("PacToW3Model PROBLEME LOADRESOURCE1 instanceof DataUnit: ");
        }
        this.w3pkvisitor.setIsWLineF(false);
    }

    protected Object createW3Lines() throws Exception {
        W3ProgramLine wp = this.w3pkvisitor.getCurrentW3program();
        this.W3Lines.add(wp.toStringW3());
        for (W3LibraryImpl line : wp.getW3library()) {
            this.W3Lines.add(line.toStringW3());
        }
        for (W3LibraryImpl line : wp.getW3commentline()) {
            this.W3Lines.add(line.toStringW3());
        }
        for (W3LibraryImpl line : wp.getW3cdline()) {
            this.W3Lines.add(line.toStringW3());
        }
        for (W3LibraryImpl line : wp.getW3calledmacro()) {
            this.W3Lines.add(line.toStringW3());
        }
        for (W3LibraryImpl line : wp.getW3datastructure()) {
            this.W3Lines.add(line.toStringW3());
        }
        for (W3LibraryImpl line : wp.getW3segment()) {
            this.W3Lines.add(new StringBuilder(CharsetUtil.transformToJavaCharset((String)line.toStringW3())));
        }
        for (W3LibraryImpl line : wp.getW3dataelement()) {
            this.W3Lines.add(line.toStringW3());
        }
        for (W3LibraryImpl line : wp.getW3dataelementdocumentation()) {
            this.W3Lines.add(line.toStringW3());
        }
        for (W3LibraryImpl line : wp.getW3reportdescription()) {
            this.W3Lines.add(line.toStringW3());
        }
        for (W3LibraryImpl line : wp.getW3reportelementcall()) {
            this.W3Lines.add(line.toStringW3());
        }
        for (W3LibraryImpl line : wp.getW3report()) {
            this.W3Lines.add(line.toStringW3());
        }
        for (W3LibraryImpl line : wp.getW3reportlayout()) {
            this.W3Lines.add(line.toStringW3());
        }
        return null;
    }

    public PacbaseLinksEntitiesService getPacLinksEntitiesService() {
        if (this.ples == null) {
            this.ples = new PacbaseLinksEntitiesService(this.patternName);
        }
        return this.ples;
    }

    protected ArrayList<StringBuilder> getW3Lines() {
        return this.W3Lines;
    }

    protected void setW3ResultFile(File resultFile) {
        this.w3ResultFile = resultFile;
    }

    private void computeAndSaveLengthAndPosition(W3Program wp) {
        for (W3DataElement element : wp.getW3dataelement()) {
            int l = this.getLengthOFDataElement(element);
            element.setLORUBI(String.valueOf(l));
            if (!element.getNRURE().equals("00")) continue;
            int n = this.getNumberOfElementaryDataElements(element);
            element.setNRURE(String.valueOf(n));
            if (n >= 100) {
                element.setNRURE("99");
            }
            if (l != 0 || n != 0 || element.getPICTUI().trim().length() >= 1 || element.getTYRUB().equals("P")) continue;
            element.setNRURE("01");
        }
    }

    private int getLengthOFDataElement(W3DataElement wde) {
        int len = 0;
        Iterator<W3DataElement> iwde = wde.getW3dechildren().iterator();
        if (!iwde.hasNext()) {
            if (wde.getLORUBI().trim().length() > 0) {
                return Integer.parseInt(wde.getLORUBI());
            }
            if (this._trace) {
                System.out.println("la longueur de " + wde.getCOFIC() + wde.getNUENR() + wde.getCORUB() + " est a blanc ");
            }
        }
        while (iwde.hasNext()) {
            W3DataElement element = iwde.next();
            int len1 = this.getLengthOFDataElement(element);
            len += len1;
        }
        return len;
    }

    private int getNumberOfElementaryDataElements(W3DataElement wde) {
        int nbr = 0;
        for (W3DataElement element : wde.getW3dechildren()) {
            if (element.getW3dechildren().size() == 0) {
                ++nbr;
                continue;
            }
            nbr += this.getNumberOfElementaryDataElements(element);
        }
        return nbr;
    }
}

