/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.w3.generate.analyser.pacmodeltow3model;

public final class LengthsAndPositions {
    private int[] lengths = new int[]{-1, -1, -1, -1};
    private static final int INTERNAL_LENGTH_WITHOUT_ERROR = 0;
    private static final int INTERNAL_LENGTH_WITH_ERROR = 1;
    private static final int INPUT_LENGTH_WITHOUT_ERROR = 2;
    private static final int INPUT_LENGTH_WITH_ERROR = 3;
    private int internalPosition = -1;
    private int inputPosition = -1;
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    void addLengths(LengthsAndPositions lg) {
        int i = 0;
        while (i < this.lengths.length) {
            if (this.lengths[i] != -1) {
                if (lg.lengths[i] == -1) {
                    this.lengths[i] = -1;
                } else {
                    int n = i;
                    this.lengths[n] = this.lengths[n] + lg.lengths[i];
                }
            }
            ++i;
        }
    }

    public int getInputLengthWithError() {
        return this.lengths[3];
    }

    public int getInputLengthWithoutError() {
        return this.lengths[2];
    }

    public int getInputPosition() {
        return this.inputPosition;
    }

    public int getInternalLengthWithError() {
        return this.lengths[1];
    }

    public int getInternalLengthWithoutError() {
        return this.lengths[0];
    }

    public int getInternalPosition() {
        return this.internalPosition;
    }

    void initLengths(int initValue) {
        int i = 0;
        while (i < this.lengths.length) {
            this.lengths[i] = initValue;
            ++i;
        }
    }

    void setInputLengthWithError(int newValue) {
        this.lengths[3] = newValue;
    }

    void setInputLengthWithoutError(int newValue) {
        this.lengths[2] = newValue;
    }

    void setInputPosition(int newValue) {
        this.inputPosition = newValue;
    }

    void setInternalLengthWithError(int newValue) {
        this.lengths[1] = newValue;
    }

    void setInternalLengthWithoutError(int newValue) {
        this.lengths[0] = newValue;
    }

    void setInternalPosition(int newValue) {
        this.internalPosition = newValue;
    }

    void setLengthsMultiplyBy(LengthsAndPositions lg, int coef) {
        int i = 0;
        while (i < this.lengths.length) {
            this.lengths[i] = lg.lengths[i] < 0 ? -1 : lg.lengths[i] * coef;
            ++i;
        }
    }
}

