/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.skeleton.pattern.cobol.api;

import com.ibm.pdp.mdl.cobol.Copy;
import com.ibm.pdp.mdl.cobol.Program;
import com.ibm.pdp.mdl.skeleton.SourceCode;
import com.ibm.pdp.skeleton.framework.api.ISkeletonPredefinedPropertyExtension;
import java.util.HashMap;
import java.util.Map;

public class CobolPredefinedPropertyExtension
implements ISkeletonPredefinedPropertyExtension {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Map<String, String> getPredefinedProperties(SourceCode sourceCode) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (sourceCode instanceof Program) {
            Program program = (Program)sourceCode;
            result.put(SkeletonPredefinedProperty.PROGRAM_ID.getName(), program.getProgramId() == null ? program.getName() : program.getProgramId());
        } else if (sourceCode instanceof Copy) {
            Copy copy = (Copy)sourceCode;
            result.put(SkeletonPredefinedProperty.COPY_ID.getName(), copy.getCopyId() == null ? copy.getName() : copy.getCopyId());
        }
        return result;
    }

    public static enum SkeletonPredefinedProperty {
        PROGRAM_ID("programId"),
        COPY_ID("copyId");

        private String name;

        private SkeletonPredefinedProperty(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

