/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.screen.address.rdz.view;

import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.editor.ScreenFlatEditor;
import com.ibm.pdp.pacbase.generate.util.Field;
import com.ibm.pdp.pacbase.generate.util.ScreenAddress;
import com.ibm.pdp.screen.address.rdz.view.Activator;
import com.ibm.pdp.screen.address.rdz.view.Messages;
import com.ibm.pdp.util.Util;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class ScreenAddressView
extends ViewPart {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2017, 2021.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ScreenAddressView _instance;
    private TableViewer _tabViewer;
    private Action _linkAction;
    private Action _showErrorOnlyAction;
    protected IEclipsePreferences _prefs = InstanceScope.INSTANCE.getNode("com.ibm.pdp.screen.address.rdz");
    private static Map<String, Image> images;
    public static final String ERROR_ICON = "error.gif";
    public static final String ID = "com.ibm.pdp.screen.address.view.ScreenAddressView";
    public static final String _HELP_PLUGIN = "com.ibm.pdp.doc.cshelp";
    private String CONTEXT_ID_FOR_HELP = "adr";
    private List<Field> fields = null;
    private PacScreen screen;
    private AdapterImpl adapter;
    private static final String _PREF_VIEW_LINK_EDITOR = "PREF_VIEW_LINK_EDITOR";
    private static final String _PREF_VIEW_SHOW_ALL_ERROR = "PREF_VIEW_SHOW_ALL_ERROR";

    static {
        images = new HashMap<String, Image>();
    }

    public static ImageDescriptor getImageDescriptor(String file) {
        Bundle bundle = FrameworkUtil.getBundle(ScreenAddressView.class);
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/" + file), null);
        return ImageDescriptor.createFromURL((URL)url);
    }

    public void createPartControl(Composite aParent) {
        try {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)aParent, this.getContextId());
            Composite parent = new Composite(aParent, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 1;
            layout.marginWidth = 1;
            layout.verticalSpacing = 1;
            parent.setLayout((Layout)layout);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            parent.setLayoutData((Object)gridData);
            this._tabViewer = new TableViewer(parent, 67588);
            GridData data = new GridData(1808);
            data.grabExcessVerticalSpace = true;
            data.minimumHeight = 50;
            data.minimumWidth = 50;
            data.widthHint = 300;
            data.heightHint = 300;
            this._tabViewer.getTable().setLayoutData((Object)data);
            this.createColumns(parent, this._tabViewer);
            Table table = this._tabViewer.getTable();
            table.setHeaderVisible(true);
            table.setLinesVisible(true);
            this._tabViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this._tabViewer, (int)2);
            this.makeActions();
            this.contributeToActionBars();
        }
        catch (Exception exception) {
            Util.rethrow((Throwable)exception);
        }
    }

    private String getContextId() {
        return "com.ibm.pdp.doc.cshelp." + this.CONTEXT_ID_FOR_HELP;
    }

    public void setHelp(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getContextId());
    }

    private void createColumns(Composite parent, TableViewer _tabViewer) {
        String[] _columnsNames = new String[]{"", com.ibm.pdp.pacbase.generate.util.Messages._LINE, com.ibm.pdp.pacbase.generate.util.Messages._COLUMN, com.ibm.pdp.pacbase.generate.util.Messages._LENGTH, com.ibm.pdp.pacbase.generate.util.Messages._FIELD_TYPE, com.ibm.pdp.pacbase.generate.util.Messages._FIELD_CODE, com.ibm.pdp.pacbase.generate.util.Messages._CATEGORY_REPEAT, com.ibm.pdp.pacbase.generate.util.Messages._FIELD_HORIZONTAL_REPEAT, com.ibm.pdp.pacbase.generate.util.Messages._FIELD_VERTICAL_REPEAT};
        int[] _columnsWidth = new int[]{30, 50, 70, 80, 120, 130, 170, 170, 150};
        int _columnsSize = _columnsNames.length;
        int i = 0;
        while (i < _columnsSize) {
            TableViewerColumn col = this.createTableViewerColumn(_columnsNames[i], _columnsWidth[i], i);
            if (i == 0) {
                col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        return null;
                    }

                    public Image getImage(Object element) {
                        if (((Field)element).isInError()) {
                            return ScreenAddressView._getImage(ScreenAddressView.ERROR_ICON);
                        }
                        return null;
                    }

                    public String getToolTipText(Object element) {
                        if (((Field)element).isInError()) {
                            Field f = (Field)element;
                            return String.valueOf(f.getErrorMessage());
                        }
                        return null;
                    }
                });
            }
            if (i == 1) {
                col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        Field f = (Field)element;
                        return String.valueOf(f.getLine());
                    }
                });
            }
            if (i == 2) {
                col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        Field f = (Field)element;
                        return String.valueOf(f.getColumn());
                    }
                });
            }
            if (i == 3) {
                col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        Field f = (Field)element;
                        return String.valueOf(f.getLength());
                    }
                });
            }
            if (i == 4) {
                col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        Field f = (Field)element;
                        return f.getFieldType();
                    }
                });
            }
            if (i == 5) {
                col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        Field f = (Field)element;
                        return f.getFieldCode();
                    }
                });
            }
            if (i == 6) {
                col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        Field f = (Field)element;
                        return f.getCategoryRepeat();
                    }
                });
            }
            if (i == 7) {
                col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        Field f = (Field)element;
                        return f.getFieldHorizontalRepeat();
                    }
                });
            }
            if (i == 8) {
                col.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

                    public String getText(Object element) {
                        Field f = (Field)element;
                        return f.getFieldVerticalRepeat();
                    }
                });
            }
            ++i;
        }
    }

    private TableViewerColumn createTableViewerColumn(String columnsNames, int columnsWidth, int colNumber) {
        TableViewerColumn viewerColumn = new TableViewerColumn(this._tabViewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(columnsNames);
        column.setWidth(columnsWidth);
        column.setResizable(true);
        column.setMoveable(true);
        return viewerColumn;
    }

    public void setFocus() {
        this._tabViewer.getControl().setFocus();
    }

    public static ScreenAddressView getInstance() {
        return _instance;
    }

    public ScreenAddressView() {
        _instance = this;
    }

    public void setCurrentScreenEditor(IEditorPart part) {
        this.unregister();
        if (part instanceof ScreenFlatEditor) {
            this.screen = (PacScreen)((ScreenFlatEditor)part).getEditorData().getRadicalObject();
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (ScreenAddressView.this.screen != null && ScreenAddressView.this.isLinked()) {
                        ScreenAddressView.this.execute();
                    }
                }
            };
            this.screen.eAdapters().add((Object)this.adapter);
            if (this.isLinked()) {
                this.execute();
            }
        } else {
            this.screen = null;
        }
    }

    private void unregister() {
        if (this.screen != null) {
            this.screen.eSetDeliver(false);
            if (this.adapter != null) {
                this.screen.eAdapters().remove((Object)this.adapter);
            }
            this.screen.eSetDeliver(true);
            this.screen = null;
        }
    }

    public void execute() {
        this.fields = ScreenAddress.getAllFields((PacScreen)this.screen);
        this.refresh();
    }

    private void refresh() {
        this.setPartName(this.mefTitle(this.screen.getName()));
        if (this._tabViewer.getControl().isDisposed()) {
            return;
        }
        if (this.fields == null) {
            this._tabViewer.setInput(new ArrayList());
        } else if (!this.showErrorOnlyAction()) {
            this._tabViewer.setInput(this.fields);
        } else {
            ArrayList<Field> errorFields = new ArrayList<Field>();
            for (Field field : this.fields) {
                if (!field.isInError()) continue;
                errorFields.add(field);
            }
            this._tabViewer.setInput(errorFields);
        }
    }

    private static Image _getImage(String path) {
        ImageDescriptor descriptor;
        Image image = images.get(path);
        if (image == null && (descriptor = ScreenAddressView.getImageDescriptor(path)) != null) {
            image = descriptor.createImage();
            images.put(path, image);
        }
        return image;
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    public boolean isLinked() {
        return this._linkAction != null && this._linkAction.isChecked();
    }

    public boolean showErrorOnlyAction() {
        return this._showErrorOnlyAction != null && this._showErrorOnlyAction.isChecked();
    }

    private void makeActions() {
        this._linkAction = new Action("", 2){

            public void run() {
            }
        };
        this._linkAction.setToolTipText(com.ibm.pdp.pacbase.generate.util.Messages._VIEW_ADR_TOOLTIP);
        this._linkAction.setImageDescriptor(Activator.getImageDescriptor("icons/synched.gif"));
        this._linkAction.setChecked(this._prefs.getBoolean(_PREF_VIEW_LINK_EDITOR, false));
        this._showErrorOnlyAction = new Action("", 2){

            public void run() {
            }
        };
        this._showErrorOnlyAction.setToolTipText(com.ibm.pdp.pacbase.generate.util.Messages._VIEW_ADR_ONLY_ERROR_TOOLTIP);
        this._showErrorOnlyAction.setImageDescriptor(Activator.getImageDescriptor("icons/error.gif"));
        this._showErrorOnlyAction.setChecked(this._prefs.getBoolean(_PREF_VIEW_SHOW_ALL_ERROR, false));
        this._showErrorOnlyAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ScreenAddressView.this.refresh();
            }
        });
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this._linkAction);
        manager.add((IAction)this._showErrorOnlyAction);
    }

    public static ScreenAddressView showView() {
        try {
            return (ScreenAddressView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(ID);
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    public void dispose() {
        super.dispose();
        this.unregister();
        this._prefs.putBoolean(_PREF_VIEW_LINK_EDITOR, this.isLinked());
        this._prefs.putBoolean(_PREF_VIEW_SHOW_ALL_ERROR, this.showErrorOnlyAction());
    }

    private String mefTitle(String screen) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(Messages.ScreenAddressTitle);
        buffer.append(" : ");
        buffer.append(screen);
        return buffer.toString();
    }
}

