/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.rpp.license;

import com.ibm.pdp.rpp.license.ILicenseExtension;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class RppLicenseManager {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2018, 2024.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String RPP_LICENCE_ID = "com.ibm.pdp.build.mainfeature.pac";
    public static final String RPP_LICENCE_VERSION = "9.8.0";
    private static final String ExtensionPointName = "licenceExtension";
    private static final String ExtensionPointId = "com.ibm.pdp.rpp.license.licenceExtension";
    private static List<ILicenseExtension> _extensions = null;

    public static synchronized boolean checkLicence() throws Exception {
        RppLicenseManager.loadLicenseExtensions();
        if (!_extensions.isEmpty()) {
            for (ILicenseExtension extension : _extensions) {
                try {
                    if (extension.requestLicense(RPP_LICENCE_ID, RPP_LICENCE_VERSION, true)) continue;
                    return false;
                }
                catch (Exception exception) {
                    extension.requestLicense(RPP_LICENCE_ID, RPP_LICENCE_VERSION, false);
                }
            }
        }
        return true;
    }

    private static synchronized void loadLicenseExtensions() {
        if (_extensions == null) {
            IConfigurationElement[] contributions;
            _extensions = new ArrayList<ILicenseExtension>();
            IConfigurationElement[] iConfigurationElementArray = contributions = Platform.getExtensionRegistry().getConfigurationElementsFor(ExtensionPointId);
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement contribution = iConfigurationElementArray[n2];
                try {
                    ILicenseExtension instance = (ILicenseExtension)contribution.createExecutableExtension("class");
                    _extensions.add(instance);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }
}

