/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.resources;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.link.PdpFileGenerationLinksParser;
import com.ibm.pdp.mdl.link.PdpFileGenerationLinksParserResult;
import com.ibm.pdp.mdl.link.design.MacrosCrossRefsCaller;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.io.MetadataAccess;
import com.ibm.pdp.mdl.meta.io.MetadataContext;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.pdppath.service.PdpPathService;
import com.ibm.pdp.resources.Messages;
import com.ibm.pdp.resources.PdpResourceParser;
import com.ibm.pdp.trace.PTTraceManager;
import com.ibm.pdp.util.Iterators;
import com.ibm.pdp.util.Util;
import com.ibm.pdp.util.performance.PerformanceManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.search.BooleanClause;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;

public class PdpResourcesMgr {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2017.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final Set<String> PUBLIC_GENERATION_CAT_SET = new HashSet<String>(2);
    public static final Set<String> PRIVATE_GENERATION_CAT_SET = new HashSet<String>(2);
    public static final Set<String> PUBLIC_ENTRYPOINT_CAT_SET = new HashSet<String>(2);
    public static final Set<String> PUBLIC_MICROPATTERN_CAT_SET = new HashSet<String>(2);
    public static final Set<String> PUBLIC_DATAELEMENT_USAGE_CAT_SET = new HashSet<String>(2);
    public static final Set<String> ALL_GENERATION_REFERENCES_CAT_SET = new HashSet<String>(2);
    public static final Set<String> ALL_REFERENCES_PRODUCED_BY_CBL = new HashSet<String>(4);
    private static final String FOLDER_DELIMITER = "/";
    private static final String PACKAGE_DELIMITER = ".";
    private static final String EXTENSION_DELIMITER = ".";
    private static final String CR = System.getProperty("line.separator");
    private static final String DESIGNS_GENERATED_LINKS_RECOMPUTE = Messages.PdpResourcesMgr_DESIGNS_GENERATED_LINKS_RECOMPUTE;
    private static final String FILES_PROCESSING = Messages.PdpResourcesMgr_FILES_PROCESSING;
    private static final String SEARCH_OF_ALL_PDP_FILES = Messages.PdpResourcesMgr_SEARCH_OF_ALL_PDP_FILES;
    private static final String LINKS_SAVING = Messages.PdpResourcesMgr_LINKS_SAVING;
    private static final String MACROS_LINKS_RECOMPUTE = Messages.PdpResourcesMgr_MACROS_LINKS_RECOMPUTE;
    private static final String MACROS_PROCESSING = Messages.PdpResourcesMgr_MACROS_PROCESSING;
    private static final String SEARCH_OF_ALL_MACROS_FILES = Messages.PdpResourcesMgr_SEARCH_OF_ALL_MACROS_FILES;
    private static final String MACROS_LINKS_SAVING = Messages.PdpResourcesMgr_MACROS_LINKS_SAVING;
    private MetadataAccess _metadataAccess = null;
    private static List<String> _workspacePdpFilesNames;
    private static Set<String> _workspaceMacrosFilesNames;
    private static Iterator<Reference> EMPTY_ITERATOR;
    private static int BUFFER_SIZE;
    private static Map<String, Map<String, Document>> _generatedResourcesGlobalMap;
    private static Map<String, Set<String>> _generatedEntryPointsMap;
    private static PdpResourcesMgr _instance;
    private static PerformanceManager performanceManager;

    static {
        EMPTY_ITERATOR = Iterators.emptyIterator();
        BUFFER_SIZE = 4000;
        _instance = null;
        performanceManager = PerformanceManager.getInstance();
    }

    private PdpResourcesMgr() {
        _generatedEntryPointsMap = new HashMap<String, Set<String>>();
        this._metadataAccess = MetadataAccess.getMetadataAccess();
        _generatedResourcesGlobalMap = new HashMap<String, Map<String, Document>>();
        PUBLIC_GENERATION_CAT_SET.add("public");
        PUBLIC_GENERATION_CAT_SET.add("generatedResource");
        PUBLIC_ENTRYPOINT_CAT_SET.add("public");
        PUBLIC_ENTRYPOINT_CAT_SET.add("entrypoint");
        PRIVATE_GENERATION_CAT_SET.add("private");
        PRIVATE_GENERATION_CAT_SET.add("generation");
        PUBLIC_DATAELEMENT_USAGE_CAT_SET.add("public");
        PUBLIC_DATAELEMENT_USAGE_CAT_SET.add("usage");
        PUBLIC_MICROPATTERN_CAT_SET.add("public");
        PUBLIC_MICROPATTERN_CAT_SET.add("micropattern");
        ALL_GENERATION_REFERENCES_CAT_SET.add("entrypoint");
        ALL_GENERATION_REFERENCES_CAT_SET.add("generation");
        ALL_REFERENCES_PRODUCED_BY_CBL.add("generation");
        ALL_REFERENCES_PRODUCED_BY_CBL.add("entrypoint");
        ALL_REFERENCES_PRODUCED_BY_CBL.add("micropattern");
        ALL_REFERENCES_PRODUCED_BY_CBL.add("usage");
        this.loadWorkspaceData();
        this.initEntryPointsWithGeneratedMap();
    }

    public static PdpResourcesMgr getInstance() {
        if (_instance == null) {
            _instance = new PdpResourcesMgr();
        }
        return _instance;
    }

    private boolean addItemInEntryPointsMap(List<Reference> references) {
        if (references == null || references.size() == 0) {
            return false;
        }
        String designId = this.getEntryPointId(references);
        if (designId != null) {
            String prjName = PdpResourcesMgr.getProjectName(designId);
            Set<String> entryPointsSet = _generatedEntryPointsMap.get(prjName);
            if (entryPointsSet == null) {
                entryPointsSet = new HashSet<String>();
                _generatedEntryPointsMap.put(prjName, entryPointsSet);
            }
            entryPointsSet.add(designId);
            return true;
        }
        return false;
    }

    private void addAllPdpFilesOf(IResource aMember, IProgressMonitor progress) throws CoreException {
        if (progress.isCanceled()) {
            return;
        }
        if (aMember instanceof IContainer) {
            IResource[] members;
            if (aMember instanceof IProject && !((IProject)aMember).isOpen()) {
                return;
            }
            IResource[] iResourceArray = members = ((IContainer)aMember).members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource aRes = iResourceArray[n2];
                this.addAllPdpFilesOf(aRes, progress);
                ++n2;
            }
        } else {
            IPath path = aMember.getFullPath();
            if (path.getFileExtension() != null && path.getFileExtension().endsWith("pdp")) {
                _workspacePdpFilesNames.add(aMember.getLocation().toOSString());
            }
        }
    }

    private void addAllMacrosFilesOf(IResource aMember, IProgressMonitor progress) throws CoreException {
        if (progress.isCanceled()) {
            return;
        }
        if (aMember instanceof IContainer) {
            IResource[] members;
            if (aMember instanceof IProject && !((IProject)aMember).isOpen()) {
                return;
            }
            IResource[] iResourceArray = members = ((IContainer)aMember).members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IResource aRes = iResourceArray[n2];
                this.addAllMacrosFilesOf(aRes, progress);
                ++n2;
            }
        } else {
            IPath path = aMember.getFullPath();
            if (path.getFileExtension() != null && path.getFileExtension().endsWith("pacmacro")) {
                _workspaceMacrosFilesNames.add(aMember.getFullPath().toString());
            }
        }
    }

    private void clearPropertiesFrom(Map<String, List<Reference>> de_usagesRefs) {
        Set<String> docs = de_usagesRefs.keySet();
        for (String aDoc : docs) {
            List<Reference> refs = de_usagesRefs.get(aDoc);
            for (Reference aRef : refs) {
                aRef.forgetProperties();
            }
        }
    }

    public String getRelativeFileIdFromURI(String generatedResourceURI) {
        String fileId = "/%" + generatedResourceURI.substring(1);
        Document genRes = this.getResource(fileId);
        if (genRes != null) {
            return fileId;
        }
        int endOfProject = generatedResourceURI.indexOf(FOLDER_DELIMITER, 1);
        String projectName = generatedResourceURI.substring(1, endOfProject);
        String resourceURIWithoutproject = generatedResourceURI.substring(endOfProject + 1);
        String genRoot = PdpPathService.getGenRootFolder((String)projectName);
        String relativeFileId = genRoot != null && genRoot.length() != 0 ? (resourceURIWithoutproject.startsWith(genRoot) ? FOLDER_DELIMITER + projectName + resourceURIWithoutproject.substring(genRoot.length()) : null) : generatedResourceURI;
        return relativeFileId;
    }

    public static String getProjectName(String fileURI) {
        if (fileURI == null || fileURI.length() < 3) {
            return null;
        }
        int index = fileURI.indexOf(47, 1);
        if (index == -1) {
            return null;
        }
        String s = fileURI.indexOf(37, 1) != -1 ? fileURI.substring(2, index) : fileURI.substring(1, index);
        return s;
    }

    public Document getResource(String fileURI) {
        String projectName = PdpResourcesMgr.getProjectName(fileURI);
        Map<String, Document> internalMap = _generatedResourcesGlobalMap.get(projectName);
        if (internalMap != null) {
            return internalMap.get(fileURI);
        }
        return null;
    }

    public Reference getEntryPoint(String documentId) {
        if (documentId == null || documentId.length() == 0) {
            return null;
        }
        List ep = this._metadataAccess.readReferences("entrypoint", documentId, 0);
        if (ep != null && ep.size() > 0) {
            return (Reference)ep.get(0);
        }
        return null;
    }

    public Iterator<String> getAllRegisteredEntities() {
        Iterator<Map<String, Document>> internalMaps = _generatedResourcesGlobalMap.values().iterator();
        ArrayList<String> entitiesList = new ArrayList<String>();
        while (internalMaps.hasNext()) {
            Map<String, Document> aMap = internalMaps.next();
            entitiesList.addAll(aMap.keySet());
        }
        return entitiesList.iterator();
    }

    public Iterator<Reference> getGenerationSubReferences(String sourceId) {
        if (this.isRPPInBatchMode() || sourceId == null) {
            return EMPTY_ITERATOR;
        }
        MetadataContext context = new MetadataContext(ALL_GENERATION_REFERENCES_CAT_SET, BooleanClause.Occur.SHOULD, null);
        List subReferences = this._metadataAccess.readReferences(context, sourceId, 0);
        return subReferences.iterator();
    }

    public List<Reference> getGenerationSubReferences2(String sourceId) {
        if (this.isRPPInBatchMode() || sourceId == null) {
            return Collections.emptyList();
        }
        MetadataContext context = new MetadataContext(ALL_GENERATION_REFERENCES_CAT_SET, BooleanClause.Occur.SHOULD, null);
        List subReferences = this._metadataAccess.readReferences(context, sourceId, 0);
        return subReferences;
    }

    public Iterator<Reference> getGenerationSuperReferences(String sourceId) {
        if (this.isRPPInBatchMode() || sourceId == null) {
            return EMPTY_ITERATOR;
        }
        MetadataContext context = new MetadataContext(ALL_GENERATION_REFERENCES_CAT_SET, BooleanClause.Occur.SHOULD, null);
        List subReferences = this._metadataAccess.readReferences(context, sourceId, 1);
        return subReferences.iterator();
    }

    public Iterator<Reference> getAllSubReferences(String sourceId) {
        if (this.isRPPInBatchMode() || sourceId == null) {
            return EMPTY_ITERATOR;
        }
        List subReferences = this._metadataAccess.readReferences(sourceId, 0);
        return subReferences.iterator();
    }

    public Iterator<Reference> getSuperReferences(String sourceId) {
        if (sourceId == null) {
            return EMPTY_ITERATOR;
        }
        List superReferences = this._metadataAccess.readReferences(sourceId, 1);
        if (superReferences.size() > 1 && ((Reference)superReferences.get(0)).getRelation().endsWith("entrypoint")) {
            Reference[] ref = new Reference[superReferences.size()];
            ref = superReferences.toArray(ref);
            Arrays.sort(ref, new Comparator<Object>(){

                @Override
                public int compare(Object obj0, Object obj1) {
                    int rank1 = PdpResourcesMgr.this.getRankFor(obj0);
                    if (rank1 < 0) {
                        return 1;
                    }
                    int rank2 = PdpResourcesMgr.this.getRankFor(obj1);
                    if (rank2 < 0) {
                        return 1;
                    }
                    return rank1 - rank2;
                }
            });
            superReferences.clear();
            Reference[] referenceArray = ref;
            int n = ref.length;
            int n2 = 0;
            while (n2 < n) {
                Reference reference = referenceArray[n2];
                superReferences.add(reference);
                ++n2;
            }
        }
        return superReferences.iterator();
    }

    int getRankFor(Object obj) {
        if (!(obj instanceof Reference)) {
            return -1;
        }
        Reference ref = (Reference)obj;
        if (ref.getRelation().endsWith("entrypoint")) {
            String rank = ref.getRelation().substring(0, ref.getRelation().indexOf("entrypoint") - 1);
            rank = rank.substring(rank.lastIndexOf("_") + 1);
            return Integer.parseInt(rank);
        }
        return -1;
    }

    public Iterator<Reference> getAllSuperReferencesExceptGenerationRelations(String sourceId) {
        if (sourceId == null) {
            return EMPTY_ITERATOR;
        }
        String virtualId = PTElement.getVirtualId((String)sourceId);
        List superReferences = this._metadataAccess.readReferences(virtualId, 1);
        return superReferences.iterator();
    }

    public boolean hasDesignEntryPointBeenGenerated(String designId) {
        String prjName = PdpResourcesMgr.getProjectName(designId);
        Set<String> entryPointsSet = _generatedEntryPointsMap.get(prjName);
        if (entryPointsSet == null) {
            return false;
        }
        return entryPointsSet.contains(designId);
    }

    private void initEntryPointsWithGeneratedMap() {
        int nbOfEntryPointsRegistered;
        int engineTraceLevel;
        PTTraceManager traceManager;
        long debut;
        block6: {
            if (this.isRPPInBatchMode()) {
                return;
            }
            debut = System.currentTimeMillis();
            traceManager = PTTraceManager.getInstance();
            engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.framework");
            if (engineTraceLevel > 0) {
                String message = String.valueOf(CR) + "Enter initEntryPointsWithGeneratedSet." + CR;
                traceManager.trace(this.getClass(), "com.ibm.pdp.framework", 1, message);
            }
            nbOfEntryPointsRegistered = 0;
            try {
                MetadataContext context = new MetadataContext("entrypoint", null);
                Map refs = this._metadataAccess.readReferences(context);
                for (List rList : refs.values()) {
                    if (!this.addItemInEntryPointsMap(rList)) continue;
                    ++nbOfEntryPointsRegistered;
                }
            }
            catch (Exception e) {
                if (engineTraceLevel <= 0) break block6;
                String message = e.getMessage();
                traceManager.trace(this.getClass(), "com.ibm.pdp.framework", 1, message);
            }
        }
        long fin = System.currentTimeMillis();
        if (engineTraceLevel > 0) {
            String message = String.valueOf(CR) + "Number of instances loaded : " + nbOfEntryPointsRegistered + CR + "Exit initEntryPointsWithGeneratedMap. Time elapsed = " + (fin - debut) + CR;
            traceManager.trace(this.getClass(), "com.ibm.pdp.framework", 1, message);
        }
    }

    private boolean isRPPInBatchMode() {
        return Util.isRPPInBatchMode();
    }

    private void loadWorkspaceData() {
        int engineTraceLevel;
        PTTraceManager traceManager;
        long debut;
        block6: {
            if (this.isRPPInBatchMode()) {
                return;
            }
            debut = System.currentTimeMillis();
            traceManager = PTTraceManager.getInstance();
            engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.framework");
            if (engineTraceLevel > 0) {
                String message = String.valueOf(CR) + "Enter loadWorkspaceData." + CR;
                traceManager.trace(this.getClass(), "com.ibm.pdp.framework", 1, message);
            }
            try {
                PdpResourceParser.loadAllDocumentsFromLucene(this._metadataAccess, _generatedResourcesGlobalMap);
            }
            catch (Exception e) {
                if (engineTraceLevel <= 0) break block6;
                String message = e.getMessage();
                traceManager.trace(this.getClass(), "com.ibm.pdp.framework", 1, message);
            }
        }
        long fin = System.currentTimeMillis();
        int nbOfDocs = 0;
        if (engineTraceLevel > 0) {
            for (Map<String, Document> aMap : _generatedResourcesGlobalMap.values()) {
                nbOfDocs += aMap.values().size();
            }
            String message = String.valueOf(CR) + "Number of instances loaded : " + nbOfDocs + CR + "Exit loadWorkspaceData. Time elapsed = " + (fin - debut) + CR;
            traceManager.trace(this.getClass(), "com.ibm.pdp.framework", 1, message);
        }
    }

    public static String getURIFromGeneratedDocument(String generatedFileId) {
        if (generatedFileId.startsWith("/%")) {
            return FOLDER_DELIMITER + generatedFileId.substring(2);
        }
        String[] tokens = MetadataService.getTokens((String)generatedFileId);
        if (tokens.length != 5) {
            throw new RuntimeException("PdpResourcesMgr.getURIFromGeneratedDocument : Invalid designID = " + generatedFileId);
        }
        String project = tokens[0];
        String packagee = tokens[1];
        String name = tokens[2];
        String type = tokens[4];
        String genRoot = PdpPathService.getGenRootFolder((String)project);
        StringBuilder sb = new StringBuilder();
        sb.append(FOLDER_DELIMITER);
        sb.append(project);
        sb.append(FOLDER_DELIMITER);
        if (genRoot != null && genRoot.length() != 0) {
            sb.append(genRoot);
            sb.append(FOLDER_DELIMITER);
        }
        if (packagee != null && packagee.length() != 0) {
            String pack = packagee;
            pack = pack.replace(".", FOLDER_DELIMITER);
            sb.append(pack);
            sb.append(FOLDER_DELIMITER);
        }
        sb.append(name);
        sb.append(".");
        sb.append(type);
        return sb.toString();
    }

    public static String getURIFromDocument(String designId) {
        String[] tokens = MetadataService.getTokens((String)designId);
        if (tokens.length != 5) {
            throw new RuntimeException("PdpResourcesMgr.getURIFromGeneratedDocument : Invalid designID = " + designId);
        }
        String project = tokens[0];
        String packagee = tokens[1];
        String name = tokens[2];
        String metatype = tokens[3];
        String type = tokens[4];
        boolean isDesign = PdpResourcesMgr.isDesignDocument(type);
        String platformURI = null;
        if (isDesign) {
            IPath path = null;
            path = metatype != null && metatype.length() > 0 ? PTModelService.getPath((String)project, (String)packagee, (String)name, (String)metatype, (String)type) : PTModelService.getPath((String)project, (String)packagee, (String)name, (String)type);
            platformURI = path.toString();
        } else {
            platformURI = PdpResourcesMgr.getURIFromGeneratedDocument(designId);
        }
        return platformURI;
    }

    public static boolean isDesignDocument(String type) {
        return !PdpFileGenerationLinksParser.isGeneratedDocument((String)type);
    }

    private String getEntryPointId(List<Reference> references) {
        for (Reference aRef : references) {
            if (aRef.getRelation().indexOf("entrypoint") == -1) continue;
            return aRef.getTargetId();
        }
        return null;
    }

    public void unregisterResourcesOfProject(String projectName) {
    }

    public void unregisterResourcesOfProjectV2(Set<String> projectsNames) {
        if (this.isRPPInBatchMode() || projectsNames == null || projectsNames.size() == 0) {
            return;
        }
        HashSet<String> aProjectNamesSet = new HashSet<String>(projectsNames.size() * 2);
        for (String projectName : projectsNames) {
            aProjectNamesSet.add(projectName);
            aProjectNamesSet.add(String.valueOf('%') + projectName);
        }
        MetadataContext aCtx = new MetadataContext(PUBLIC_GENERATION_CAT_SET, BooleanClause.Occur.SHOULD, aProjectNamesSet);
        List documents = this._metadataAccess.readDocuments(aCtx, true);
        HashSet<String> documentsIds = new HashSet<String>();
        int i = 0;
        while (i < documents.size()) {
            Document doc = (Document)documents.get(i);
            documentsIds.add(doc.getId());
            if (documentsIds.size() > BUFFER_SIZE) {
                this.unregisterResourcesSubProcess(documentsIds);
                documentsIds = new HashSet();
            }
            ++i;
        }
        if (documentsIds.size() > 0) {
            this.unregisterResourcesSubProcess(documentsIds);
        }
        for (String projectName : projectsNames) {
            _generatedResourcesGlobalMap.remove(projectName);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rebuildWorkspaceGenerationLinks(IProgressMonitor progress) {
        int STEP1 = 40;
        int STEP2 = 50;
        int STEP3_1 = 6;
        int STEP3_2 = 4;
        int MAX_REF_WITHOUT_WRITING = 1000000;
        int MAX_DOC_WITHOUT_WRITING = 20000;
        int nbOfDocsRegistered = 0;
        long debut = System.currentTimeMillis();
        PTTraceManager traceManager = PTTraceManager.getInstance();
        int engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.framework");
        if (engineTraceLevel > 0) {
            String message = String.valueOf(CR) + "Enter rebuildWorkspaceGenerationLinks : " + CR;
            traceManager.trace(this.getClass(), "com.ibm.pdp.framework", 1, message);
        }
        try {
            progress.beginTask(DESIGNS_GENERATED_LINKS_RECOMPUTE, 100);
            float step = 0.0f;
            float cumul = 0.0f;
            int cumul2 = 0;
            int done = 0;
            progress.setTaskName(SEARCH_OF_ALL_PDP_FILES);
            _workspacePdpFilesNames = new ArrayList<String>();
            try {
                IResource[] members = ResourcesPlugin.getWorkspace().getRoot().members();
                if (members.length > 0) {
                    step = (float)STEP1 / (float)members.length;
                    IResource[] iResourceArray = members;
                    int n = members.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource aMember = iResourceArray[n2];
                        this.addAllPdpFilesOf(aMember, progress);
                        if (progress.isCanceled()) {
                            return;
                        }
                        cumul2 = Math.round(cumul += step);
                        if (cumul2 != done) {
                            progress.worked(cumul2 - done);
                            done = cumul2;
                        }
                        ++n2;
                    }
                }
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
            MetadataContext context = new MetadataContext(ALL_REFERENCES_PRODUCED_BY_CBL, BooleanClause.Occur.SHOULD, null);
            this._metadataAccess.deleteReferences(context);
            MetadataContext contextDocs = new MetadataContext("generatedResource", null);
            this._metadataAccess.deleteDocuments(contextDocs);
            _generatedResourcesGlobalMap = new HashMap<String, Map<String, Document>>();
            _generatedEntryPointsMap = new HashMap<String, Set<String>>();
            int nbFiles = _workspacePdpFilesNames.size();
            if (nbFiles > 0) {
                progress.setTaskName(FILES_PROCESSING);
                HashMap<String, Document> allDocuments = new HashMap<String, Document>(nbFiles);
                HashMap<String, List<Reference>> allEntryPointsReferences = new HashMap<String, List<Reference>>(nbFiles);
                HashMap<String, List<Reference>> allOthersReferences = new HashMap<String, List<Reference>>(nbFiles);
                HashMap<String, List<Reference>> mpReferences = new HashMap<String, List<Reference>>(nbFiles);
                HashMap<String, List<Reference>> usagesReferences = new HashMap<String, List<Reference>>(nbFiles);
                int currentFile = 0;
                step = (float)STEP2 / (float)nbFiles;
                StringBuilder subTaskName = null;
                int totalNbOfRefs = 0;
                for (String afilename : _workspacePdpFilesNames) {
                    ++nbOfDocsRegistered;
                    int nbRefs = this.retrieveMetadatas(afilename, allDocuments, allEntryPointsReferences, allOthersReferences, mpReferences, usagesReferences);
                    totalNbOfRefs += nbRefs;
                    if (progress.isCanceled()) {
                        return;
                    }
                    subTaskName = new StringBuilder("(");
                    subTaskName.append(currentFile).append(FOLDER_DELIMITER).append(nbFiles).append(") : ").append(afilename);
                    if (totalNbOfRefs > MAX_REF_WITHOUT_WRITING || allDocuments.size() > MAX_DOC_WITHOUT_WRITING) {
                        this.saveMetadatas(allDocuments, allEntryPointsReferences, allOthersReferences, mpReferences, usagesReferences);
                        allDocuments.clear();
                        allEntryPointsReferences.clear();
                        allOthersReferences.clear();
                        mpReferences.clear();
                        usagesReferences.clear();
                        totalNbOfRefs = 0;
                    }
                    progress.subTask(subTaskName.toString());
                    ++currentFile;
                    cumul2 = Math.round(cumul += step);
                    if (cumul2 == done) continue;
                    progress.worked(cumul2 - done);
                    done = cumul2;
                }
                progress.setTaskName(LINKS_SAVING);
                progress.subTask("");
                progress.worked(STEP3_1);
                this.saveMetadatas(allDocuments, allEntryPointsReferences, allOthersReferences, mpReferences, usagesReferences);
                progress.worked(STEP3_2);
            }
        }
        finally {
            progress.done();
        }
        long fin = System.currentTimeMillis();
        if (engineTraceLevel <= 0) return;
        String message = "Nb of doc registered = " + nbOfDocsRegistered + CR + "Time elapsed = " + (fin - debut) + CR + "Exit rebuildWorkspaceGenerationLinks : " + CR;
        traceManager.trace(this.getClass(), "com.ibm.pdp.framework", 1, message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rebuildWorkspaceMacroLinks(IProgressMonitor progress) {
        int engineTraceLevel;
        PTTraceManager traceManager;
        long debut;
        int nbOfDocsRegistered;
        block18: {
            int STEP1 = 40;
            int STEP2 = 50;
            int STEP3_1 = 6;
            int STEP3_2 = 4;
            int MAX_REF_WITHOUT_WRITING = 1000000;
            nbOfDocsRegistered = 0;
            debut = System.currentTimeMillis();
            traceManager = PTTraceManager.getInstance();
            engineTraceLevel = traceManager.getTraceLevel("com.ibm.pdp.framework");
            if (engineTraceLevel > 0) {
                String message = String.valueOf(CR) + "Enter rebuildWorkspaceMacroLinks : " + CR;
                traceManager.trace(this.getClass(), "com.ibm.pdp.framework", 1, message);
            }
            try {
                progress.beginTask(MACROS_LINKS_RECOMPUTE, 100);
                float step = 0.0f;
                float cumul = 0.0f;
                int cumul2 = 0;
                int done = 0;
                progress.setTaskName(SEARCH_OF_ALL_MACROS_FILES);
                _workspaceMacrosFilesNames = new HashSet<String>();
                try {
                    IResource[] members = ResourcesPlugin.getWorkspace().getRoot().members();
                    if (members.length > 0) {
                        step = (float)STEP1 / (float)members.length;
                        IResource[] iResourceArray = members;
                        int n = members.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IResource aMember = iResourceArray[n2];
                            this.addAllMacrosFilesOf(aMember, progress);
                            if (progress.isCanceled()) {
                                return;
                            }
                            cumul2 = Math.round(cumul += step);
                            if (cumul2 != done) {
                                progress.worked(cumul2 - done);
                                done = cumul2;
                            }
                            ++n2;
                        }
                    }
                }
                catch (CoreException e) {
                    throw new RuntimeException(e);
                }
                this.deleteMacrosDesignAndUsageSubReferences(_workspaceMacrosFilesNames);
                int nbFiles = _workspaceMacrosFilesNames.size();
                if (nbFiles <= 0) break block18;
                progress.setTaskName(MACROS_PROCESSING);
                HashMap<String, List<Reference>> designSubRefs = new HashMap<String, List<Reference>>();
                HashMap<String, List<Reference>> usageSubRefs = new HashMap<String, List<Reference>>();
                int currentFile = 0;
                step = (float)STEP2 / (float)nbFiles;
                StringBuilder subTaskName = null;
                int totalNbOfRefs = 0;
                for (String afilename : _workspaceMacrosFilesNames) {
                    ++nbOfDocsRegistered;
                    RadicalEntity radicalEntity = PTModelService.getResource((IPath)new Path(afilename));
                    InputStream macrosContents = com.ibm.pdp.mdl.link.design.Util.getMacroSourceCodeAttribute((RadicalEntity)radicalEntity);
                    String documentId = null;
                    try {
                        documentId = com.ibm.pdp.mdl.link.design.Util.getMacroDocumentId((String)afilename, (RadicalEntity)radicalEntity);
                    }
                    catch (Exception e) {
                        String mess = "Macro could not be processed correctly : " + afilename;
                        Status status = new Status(4, "com.ibm.pdp.resources", mess, (Throwable)e);
                        Bundle bundle = Platform.getBundle((String)"com.ibm.pdp.resources");
                        ILog log = Platform.getLog((Bundle)bundle);
                        log.log((IStatus)status);
                    }
                    if (macrosContents == null || documentId == null) continue;
                    MacrosCrossRefsCaller.searchForMacroSubReferences((String)documentId, (InputStream)macrosContents, designSubRefs, usageSubRefs);
                    totalNbOfRefs += usageSubRefs.size() + 10;
                    if (progress.isCanceled()) {
                        return;
                    }
                    subTaskName = new StringBuilder("(");
                    subTaskName.append(currentFile).append(FOLDER_DELIMITER).append(nbFiles).append(") : ").append(afilename);
                    if (totalNbOfRefs > MAX_REF_WITHOUT_WRITING) {
                        this.registerMacro(designSubRefs, usageSubRefs);
                        designSubRefs.clear();
                        usageSubRefs.clear();
                        totalNbOfRefs = 0;
                    }
                    progress.subTask(subTaskName.toString());
                    ++currentFile;
                    cumul2 = Math.round(cumul += step);
                    if (cumul2 == done) continue;
                    progress.worked(cumul2 - done);
                    done = cumul2;
                }
                progress.setTaskName(MACROS_LINKS_SAVING);
                progress.subTask("");
                progress.worked(STEP3_1);
                this.registerMacro(designSubRefs, usageSubRefs);
                progress.worked(STEP3_2);
            }
            finally {
                progress.done();
            }
        }
        long fin = System.currentTimeMillis();
        if (engineTraceLevel <= 0) return;
        String message = "Nb of doc registered = " + nbOfDocsRegistered + CR + "Time elapsed = " + (fin - debut) + CR + "Exit rebuildWorkspaceMacrosLinks : " + CR;
        traceManager.trace(this.getClass(), "com.ibm.pdp.framework", 1, message);
    }

    public void registerResources(List<String> pdpFileNames) {
        long start;
        if (this.isRPPInBatchMode()) {
            return;
        }
        long l = start = performanceManager.isEnabled() ? System.currentTimeMillis() : -1L;
        if (pdpFileNames == null || pdpFileNames.size() == 0) {
            return;
        }
        HashMap<String, Document> addedDocuments = new HashMap<String, Document>();
        HashMap<String, List<Reference>> addedPrimaryReferences = new HashMap<String, List<Reference>>();
        HashMap<String, List<Reference>> addedSecondaryReferences = new HashMap<String, List<Reference>>();
        HashMap<String, List<Reference>> addedMPReferences = new HashMap<String, List<Reference>>();
        HashMap<String, List<Reference>> addedUsagesReferences = new HashMap<String, List<Reference>>();
        for (String resourcePath : pdpFileNames) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(resourcePath));
            if (!file.exists()) continue;
            String location = file.getLocation().toOSString();
            this.retrieveMetadatas(location, addedDocuments, addedPrimaryReferences, addedSecondaryReferences, addedMPReferences, addedUsagesReferences);
        }
        this.saveMetadatas(addedDocuments, addedPrimaryReferences, addedSecondaryReferences, addedMPReferences, addedUsagesReferences);
        addedDocuments.clear();
        addedPrimaryReferences.clear();
        addedSecondaryReferences.clear();
        addedMPReferences.clear();
        addedUsagesReferences.clear();
        if (performanceManager.isEnabled()) {
            performanceManager.addTotalTimeMillis("PDP_RESOURCE_MANAGER_REG_RESOURCES", System.currentTimeMillis() - start);
        }
    }

    public void deleteMacrosDesignAndUsageSubReferences(Set<String> documents) {
        HashSet<String> categ = new HashSet<String>();
        categ.add("usage");
        categ.add("micropattern");
        MetadataContext context = new MetadataContext(categ, BooleanClause.Occur.SHOULD, null);
        this._metadataAccess.deleteReferences(context, documents);
    }

    public void registerMacro(Map<String, List<Reference>> designSubRef, Map<String, List<Reference>> usageSubRefs) {
        this._metadataAccess.writeReferences(PUBLIC_MICROPATTERN_CAT_SET, designSubRef);
        this.clearPropertiesFrom(usageSubRefs);
        this._metadataAccess.writeReferences(PUBLIC_DATAELEMENT_USAGE_CAT_SET, usageSubRefs);
    }

    public void registerResource(String pdpFileName) {
        if (this.isRPPInBatchMode()) {
            return;
        }
        if (pdpFileName == null || pdpFileName.length() == 0) {
            return;
        }
        String location = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(pdpFileName)).getLocation().toOSString();
        HashMap<String, Document> documents = new HashMap<String, Document>();
        HashMap<String, List<Reference>> primaryRef = new HashMap<String, List<Reference>>();
        HashMap<String, List<Reference>> secondaryRef = new HashMap<String, List<Reference>>();
        HashMap<String, List<Reference>> mpRef = new HashMap<String, List<Reference>>();
        HashMap<String, List<Reference>> usagesRef = new HashMap<String, List<Reference>>();
        this.retrieveMetadatas(location, documents, primaryRef, secondaryRef, mpRef, usagesRef);
        Iterator docsKeys = documents.keySet().iterator();
        if (!docsKeys.hasNext()) {
            return;
        }
        this.saveMetadatas(documents, primaryRef, secondaryRef, mpRef, usagesRef);
    }

    public int retrieveMetadatas(String pdpFileName, Map<String, Document> documents, Map<String, List<Reference>> primaryReferences, Map<String, List<Reference>> secondaryReferences, Map<String, List<Reference>> mpReferences, Map<String, List<Reference>> usagesReferences) {
        if (this.isRPPInBatchMode()) {
            return 0;
        }
        if (pdpFileName == null || pdpFileName.length() == 0) {
            return 0;
        }
        PdpFileGenerationLinksParser parser = new PdpFileGenerationLinksParser();
        PdpFileGenerationLinksParserResult genLinks = parser.parse(pdpFileName, _generatedResourcesGlobalMap, false);
        if (genLinks == null || genLinks.getDocument() == null || genLinks.getGenerationRefs() == null || genLinks.getGenerationRefs().size() == 0) {
            throw new RuntimeException("Invalid data for :" + pdpFileName);
        }
        long start = performanceManager.isEnabled() ? System.currentTimeMillis() : -1L;
        int totalNbOfRefs = 0;
        Document aDoc = genLinks.getDocument();
        if (aDoc != null) {
            List de_usagesRefs;
            List metaRefs = genLinks.getGenerationRefs();
            String docId = aDoc.getId();
            documents.put(docId, aDoc);
            List<List<Reference>> ref = this.splitReferences(metaRefs);
            primaryReferences.put(docId, ref.get(0));
            secondaryReferences.put(docId, ref.get(1));
            this.addItemInEntryPointsMap(ref.get(0));
            List mpRefs = genLinks.getMicroPatternRefs();
            if (mpRefs != null && mpRefs.size() > 0) {
                mpReferences.put(docId, genLinks.getMicroPatternRefs());
            }
            if ((de_usagesRefs = genLinks.getDetailedUsages()) != null && de_usagesRefs.size() > 0) {
                usagesReferences.put(docId, de_usagesRefs);
            }
            totalNbOfRefs = metaRefs.size() + mpRefs.size() + de_usagesRefs.size();
        }
        if (performanceManager.isEnabled()) {
            performanceManager.addTotalTimeMillis("PDP_RESOURCE_MANAGER_RET_METADATAS", System.currentTimeMillis() - start);
        }
        return totalNbOfRefs;
    }

    private List<List<Reference>> splitReferences(List<Reference> references) {
        ArrayList<List<Reference>> result = new ArrayList<List<Reference>>(2);
        ArrayList<Reference> entryPointList = new ArrayList<Reference>(1);
        ArrayList<Reference> othersList = new ArrayList<Reference>(references.size() - 1);
        result.add(entryPointList);
        result.add(othersList);
        for (Reference aRef : references) {
            if (aRef.getRelation().indexOf("entrypoint") != -1) {
                entryPointList.add(aRef);
                continue;
            }
            othersList.add(aRef);
        }
        return result;
    }

    public void saveMetadatas(Map<String, Document> documents, Map<String, List<Reference>> primaryRef, Map<String, List<Reference>> secondaryRef, Map<String, List<Reference>> mpRef, Map<String, List<Reference>> usagesRef) {
        if (this.isRPPInBatchMode()) {
            return;
        }
        long start = performanceManager.isEnabled() ? System.currentTimeMillis() : -1L;
        this._metadataAccess.deleteDocuments(documents.keySet());
        this._metadataAccess.writeDocuments(PUBLIC_GENERATION_CAT_SET, new ArrayList<Document>(documents.values()));
        this._metadataAccess.deleteReferences(documents.keySet());
        this._metadataAccess.writeReferences(PUBLIC_ENTRYPOINT_CAT_SET, primaryRef);
        this._metadataAccess.writeReferences(PRIVATE_GENERATION_CAT_SET, secondaryRef);
        this._metadataAccess.writeReferences(PUBLIC_MICROPATTERN_CAT_SET, mpRef);
        this.clearPropertiesFrom(usagesRef);
        this._metadataAccess.writeReferences(PUBLIC_DATAELEMENT_USAGE_CAT_SET, usagesRef);
        if (performanceManager.isEnabled()) {
            performanceManager.addTotalTimeMillis("PDP_RESOURCE_MANAGER_SAVE_METADATAS", System.currentTimeMillis() - start);
        }
    }

    private boolean removeItemInEntryPointsMap(List<Reference> references) {
        String prjName;
        Set<String> entryPointsSet;
        String designId = this.getEntryPointId(references);
        if (designId != null && (entryPointsSet = _generatedEntryPointsMap.get(prjName = PdpResourcesMgr.getProjectName(designId))) != null) {
            entryPointsSet.remove(designId);
            if (entryPointsSet.size() == 0) {
                _generatedEntryPointsMap.remove(prjName);
            }
            return true;
        }
        return false;
    }

    private void unregisterResourcesSubProcess(Set<String> documentsIds) {
        Map subReferences = this._metadataAccess.readReferences(documentsIds, 0);
        for (String docId : subReferences.keySet()) {
            List subRefs = (List)subReferences.get(docId);
            this.removeItemInEntryPointsMap(subRefs);
        }
        this._metadataAccess.deleteReferences(documentsIds);
        this._metadataAccess.deleteDocuments(documentsIds);
    }

    public void unregisterResources(List<String> generatedResourceURIs) {
        if (this.isRPPInBatchMode() || generatedResourceURIs == null) {
            return;
        }
        HashSet<String> documentsIds = new HashSet<String>();
        for (String generatedResourceURI : generatedResourceURIs) {
            String fileId;
            Document genRes;
            String projectName = PdpResourcesMgr.getProjectName(generatedResourceURI);
            Map<String, Document> internalMap = _generatedResourcesGlobalMap.get(projectName);
            if (internalMap == null || (genRes = this.getResource(fileId = this.getRelativeFileIdFromURI(generatedResourceURI))) == null) continue;
            String generatedResourceID = genRes.getId();
            internalMap.remove(generatedResourceID);
            if (internalMap.size() == 0) {
                _generatedResourcesGlobalMap.remove(projectName);
            }
            documentsIds.add(generatedResourceID);
            if (documentsIds.size() <= BUFFER_SIZE) continue;
            this.unregisterResourcesSubProcess(documentsIds);
            documentsIds = new HashSet();
        }
        if (documentsIds.size() > 0) {
            this.unregisterResourcesSubProcess(documentsIds);
        }
    }

    public void unregisterResource(String generatedResourceURI) {
        if (this.isRPPInBatchMode()) {
            return;
        }
        if (generatedResourceURI == null || generatedResourceURI.length() == 0) {
            return;
        }
        ArrayList<String> l = new ArrayList<String>();
        l.add(generatedResourceURI);
        this.unregisterResources(l);
    }
}

