/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.resources;

import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.io.MetadataAccess;
import com.ibm.pdp.mdl.meta.io.MetadataContext;
import com.ibm.pdp.resources.PdpResourcesMgr;
import com.ibm.pdp.trace.PTTraceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;

public class PdpResourceParser {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2010, 2013.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static String[] getAllProjectsNames(IPath path) {
        File dir;
        PTTraceManager traceManager;
        int engineTraceLevel;
        if ((path == null || path.isEmpty()) && (engineTraceLevel = (traceManager = PTTraceManager.getInstance()).getTraceLevel("com.ibm.pdp.framework")) > 0) {
            String message = "\r\nEnter getAllProjectsNames.\r\nInvalid path passed in parameter : " + path;
            traceManager.trace(PdpResourceParser.class, "com.ibm.pdp.framework", 1, message);
        }
        if ((dir = new File(path.toString())) == null || !dir.isDirectory()) {
            return new String[0];
        }
        File[] dirList = dir.listFiles();
        ArrayList<String> temp = new ArrayList<String>(dirList.length);
        int i = 0;
        while (i < dirList.length) {
            if (dirList[i].isDirectory()) {
                temp.add(dirList[i].getName());
            }
            ++i;
        }
        String[] result = new String[temp.size()];
        temp.toArray(result);
        return result;
    }

    public static void loadAllDocumentsFromLucene(MetadataAccess metaDataAccess, Map<String, Map<String, Document>> generatedResources) {
        MetadataContext context = new MetadataContext("generatedResource", null);
        List docs = metaDataAccess.readDocuments(context);
        for (Document aDoc : docs) {
            String projectName = PdpResourcesMgr.getProjectName(aDoc.getId());
            Map<String, Document> docsMap = generatedResources.get(projectName);
            if (docsMap == null) {
                docsMap = new HashMap<String, Document>();
            }
            docsMap.put(aDoc.getId(), aDoc);
            generatedResources.put(projectName, docsMap);
        }
    }
}

