/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.references.util;

import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.references.ReferencesPlugin;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.DocumentProviderRegistry;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class DocumentProviderUtil {
    public static final String copyright = "Licensed Materials - Property of IBM\n5724-T07\n(C) Copyright IBM Corp. 2011.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static IDocumentProvider getDocumentProvider(IEditorInput editorInput) {
        return DocumentProviderRegistry.getDefault().getDocumentProvider(editorInput);
    }

    public static void connectToDocument(IDocumentProvider documentProvider, IEditorInput editorInput) {
        try {
            documentProvider.connect((Object)editorInput);
        }
        catch (Exception e) {
            String mess = "Error while connecting to the document : " + editorInput.getName();
            PdpTool.logErr((Plugin)ReferencesPlugin.getDefault(), (String)"com.ibm.pdp.references", (String)mess, (Throwable)e);
        }
    }

    public static void disconnectFromDocument(IDocumentProvider documentProvider, IEditorInput editorInput) {
        try {
            documentProvider.disconnect((Object)editorInput);
        }
        catch (Exception e) {
            String mess = "Error while disconnecting from the document : " + editorInput.getName();
            PdpTool.logErr((Plugin)ReferencesPlugin.getDefault(), (String)"com.ibm.pdp.references", (String)mess, (Throwable)e);
        }
    }
}

