/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.references.service;

import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.Reference;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IControllerFactory;
import com.ibm.pdp.framework.interfaces.IReference;
import com.ibm.pdp.generation.menu.SynchronizationTool;
import java.io.File;

public class ReferenceService {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static boolean checkDesynchronizationWithDesigns(String sourceFileName) {
        if (sourceFileName == null) {
            return true;
        }
        String _sourceFileName = ReferenceService.normalizeFileName(sourceFileName);
        IController _controler = ReferenceService.getController(_sourceFileName);
        String _logicalFileName = _controler.getGenerationLink().getGenerationOutput().getLogicalFileName();
        ControllerFactory.getInstance().dispose(_controler);
        return SynchronizationTool.checkIfTheGeneratedResourceNeedsRegeneration(_logicalFileName, _sourceFileName);
    }

    public static IReference newReference(String project, String packageName, String metaType, String name, String type, String identifier, String relationName) {
        return new Reference(project, true, packageName, metaType, name, type, identifier, relationName);
    }

    private static String normalizeFileName(String fileName) {
        return new File(fileName).getPath().replace('\\', '/');
    }

    private static IController getController(String sourceFileName) {
        String _sourceFileName = ReferenceService.normalizeFileName(sourceFileName);
        IControllerFactory _factory = ControllerFactory.getInstance();
        if (_factory == null) {
            return null;
        }
        return _factory.getController(_sourceFileName, false);
    }
}

