/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.references.entityduplication;

import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.explorer.view.service.PTWidgetTool;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.Property;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.util.PacGenerationValidityChecking;
import com.ibm.pdp.references.entityduplication.DuplicationData;
import com.ibm.pdp.references.entityduplication.Messages;
import com.ibm.pdp.resources.PdpResourcesMgr;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DuplicationWizardPage
extends WizardPage {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String DESC1 = Messages.DuplicationWizardPage_DESC1;
    private static String DESC2 = Messages.DuplicationWizardPage_DESC2;
    private static String DESC3 = Messages.DuplicationWizardPage_DESC3;
    private static String DESC4 = Messages.DuplicationWizardPage_DESC4;
    private static String DESC5 = Messages.DuplicationWizardPage_DESC5;
    private static String DUPLICATE_ALL_PROJECTS = Messages.DuplicationWizardPage_DUPLICATE_ALL_PROJECTS;
    private static String DESIGN_PROJ = Messages.DuplicationWizardPage_DESIGN_PROJ;
    private static String DESIGN_ENTITY_NAME = Messages.DuplicationWizardPage_DESIGN_ENTITY_NAME;
    private static String COBOL_PROJ = Messages.DuplicationWizardPage_COBOL_PROJ;
    private static String COBOL_FOLDER = Messages.DuplicationWizardPage_COBOL_FOLDER;
    private static String COBOL_NAME = Messages.DuplicationWizardPage_COBOL_NAME;
    private static String MAP_PROJ = Messages.DuplicationWizardPage_MAP_PROJ;
    private static String MAP_FOLDER = Messages.DuplicationWizardPage_MAP_FOLDER;
    private static String MAP_NAME = Messages.DuplicationWizardPage_MAP_NAME;
    private static String DESIGN_NAME_ALREADY_USED = Messages.DuplicationWizardPage_DESIGN_NAME_ALREADY_USED;
    private static String PROJ_WITH_NOT_PTNATURE = Messages.DuplicationWizardPage_PROJ_WITH_NOT_PTNATURE;
    private static String COBOL_FOLDER_MUST_NOT_BE_EMPTY = Messages.DuplicationWizardPage_COBOL_FOLDER_MUST_NOT_BE_EMPTY;
    private static String COBOL_FOLDER_FORMAT_ERR = Messages.DuplicationWizardPage_COBOL_FOLDER_FORMAT_ERR;
    private static String COBOL_FOLDER_MUST_BE_EMPTY = Messages.DuplicationWizardPage_COBOL_FOLDER_MUST_BE_EMPTY;
    private static String MAP_FOLDER_MUST_NOT_BE_EMPTY = Messages.DuplicationWizardPage_MAP_FOLDER_MUST_NOT_BE_EMPTY;
    private static String MAP_FOLDER_FORMAT_ERR = Messages.DuplicationWizardPage_MAP_FOLDER_FORMAT_ERR;
    private static String MAP_FOLDER_MUST_BE_EMPTY = Messages.DuplicationWizardPage_MAP_FOLDER_MUST_BE_EMPTY;
    private static String PROGRAMID_ALREADY_USED = Messages.DuplicationWizardPage_PROGRAMID_ALREADY_USED;
    private static String MAP_NAME_ALREADY_USED = Messages.DuplicationWizardPage_MAP_NAME_ALREADY_USED;
    private static String SERVER_SERVICE = Messages._SERVER_SERVICE_NAME;
    private static String SERVICE_PROJ = Messages.DuplicationWizardPage_SERVICE_PROJ;
    private static String SERVICE_FOLDER = Messages.DuplicationWizardPage_SERVICE_FOLDER;
    private static String PROGRAMID_INVALID = Messages.DuplicationWizardPage_PROGRAMID_INVALID;
    private static String MAPID_INVALID = Messages.DuplicationWizardPage_MAPID_INVALID;
    private static String SERVICEID_INVALID = Messages.DuplicationWizardPage_SERVICEID_INVALID;
    private static String PROGRAMID_DESIGNID_INVALID = Messages.DuplicationWizardPage_PROGRAMID_DESIGNID_INVALID;
    private Button _newDesignPrj_All;
    private Combo _newDesignPrjCombo;
    private Text _newDesignName;
    private Text _newCobolFolder;
    private Combo _newCobolPrjCombo;
    private Text _newCobolName;
    private Combo _newMapPrjCombo;
    private Text _newMapFolder;
    private Text _newMapName;
    private PTElement _element2Duplicate;
    private DuplicationData _duplicationData;
    private boolean _isMapToGenerate;
    private boolean _isServiceServerToGenerate;
    private String[] _availableProjects;
    private String[] _allProjects;
    private List<String> _possibleCandidateForDesignProjects;
    boolean _setupInProgress = true;
    private static String CR = System.getProperty("line.separator");
    private static String SLASH = "/";
    private static String CBL_EXT = ".cbl";
    private static String EMPTY_STR = "";
    private ModifyListener _designProjComboListener = new ModifyListener(){

        public void modifyText(ModifyEvent arg0) {
            DuplicationWizardPage.this.setPageComplete(DuplicationWizardPage.this.isPageComplete());
        }
    };

    public DuplicationWizardPage(String pageName, PTElement elem2Duplicate, DuplicationData duplicationData) {
        super(pageName);
        this.setTitle(pageName);
        String mess = String.valueOf(DESC1) + CR + DESC2 + CR + DESC3 + CR + DESC4 + CR + DESC5;
        this.setDescription(mess);
        this._element2Duplicate = elem2Duplicate;
        this._duplicationData = duplicationData;
    }

    public void createControl(Composite parent) {
        this.init();
        Composite composite = PTWidgetTool.createComposite((Composite)parent, (int)2, (boolean)false);
        GridData gridData = new GridData(4, 1, true, false);
        composite.setLayoutData((Object)gridData);
        this.setHelp(composite);
        this.createLabelsAndFields(composite);
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setupData();
        this.setControl((Control)composite);
    }

    private static Combo createDropDownCombo(Composite parent) {
        Combo combo = new Combo(parent, 12);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gridData);
        return combo;
    }

    private void createLabelsAndFields(Composite composite) {
        this._newDesignPrj_All = PTWidgetTool.createCheckBox((Composite)composite, (String)DUPLICATE_ALL_PROJECTS, (int)2);
        this._newDesignPrj_All.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                Button btn = (Button)arg0.getSource();
                DuplicationWizardPage.this._newDesignPrjCombo.removeModifyListener(DuplicationWizardPage.this._designProjComboListener);
                DuplicationWizardPage.this.determinePossibleGoodDesignProjects(btn.getSelection());
                DuplicationWizardPage.this._newDesignPrjCombo.setItems(DuplicationWizardPage.this._availableProjects);
                int idx = DuplicationWizardPage.this.getIndex(DuplicationWizardPage.this._availableProjects, DuplicationWizardPage.this._element2Duplicate.getProjectName());
                if (idx != -1) {
                    DuplicationWizardPage.this._newDesignPrjCombo.select(idx);
                }
                DuplicationWizardPage.this._newDesignPrjCombo.addModifyListener(DuplicationWizardPage.this._designProjComboListener);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        PTWidgetTool.createLabel((Composite)composite, (String)DESIGN_PROJ);
        this._newDesignPrjCombo = DuplicationWizardPage.createDropDownCombo(composite);
        this._newDesignPrjCombo.addModifyListener(this._designProjComboListener);
        PTWidgetTool.createLabel((Composite)composite, (String)DESIGN_ENTITY_NAME);
        this._newDesignName = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        this._newDesignName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DuplicationWizardPage.this.setPageComplete(DuplicationWizardPage.this.isPageComplete());
            }
        });
        boolean enabled = !this._duplicationData.getOldCobolName().isEmpty();
        PTWidgetTool.createLabel((Composite)composite, (String)COBOL_PROJ);
        this._newCobolPrjCombo = DuplicationWizardPage.createDropDownCombo(composite);
        this._newCobolPrjCombo.getLayoutData();
        this._newCobolPrjCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DuplicationWizardPage.this.setPageComplete(DuplicationWizardPage.this.isPageComplete());
            }
        });
        this._newCobolPrjCombo.setEnabled(enabled);
        PTWidgetTool.createLabel((Composite)composite, (String)COBOL_FOLDER);
        this._newCobolFolder = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        this._newCobolFolder.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DuplicationWizardPage.this.setPageComplete(DuplicationWizardPage.this.isPageComplete());
            }
        });
        this._newCobolFolder.setEnabled(enabled);
        PTWidgetTool.createLabel((Composite)composite, (String)COBOL_NAME);
        this._newCobolName = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
        this._newCobolName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DuplicationWizardPage.this.setPageComplete(DuplicationWizardPage.this.isPageComplete());
            }
        });
        this._newCobolName.setEnabled(enabled);
        if (this._isMapToGenerate || this._isServiceServerToGenerate) {
            if (this._isServiceServerToGenerate) {
                PTWidgetTool.createLabel((Composite)composite, (String)SERVICE_PROJ);
            } else {
                PTWidgetTool.createLabel((Composite)composite, (String)MAP_PROJ);
            }
            this._newMapPrjCombo = DuplicationWizardPage.createDropDownCombo(composite);
            this._newMapPrjCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    DuplicationWizardPage.this.setPageComplete(DuplicationWizardPage.this.isPageComplete());
                }
            });
            this._newMapPrjCombo.setEnabled(enabled && this._isMapToGenerate);
            if (this._isServiceServerToGenerate) {
                PTWidgetTool.createLabel((Composite)composite, (String)SERVICE_FOLDER);
            } else {
                PTWidgetTool.createLabel((Composite)composite, (String)MAP_FOLDER);
            }
            this._newMapFolder = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
            this._newMapFolder.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    DuplicationWizardPage.this.setPageComplete(DuplicationWizardPage.this.isPageComplete());
                }
            });
            this._newMapFolder.setEnabled(enabled && this._isMapToGenerate);
            PTWidgetTool.createLabel((Composite)composite, (String)(this._isServiceServerToGenerate ? SERVER_SERVICE : MAP_NAME));
            this._newMapName = PTWidgetTool.createTextField((Composite)composite, (boolean)false, (boolean)false);
            this._newMapName.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    DuplicationWizardPage.this.setPageComplete(DuplicationWizardPage.this.isPageComplete());
                }
            });
            this._newMapName.setEnabled(enabled && (this._isMapToGenerate || this._isServiceServerToGenerate));
        }
    }

    public void setHelp(Composite composite) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getContextId());
    }

    protected String getContextId() {
        return "com.ibm.pdp.doc.cshelp.Duplicate";
    }

    private String getFolderString(String folderName) {
        String folderNameStr = folderName.isEmpty() ? EMPTY_STR : String.valueOf(SLASH) + folderName;
        return folderNameStr;
    }

    private void determineIfMapIsToGenerate() {
        RadicalEntity re1 = PTModelService.getResource((String)this._element2Duplicate.getProjectName(), (String)this._element2Duplicate.getPackageName(), (String)this._element2Duplicate.getName(), (String)this._element2Duplicate.getDocument().getType());
        this._isServiceServerToGenerate = false;
        if (re1 instanceof PacScreen) {
            this._isMapToGenerate = ((PacScreen)re1).isGenerateWithMap();
            return;
        }
        if (re1 instanceof PacServer) {
            this._isServiceServerToGenerate = true;
        }
        this._isMapToGenerate = false;
    }

    private void init() {
        RadicalEntity re1;
        String[] cblTokens;
        this._allProjects = this.getAllWksProjects();
        this.determinePossibleGoodDesignProjects(false);
        this.determineIfMapIsToGenerate();
        String designId = this._element2Duplicate.getDocument().getId();
        Iterator superRefs = PdpResourcesMgr.getInstance().getSuperReferences(designId);
        String cblNameID = EMPTY_STR;
        String mapNameID = EMPTY_STR;
        while (superRefs.hasNext()) {
            Reference ref = (Reference)superRefs.next();
            if (ref.getRelation().endsWith("1_entrypoint")) {
                Property patternProperty;
                String sourceId = ref.getSourceId();
                String[] tokens = MetadataService.getTokens((String)sourceId);
                if (tokens[4].equals("cbl")) {
                    cblNameID = sourceId;
                }
                if ((patternProperty = ref.getProperty("pattern")) == null) continue;
                String patternName = patternProperty.getValue();
                this._duplicationData.getPatternsUsed().add(patternName);
                continue;
            }
            if (!ref.getRelation().endsWith("2_entrypoint")) continue;
            mapNameID = ref.getSourceId();
        }
        if (cblNameID.length() > 13) {
            this._duplicationData.setCobolFileNameAbsolute(cblNameID.indexOf(37) != -1);
            cblNameID = cblNameID.replace(String.valueOf(EMPTY_STR) + '%', EMPTY_STR);
            cblTokens = MetadataService.getTokens((String)cblNameID);
            this._duplicationData.setOldCobolProject(cblTokens[0]);
            this._duplicationData.setOldCobolFolder(cblTokens[1].replace('.', '/'));
            this._duplicationData.setOldCobolName(cblTokens[2]);
        } else {
            this._duplicationData.setOldCobolProject(EMPTY_STR);
            this._duplicationData.setOldCobolFolder(EMPTY_STR);
            this._duplicationData.setOldCobolName(EMPTY_STR);
        }
        if (mapNameID.length() > 13) {
            mapNameID = mapNameID.replace(String.valueOf(EMPTY_STR) + '%', EMPTY_STR);
            cblTokens = MetadataService.getTokens((String)mapNameID);
            this._duplicationData.setOldMapProject(cblTokens[0]);
            this._duplicationData.setOldMapFolder(cblTokens[1].replace('.', '/'));
            this._duplicationData.setOldMapName(cblTokens[2]);
        } else if (this._isMapToGenerate && (re1 = PTModelService.getResource((String)this._element2Duplicate.getProjectName(), (String)this._element2Duplicate.getPackageName(), (String)this._element2Duplicate.getName(), (String)this._element2Duplicate.getDocument().getType())) instanceof PacScreen) {
            PacScreen ps = (PacScreen)re1;
            String mapProject = ps.getMapProject();
            if (mapProject.trim().length() == 0) {
                mapProject = ps.getCobolProject();
            }
            this._duplicationData.setOldMapProject(mapProject);
            String mapFolder = ps.getMapFolder();
            if (mapFolder.trim().length() == 0) {
                mapFolder = ps.getMapFolder();
            }
            this._duplicationData.setOldMapFolder(mapFolder);
            this._duplicationData.setOldMapName(ps.getScreenExternalName());
        }
    }

    private int getIndex(String[] elements, String elem) {
        int i = 0;
        while (i < elements.length) {
            if (elements[i].equalsIgnoreCase(elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void setupData() {
        this._setupInProgress = true;
        this._newDesignPrjCombo.setItems(this._availableProjects);
        int idx = this.getIndex(this._availableProjects, this._element2Duplicate.getProjectName());
        this._newDesignPrjCombo.select(idx);
        this._newDesignName.setText(this._element2Duplicate.getName());
        this._newCobolPrjCombo.setItems(this._allProjects);
        int idxCbl = this.getIndex(this._allProjects, this._duplicationData.getOldCobolProject());
        this._newCobolPrjCombo.select(idxCbl);
        this._newCobolFolder.setText(this._duplicationData.getOldCobolFolder());
        if (!this._duplicationData.isCobolFileNameAbsolute()) {
            this._newCobolFolder.setEnabled(false);
        }
        this._newCobolName.setText(this._duplicationData.getOldCobolName());
        if (this._isMapToGenerate || this._isServiceServerToGenerate) {
            this._newMapPrjCombo.setItems(this._allProjects);
            int idxMap = this.getIndex(this._allProjects, this._duplicationData.getOldMapProject());
            this._newMapPrjCombo.select(idxMap);
            if (this._duplicationData.getOldMapFolder() != null) {
                this._newMapFolder.setText(this._duplicationData.getOldMapFolder());
            }
            if (!this._duplicationData.isCobolFileNameAbsolute()) {
                this._newMapFolder.setEnabled(false);
            }
            if (this._duplicationData.getOldMapName() != null) {
                this._newMapName.setText(this._duplicationData.getOldMapName());
            }
        }
        this._setupInProgress = false;
    }

    private String getNewLogicalCobolFileName() {
        String newCobolFileName = this._duplicationData.isCobolFileNameAbsolute() ? String.valueOf(SLASH) + '%' : SLASH;
        String folderStr = this.getFolderString(this._newCobolFolder.getText());
        newCobolFileName = String.valueOf(newCobolFileName) + this._newCobolPrjCombo.getItem(this._newCobolPrjCombo.getSelectionIndex()) + folderStr + SLASH + this._newCobolName.getText() + CBL_EXT;
        return newCobolFileName;
    }

    private String getNewLogicalMapFileIncompleteName() {
        String newMapFileName = this._duplicationData.isCobolFileNameAbsolute() ? String.valueOf(SLASH) + '%' : SLASH;
        String folderStr = this.getFolderString(this._newMapFolder.getText());
        String mapProject = "";
        if (this._newMapPrjCombo.getSelectionIndex() >= 0) {
            mapProject = this._newMapPrjCombo.getItem(this._newMapPrjCombo.getSelectionIndex());
        }
        if (this._newCobolPrjCombo.getSelectionIndex() >= 0) {
            mapProject = this._newCobolPrjCombo.getItem(this._newCobolPrjCombo.getSelectionIndex());
        }
        if ((newMapFileName = String.valueOf(newMapFileName) + mapProject + folderStr + SLASH + this._newMapName.getText()).equals("//")) {
            newMapFileName = "";
        }
        return newMapFileName;
    }

    private String[] getAllWksProjects() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject[] projects = root.getProjects();
        ArrayList<String> projectNamesList = new ArrayList<String>();
        int i = 0;
        while (i < projects.length) {
            String aName = projects[i].getName();
            if (!aName.startsWith("..") && !aName.startsWith("Remote")) {
                projectNamesList.add(projects[i].getName());
            }
            ++i;
        }
        String[] projectNames = new String[projectNamesList.size()];
        projectNamesList.toArray(projectNames);
        return projectNames;
    }

    private void determinePossibleGoodDesignProjects(boolean allProjects) {
        IProject[] designProjects;
        String prjName = this._element2Duplicate.getProjectName();
        PTNature nature = PTNature.getNature((String)prjName);
        if (nature == null) {
            return;
        }
        this._possibleCandidateForDesignProjects = new ArrayList<String>();
        if (!allProjects) {
            this._possibleCandidateForDesignProjects.add(prjName);
        }
        IProject[] iProjectArray = designProjects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = designProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject aPrj = iProjectArray[n2];
            if (!allProjects) {
                List reqProjects = PTNature.getRequiredPaths((String)aPrj.getName());
                if (reqProjects.contains(prjName)) {
                    this._possibleCandidateForDesignProjects.add(aPrj.getName());
                }
            } else {
                this._possibleCandidateForDesignProjects.add(aPrj.getName());
            }
            ++n2;
        }
        this._availableProjects = new String[this._possibleCandidateForDesignProjects.size()];
        this._possibleCandidateForDesignProjects.toArray(this._availableProjects);
    }

    public boolean isPageComplete() {
        if (this._setupInProgress) {
            return false;
        }
        String message = EMPTY_STR;
        String projectName = this._newDesignPrjCombo.getItem(this._newDesignPrjCombo.getSelectionIndex());
        RadicalEntity radEntity = PTModelService.getResource((String)projectName, (String)EMPTY_STR, (String)this._newDesignName.getText(), (String)this._element2Duplicate.getDocument().getType());
        if (radEntity != null) {
            this.setErrorMessage(DESIGN_NAME_ALREADY_USED);
            return false;
        }
        if (this._duplicationData.getOldCobolName().isEmpty()) {
            this.setErrorMessage(null);
            this.feedObjectDuplicationData();
            return true;
        }
        String prjName = this._element2Duplicate.getProjectName();
        PTNature nature = PTNature.getNature((String)prjName);
        if (nature == null) {
            this.setErrorMessage(PROJ_WITH_NOT_PTNATURE);
            return false;
        }
        String cblfolder = this._newCobolFolder.getText();
        if (this._duplicationData.isCobolFileNameAbsolute()) {
            if (cblfolder.isEmpty()) {
                this.setErrorMessage(COBOL_FOLDER_MUST_NOT_BE_EMPTY);
                return false;
            }
            if (cblfolder.startsWith(SLASH) || cblfolder.endsWith(SLASH) || cblfolder.indexOf(46) > -1) {
                this.setErrorMessage(COBOL_FOLDER_FORMAT_ERR);
                return false;
            }
        } else if (!cblfolder.isEmpty()) {
            this.setErrorMessage(COBOL_FOLDER_MUST_BE_EMPTY);
            return false;
        }
        if (this._isMapToGenerate) {
            String mapfolder = this._newMapFolder.getText();
            if (this._duplicationData.isCobolFileNameAbsolute()) {
                if (mapfolder.isEmpty()) {
                    this.setErrorMessage(MAP_FOLDER_MUST_NOT_BE_EMPTY);
                    return false;
                }
                if (mapfolder.startsWith(SLASH) || mapfolder.endsWith(SLASH) || cblfolder.indexOf(46) > -1) {
                    this.setErrorMessage(MAP_FOLDER_FORMAT_ERR);
                    return false;
                }
            } else if (!mapfolder.isEmpty()) {
                this.setErrorMessage(MAP_FOLDER_MUST_BE_EMPTY);
                return false;
            }
        }
        if (!PacGenerationValidityChecking.isValidExternalName((String)this._newDesignName.getText())) {
            this.setErrorMessage(PROGRAMID_DESIGNID_INVALID);
            return false;
        }
        if (this._newCobolName.getText().trim().length() > 0 && !PacGenerationValidityChecking.isValidExternalName((String)this._newCobolName.getText())) {
            this.setErrorMessage(PROGRAMID_INVALID);
            return false;
        }
        if (this._isServiceServerToGenerate && this._newMapName.getText().trim().length() > 0 && !PacGenerationValidityChecking.isValidExternalName((String)this._newMapName.getText())) {
            this.setErrorMessage(SERVICEID_INVALID);
            return false;
        }
        String newPgmId = this.getNewLogicalCobolFileName();
        Document document = PdpResourcesMgr.getInstance().getResource(newPgmId);
        if (document != null) {
            this.setErrorMessage(PROGRAMID_ALREADY_USED);
            return false;
        }
        if (this._isMapToGenerate) {
            String[] extensions = new String[]{".bms", ".mfs", ".map"};
            Document mapDocument = null;
            int i = 0;
            while (mapDocument == null && i < extensions.length) {
                String newMapId = this.getNewLogicalMapFileIncompleteName();
                newMapId = String.valueOf(newMapId) + extensions[i];
                mapDocument = PdpResourcesMgr.getInstance().getResource(newMapId);
                if (mapDocument != null) {
                    this.setErrorMessage(MAP_NAME_ALREADY_USED);
                    return false;
                }
                if (this._newMapName.getText().trim().length() > 0 && !PacGenerationValidityChecking.isValidExternalName((String)this._newMapName.getText())) {
                    this.setErrorMessage(MAPID_INVALID);
                    return false;
                }
                ++i;
            }
        }
        if (message.length() > 0) {
            this.setErrorMessage(message);
            return false;
        }
        this.feedObjectDuplicationData();
        this.setErrorMessage(null);
        return true;
    }

    private void feedObjectDuplicationData() {
        this._duplicationData.setNewDesignProject(this._newDesignPrjCombo.getItem(this._newDesignPrjCombo.getSelectionIndex()));
        this._duplicationData.setNewDesignFolder(EMPTY_STR);
        this._duplicationData.setNewDesignName(this._newDesignName.getText());
        if (this._duplicationData.getOldCobolName().isEmpty()) {
            this._duplicationData.setNewCobolProject(EMPTY_STR);
            this._duplicationData.setNewCobolFolder(EMPTY_STR);
            this._duplicationData.setNewCobolName(EMPTY_STR);
            this._duplicationData.setNewMapProject(EMPTY_STR);
            this._duplicationData.setNewMapFolder(EMPTY_STR);
            this._duplicationData.setNewMapName(EMPTY_STR);
            return;
        }
        this._duplicationData.setNewCobolProject(this._newCobolPrjCombo.getItem(this._newCobolPrjCombo.getSelectionIndex()));
        this._duplicationData.setNewCobolFolder(this._newCobolFolder.getText());
        this._duplicationData.setNewCobolName(this._newCobolName.getText());
        if (this._isMapToGenerate || this._isServiceServerToGenerate) {
            if (this._newMapPrjCombo.getSelectionIndex() >= 0) {
                this._duplicationData.setNewMapProject(this._newMapPrjCombo.getItem(this._newMapPrjCombo.getSelectionIndex()));
            }
            this._duplicationData.setNewMapFolder(this._newMapFolder.getText());
            this._duplicationData.setNewMapName(this._newMapName.getText());
        } else {
            this._duplicationData.setNewMapProject(EMPTY_STR);
            this._duplicationData.setNewMapFolder(EMPTY_STR);
            this._duplicationData.setNewMapName(EMPTY_STR);
        }
    }
}

