/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.references.entityduplication;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.model.PTResourceManager;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.nature.PTNature;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.GenerationManager;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IGenResult;
import com.ibm.pdp.framework.interfaces.IGenStatus;
import com.ibm.pdp.framework.interfaces.IPattern;
import com.ibm.pdp.framework.interfaces.IStatusMessage;
import com.ibm.pdp.framework.pattern.PdpPatternManager;
import com.ibm.pdp.framework.util.CharsetUtil;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.kernel.RadicalEntityExtension;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.mdl.pacbase.PacCPLine;
import com.ibm.pdp.mdl.pacbase.PacCobolTypeValues;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogTypeValues;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacLibrary;
import com.ibm.pdp.mdl.pacbase.PacLibrarySubstitutionGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacMacro;
import com.ibm.pdp.mdl.pacbase.PacMapTypeValues;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.mdl.pacbase.PacSourceInheritanceGenerationHeader;
import com.ibm.pdp.mdl.pacbase.PacStructuredLanguageEntity;
import com.ibm.pdp.pdppath.service.PdpPathService;
import com.ibm.pdp.references.ReferencesPlugin;
import com.ibm.pdp.references.entityduplication.DuplicationData;
import com.ibm.pdp.references.entityduplication.DuplicationWizardPage;
import com.ibm.pdp.references.entityduplication.Messages;
import com.ibm.pdp.references.entityduplication.service.IDuplicateSourceCodeExtension;
import com.ibm.pdp.resources.PdpResourcesMgr;
import com.ibm.pdp.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class DuplicationWizard
extends Wizard {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2023.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String DUPLICATION_WIZARD_TITLE = Messages.DuplicationWizard_DUPLICATION_WIZARD_TITLE;
    private static String DESIGN_ENTITY_DUPLICATION = Messages.DuplicationWizard_DESIGN_ENTITY_DUPLICATION;
    private IWizardPage _duplicationWizardPage;
    private PTElement _element2Duplicate;
    private DuplicationData _duplicationData;
    private boolean _isLogicalMode = false;
    private boolean _isMapToGenerate = false;
    private String _designStateID;
    private RadicalEntity _designInstance;
    private static String CR = System.getProperty("line.separator");
    private static String SLASH = "/";
    private static String CBL_EXT = ".cbl";
    private static String EMPTY_STR = "";
    private String _newCblFileName;
    private String _newCblpdpFileName;
    private String _mapExtension;

    public DuplicationWizard(PTElement element2Duplicate) {
        this.setWindowTitle(DUPLICATION_WIZARD_TITLE);
        this._element2Duplicate = element2Duplicate;
        this._duplicationData = new DuplicationData();
    }

    public void addPages() {
        if (this._duplicationWizardPage == null) {
            this._duplicationWizardPage = new DuplicationWizardPage(DESIGN_ENTITY_DUPLICATION, this._element2Duplicate, this._duplicationData);
        }
        this.addPage(this._duplicationWizardPage);
    }

    public boolean canFinish() {
        return this._duplicationWizardPage.isPageComplete();
    }

    private boolean createNecessaryCBLFolders() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String foldersChain = this._duplicationData.getNewCobolFolder();
        if (foldersChain.isEmpty()) {
            return true;
        }
        String[] segments = foldersChain.split(SLASH);
        String currentFolderChain = EMPTY_STR;
        try {
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String aSegment = stringArray[n2];
                currentFolderChain = String.valueOf(currentFolderChain) + SLASH + aSegment;
                IFolder aFolder = root.getFolder((IPath)new Path(String.valueOf(this._duplicationData.getNewCobolProject()) + currentFolderChain));
                if (!aFolder.exists()) {
                    aFolder.create(false, true, null);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
        return true;
    }

    private boolean createNecessaryPDPFolders(String pdpFileName) {
        String foldersChain = this._duplicationData.getNewCobolFolder();
        if (foldersChain.isEmpty()) {
            return true;
        }
        String cblpdp = PdpPathService.getMetaPdpRootFolder((String)this._duplicationData.getNewCobolProject());
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IFolder cblpdpfolder = root.getFolder((IPath)new Path(String.valueOf(this._duplicationData.getNewCobolProject()) + SLASH + cblpdp));
        try {
            if (!cblpdpfolder.exists()) {
                cblpdpfolder.create(false, true, null);
            }
            String[] segments = foldersChain.split(SLASH);
            String currentFolderChain = String.valueOf(SLASH) + cblpdp;
            String[] stringArray = segments;
            int n = segments.length;
            int n2 = 0;
            while (n2 < n) {
                String aSegment = stringArray[n2];
                currentFolderChain = String.valueOf(currentFolderChain) + SLASH + aSegment;
                IFolder aFolder = root.getFolder((IPath)new Path(String.valueOf(this._duplicationData.getNewCobolProject()) + currentFolderChain));
                if (!aFolder.exists()) {
                    aFolder.create(false, true, null);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
        }
        return true;
    }

    public boolean performFinish() {
        boolean b1;
        System.currentTimeMillis();
        ResourcesPlugin.getWorkspace().getRoot();
        this.determineIfMapIsToGenerate();
        if (this._duplicationData.getNewCobolProject().isEmpty() || this._duplicationData.getNewCobolName().isEmpty()) {
            boolean b12 = this.duplicateDesign();
            return b12;
        }
        this._isLogicalMode = true;
        if (this._duplicationData.isCobolFileNameAbsolute()) {
            this._isLogicalMode = false;
        }
        if (!(b1 = this.duplicateDesign())) {
            return false;
        }
        this.duplicateCobol();
        this.duplicateCblpdp();
        String newDesign = String.valueOf(SLASH) + this._duplicationData.getNewDesignProject() + SLASH + this._duplicationData.getNewDesignFolder() + SLASH + this._duplicationData.getNewDesignName();
        String realFileName = PdpTool.addRPPFolderToFileName((String)newDesign);
        realFileName = String.valueOf(realFileName) + "." + this._element2Duplicate.getDocument().getType();
        MetadataService.getId((String)this._duplicationData.getNewDesignProject(), (String)this._duplicationData.getNewDesignFolder(), (String)this._duplicationData.getNewDesignName(), null, (String)this._element2Duplicate.getDocument().getType());
        List<String> patternsUsed = this._duplicationData.getPatternsUsed();
        if (patternsUsed.size() != 0) {
            ArrayList<IGenStatus> failedGeneration = new ArrayList<IGenStatus>();
            for (String pattern : patternsUsed) {
                ArrayList controllers = new ArrayList();
                IController contr = ControllerFactory.getInstance().getController(this._newCblFileName);
                controllers.add(contr);
                IPattern ipattern = PdpPatternManager.getPdpPattern((String)pattern);
                IGenResult result = GenerationManager.generate((List)controllers, (Object)this._designInstance, (IPattern)ipattern, null, null);
                if (result.getGenStatus().getState() != 1) continue;
                failedGeneration.add(result.getGenStatus());
            }
            if (failedGeneration.size() != 0) {
                StringBuilder sb = new StringBuilder();
                for (IGenStatus iGenStatus : failedGeneration) {
                    Iterator messages = iGenStatus.getMessages();
                    while (messages.hasNext()) {
                        IStatusMessage statusMessage = (IStatusMessage)messages.next();
                        sb.append(statusMessage.getText());
                        sb.append("\r\n");
                    }
                }
                String errorMessage = sb.toString();
                String title = Messages.GENERATION_PROCESS;
                PdpTool.logErr((Plugin)ReferencesPlugin.getDefault(), (String)"com.ibm.pdp.references", (String)errorMessage);
                MessageDialog.openError(null, (String)title, (String)errorMessage);
                PdpTool.openErrorLog();
            }
        } else {
            String patternName = this.getPatternOfCurrentEntity();
            ArrayList<IController> controllers = new ArrayList<IController>();
            IController contr = ControllerFactory.getInstance().getController(this._newCblFileName);
            controllers.add(contr);
            IPattern ipattern = PdpPatternManager.getPdpPattern((String)patternName);
            IGenResult genResult = GenerationManager.generate(controllers, (Object)this._designInstance, (IPattern)ipattern, null, null);
            if (genResult.getGenStatus().getState() == 1) {
                StringBuilder sb = new StringBuilder();
                Iterator messages = genResult.getGenStatus().getMessages();
                while (messages.hasNext()) {
                    IStatusMessage statusMessage = (IStatusMessage)messages.next();
                    sb.append(statusMessage.getText());
                    sb.append("\r\n");
                }
                String errorMessage = sb.toString();
                String title = Messages.GENERATION_PROCESS;
                PdpTool.logErr((Plugin)ReferencesPlugin.getDefault(), (String)"com.ibm.pdp.references", (String)errorMessage);
                MessageDialog.openError(null, (String)title, (String)errorMessage);
                PdpTool.openErrorLog();
            }
        }
        this.duplicateSourceCodeExtension();
        System.currentTimeMillis();
        return true;
    }

    private void duplicateSourceCodeExtension() {
        IFile newFile = PdpTool.getFile((String)this._newCblFileName);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        String oldCobolName = this.getOldCobolOSFileName().substring(root.getLocation().toString().length());
        IFile oldFile = PdpTool.getFile((String)oldCobolName);
        List<IDuplicateSourceCodeExtension> duplicateSourceCodeExtensions = ReferencesPlugin.getDuplicateSourceCodeExtensions(oldFile.getFileExtension());
        if (duplicateSourceCodeExtensions != null && !duplicateSourceCodeExtensions.isEmpty()) {
            for (IDuplicateSourceCodeExtension codeExtension : duplicateSourceCodeExtensions) {
                codeExtension.duplicateSourceCode(oldFile, newFile);
            }
        }
        if (this._isMapToGenerate) {
            String newMapFileName = String.valueOf('/') + this._duplicationData.getNewMapProject() + '/' + this._duplicationData.getNewMapFolder() + '/' + this._duplicationData.getNewMapName() + '.' + this._mapExtension;
            String oldMapFileName = String.valueOf('/') + this._duplicationData.getOldMapProject() + '/' + this._duplicationData.getOldMapFolder() + '/' + this._duplicationData.getOldMapName() + '.' + this._mapExtension;
            try {
                oldFile = null;
                oldFile = PdpTool.getFile((String)oldMapFileName);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
            if (oldFile == null) {
                return;
            }
            newFile = PdpTool.getFile((String)newMapFileName);
            duplicateSourceCodeExtensions = ReferencesPlugin.getDuplicateSourceCodeExtensions(oldFile.getFileExtension());
            if (duplicateSourceCodeExtensions != null && !duplicateSourceCodeExtensions.isEmpty()) {
                for (IDuplicateSourceCodeExtension codeExtension : duplicateSourceCodeExtensions) {
                    codeExtension.duplicateSourceCode(oldFile, newFile);
                }
            }
        }
    }

    private boolean duplicateDesign() {
        Document metaDocument = this._element2Duplicate.getDocument();
        RadicalEntity clone = PTResourceManager.loadResource((Document)metaDocument);
        if (clone instanceof PacScreen || clone instanceof PacServer) {
            Iterator iter = clone instanceof PacScreen ? ((PacScreen)clone).getCPLines().iterator() : ((PacServer)clone).getCPLines().iterator();
            while (iter.hasNext()) {
                String newScreenCode;
                String oldScreenCode;
                PacMacro pacMacro;
                String source;
                String modifiedSource;
                PacCPLine cpLine;
                PacStructuredLanguageEntity sle;
                Object object = iter.next();
                if (!(object instanceof PacCPLine) || !(sle = (cpLine = (PacCPLine)object).getMacro()).getName().equals(String.valueOf(clone.getName()) + "SP")) continue;
                sle.setName(String.valueOf(this._duplicationData.getNewDesignName()) + "SP");
                if (sle instanceof PacMacro && !(modifiedSource = this.modifySourceCode(source = (pacMacro = (PacMacro)sle).getSource(), oldScreenCode = clone.getName().substring(2), newScreenCode = this._duplicationData.getNewDesignName().substring(2))).equals(source)) {
                    pacMacro.setSource(modifiedSource);
                }
                try {
                    sle.save();
                }
                catch (IOException e) {
                    Util.rethrow((Throwable)e);
                }
                sle = (PacStructuredLanguageEntity)PTModelService.resolveResource((String)clone.getProject(), (String)clone.getPackage(), (String)(String.valueOf(this._duplicationData.getNewDesignName()) + "SP"), (String)"pacmacro");
                cpLine.setMacro(sle);
            }
        }
        clone.setProject(this._duplicationData.getNewDesignProject());
        clone.setName(this._duplicationData.getNewDesignName());
        clone.setPackage(this._duplicationData.getNewDesignFolder());
        String programID = this._duplicationData.getNewDesignName();
        if (!this._duplicationData.getNewCobolName().isEmpty()) {
            programID = this._duplicationData.getNewCobolName();
        }
        PacLibrary newLib = DuplicationWizard.searchPacLibrary(this._duplicationData.getNewDesignProject());
        if (clone instanceof PacProgram) {
            PacProgram pgm = (PacProgram)clone;
            pgm.setGenerationParameter(newLib);
            pgm.setProgramID(programID);
            pgm.setCobolProject(this._duplicationData.getNewCobolProject());
            pgm.setCobolFolder(this._duplicationData.getNewCobolFolder());
        } else if (clone instanceof PacScreen) {
            PacScreen screen = (PacScreen)clone;
            screen.setGenerationParameter(newLib);
            screen.setProgramExternalName(programID);
            screen.setScreenExternalName(this._duplicationData.getNewMapName());
            screen.setCobolProject(this._duplicationData.getNewCobolProject());
            screen.setCobolFolder(this._duplicationData.getNewCobolFolder());
        } else if (clone instanceof PacServer) {
            PacServer server = (PacServer)clone;
            server.setGenerationParameter(newLib);
            server.setProgramExternalName(programID);
            server.setServerExternalName(this._duplicationData.getNewMapName());
            server.setCobolProject(this._duplicationData.getNewCobolProject());
            server.setCobolFolder(this._duplicationData.getNewCobolFolder());
        } else if (clone instanceof PacCommunicationMonitor) {
            PacCommunicationMonitor communicationMonitor = (PacCommunicationMonitor)clone;
            communicationMonitor.setGenerationParameter(newLib);
            communicationMonitor.setExternalName(programID);
            communicationMonitor.setCobolProject(this._duplicationData.getNewCobolProject());
            communicationMonitor.setCobolFolder(this._duplicationData.getNewCobolFolder());
        } else if (clone instanceof PacFolder) {
            PacFolder folder = (PacFolder)clone;
            folder.setGenerationParameter(newLib);
            folder.setExternalName(programID);
            folder.setCobolProject(this._duplicationData.getNewCobolProject());
            folder.setCobolFolder(this._duplicationData.getNewCobolFolder());
        }
        for (RadicalEntityExtension extension : clone.getExtensions()) {
            if (extension.getAlias().length() <= 0) continue;
            extension.setAlias(this._duplicationData.getNewDesignName());
        }
        clone.setMasterStateId(metaDocument.getStateId());
        try {
            clone.save();
        }
        catch (IOException e) {
            Util.rethrow((Throwable)e);
        }
        this._designStateID = clone.getStateId();
        this._designInstance = clone;
        return true;
    }

    private static PacLibrary searchPacLibrary(String newProject) {
        PacLibrary libraryFromDisk;
        if (newProject == null) {
            return null;
        }
        String pacLibraryName = null;
        int dotIndex = newProject.lastIndexOf(46);
        if (dotIndex != -1) {
            pacLibraryName = newProject.substring(dotIndex + 1);
        }
        if ((libraryFromDisk = (PacLibrary)PTModelService.getResource((String)newProject, (String)"", pacLibraryName, (String)"paclibrary")) != null) {
            return libraryFromDisk;
        }
        List paths = PTNature.getPaths((String)newProject);
        for (String project : paths) {
            pacLibraryName = null;
            dotIndex = project.lastIndexOf(46);
            if (dotIndex != -1) {
                pacLibraryName = project.substring(dotIndex + 1);
            }
            if (pacLibraryName == null || (libraryFromDisk = (PacLibrary)PTModelService.getResource((String)project, (String)"", (String)pacLibraryName, (String)"paclibrary")) == null) continue;
            return libraryFromDisk;
        }
        return libraryFromDisk;
    }

    private String modifySourceCode(String source, String oldScreenCode, String newScreenCode) {
        String newTwoLastCharactersScreenCode;
        if (source == null || source.length() == 0 || oldScreenCode == null || oldScreenCode.length() == 0 || newScreenCode == null || newScreenCode.length() == 0) {
            return source;
        }
        String oldTwoLastCharactersScreenCode = oldScreenCode.substring(oldScreenCode.length() - 2);
        String patternToFind = oldTwoLastCharactersScreenCode.equals(newTwoLastCharactersScreenCode = newScreenCode.substring(newScreenCode.length() - 2)) ? null : "PR-" + oldTwoLastCharactersScreenCode + "-";
        int patternToFindIndex = patternToFind == null ? -1 : source.indexOf(patternToFind);
        int screenCodeIndex = source.indexOf(oldScreenCode);
        if (screenCodeIndex == -1 && patternToFindIndex == -1) {
            return source;
        }
        int index = screenCodeIndex;
        if (patternToFindIndex != -1 && patternToFindIndex < screenCodeIndex || screenCodeIndex == -1) {
            index = patternToFindIndex;
        }
        StringBuilder sb = null;
        int previousWrittenIndex = 0;
        while (index != -1) {
            if (patternToFindIndex == index) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(source.subSequence(previousWrittenIndex, patternToFindIndex + "PR-".length()));
                sb.append(newTwoLastCharactersScreenCode);
                previousWrittenIndex = patternToFindIndex + "PR-".length() + oldTwoLastCharactersScreenCode.length();
                patternToFindIndex = source.indexOf(patternToFind, patternToFindIndex + patternToFind.length());
                index = screenCodeIndex;
                if ((patternToFindIndex == -1 || patternToFindIndex >= screenCodeIndex) && screenCodeIndex != -1) continue;
                index = patternToFindIndex;
                continue;
            }
            String context = source.substring(screenCodeIndex - 2, screenCodeIndex + oldScreenCode.length() + 1);
            if ((context.startsWith("I-") || context.startsWith("O-")) && context.endsWith("-")) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(source.subSequence(previousWrittenIndex, screenCodeIndex));
                sb.append(newScreenCode);
                previousWrittenIndex = screenCodeIndex + oldScreenCode.length();
            }
            index = screenCodeIndex = source.indexOf(oldScreenCode, screenCodeIndex + oldScreenCode.length());
            if ((patternToFindIndex == -1 || patternToFindIndex >= screenCodeIndex) && screenCodeIndex != -1) continue;
            index = patternToFindIndex;
        }
        if (previousWrittenIndex == 0) {
            return source;
        }
        sb.append(source.substring(previousWrittenIndex));
        return sb.toString();
    }

    private boolean duplicateCobol() {
        String oldCobolPath = this.getOldCobolOSFileName();
        String oldCobolContents = null;
        try {
            oldCobolContents = PdpTool.readFileContents((String)oldCobolPath, (String)CharsetUtil.getWorkspaceCharset());
        }
        catch (CoreException coreException) {
            oldCobolContents = PdpTool.readFileContents((String)oldCobolPath);
        }
        String newCobolContents = this.replaceProgramID(oldCobolContents, String.valueOf(CR) + "       PROGRAM-ID. ");
        newCobolContents = this.replaceDesignNameAtOffset73InWholeText(newCobolContents);
        this._newCblFileName = this.getNewCobolEclipseFileName();
        PdpTool.writeEclipseFileContents((String)newCobolContents, (String)this._newCblFileName);
        return true;
    }

    private boolean duplicateCblpdp() {
        String newCblpdpFileName;
        String wksRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        String oldCobolPath = this.getOldCobolEclipseFileName();
        String oldCblpdpPath = String.valueOf(wksRoot) + this.getPdpFilePathFrom(oldCobolPath);
        String newCobolFileName = this.getNewCobolEclipseFileName();
        this._newCblpdpFileName = newCblpdpFileName = this.getPdpFilePathFrom(newCobolFileName);
        newCblpdpFileName = String.valueOf(wksRoot) + newCblpdpFileName;
        String oldCblPdpContents = null;
        try {
            oldCblPdpContents = PdpTool.readFileContents((String)oldCblpdpPath, (String)CharsetUtil.getWorkspaceCharset());
        }
        catch (CoreException coreException) {
            oldCblPdpContents = PdpTool.readFileContents((String)oldCblpdpPath);
        }
        String newCblPdpContents = oldCblPdpContents;
        newCblPdpContents = this.modifyGenOutputResourceName(newCblPdpContents);
        newCblPdpContents = this.modifyGenOutput(newCblPdpContents);
        newCblPdpContents = this.modifyEntryPoint(newCblPdpContents, this._duplicationData.getNewDesignName());
        newCblPdpContents = this.modifySubRefs(newCblPdpContents, this._duplicationData.getNewDesignName());
        newCblPdpContents = this.modifyFirstTag(newCblPdpContents, this._duplicationData.getNewDesignName(), this._element2Duplicate.getName());
        newCblPdpContents = this.replaceProgramID(newCblPdpContents, ">       PROGRAM-ID. ");
        newCblPdpContents = this.replaceDesignNameInCblpdpAtCol73(newCblPdpContents);
        newCblPdpContents = this.replaceMSPTagPropertiesInCblpdp(newCblPdpContents);
        PdpTool.writeEclipseFileContents((String)newCblPdpContents, (String)this._newCblpdpFileName);
        return true;
    }

    private String getNewCobolOSFileName() {
        String wksRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        String newCobolFileName = String.valueOf(wksRoot) + this.getNewCobolEclipseFileName();
        return newCobolFileName;
    }

    private String getNewCobolEclipseFileName() {
        String newCobolFileName = String.valueOf(SLASH) + this._duplicationData.getNewCobolProject() + SLASH + this._duplicationData.getNewCobolFolder() + SLASH + this._duplicationData.getNewCobolName() + CBL_EXT;
        if (!this._duplicationData.isCobolFileNameAbsolute()) {
            newCobolFileName = PdpResourcesMgr.getURIFromGeneratedDocument((String)newCobolFileName);
        }
        return newCobolFileName;
    }

    private String getOldCobolOSFileName() {
        String wksRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        String fileName = String.valueOf(wksRoot) + this.getOldCobolEclipseFileName();
        return fileName;
    }

    private String getOldCobolEclipseFileName() {
        String oldCobolPath = String.valueOf(SLASH) + this._duplicationData.getOldCobolProject() + SLASH + this._duplicationData.getOldCobolFolder() + SLASH + this._duplicationData.getOldCobolName() + CBL_EXT;
        if (!this._duplicationData.isCobolFileNameAbsolute()) {
            oldCobolPath = PdpResourcesMgr.getURIFromGeneratedDocument((String)oldCobolPath);
        }
        return oldCobolPath;
    }

    private String getPdpFilePathFrom(String cblFilePath) {
        String pdpFileLocation = PdpTool.computePdpFileLocationFromSourceFileLocation((String)cblFilePath);
        return pdpFileLocation;
    }

    private String getNewLogicalCobolFileName() {
        String newCobolFileName = this._duplicationData.isCobolFileNameAbsolute() ? String.valueOf(SLASH) + '%' : SLASH;
        String folderStr = this.getFolderString(this._duplicationData.getNewCobolFolder());
        newCobolFileName = String.valueOf(newCobolFileName) + this._duplicationData.getNewCobolProject() + folderStr + SLASH + this._duplicationData.getNewCobolName() + CBL_EXT;
        return newCobolFileName;
    }

    private String getFolderString(String folderName) {
        String folderNameStr = folderName.isEmpty() ? EMPTY_STR : String.valueOf(SLASH) + folderName;
        return folderNameStr;
    }

    private String getStateIDForDesign() {
        return this._designStateID;
    }

    private String getOldProgramID(String text) {
        int end = text.indexOf(". ");
        return text.substring(0, end);
    }

    private String getSpaces(String newProgramID) {
        int n = 52 - newProgramID.length();
        StringBuilder sb = new StringBuilder(n);
        int i = 0;
        while (i < n) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    private String getPatternOfCurrentEntity() {
        String entityType = this._element2Duplicate.getDocument().getType();
        if (entityType.equals("pacprogram")) {
            return "com.ibm.pdp.pacbase.batch";
        }
        if (entityType.equals("pacscreen")) {
            PacScreen screen = (PacScreen)this._designInstance;
            PacDialogTypeValues type = screen.getDialogType();
            if (type.equals(PacDialogTypeValues._INHERITED_LITERAL)) {
                PacDialog dialog = screen.getDialog();
                PacDialogTypeValues dialogType = dialog.getDialogType();
                if (dialogType.equals(PacDialogTypeValues._NONE_LITERAL)) {
                    return "com.ibm.pdp.pacbase.dialog";
                }
                return "com.ibm.pdp.pacbase.csclient";
            }
            if (type.equals(PacDialogTypeValues._NONE_LITERAL)) {
                return "com.ibm.pdp.pacbase.dialog";
            }
            return "com.ibm.pdp.pacbase.csclient";
        }
        if (entityType.equals("pacserver")) {
            return "com.ibm.pdp.pacbase.csserver";
        }
        if (entityType.equals("paccommunicationmonitor")) {
            return "com.ibm.pdp.pacbase.communicationmonitor";
        }
        if (entityType.equals("pacfolder")) {
            return "com.ibm.pdp.pacbase.folder";
        }
        return null;
    }

    private void determineIfMapIsToGenerate() {
        RadicalEntity re1 = PTModelService.getResource((String)this._element2Duplicate.getProjectName(), (String)this._element2Duplicate.getPackageName(), (String)this._element2Duplicate.getName(), (String)this._element2Duplicate.getDocument().getType());
        if (re1 instanceof PacScreen) {
            this._isMapToGenerate = ((PacScreen)re1).isGenerateWithMap();
            this._mapExtension = DuplicationWizard.getExtensionForScreen((PacScreen)re1);
        }
    }

    private String modifyGenOutputResourceName(String oldString) {
        String GEN_OUTPUT_RESOURCE_NAME = "gen_output_resource_name=\"";
        int GEN_OUTPUT_RESOURCE_NAME_LEN = GEN_OUTPUT_RESOURCE_NAME.length();
        int idx1 = oldString.indexOf(GEN_OUTPUT_RESOURCE_NAME);
        int idx2 = oldString.indexOf(34, idx1 + GEN_OUTPUT_RESOURCE_NAME_LEN + 1);
        String s = this.getNewCobolEclipseFileName();
        String result = String.valueOf(oldString.substring(0, idx1 + GEN_OUTPUT_RESOURCE_NAME_LEN)) + s + oldString.substring(idx2);
        return result;
    }

    private String modifyGenOutput(String oldString) {
        String GEN_OUTPUT = "<generation_output project=\"";
        int GEN_OUTPUT_LEN = GEN_OUTPUT.length();
        String LOGICAL_PACKAGE = " logical_package=\"";
        int LOGICAL_PACKAGE_LEN = LOGICAL_PACKAGE.length();
        String THE_PACKAGE = " package=\"";
        int THE_PACKAGE_LEN = THE_PACKAGE.length();
        String NAME = " name=\"";
        int NAME_LEN = NAME.length();
        int idxGenOutput1 = oldString.indexOf(GEN_OUTPUT);
        int idxGenOutput2 = oldString.indexOf(34, idxGenOutput1 + GEN_OUTPUT_LEN);
        int idxLogicalPack1 = oldString.indexOf(LOGICAL_PACKAGE);
        int idxLogicalPack2 = oldString.indexOf(34, idxLogicalPack1 + LOGICAL_PACKAGE_LEN);
        int idxPackage1 = oldString.indexOf(THE_PACKAGE);
        int idxPackage2 = oldString.indexOf(34, idxPackage1 + THE_PACKAGE_LEN);
        int idxName1 = oldString.indexOf(NAME, idxPackage2);
        int idxName2 = oldString.indexOf(34, idxName1 + NAME_LEN);
        String isLogPackageString = this._isLogicalMode ? "Y" : "N";
        String result = String.valueOf(oldString.substring(0, idxGenOutput1 + GEN_OUTPUT_LEN)) + this._duplicationData.getNewCobolProject() + oldString.substring(idxGenOutput2, idxLogicalPack1 + LOGICAL_PACKAGE_LEN) + isLogPackageString + oldString.substring(idxLogicalPack2, idxPackage1 + THE_PACKAGE_LEN) + this._duplicationData.getNewCobolFolder() + oldString.substring(idxPackage2, idxName1 + NAME_LEN) + this._duplicationData.getNewCobolName() + oldString.substring(idxName2);
        return result;
    }

    private String modifyEntryPoint(String oldString, String newEntryPoint) {
        String ENTRY_POINT1 = "relation=\"generation_1_entrypoint\"></subRef>";
        ENTRY_POINT1.length();
        String SUBREF_STARTING = "<subRef project=\"";
        int SUBREF_STARTING_LEN = SUBREF_STARTING.length();
        String NAME = " name=\"";
        int NAME_LEN = NAME.length();
        String TIMESTAMP = " timestamp=\"";
        int TIMESTAMP_LEN = TIMESTAMP.length();
        int idx1 = oldString.indexOf(ENTRY_POINT1);
        int idx2 = this.searchPreviousIndex(oldString, SUBREF_STARTING, idx1);
        int idx2_prime = oldString.indexOf(34, idx2 + SUBREF_STARTING_LEN);
        int idx3 = oldString.indexOf(NAME, idx2);
        int idx4 = oldString.indexOf(34, idx3 + NAME_LEN + 1);
        String result = String.valueOf(oldString.substring(0, idx2 + SUBREF_STARTING_LEN)) + this._duplicationData.getNewDesignProject() + oldString.substring(idx2_prime, idx3 + NAME_LEN) + newEntryPoint + oldString.substring(idx4);
        int idxTS = result.indexOf(TIMESTAMP, idx2);
        int idxTS_END = result.indexOf(34, idxTS + TIMESTAMP_LEN + 1);
        String result1 = String.valueOf(result.substring(0, idxTS + TIMESTAMP_LEN)) + this.getStateIDForDesign() + result.substring(idxTS_END);
        return result1;
    }

    private String modifySubRefs(String oldString, String newEntryPoint) {
        String result2;
        String result1;
        String newLogFileName = this.getNewLogicalCobolFileName();
        String MPREFS = "<MicroPatternRefsSection src=\"";
        int MPREFS_LEN = MPREFS.length();
        int idxMPRefs1 = oldString.indexOf(MPREFS);
        if (idxMPRefs1 != -1) {
            int idxMPRefs2 = oldString.indexOf(34, idxMPRefs1 + MPREFS_LEN + 1);
            result1 = String.valueOf(oldString.substring(0, idxMPRefs1 + MPREFS_LEN)) + newLogFileName + oldString.substring(idxMPRefs2);
        } else {
            result1 = oldString;
        }
        String USAGESREFS = "<RubriquesUsagesRefsSection src=\"";
        int USAGESREFS_LEN = USAGESREFS.length();
        int idxUsages1 = result1.indexOf(USAGESREFS);
        if (idxUsages1 != -1) {
            int idxUsages2 = result1.indexOf(34, idxUsages1 + USAGESREFS_LEN + 1);
            result2 = String.valueOf(result1.substring(0, idxUsages1 + USAGESREFS_LEN)) + newLogFileName + result1.substring(idxUsages2);
        } else {
            result2 = result1;
        }
        return result2;
    }

    private String modifyFirstTag(String oldString, String newEntryPoint, String oldEntryPoint) {
        String FIRST_TAG = "<Text><Tag name=\"";
        int FIRST_TAG_LEN = FIRST_TAG.length();
        int idx1 = oldString.indexOf(FIRST_TAG);
        int idx2 = oldString.indexOf(34, idx1 + FIRST_TAG_LEN + 1);
        String oldtagname = oldString.substring(idx1 + FIRST_TAG_LEN, idx2);
        String result = String.valueOf(oldString.substring(0, idx1 + FIRST_TAG_LEN)) + oldtagname.replace(oldEntryPoint, newEntryPoint) + oldString.substring(idx2);
        return result;
    }

    private String replaceDesignNameAtOffset73InWholeText(String text) {
        String DESIGN_NAME = String.valueOf(this._element2Duplicate.getName()) + CR;
        String DESIGN_NAME_SP = String.valueOf(this._element2Duplicate.getName()) + "SP" + CR;
        int COL_72 = 72;
        int len = text.length();
        StringBuilder sb = new StringBuilder(len);
        int i = 0;
        while (i < len) {
            int end = PdpTool.getLineEndOffset((CharSequence)text, (int)i);
            String line = text.substring(i, end);
            if (line.indexOf(DESIGN_NAME, COL_72) != -1) {
                sb.append(line.substring(0, COL_72));
                sb.append(this._duplicationData.getNewDesignName());
                sb.append(CR);
            } else if (line.indexOf(DESIGN_NAME_SP, COL_72) != -1) {
                sb.append(line.substring(0, COL_72));
                sb.append(String.valueOf(this._duplicationData.getNewDesignName()) + "SP");
                sb.append(CR);
            } else {
                sb.append(line);
            }
            i = end;
        }
        return sb.toString();
    }

    private String replaceProgramID(String text, String PROGRAM_ID_string) {
        int PROGRAM_ID_LEN = PROGRAM_ID_string.length();
        int idx1 = text.indexOf(PROGRAM_ID_string);
        String oldProgName = this.getOldProgramID(text.substring(idx1 + PROGRAM_ID_LEN));
        String newProgName = this._duplicationData.getNewCobolName();
        oldProgName.length();
        newProgName.length();
        String result = EMPTY_STR;
        if (idx1 != -1) {
            result = String.valueOf(text.substring(0, idx1 + PROGRAM_ID_LEN)) + this._duplicationData.getNewCobolName() + "." + this.getSpaces(newProgName) + text.substring(idx1 + 73);
        }
        return result;
    }

    private String replaceDesignNameInCblpdpAtCol73(String text) {
        String DESIGN_NAME = String.valueOf(this._element2Duplicate.getName()) + "&#xD;" + CR;
        String DESIGN_NAME_SP = String.valueOf(this._element2Duplicate.getName()) + "SP" + "&#xD;" + CR;
        int DESIGN_NAME_LEN = DESIGN_NAME.length();
        int DESIGN_NAME_SP_LEN = DESIGN_NAME_SP.length();
        int len = text.length();
        StringBuilder sb = new StringBuilder(len);
        int previousOffset = 0;
        int offsetDesign = text.indexOf(DESIGN_NAME);
        int offsetDesignSP = text.indexOf(DESIGN_NAME_SP);
        int offset = -1;
        if (offsetDesign == -1) {
            offset = offsetDesignSP;
        }
        if (offsetDesignSP == -1) {
            offset = offsetDesign;
        }
        if (offsetDesign < offsetDesignSP && offsetDesign != -1) {
            offset = offsetDesign;
        }
        if (offsetDesignSP < offsetDesign && offsetDesignSP != -1) {
            offset = offsetDesignSP;
        }
        while (offset != -1) {
            if (previousOffset == 0) {
                sb.append(text.subSequence(0, offset));
            } else {
                sb.append(text.subSequence(previousOffset, offset));
            }
            sb.append(this._duplicationData.getNewDesignName());
            if (offset == offsetDesignSP) {
                sb.append("SP");
            }
            sb.append("&#xD;");
            sb.append(CR);
            previousOffset = offset + (offset == offsetDesignSP ? DESIGN_NAME_SP_LEN : DESIGN_NAME_LEN);
            if (offsetDesign != -1 && offsetDesign < previousOffset) {
                offsetDesign = text.indexOf(DESIGN_NAME, previousOffset);
            }
            if (offsetDesignSP != -1 && offsetDesignSP < previousOffset) {
                offsetDesignSP = text.indexOf(DESIGN_NAME_SP, previousOffset);
            }
            offset = -1;
            if (offsetDesign == -1) {
                offset = offsetDesignSP;
            }
            if (offsetDesignSP == -1) {
                offset = offsetDesign;
            }
            if (offsetDesign < offsetDesignSP && offsetDesign != -1) {
                offset = offsetDesign;
            }
            if (offsetDesignSP >= offsetDesign || offsetDesignSP == -1) continue;
            offset = offsetDesignSP;
        }
        sb.append(text.substring(previousOffset));
        return sb.toString();
    }

    private String replaceMSPTagPropertiesInCblpdp(String text) {
        String OLD_MACRO_NAME_SP = "msp=\"" + this._element2Duplicate.getName() + "SP\"";
        String NEW_MACRO_NAME_SP = "msp=\"" + this._duplicationData.getNewDesignName() + "SP\"";
        StringBuilder sb = new StringBuilder(text.length());
        int previousOffset = 0;
        int offset = text.indexOf(OLD_MACRO_NAME_SP);
        while (offset != -1) {
            if (previousOffset == 0) {
                sb.append(text.subSequence(0, offset));
            } else {
                sb.append(text.subSequence(previousOffset, offset));
            }
            sb.append(NEW_MACRO_NAME_SP);
            previousOffset = offset + NEW_MACRO_NAME_SP.length();
            offset = text.indexOf(OLD_MACRO_NAME_SP, previousOffset);
        }
        sb.append(text.substring(previousOffset));
        return sb.toString();
    }

    private String replaceStringInLine(String line, String oldString, String newString) {
        if (oldString.length() == newString.length()) {
            return line.replaceAll(oldString, newString);
        }
        if (oldString.length() > newString.length()) {
            String s = line.substring(0, 73);
            int i = 0;
            while (s.contains(oldString)) {
                s = s.replaceFirst(oldString, newString);
                ++i;
            }
            StringBuilder sb = new StringBuilder(80);
            sb.append(s);
            int j = 0;
            while (j < i) {
                sb.append(' ');
                ++j;
            }
            sb.append(line.substring(73));
            return sb.toString();
        }
        if (oldString.length() < newString.length()) {
            String s = line.substring(0, 73);
            int i = 0;
            while (s.contains(oldString)) {
                s = s.replaceFirst(oldString, newString);
                ++i;
            }
            if (line.substring(line.length() - i).trim().length() == 0) {
                StringBuilder sb = new StringBuilder(80);
                sb.append(s.substring(0, s.length() - i));
                sb.append(line.substring(73));
                return sb.toString();
            }
            return line;
        }
        return line;
    }

    private int searchPreviousIndex(String source, String searchedString, int startingOffset) {
        String miniSource = source.substring(0, startingOffset);
        int idx = miniSource.lastIndexOf(searchedString);
        return idx;
    }

    private static String getExtensionForScreen(PacScreen screen) {
        PacGenerationHeader generationHeader;
        while (screen.getGenerationHeader() != null) {
            PacGenerationHeader generationHeader2 = screen.getGenerationHeader();
            if (!(generationHeader2 instanceof PacSourceInheritanceGenerationHeader)) break;
            int resolMode = PTEditorService.getResolvingMode();
            PTEditorService.setResolvingMode((int)3);
            screen = (PacScreen)((PacSourceInheritanceGenerationHeader)generationHeader2).getGeneratedRadicalEntity();
            PTEditorService.setResolvingMode((int)resolMode);
        }
        PacDialog dialog = screen.getDialog();
        if (screen.getGenerationHeader() != null && (generationHeader = screen.getGenerationHeader()) instanceof PacLibrarySubstitutionGenerationHeader) {
            int resolMode = PTEditorService.getResolvingMode();
            PTEditorService.setResolvingMode((int)3);
            PacScreen parentScreen = (PacScreen)((PacLibrarySubstitutionGenerationHeader)generationHeader).getGeneratedRadicalEntity();
            PTEditorService.setResolvingMode((int)resolMode);
            dialog = parentScreen.getDialog();
        }
        PacCobolTypeValues c = screen.getCobolType();
        PacMapTypeValues m = screen.getMapType();
        if (c == PacCobolTypeValues._NONE_LITERAL) {
            c = dialog.getCobolType();
        }
        if (m == PacMapTypeValues._NONE_LITERAL) {
            m = dialog.getMapType();
        }
        if (c == PacCobolTypeValues._X_LITERAL && m == PacMapTypeValues._0_LITERAL || c == PacCobolTypeValues._X_LITERAL && m == PacMapTypeValues._2_LITERAL || c == PacCobolTypeValues._1_LITERAL && m == PacMapTypeValues._0_LITERAL || c == PacCobolTypeValues._1_LITERAL && m == PacMapTypeValues._2_LITERAL) {
            return "bms";
        }
        if (c == PacCobolTypeValues._X_LITERAL && m == PacMapTypeValues._1_LITERAL || c == PacCobolTypeValues._X_LITERAL && m == PacMapTypeValues._3_LITERAL) {
            return "mfs";
        }
        return "map";
    }
}

