/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.references.associate.provider;

import com.ibm.pdp.framework.preferences.PdpFmwkPreferenceTool;
import com.ibm.pdp.references.ReferencesPlugin;
import com.ibm.pdp.references.associate.DesignGeneratedAssociation;
import com.ibm.pdp.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DesignGeneratedAssociateLabelProvider
extends LabelProvider {
    private ILabelDecorator _labelDecorator = null;
    private DecoratingLabelProvider _decoratingProvider = null;
    private static String PDP_COBOL_FILE_IMAGE_NAME = "pdpsyseditor_2";
    private static String PDP_COBOL_FILE_DESYNCHRO_IMAGE_NAME = "pdpsyseditor_2_DESYNCHRONIZED";
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Image getImage(Object object) {
        Image image = null;
        if (object instanceof DesignGeneratedAssociation) {
            DesignGeneratedAssociation association = (DesignGeneratedAssociation)object;
            IFile file = association.getFile();
            image = this.isDesynchronized(file) ? ReferencesPlugin.getDefault().getImage(PDP_COBOL_FILE_DESYNCHRO_IMAGE_NAME) : ReferencesPlugin.getDefault().getImage(PDP_COBOL_FILE_IMAGE_NAME);
            image = this.decorateImage(image, object);
        }
        return image;
    }

    public String getText(Object object) {
        String label = "";
        if (object instanceof DesignGeneratedAssociation) {
            DesignGeneratedAssociation association = (DesignGeneratedAssociation)object;
            label = association.getFile().getFullPath().toString();
            label = this.decorateLabel(label, association);
        }
        return label;
    }

    private boolean isDesynchronized(IFile file) {
        IMarker[] markers = null;
        try {
            markers = file.findMarkers("com.ibm.pdp.desynchronized_generated_file_marker", false, 0);
            return markers.length > 0;
        }
        catch (Exception e) {
            Util.rethrow((Throwable)e);
            return false;
        }
    }

    public String decorateLabel(String label, DesignGeneratedAssociation association) {
        String result = label;
        if (association.getResource() != null) {
            StringBuilder buffer = new StringBuilder();
            if (this.isDesynchronized(association.getFile())) {
                buffer.append(PdpFmwkPreferenceTool.getCharToShowDesynchronization());
            }
            buffer.append(label);
            String decorateLabel = this.getLabelDecorator().decorateText("", (Object)association).trim();
            buffer.append("    ").append(decorateLabel);
            result = buffer.toString().trim();
        }
        return result;
    }

    public Image decorateImage(Image image, Object object) {
        IResource resource;
        Image result = image;
        if (object instanceof DesignGeneratedAssociation && (resource = ((DesignGeneratedAssociation)object).getResource()) != null) {
            result = this.getLabelDecorator().decorateImage(image, object);
        }
        return result;
    }

    private ILabelDecorator getLabelDecorator() {
        if (this._labelDecorator == null) {
            this._labelDecorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        }
        return this._labelDecorator;
    }

    public void addListener(ILabelProviderListener listener) {
        this.getDecoratingProvider().addListener(listener);
    }

    public void removeListener(ILabelProviderListener listener) {
        this.getDecoratingProvider().removeListener(listener);
    }

    public DecoratingLabelProvider getDecoratingProvider() {
        if (this._decoratingProvider == null) {
            WorkbenchLabelProvider provider = new WorkbenchLabelProvider();
            this._decoratingProvider = new DecoratingLabelProvider((ILabelProvider)provider, this.getLabelDecorator());
        }
        return this._decoratingProvider;
    }
}

