/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.references.associate;

import com.ibm.pdp.explorer.associate.service.PTAssociationService;
import com.ibm.pdp.framework.ControllerFactory;
import com.ibm.pdp.framework.PdpPlugin;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IControllerFactory;
import com.ibm.pdp.references.associate.Messages;
import com.ibm.pdp.resources.DesynchronizedWorkspaceException;
import com.ibm.pdp.resources.PdpResourcesMgr;
import com.ibm.pdp.util.Util;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;

public class RecomputeLinksAction
extends Action {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String MAPPING_REBUILD_TITLE = Messages.RecomputeLinksAction_MAPPING_REBUILD_TITLE;
    private static String MAPPING_REBUILD_MESSAGE = Messages.RecomputeLinksAction_MAPPING_REBUILD_MESSAGE;
    private static String MAPPING_REBUILD_ACTION_LABEL = Messages.RecomputeLinksAction_MAPPING_REBUILD_ACTION_LABEL;
    private static final String WORKSPACE_DESYNCHRONIZED_MESS = Messages.RecomputeLinksAction_WORKSPACE_DESYNCHRONIZED_MESS;

    public void run() {
        ProgressMonitorDialog dialog;
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IEditorReference[] allEditors = PdpTool.findAllOpenedEditors();
        if (allEditors.length != 0) {
            MessageDialog.openError((Shell)shell, (String)MAPPING_REBUILD_TITLE, (String)Messages.RecomputeLinksAction_MULTIPLE_EDITORS);
            return;
        }
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor arg0) throws InvocationTargetException, InterruptedException {
                IControllerFactory factory = ControllerFactory.getInstance();
                if (factory instanceof ControllerFactory) {
                    ((ControllerFactory)factory).disposeAllControlers();
                }
                PdpResourcesMgr.getInstance().rebuildWorkspaceGenerationLinks(arg0);
            }
        };
        IRunnableWithProgress operation2 = new IRunnableWithProgress(){

            public void run(IProgressMonitor arg0) throws InvocationTargetException, InterruptedException {
                PdpResourcesMgr.getInstance().rebuildWorkspaceMacroLinks(arg0);
            }
        };
        try {
            dialog = new ProgressMonitorDialog(shell);
            dialog.run(true, true, operation);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof DesynchronizedWorkspaceException) {
                MessageDialog.openError((Shell)shell, (String)MAPPING_REBUILD_TITLE, (String)WORKSPACE_DESYNCHRONIZED_MESS);
                PdpTool.logErr((Plugin)PdpPlugin.getDefault(), (String)"com.ibm.pdp.framework", (String)WORKSPACE_DESYNCHRONIZED_MESS, null);
                return;
            }
            Util.rethrow((Throwable)e);
        }
        catch (InterruptedException f) {
            Util.rethrow((Throwable)f);
        }
        try {
            dialog = new ProgressMonitorDialog(shell);
            dialog.run(true, true, operation2);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof DesynchronizedWorkspaceException) {
                MessageDialog.openError((Shell)shell, (String)MAPPING_REBUILD_TITLE, (String)WORKSPACE_DESYNCHRONIZED_MESS);
                PdpTool.logErr((Plugin)PdpPlugin.getDefault(), (String)"com.ibm.pdp.framework", (String)WORKSPACE_DESYNCHRONIZED_MESS, null);
                return;
            }
            Util.rethrow((Throwable)e);
        }
        catch (InterruptedException f) {
            Util.rethrow((Throwable)f);
        }
        PTAssociationService.getInstance().fireAssociationChangeEvent(null, null);
        MessageDialog.openInformation((Shell)shell, (String)MAPPING_REBUILD_TITLE, (String)MAPPING_REBUILD_MESSAGE);
    }

    public String getText() {
        return MAPPING_REBUILD_ACTION_LABEL;
    }
}

