/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.references.associate;

import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.model.tool.PTIndexingRule;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.link.design.MacrosCrossRefsCaller;
import com.ibm.pdp.references.associate.Messages;
import com.ibm.pdp.resources.PdpResourcesMgr;
import com.ibm.pdp.util.Util;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;

public class MacrosToParseQueue {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2014, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long _REBUILD_DELAY = 1000L;
    private static final int _PACKET_SIZE = 5000;
    private Job _rebuildJob = null;
    private Set<IPath> _fileAdditionQueue = null;
    private Set<IPath> _fileRemovedQueue = null;

    public boolean addToQueue(IFile file, int kindOfDelta) {
        boolean added = false;
        if (kindOfDelta == 1 || kindOfDelta == 4) {
            added = this.getFileAdditionQueue().add(file.getFullPath());
            this.activateRebuildJob();
        }
        return added;
    }

    private Set<IPath> getFileAdditionQueue() {
        if (this._fileAdditionQueue == null) {
            this._fileAdditionQueue = new HashSet<IPath>();
        }
        return this._fileAdditionQueue;
    }

    private Set<IPath> getFileRemovedQueue() {
        if (this._fileRemovedQueue == null) {
            this._fileRemovedQueue = new HashSet<IPath>();
        }
        return this._fileRemovedQueue;
    }

    private void resetFileQueues() {
        this._fileAdditionQueue = null;
        this._fileRemovedQueue = null;
    }

    private void activateRebuildJob() {
        if (this._rebuildJob == null) {
            this._rebuildJob = new Job(Messages.Indexing_Title){

                protected IStatus run(final IProgressMonitor monitor) {
                    try {
                        IWorkspaceRunnable runnable = new IWorkspaceRunnable(){

                            public void run(IProgressMonitor amonitor) {
                                MacrosToParseQueue.this.processFilesQueue(monitor);
                            }
                        };
                        try {
                            ResourcesPlugin.getWorkspace().run(runnable, (ISchedulingRule)PTIndexingRule.getInstance(), 1, monitor);
                        }
                        catch (CoreException e) {
                            Util.rethrow((Throwable)e);
                        }
                    }
                    catch (Exception e) {
                        MacrosToParseQueue.this._rebuildJob = null;
                        Util.rethrow((Throwable)e);
                    }
                    monitor.done();
                    return monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
                }
            };
            this._rebuildJob.setRule((ISchedulingRule)PTIndexingRule.getInstance());
            this._rebuildJob.setPriority(40);
            this._rebuildJob.setUser(true);
            this._rebuildJob.schedule(1000L);
        }
    }

    private synchronized void processFilesQueue(IProgressMonitor monitor) {
        this._rebuildJob = null;
        Set<IPath> additionQueue = this.getFileAdditionQueue();
        Set<IPath> removedQueue = this.getFileRemovedQueue();
        this.resetFileQueues();
        PdpResourcesMgr resMgr = PdpResourcesMgr.getInstance();
        int worked = 0;
        int nbResources = additionQueue.size() + removedQueue.size();
        monitor.beginTask(Messages.Indexing_Task, nbResources);
        if (additionQueue.size() > 0) {
            HashSet<String> documents = new HashSet<String>();
            HashMap designSubRefs = new HashMap();
            HashMap usageSubRefs = new HashMap();
            for (IPath resourcePath : additionQueue) {
                monitor.worked(1);
                Object[] array = new String[]{Integer.toString(++worked), Integer.toString(nbResources)};
                monitor.subTask(NLS.bind((String)Messages.Indexing_Subtask, (Object[])array));
                String fileName = resourcePath.toString();
                RadicalEntity radicalEntity = PTModelService.getResource((IPath)resourcePath);
                InputStream macrosContents = com.ibm.pdp.mdl.link.design.Util.getMacroSourceCodeAttribute((RadicalEntity)radicalEntity);
                String docId = null;
                try {
                    docId = com.ibm.pdp.mdl.link.design.Util.getMacroDocumentId((String)fileName, (RadicalEntity)radicalEntity);
                }
                catch (Exception e) {
                    String mess = "MacrosToParseQueue. Problem during parsing of macro : " + fileName;
                    Status status = new Status(4, "com.ibm.pdp.references", mess, (Throwable)e);
                    Bundle bundle = Platform.getBundle((String)"com.ibm.pdp.references");
                    ILog log = Platform.getLog((Bundle)bundle);
                    log.log((IStatus)status);
                }
                if (macrosContents == null || docId == null) continue;
                documents.add(docId);
                MacrosCrossRefsCaller.searchForMacroSubReferences((String)docId, (InputStream)macrosContents, designSubRefs, usageSubRefs);
                if (worked % 5000 == 0) {
                    resMgr.deleteMacrosDesignAndUsageSubReferences(documents);
                    resMgr.registerMacro(designSubRefs, usageSubRefs);
                    designSubRefs.clear();
                    usageSubRefs.clear();
                    documents.clear();
                }
                if (!monitor.isCanceled()) continue;
                return;
            }
            resMgr.deleteMacrosDesignAndUsageSubReferences(documents);
            resMgr.registerMacro(designSubRefs, usageSubRefs);
            designSubRefs.clear();
            usageSubRefs.clear();
            documents.clear();
        }
    }
}

