/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.references.associate;

import com.ibm.pdp.explorer.associate.IPTAssociate;
import com.ibm.pdp.explorer.associate.IPTAssociation;
import com.ibm.pdp.explorer.model.PTElement;
import com.ibm.pdp.explorer.plugin.IPTActionContributor;
import com.ibm.pdp.explorer.plugin.PTExplorerPlugin;
import com.ibm.pdp.explorer.view.PTExplorerView;
import com.ibm.pdp.explorer.view.PTViewLabel;
import com.ibm.pdp.explorer.view.action.PTRebuildAction;
import com.ibm.pdp.explorer.view.actiongroup.PTGenerateActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTNewActionGroup;
import com.ibm.pdp.explorer.view.actiongroup.PTSearchRefActionGroup;
import com.ibm.pdp.explorer.view.service.IPTView;
import com.ibm.pdp.explorer.view.service.PTViewService;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.generation.menu.SynchronizationTool;
import com.ibm.pdp.mdl.kernel.DataAggregate;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.pacbase.PacBlockBase;
import com.ibm.pdp.mdl.pacbase.PacCommunicationMonitor;
import com.ibm.pdp.mdl.pacbase.PacCopybook;
import com.ibm.pdp.mdl.pacbase.PacDialog;
import com.ibm.pdp.mdl.pacbase.PacDialogServer;
import com.ibm.pdp.mdl.pacbase.PacErrorLabel;
import com.ibm.pdp.mdl.pacbase.PacFolder;
import com.ibm.pdp.mdl.pacbase.PacFolderView;
import com.ibm.pdp.mdl.pacbase.PacMacro;
import com.ibm.pdp.mdl.pacbase.PacProgram;
import com.ibm.pdp.mdl.pacbase.PacScreen;
import com.ibm.pdp.mdl.pacbase.PacServer;
import com.ibm.pdp.references.associate.DeleteAction;
import com.ibm.pdp.references.associate.DesignGeneratedAssociation;
import com.ibm.pdp.references.associate.MacrosToParseQueue;
import com.ibm.pdp.references.associate.PropertyAction;
import com.ibm.pdp.references.associate.RecomputeLinksAction;
import com.ibm.pdp.references.associate.provider.DesignGeneratedAssociateContentProvider;
import com.ibm.pdp.references.associate.provider.DesignGeneratedAssociateLabelProvider;
import com.ibm.pdp.references.entityduplication.DuplicateAction;
import com.ibm.pdp.resources.PdpResourcesMgr;
import com.ibm.pdp.util.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.OpenWithMenu;
import org.eclipse.ui.ide.IDE;

public class DesignGeneratedAssocManager
implements IPTAssociate,
IPTActionContributor,
IResourceChangeListener,
IStartup {
    public static final String _ID = String.valueOf(DesignGeneratedAssocManager.class.getName()) + "_ID";
    private static final String _SEPARATOR_AFTER_GROUP_NEW = "SeparatorAfterGroupNew";
    private static final String PACPROGRAM_EXT = PacProgram.class.getSimpleName().toLowerCase();
    private static final String PACSCREEN_EXT = PacScreen.class.getSimpleName().toLowerCase();
    private static final String PACSERVER_EXT = PacServer.class.getSimpleName().toLowerCase();
    private static final String PACDIALOG_EXT = PacDialog.class.getSimpleName().toLowerCase();
    private static final String PACDIALOG_SERVER_EXT = PacDialogServer.class.getSimpleName().toLowerCase();
    private static final String PACMACRO_EXT = PacMacro.class.getSimpleName().toLowerCase();
    private static final String PACBLOCKBASE_EXT = PacBlockBase.class.getSimpleName().toLowerCase();
    private static final String PACERRORLABEL_EXT = PacErrorLabel.class.getSimpleName().toLowerCase();
    private static final String PACCOPYBOOK_EXT = PacCopybook.class.getSimpleName().toLowerCase();
    private static final String DATAAGGREGATE_EXT = DataAggregate.class.getSimpleName().toLowerCase();
    private static final String PACFOLDER_EXT = PacFolder.class.getSimpleName().toLowerCase();
    private static final String PACCOMMONITOR_EXT = PacCommunicationMonitor.class.getSimpleName().toLowerCase();
    private static final String PACFOLDERVIEW_EXT = PacFolderView.class.getSimpleName().toLowerCase();
    private static DesignGeneratedAssocManager _instance = null;
    private ITreeContentProvider _contentProvider = null;
    private LabelProvider _labelProvider = null;
    private MacrosToParseQueue _macrosQueue;
    private static Set<String> _extraExtentions = null;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2016.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DesignGeneratedAssocManager() {
        if (_instance != null && this != _instance) {
            return;
        }
        _instance = this;
        PdpResourcesMgr.getInstance();
        this.addResourcesChangedListener();
        this._macrosQueue = new MacrosToParseQueue();
    }

    public static DesignGeneratedAssocManager getInstance() {
        if (_instance == null) {
            _instance = new DesignGeneratedAssocManager();
        }
        return _instance;
    }

    public void addResourcesChangedListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)_instance);
    }

    public void earlyStartup() {
    }

    public ITreeContentProvider getContentProvider() {
        if (this._contentProvider == null) {
            this._contentProvider = new DesignGeneratedAssociateContentProvider();
        }
        return this._contentProvider;
    }

    public LabelProvider getLabelProvider() {
        if (this._labelProvider == null) {
            this._labelProvider = new DesignGeneratedAssociateLabelProvider();
        }
        return this._labelProvider;
    }

    public void keyPressed(KeyEvent event) {
        if (event.keyCode == 127) {
            IStructuredSelection selection = PTViewService.getSelection();
            boolean hasAGeneratedElementToDel = false;
            for (Object obj : selection) {
                if (!(obj instanceof DesignGeneratedAssociation)) continue;
                hasAGeneratedElementToDel = true;
                break;
            }
            if (hasAGeneratedElementToDel) {
                DeleteAction deleteAction = new DeleteAction(selection);
                deleteAction.run();
            }
        }
    }

    public void keyReleased(KeyEvent arg0) {
    }

    protected void computeDesynchronizationState(TreeExpansionEvent event) {
        Object o = event.getElement();
        if (!(o instanceof PTElement)) {
            return;
        }
        PTElement elem = (PTElement)o;
        String designId = elem.getDocument().getId();
        Iterator superRefs = PdpResourcesMgr.getInstance().getSuperReferences(designId);
        while (superRefs.hasNext()) {
            String uri;
            IFile cobol;
            Reference ref = (Reference)superRefs.next();
            if (!ref.getRelation().endsWith("entrypoint") || !(cobol = PdpTool.getFile((String)(uri = PdpResourcesMgr.getURIFromGeneratedDocument((String)ref.getSourceId())))).exists()) continue;
            Document doc = PdpResourcesMgr.getInstance().getResource(ref.getSourceId());
            String logicalPathOfTheGenerated = doc.getId();
            String physicalPathOfTheGeneratedFile = cobol.getFullPath().toString();
            SynchronizationTool.checkIfTheGeneratedResourceNeedsRegeneration(logicalPathOfTheGenerated, physicalPathOfTheGeneratedFile);
        }
    }

    public void treeExpanded(TreeExpansionEvent event) {
        this.computeDesynchronizationState(event);
    }

    public void treeCollapsed(TreeExpansionEvent event) {
    }

    public void menuAboutToShow(IMenuManager menu) {
        menu.add((IContributionItem)new Separator());
        IStructuredSelection selection = PTViewService.getSelection();
        if (selection.size() == 1) {
            Object o = selection.getFirstElement();
            if (o instanceof DesignGeneratedAssociation) {
                IFile resourceFileF = ((DesignGeneratedAssociation)o).getFile();
                Separator separator = new Separator(_SEPARATOR_AFTER_GROUP_NEW);
                menu.insertAfter(PTNewActionGroup._ID, (IContributionItem)separator);
                MenuManager subMenuOpenWith = new MenuManager(PTViewLabel.getString((String)PTViewLabel._OPEN_WITH), _ID);
                IWorkbenchPage page = PTExplorerPlugin.getActiveWorkbenchWindow().getActivePage();
                subMenuOpenWith.add((IContributionItem)new OpenWithMenu(page, (IAdaptable)resourceFileF));
                menu.add((IAction)new DeleteAction(selection));
                menu.insertAfter(_SEPARATOR_AFTER_GROUP_NEW, (IContributionItem)subMenuOpenWith);
                menu.add((IContributionItem)new Separator(PTSearchRefActionGroup._SEPARATOR));
                PTExplorerView view = PTExplorerView.getFromActivePerspective();
                new PTSearchRefActionGroup((IPTView)view).fillContextMenu(menu);
                menu.add((IContributionItem)new Separator());
                menu.add((IAction)new PropertyAction((IPTView)view, resourceFileF));
                menu.add((IContributionItem)new Separator());
            } else if (o instanceof PTElement) {
                DuplicateAction duplicateAction = new DuplicateAction(selection);
                menu.insertAfter(PTGenerateActionGroup._ID, (IAction)duplicateAction);
            }
        } else if (selection.size() > 1) {
            Iterator iter = selection.iterator();
            boolean onlyFilesOfGoodType = true;
            while (iter.hasNext()) {
                Object o = iter.next();
                if (o instanceof DesignGeneratedAssociation) continue;
                onlyFilesOfGoodType = false;
            }
            if (onlyFilesOfGoodType) {
                menu.add((IAction)new DeleteAction(selection));
                menu.add((IContributionItem)new Separator());
            }
        }
        RecomputeLinksAction recomputeLinksAction = new RecomputeLinksAction();
        menu.insertAfter(PTRebuildAction._ID, (IAction)recomputeLinksAction);
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
        Object object = selection.getFirstElement();
        if (object instanceof DesignGeneratedAssociation) {
            IFile file = ((DesignGeneratedAssociation)object).getFile();
            IWorkbenchPage page = PTExplorerPlugin.getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)file);
            }
            catch (PartInitException e) {
                Util.rethrow((Throwable)e);
            }
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() != 1) {
            return;
        }
        IResourceDelta rootDelta = event.getDelta();
        if (rootDelta == null) {
            return;
        }
        IResourceDeltaVisitor visitor = new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) {
                IResource resource = delta.getResource();
                if ((resource.getType() & 1) != 0 && PACMACRO_EXT.equalsIgnoreCase(resource.getFileExtension())) {
                    if (delta.getKind() == 1) {
                        return DesignGeneratedAssocManager.this._macrosQueue.addToQueue((IFile)resource, delta.getKind());
                    }
                    if (delta.getKind() == 4) {
                        if ((delta.getFlags() & 0x100) != 0) {
                            return DesignGeneratedAssocManager.this._macrosQueue.addToQueue((IFile)resource, delta.getKind());
                        }
                        delta.getFlags();
                    }
                }
                return true;
            }
        };
        try {
            rootDelta.accept(visitor);
        }
        catch (CoreException coreException) {}
    }

    public void removeResourcesChangedListener() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)_instance);
    }

    public String getAssociationId(IPath filePath) {
        String relPath = PdpResourcesMgr.getInstance().getRelativeFileIdFromURI(filePath.toString());
        return relPath;
    }

    public IPTAssociation getAssociation(String associationId) {
        String uri;
        IFile cobol;
        if (associationId == null || associationId.length() == 0) {
            return null;
        }
        Reference ref = PdpResourcesMgr.getInstance().getEntryPoint(associationId);
        if (ref != null && (cobol = PdpTool.getFile((String)(uri = PdpResourcesMgr.getURIFromGeneratedDocument((String)associationId)))).exists()) {
            Document doc = PdpResourcesMgr.getInstance().getResource(ref.getSourceId());
            DesignGeneratedAssociation association = new DesignGeneratedAssociation(cobol, doc, ref.getTargetId());
            return association;
        }
        return null;
    }

    public boolean hasAssociations(String designId) {
        return PdpResourcesMgr.getInstance().hasDesignEntryPointBeenGenerated(designId);
    }

    public List<IPTAssociation> getAssociations(String locationName, String designId) {
        return Collections.emptyList();
    }

    public List<IPTAssociation> getAssociations(String designId) {
        if (!this.acceptDesignId(designId)) {
            return Collections.emptyList();
        }
        ArrayList<IPTAssociation> list = new ArrayList<IPTAssociation>();
        Iterator superRefs = PdpResourcesMgr.getInstance().getSuperReferences(designId);
        while (superRefs.hasNext()) {
            String uri;
            IFile cobol;
            Reference ref = (Reference)superRefs.next();
            if (!ref.getRelation().endsWith("entrypoint") || !(cobol = PdpTool.getFile((String)(uri = PdpResourcesMgr.getURIFromGeneratedDocument((String)ref.getSourceId())))).exists()) continue;
            Document doc = PdpResourcesMgr.getInstance().getResource(ref.getSourceId());
            DesignGeneratedAssociation association = new DesignGeneratedAssociation(cobol, doc, designId);
            list.add(association);
        }
        return list;
    }

    public boolean acceptDesignId(String designId) {
        boolean result;
        boolean bl = result = designId.endsWith(PACPROGRAM_EXT) || designId.endsWith(PACSCREEN_EXT) || designId.endsWith(PACDIALOG_EXT) || designId.endsWith(PACSERVER_EXT) || designId.endsWith(PACDIALOG_SERVER_EXT) || designId.endsWith(PACBLOCKBASE_EXT) || designId.endsWith(PACERRORLABEL_EXT) || designId.endsWith(PACCOPYBOOK_EXT) || designId.endsWith(DATAAGGREGATE_EXT) || designId.endsWith(PACFOLDER_EXT) || designId.endsWith(PACCOMMONITOR_EXT) || designId.endsWith(PACFOLDERVIEW_EXT);
        if (!result) {
            DesignGeneratedAssocManager.loadSourceCodeExtentions();
            String ext = designId;
            int idx = ext.lastIndexOf(46);
            if (idx > 0) {
                ext = ext.substring(idx + 1);
            }
            return _extraExtentions.contains(ext);
        }
        return result;
    }

    private static void loadSourceCodeExtentions() {
        if (_extraExtentions != null) {
            return;
        }
        _extraExtentions = new HashSet<String>();
        _extraExtentions.add("sourcecode");
        _extraExtentions.add("program");
        _extraExtentions.add("copy");
        for (Object object : EPackage.Registry.INSTANCE.values()) {
            if (!(object instanceof EPackage)) continue;
            EPackage ePackage = (EPackage)object;
            ePackage.getESuperPackage();
            for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                EClass _eClass;
                if (!(eClassifier instanceof EClass) || (_eClass = (EClass)eClassifier).getName() == null || _eClass.isAbstract()) continue;
                for (EClass eSuperClass : _eClass.getEAllSuperTypes()) {
                    if (eSuperClass.getName() == null || !eSuperClass.getName().equals("SourceCode")) continue;
                    String extension = _eClass.getName().toLowerCase();
                    _extraExtentions.add(extension);
                }
            }
        }
    }

    public void registerExtension(String extension) {
        DesignGeneratedAssocManager.loadSourceCodeExtentions();
        _extraExtentions.add(extension);
    }
}

