/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.references.associate;

import com.ibm.pdp.explorer.plugin.PTExplorerPlugin;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.references.associate.DesignGeneratedAssociation;
import com.ibm.pdp.references.associate.Messages;
import com.ibm.pdp.util.Util;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class DeleteAction
extends Action {
    private static String DELETE_ACTION_LABEL = Messages.DeleteAction_DELETE_ACTION_LABEL;
    IStructuredSelection _selection;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2011, 2014.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public DeleteAction(IStructuredSelection selection) {
        this._selection = selection;
        this.setImageDescriptor(this.getDeleteImageDescriptor());
        this.setAccelerator(127);
    }

    private ImageDescriptor getDeleteImageDescriptor() {
        ImageDescriptor imageDesc = PTExplorerPlugin.getDefault().getImageDescriptor("delete");
        return imageDesc;
    }

    public void run() {
        if (this._selection == null || this._selection.isEmpty()) {
            return;
        }
        int response = PdpTool.askUserDeletionConfirmation();
        if (response != 0) {
            return;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor arg0) throws InvocationTargetException, InterruptedException {
                for (Object data : DeleteAction.this._selection) {
                    DesignGeneratedAssociation assoc;
                    IResource resource;
                    if (!(data instanceof DesignGeneratedAssociation) || !((resource = (assoc = (DesignGeneratedAssociation)data).getResource()) instanceof IFile)) continue;
                    String resourceName = resource.getFullPath().toString();
                    String pdpFileName = PdpTool.computePdpFileLocationFromSourceFileLocation((String)resourceName);
                    try {
                        resource.delete(true, null);
                        IFile pdpFile = PdpTool.getFile((String)pdpFileName);
                        pdpFile.delete(true, null);
                    }
                    catch (Exception e) {
                        Util.rethrow((Throwable)e);
                    }
                }
            }
        };
        try {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            dialog.run(false, true, operation);
        }
        catch (InvocationTargetException e) {
            Util.rethrow((Throwable)e);
        }
        catch (InterruptedException f) {
            Util.rethrow((Throwable)f);
        }
    }

    public String getText() {
        return DELETE_ACTION_LABEL;
    }

    public boolean isEnabled() {
        if (this._selection == null || this._selection.isEmpty()) {
            return false;
        }
        boolean hasAGeneratedElementToDel = false;
        for (Object obj : this._selection) {
            if (!(obj instanceof DesignGeneratedAssociation)) continue;
            hasAGeneratedElementToDel = true;
            break;
        }
        return hasAGeneratedElementToDel;
    }
}

