/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.references;

import com.ibm.pdp.references.entityduplication.service.IDuplicateSourceCodeExtension;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ReferencesPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.ibm.pdp.references";
    private static ReferencesPlugin plugin;
    private HashMap<String, Image> _images = new HashMap();
    private HashMap<String, ImageDescriptor> _descriptors = new HashMap();
    private static URL _iconsFolderURL;
    private static Map<String, List<IDuplicateSourceCodeExtension>> _duplicateSourceCodeExtensions;
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    static {
        _duplicateSourceCodeExtensions = null;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static ReferencesPlugin getDefault() {
        return plugin;
    }

    public static URL getIconsFolderURL() {
        if (_iconsFolderURL == null) {
            _iconsFolderURL = ReferencesPlugin.getDefault().getBundle().getEntry("/");
        }
        return _iconsFolderURL;
    }

    public Image getImage(String key) {
        Image image = this._images.get(key);
        if (image == null) {
            ImageDescriptor descriptor = this.getImageDescriptor(key);
            image = descriptor.createImage();
            this._images.put(key, image);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imgDescriptor = this._descriptors.get(key);
        if (imgDescriptor == null) {
            try {
                URL gifImageURL = new URL(ReferencesPlugin.getIconsFolderURL(), "icons/" + key + ".gif");
                imgDescriptor = ImageDescriptor.createFromURL((URL)gifImageURL);
                this._descriptors.put(key, imgDescriptor);
            }
            catch (MalformedURLException mue) {
                mue.printStackTrace();
            }
        }
        return imgDescriptor;
    }

    public static List<IDuplicateSourceCodeExtension> getDuplicateSourceCodeExtensions(String extension) {
        ReferencesPlugin.loadDuplicateSourceCodeExtensions();
        return _duplicateSourceCodeExtensions.get(extension);
    }

    private static synchronized void loadDuplicateSourceCodeExtensions() {
        if (_duplicateSourceCodeExtensions == null) {
            IConfigurationElement[] contributions;
            _duplicateSourceCodeExtensions = new HashMap<String, List<IDuplicateSourceCodeExtension>>();
            IConfigurationElement[] iConfigurationElementArray = contributions = Platform.getExtensionRegistry().getConfigurationElementsFor("com.ibm.pdp.references.duplicateSourceCodeExtension");
            int n = contributions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement contribution = iConfigurationElementArray[n2];
                try {
                    String[] extensions;
                    IDuplicateSourceCodeExtension instance = (IDuplicateSourceCodeExtension)contribution.createExecutableExtension("class");
                    String[] stringArray = extensions = contribution.getAttribute("extensions").split(",");
                    int n3 = extensions.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String extension = stringArray[n4];
                        List<IDuplicateSourceCodeExtension> list = _duplicateSourceCodeExtensions.get(extension);
                        if (list == null) {
                            list = new ArrayList<IDuplicateSourceCodeExtension>();
                            _duplicateSourceCodeExtensions.put(extension, list);
                        }
                        list.add(instance);
                        ++n4;
                    }
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
    }
}

