/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.references;

import com.ibm.pdp.explorer.plugin.IPTArtifactContributor;
import com.ibm.pdp.mdl.meta.Document;
import com.ibm.pdp.references.ReferencesPlugin;
import com.ibm.pdp.resources.PdpResourcesMgr;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class PdpReference
implements IPTArtifactContributor {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2015.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String PDP_COBOL_FILE_IMAGE_NAME = "pdpsyseditor_2";
    private static PdpReference _instance = null;
    private Set<String> _acceptedTypes = null;

    public static PdpReference getInstance() {
        return _instance;
    }

    public PdpReference() {
        if (_instance == null) {
            String[] types = new String[]{"bms", "cbl", "cpy", "ddl", "map", "mfs", "txt"};
            this._acceptedTypes = new HashSet<String>();
            String[] stringArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                String type = stringArray[n2];
                this._acceptedTypes.add(type);
                ++n2;
            }
            _instance = this;
        }
    }

    public boolean accept(String type) {
        return type != null;
    }

    public Collection<String> getAcceptedTypes() {
        if (this._acceptedTypes != null) {
            return this._acceptedTypes;
        }
        return Collections.emptyList();
    }

    public IPath getPath(Document metaDocument) {
        String uri = PdpResourcesMgr.getURIFromDocument((String)metaDocument.getId());
        return new Path(uri);
    }

    public ImageDescriptor getImageDescriptor(String type) {
        return ReferencesPlugin.getDefault().getImageDescriptor(PDP_COBOL_FILE_IMAGE_NAME);
    }

    public Image getImage(String type) {
        return ReferencesPlugin.getDefault().getImage(PDP_COBOL_FILE_IMAGE_NAME);
    }
}

