/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.pdp.generation.menu;

import com.ibm.pdp.explorer.editor.service.PTEditorService;
import com.ibm.pdp.explorer.model.PTModelManager;
import com.ibm.pdp.explorer.model.service.PTModelService;
import com.ibm.pdp.explorer.view.service.PTViewService;
import com.ibm.pdp.framework.GenerationLink;
import com.ibm.pdp.framework.PdpTool;
import com.ibm.pdp.framework.interfaces.IController;
import com.ibm.pdp.framework.interfaces.IReference;
import com.ibm.pdp.framework.pattern.PdpPatternGenStatesExceptions;
import com.ibm.pdp.generation.manager.EquivalentStateId;
import com.ibm.pdp.generation.manager.EquivalentStateIdCache;
import com.ibm.pdp.generation.menu.Messages;
import com.ibm.pdp.mdl.kernel.RadicalEntity;
import com.ibm.pdp.mdl.meta.ArtifactState;
import com.ibm.pdp.mdl.meta.MetaFactory;
import com.ibm.pdp.mdl.meta.Property;
import com.ibm.pdp.mdl.meta.Reference;
import com.ibm.pdp.mdl.meta.io.MetadataStateAccess;
import com.ibm.pdp.mdl.meta.service.MetadataService;
import com.ibm.pdp.pdppath.stateid.StateIDUtil;
import com.ibm.pdp.resources.PdpResourcesMgr;
import com.ibm.pdp.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class SynchronizationTool {
    public static final String copyright = "Licensed Materials - Property of IBM\n5725-H03\n(C) Copyright IBM Corp. 2010, 2020.   All rights reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String REGENERATION_REQUIRED_MESS = Messages.SynchronizationTool_REGENERATION_REQUIRED_MESS;
    private static List<String> _modelExtensions = null;
    private static Map<String, List<ArtifactState>> _artifactStateCache;

    public static boolean checkIfTheGeneratedResourceNeedsRegeneration(String logicalPathOfTheGenerated, String physicalPathOfTheGeneratedFile) {
        ArrayList<String> modifiedDesigns = SynchronizationTool.getModifiedDesignSinceLastGeneration(logicalPathOfTheGenerated, physicalPathOfTheGeneratedFile);
        if (modifiedDesigns == null) {
            return false;
        }
        return modifiedDesigns.size() > 0;
    }

    public static ArrayList<String> getModifiedDesignSinceLastGeneration(String logicalPathOfTheGenerated, String physicalPathOfTheGeneratedFile) {
        return SynchronizationTool._getModifiedDesignSinceLastGeneration(logicalPathOfTheGenerated, physicalPathOfTheGeneratedFile, null);
    }

    public static ArrayList<String> getModifiedDesignSinceLastGeneration(String logicalPathOfTheGenerated, String physicalPathOfTheGeneratedFile, ArrayList<String> workItems) {
        return SynchronizationTool._getModifiedDesignSinceLastGeneration(logicalPathOfTheGenerated, physicalPathOfTheGeneratedFile, workItems);
    }

    private static ArrayList<String> _getModifiedDesignSinceLastGeneration(String logicalPathOfTheGenerated, String physicalPathOfTheGeneratedFile, ArrayList<String> workItems) {
        PdpResourcesMgr x = PdpResourcesMgr.getInstance();
        ArrayList<String> notSynchronizedFilesNames = null;
        List subReferences = x.getGenerationSubReferences2(logicalPathOfTheGenerated);
        if (subReferences.isEmpty()) {
            return null;
        }
        HashSet<String> designIds = new HashSet<String>();
        for (Reference subReference : subReferences) {
            designIds.add(subReference.getTargetId());
        }
        MetadataStateAccess metadataStateAccess = MetadataStateAccess.getMetadataStateAccess();
        List existingArtifactStates = Collections.emptyList();
        if (_artifactStateCache == null) {
            existingArtifactStates = metadataStateAccess.readArtifactStates(designIds);
        }
        HashMap<String, ArrayList<ArtifactState>> byDesignIdArtifactStates = new HashMap<String, ArrayList<ArtifactState>>();
        for (ArtifactState artifactState : existingArtifactStates) {
            ArrayList<ArtifactState> artifactStates = (ArrayList<ArtifactState>)byDesignIdArtifactStates.get(artifactState.getArtifactId());
            if (artifactStates == null) {
                artifactStates = new ArrayList<ArtifactState>();
                byDesignIdArtifactStates.put(artifactState.getArtifactId(), artifactStates);
            }
            artifactStates.add(artifactState);
        }
        ArrayList<ArtifactState> writeArtifactStates = new ArrayList<ArtifactState>();
        for (Reference subReference : subReferences) {
            String[] tokens = MetadataService.getTokens((String)subReference.getTargetId());
            String stateIdStoredInLinks = subReference.getStateId();
            Property propGenStateID = subReference.getProperty("genId");
            String genStateIdStoredInLinks = propGenStateID == null ? null : propGenStateID.getValue();
            String referencedDocName = PdpResourcesMgr.getURIFromDocument((String)subReference.getTargetId());
            IFile refFile = PdpTool.getFile((String)referencedDocName);
            String stateId_ComputedOnFileOnDisk = null;
            if (refFile.exists()) {
                boolean equivalent;
                String fileExtension = tokens[4];
                if (genStateIdStoredInLinks != null && genStateIdStoredInLinks.length() != 0 && PdpPatternGenStatesExceptions.isGenStateIDActivated) {
                    Path relativePath;
                    String stateId;
                    boolean equivalent2;
                    String genStateId_ComputedOnFileOnDisk = null;
                    RadicalEntity re = null;
                    if (SynchronizationTool.isAPureDesignExtension(fileExtension)) {
                        String patternName;
                        Property prop = subReference.getProperty("pattern");
                        String patternInfo = patternName = prop == null ? null : prop.getValue();
                        if (PdpPatternGenStatesExceptions.getPatternGenStateLastVersion((String)patternName) != null) {
                            String rank;
                            prop = subReference.getProperty("patternGenStateVersion");
                            String patternGenStateVersion = null;
                            if (prop != null) {
                                patternGenStateVersion = prop.getValue();
                                patternInfo = String.valueOf(patternInfo) + ":" + patternGenStateVersion;
                            }
                            prop = subReference.getProperty("rank");
                            int iRank = -1;
                            String string = rank = prop == null ? null : prop.getValue();
                            if (rank != null) {
                                iRank = Integer.parseInt(rank);
                            }
                            ArtifactState existingArtifactState = null;
                            HashMap<String, ArtifactState> byStateIdArtifactStates = new HashMap<String, ArtifactState>();
                            if (_artifactStateCache != null) {
                                if (_artifactStateCache.containsKey(subReference.getTargetId())) {
                                    for (ArtifactState artifactState : _artifactStateCache.get(subReference.getTargetId())) {
                                        if (!artifactState.getPatternId().equals(patternName) || !artifactState.getVersionId().equals(patternGenStateVersion) || artifactState.getRank() != iRank) continue;
                                        byStateIdArtifactStates.put(artifactState.getStateId(), artifactState);
                                    }
                                }
                            } else if (byDesignIdArtifactStates.containsKey(subReference.getTargetId())) {
                                for (ArtifactState artifactState : (List)byDesignIdArtifactStates.get(subReference.getTargetId())) {
                                    if (!artifactState.getPatternId().equals(patternName) || !artifactState.getVersionId().equals(patternGenStateVersion) || artifactState.getRank() != iRank) continue;
                                    byStateIdArtifactStates.put(artifactState.getStateId(), artifactState);
                                }
                            }
                            if (byStateIdArtifactStates.size() > 1) {
                                ArrayList values = new ArrayList(byStateIdArtifactStates.values());
                                if (_artifactStateCache == null) {
                                    metadataStateAccess.deleteArtifactStates(values);
                                }
                                existingArtifactState = null;
                            } else if (byStateIdArtifactStates.size() == 1) {
                                existingArtifactState = (ArtifactState)byStateIdArtifactStates.values().iterator().next();
                            }
                            if (existingArtifactState == null) {
                                ArtifactState artifactState;
                                re = PTModelService.getResource((IPath)new Path(referencedDocName));
                                genStateId_ComputedOnFileOnDisk = PdpPatternGenStatesExceptions.getGenStateId((RadicalEntity)re, (String)patternName, (boolean)false, (String)patternGenStateVersion, (String)rank);
                                artifactState = MetaFactory.eINSTANCE.createArtifactState();
                                artifactState.setArtifactId(subReference.getTargetId());
                                artifactState.setPatternId(patternName);
                                artifactState.setVersionId(patternGenStateVersion);
                                artifactState.setRank(iRank);
                                artifactState.setStateId(genStateId_ComputedOnFileOnDisk);
                                if (_artifactStateCache != null) {
                                    List<ArtifactState> artifactStates = _artifactStateCache.get(artifactState.getArtifactId());
                                    if (artifactStates == null) {
                                        artifactStates = new ArrayList<ArtifactState>();
                                        _artifactStateCache.put(artifactState.getArtifactId(), artifactStates);
                                    }
                                    artifactStates.add(artifactState);
                                } else {
                                    writeArtifactStates.add(artifactState);
                                }
                            } else {
                                genStateId_ComputedOnFileOnDisk = existingArtifactState.getStateId();
                            }
                        }
                        if (genStateId_ComputedOnFileOnDisk == null) {
                            throw new RuntimeException("genStateId null for : " + referencedDocName + " while checking desynchronization of : " + physicalPathOfTheGeneratedFile + " with pattern :" + patternInfo);
                        }
                    }
                    if (genStateIdStoredInLinks.equals(genStateId_ComputedOnFileOnDisk) || (equivalent2 = SynchronizationTool.checkEquivalentId(stateIdStoredInLinks, referencedDocName, stateId = PTModelService.getStateId((IPath)(relativePath = new Path(referencedDocName))), workItems))) continue;
                    if (notSynchronizedFilesNames == null) {
                        notSynchronizedFilesNames = new ArrayList();
                    }
                    notSynchronizedFilesNames.add(referencedDocName);
                    continue;
                }
                RadicalEntity re = null;
                boolean isPureDesign = SynchronizationTool.isAPureDesignExtension(fileExtension);
                if (isPureDesign) {
                    re = PTModelService.getResource((IPath)new Path(referencedDocName));
                    stateId_ComputedOnFileOnDisk = re.getStateId();
                } else {
                    stateId_ComputedOnFileOnDisk = StateIDUtil.computeStateIdOfFile((IFile)refFile);
                }
                if (stateIdStoredInLinks.equals(stateId_ComputedOnFileOnDisk) || (equivalent = SynchronizationTool.checkEquivalentId(re, stateIdStoredInLinks, workItems))) continue;
                if (notSynchronizedFilesNames == null) {
                    notSynchronizedFilesNames = new ArrayList();
                }
                notSynchronizedFilesNames.add(referencedDocName);
                continue;
            }
            if (notSynchronizedFilesNames == null) {
                notSynchronizedFilesNames = new ArrayList<String>();
            }
            notSynchronizedFilesNames.add(referencedDocName);
        }
        if (_artifactStateCache == null) {
            metadataStateAccess.writeArtifactStates(writeArtifactStates);
        }
        if (notSynchronizedFilesNames == null || notSynchronizedFilesNames.size() == 0) {
            SynchronizationTool.removeDesynchronisationWarning((IPath)new Path(physicalPathOfTheGeneratedFile));
        } else {
            String modifiedDesign = (String)notSynchronizedFilesNames.get(0);
            if (notSynchronizedFilesNames.size() > 1) {
                modifiedDesign = String.valueOf(modifiedDesign) + "(+" + (notSynchronizedFilesNames.size() - 1) + ")";
            }
            SynchronizationTool.createDesynchronizationMarkerOf((IPath)new Path(physicalPathOfTheGeneratedFile), modifiedDesign);
        }
        if (PlatformUI.isWorkbenchRunning()) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    PTViewService.refresh();
                }
            });
        }
        return notSynchronizedFilesNames;
    }

    public static boolean checkEquivalentId(RadicalEntity re, String stateIdStoredInLinks) {
        String relativeFileName = re.getPath(re.getProject()).toString();
        String stateId = re.getStateId();
        return SynchronizationTool.checkEquivalentId(stateIdStoredInLinks, relativeFileName, stateId, null);
    }

    public static boolean checkEquivalentId(RadicalEntity re, String stateIdStoredInLinks, List<String> workItems) {
        String relativeFileName = re.getPath(re.getProject()).toString();
        String stateId = re.getStateId();
        return SynchronizationTool.checkEquivalentId(stateIdStoredInLinks, relativeFileName, stateId, workItems);
    }

    public static boolean checkEquivalentId(String stateIdStoredInLinks, String relativeFileName, String stateIdFromDisk) {
        return SynchronizationTool.checkEquivalentId(stateIdStoredInLinks, relativeFileName, stateIdFromDisk, null);
    }

    public static boolean checkEquivalentId(String stateIdStoredInLinks, String relativeFileName, String stateIdFromDisk, List<String> workItems) {
        if (stateIdStoredInLinks.equals(stateIdFromDisk)) {
            return true;
        }
        EquivalentStateIdCache cache = EquivalentStateIdCache.getCurrentEquivalentStateIdCache();
        if (cache == null) {
            return false;
        }
        Iterator<EquivalentStateId> iterator = cache.getEquivalentStateIdForDesignId(relativeFileName);
        if (iterator == null) {
            return false;
        }
        ArrayList candidateList = null;
        boolean searchDirectWi = true;
        while (iterator != null && (searchDirectWi || candidateList != null)) {
            ArrayList<EquivalentStateId> nextList = null;
            ArrayList nextCandidateList = null;
            while (iterator.hasNext()) {
                EquivalentStateId equivalentStateId = iterator.next();
                if (searchDirectWi) {
                    if (equivalentStateId.getBeforeStateId().equals(stateIdStoredInLinks)) {
                        if (equivalentStateId.getAfterStateId().equals(stateIdFromDisk)) {
                            if (workItems != null) {
                                int workItemNumber = equivalentStateId.getWorkItemNumber();
                                String workItemTitle = equivalentStateId.getWorkItemTitle();
                                String wi = workItemNumber + " : " + workItemTitle;
                                if (!workItems.contains(wi)) {
                                    workItems.add(wi);
                                }
                            }
                            return true;
                        }
                        if (nextCandidateList == null) {
                            nextCandidateList = new ArrayList();
                        }
                        ArrayList<EquivalentStateId> candidate = new ArrayList<EquivalentStateId>();
                        candidate.add(equivalentStateId);
                        nextCandidateList.add(candidate);
                        continue;
                    }
                    if (nextList == null) {
                        nextList = new ArrayList<EquivalentStateId>();
                    }
                    nextList.add(equivalentStateId);
                    continue;
                }
                int i = candidateList.size() - 1;
                while (i >= 0) {
                    ArrayList candidate = (ArrayList)candidateList.get(i);
                    if (equivalentStateId.getBeforeStateId().equals(((EquivalentStateId)candidate.get(candidate.size() - 1)).getAfterStateId())) {
                        if (equivalentStateId.getAfterStateId().equals(stateIdFromDisk)) {
                            if (workItems != null) {
                                for (EquivalentStateId esi : candidate) {
                                    int workItemNumber = esi.getWorkItemNumber();
                                    String workItemTitle = esi.getWorkItemTitle();
                                    String wi = workItemNumber + " : " + workItemTitle;
                                    if (workItems.contains(wi)) continue;
                                    workItems.add(wi);
                                }
                                int workItemNumber = equivalentStateId.getWorkItemNumber();
                                String workItemTitle = equivalentStateId.getWorkItemTitle();
                                String wi = workItemNumber + " : " + workItemTitle;
                                if (!workItems.contains(wi)) {
                                    workItems.add(wi);
                                }
                            }
                            return true;
                        }
                        if (nextCandidateList == null) {
                            nextCandidateList = new ArrayList();
                        }
                        ArrayList<EquivalentStateId> newCandidate = new ArrayList<EquivalentStateId>();
                        for (EquivalentStateId esi : candidate) {
                            newCandidate.add(esi);
                        }
                        newCandidate.add(equivalentStateId);
                        nextCandidateList.add(newCandidate);
                    } else {
                        if (nextList == null) {
                            nextList = new ArrayList();
                        }
                        nextList.add(equivalentStateId);
                    }
                    --i;
                }
            }
            searchDirectWi = false;
            iterator = nextList != null ? nextList.iterator() : null;
            candidateList = nextCandidateList != null ? nextCandidateList : null;
        }
        return false;
    }

    private static String computeRealTimeStateId(IFile file) {
        String stateId = "";
        try {
            int c;
            InputStream inputStream = file.getContents();
            int _BUFFER_SIZE = 10000;
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream), _BUFFER_SIZE);
            StringBuilder buffer = new StringBuilder();
            while ((c = reader.read()) != -1) {
                buffer.append((char)c);
            }
            Integer hashCode = new Integer(buffer.toString().trim().hashCode());
            stateId = hashCode.toString();
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
        return stateId;
    }

    public static boolean checkInTheMemoryIfTheGeneratedResourceNeedsRegeneration(IController controller) {
        ArrayList<String> notSynchronizedFilesNames = null;
        Iterator subRefs = controller.getGenerationLink().getSubReferences();
        String rank = null;
        String patternName = controller.getPattern().getName();
        String patternGenStateVersion = ((GenerationLink)controller.getGenerationLink()).getPatternGenStateVersion();
        String patternInfo = String.valueOf(patternName) + ":" + patternGenStateVersion;
        while (subRefs.hasNext()) {
            int entryPointIndex;
            int beforeRankIndex;
            IReference aReference = (IReference)subRefs.next();
            String relation = aReference.getRelationName();
            if (relation.endsWith("_entrypoint") && (beforeRankIndex = (relation = relation.substring(0, entryPointIndex = relation.indexOf("_entrypoint"))).lastIndexOf("_")) != -1) {
                rank = relation.substring(beforeRankIndex + 1);
            }
            String stateIdStoredInLinks = aReference.getStateId();
            String genStateIdStoredInLinks = aReference.getGenStateId();
            String targetId = aReference.getLogicalFileName();
            String[] tokens = MetadataService.getTokens((String)targetId);
            String referencedDocName = PdpResourcesMgr.getURIFromDocument((String)targetId);
            IFile refFile = PdpTool.getFile((String)referencedDocName);
            String stateId_ComputedOnFileOnDisk = null;
            if (refFile.exists()) {
                boolean equivalent;
                String fileExtension = tokens[4];
                if (genStateIdStoredInLinks != null && genStateIdStoredInLinks.length() != 0 && PdpPatternGenStatesExceptions.isGenStateIDActivated) {
                    String stateId;
                    boolean equivalent2;
                    String genStateId_ComputedOnFileOnDisk = null;
                    RadicalEntity re = null;
                    if (SynchronizationTool.isAPureDesignExtension(fileExtension)) {
                        if (PdpPatternGenStatesExceptions.getPatternGenStateLastVersion((String)patternName) != null) {
                            re = PTEditorService.getSharedResource((IPath)new Path(referencedDocName));
                            genStateId_ComputedOnFileOnDisk = PdpPatternGenStatesExceptions.getGenStateId((RadicalEntity)re, (String)patternName, (boolean)false, (String)patternGenStateVersion, (String)rank);
                        }
                        if (genStateId_ComputedOnFileOnDisk == null) {
                            throw new RuntimeException("genStateId null for : " + referencedDocName + " while checking desynchronization of : " + controller.getResourceName() + " with pattern :" + patternInfo);
                        }
                    }
                    if (genStateId_ComputedOnFileOnDisk == null || genStateIdStoredInLinks.equals(genStateId_ComputedOnFileOnDisk) || (equivalent2 = SynchronizationTool.checkEquivalentId(stateIdStoredInLinks, referencedDocName, stateId = re.getStateId(), null))) continue;
                    if (notSynchronizedFilesNames == null) {
                        notSynchronizedFilesNames = new ArrayList();
                    }
                    notSynchronizedFilesNames.add(referencedDocName);
                    continue;
                }
                RadicalEntity re = null;
                boolean isPureDesign = SynchronizationTool.isAPureDesignExtension(fileExtension);
                if (isPureDesign) {
                    re = PTEditorService.getSharedResource((IPath)new Path(referencedDocName));
                    stateId_ComputedOnFileOnDisk = re.getStateId();
                } else {
                    stateId_ComputedOnFileOnDisk = StateIDUtil.computeStateIdOfFile((IFile)refFile);
                }
                if (stateIdStoredInLinks.equals(stateId_ComputedOnFileOnDisk) || (equivalent = SynchronizationTool.checkEquivalentId(re, stateIdStoredInLinks, null))) continue;
                if (notSynchronizedFilesNames == null) {
                    notSynchronizedFilesNames = new ArrayList();
                }
                notSynchronizedFilesNames.add(referencedDocName);
                continue;
            }
            if (notSynchronizedFilesNames == null) {
                notSynchronizedFilesNames = new ArrayList<String>();
            }
            notSynchronizedFilesNames.add(referencedDocName);
        }
        return notSynchronizedFilesNames != null && notSynchronizedFilesNames.size() != 0;
    }

    private static boolean isAPureDesignExtension(String extension) {
        if (_modelExtensions == null) {
            _modelExtensions = new ArrayList<String>();
            PTModelManager.getInstance();
            for (Object object : EPackage.Registry.INSTANCE.values()) {
                if (!(object instanceof EPackage)) continue;
                EPackage ePackage = (EPackage)object;
                ePackage.getESuperPackage();
                for (EClassifier eClassifier : ePackage.getEClassifiers()) {
                    EClass eClass;
                    if (!(eClassifier instanceof EClass) || (eClass = (EClass)eClassifier).isAbstract()) continue;
                    for (EClass eSuperClass : eClass.getEAllSuperTypes()) {
                        if (eSuperClass == null || !RadicalEntity.class.getSimpleName().equals(eSuperClass.getName())) continue;
                        _modelExtensions.add(eClass.getName().toLowerCase());
                    }
                }
            }
        }
        return _modelExtensions.contains(extension);
    }

    private static void createDesynchronizationMarkerOf(IPath filePath, String modifiedDesign) {
        IFile file = PdpTool.getFile((IPath)filePath);
        if (file.exists()) {
            IMarker existingMarkerForThatFile = null;
            try {
                IMarker[] markers = file.findMarkers("com.ibm.pdp.desynchronized_generated_file_marker", false, 0);
                if (markers.length > 0) {
                    existingMarkerForThatFile = markers[0];
                    if (existingMarkerForThatFile.exists()) {
                        existingMarkerForThatFile.setAttribute("message", (Object)(String.valueOf(REGENERATION_REQUIRED_MESS) + " : " + modifiedDesign));
                    }
                } else {
                    IMarker marker = file.createMarker("com.ibm.pdp.desynchronized_generated_file_marker");
                    marker.setAttribute("severity", 1);
                    marker.setAttribute("message", (Object)(String.valueOf(REGENERATION_REQUIRED_MESS) + " : " + modifiedDesign));
                }
            }
            catch (CoreException e) {
                Util.rethrow((Throwable)e);
            }
        }
    }

    private static void removeDesynchronisationWarning(IPath filePath) {
        IFile file = PdpTool.getFile((IPath)filePath);
        try {
            if (file.exists()) {
                file.deleteMarkers("com.ibm.pdp.desynchronized_generated_file_marker", false, 0);
            }
        }
        catch (CoreException e) {
            Util.rethrow((Throwable)e);
        }
    }

    public static void initArtifactStateCache() {
        _artifactStateCache = new HashMap<String, List<ArtifactState>>();
    }

    public static Map<String, List<ArtifactState>> getArtifactStateCache() {
        return _artifactStateCache;
    }

    public static void forgetArtifactStateCache() {
        _artifactStateCache = null;
    }
}

